// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed under the Creative Commons Public Domain.
// SPDX-FileCopyrightText: 2023 Wilson Snyder
// SPDX-License-Identifier: CC0-1.0

module t (
  input clk
);

  int cyc;
  bit a;
  bit b;

  // Test loop
  always @(posedge clk) begin
    cyc <= cyc + 1;
    if (cyc == 0) begin
      a <= '0;
      b <= '0;
    end
    else if (cyc == 10) begin
      a <= '1;
      b <= '1;
    end
    else if (cyc == 11) begin
      a <= '0;
      b <= '1;
    end
    else if (cyc == 99) begin
      $write("*-* All Finished *-*\n");
      $finish;
    end
  end

  always_ff @(posedge clk) begin
    C1 :
    cover property (a) begin
      // Assert under cover legal in some other simulators
      A2 : assert (b);
    end
  end

endmodule
