﻿; Script generated by the Inno Script Studio Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

; [NOTE] These are passed from Qbs
; #define MyAppVersion
; #define MyAppCopyright
; #define MyAppArchitecture
; #define MyAppMinWinVersion
; #define buildDirectory

#define MyAppName "Valentina"
#define MyAppPublisher "Roman Telezhynskyi"
#define MyAppURL "https://smart-pattern.com.ua/"
#define MyDateTimeString GetDateTimeString('yyyymmddhhnnss', '', '');
; Appstatus: "" = release, " Dev" = development branch
; this only modifies the resulting exe name of the installer package ;-)
#define MyAppStatus " Dev"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
; Stable branch
;AppId={{7081AEC7-38FC-479F-B712-DB073BB76512}
; Dev branch
AppId={{059E7A7D-CB48-4218-B5E0-8824D2953CEC}
AppName={#MyAppName}{#MyAppStatus}
AppVersion={#MyAppVersion}
AppVerName={#MyAppName}{#MyAppStatus} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={autopf}\{#MyAppName}{#MyAppStatus}
DefaultGroupName={#MyAppName}{#MyAppStatus}
LicenseFile={#buildDirectory}\LICENSE_GPL.txt
OutputDir={#buildDirectory}
ArchitecturesInstallIn64BitMode={#MyAppArchitecture}
ArchitecturesAllowed={#MyAppArchitecture}

; [NOTE] This one is overridden by Qbs automatically
OutputBaseFilename=valentina_{#MyAppVersion}{#MyAppStatus}

SetupIconFile={#buildDirectory}\valentina.ico
UninstallDisplayIcon={app}\valentina.ico
Compression=lzma2/max
SolidCompression=yes
VersionInfoVersion={#MyAppVersion}
ShowLanguageDialog=yes
VersionInfoProductName=Valentina
AppComments=Patternmaking program
AppContact={#MyAppURL}
AppCopyright={#MyAppCopyright}
ChangesAssociations=yes
DisableDirPage=auto
DisableProgramGroupPage=auto
MinVersion={#MyAppMinWinVersion}
; Remove the following line to run in administrative install mode (install for all users.)
PrivilegesRequired=lowest
PrivilegesRequiredOverridesAllowed=dialog
WizardStyle=modern
;SignTool=MySign
;Uncomment the previous string for code signing
;The next string is an example of parameter SignTool. Should not be uncommented.
;MySign=signtool.exe sign /v /a /n $qOpen Source Developer, Roman Telezhynskyi$q /t http://time.certum.pl /fd sha256 /d $qValentina$q $f

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "armenian"; MessagesFile: "compiler:Languages\Armenian.isl"
Name: "brazilianportuguese"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
Name: "catalan"; MessagesFile: "compiler:Languages\Catalan.isl"
Name: "corsican"; MessagesFile: "compiler:Languages\Corsican.isl"
Name: "czech"; MessagesFile: "compiler:Languages\Czech.isl"
Name: "danish"; MessagesFile: "compiler:Languages\Danish.isl"
Name: "dutch"; MessagesFile: "compiler:Languages\Dutch.isl"
Name: "finnish"; MessagesFile: "compiler:Languages\Finnish.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "german"; MessagesFile: "compiler:Languages\German.isl"
;Name: "greek"; MessagesFile: "compiler:Languages\Greek.isl"
Name: "hebrew"; MessagesFile: "compiler:Languages\Hebrew.isl"
;Name: "hungarian"; MessagesFile: "compiler:Languages\Hungarian.isl"
Name: "icelandic"; MessagesFile: "compiler:Languages\Icelandic.isl"
Name: "italian"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "japanese"; MessagesFile: "compiler:Languages\Japanese.isl"
;Name: "nepali"; MessagesFile: "compiler:Languages\Nepali.islu"
Name: "norwegian"; MessagesFile: "compiler:Languages\Norwegian.isl"
Name: "polish"; MessagesFile: "compiler:Languages\Polish.isl"
;Name: "portuguese"; MessagesFile: "compiler:Languages\Portuguese.isl"
;Name: "scottishgaelic"; MessagesFile: "compiler:Languages\ScottishGaelic.isl"
;Name: "serbiancyrillic"; MessagesFile: "compiler:Languages\SerbianCyrillic.isl"
;Name: "serbianlatin"; MessagesFile: "compiler:Languages\SerbianLatin.isl"
Name: "slovak"; MessagesFile: "compiler:Languages\Slovak.isl"
Name: "slovenian"; MessagesFile: "compiler:Languages\Slovenian.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "turkish"; MessagesFile: "compiler:Languages\Turkish.isl"
Name: "ukrainian"; MessagesFile: "compiler:Languages\Ukrainian.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 0,6.1
Name: "fileassoc1"; Description: "{cm:CreateFileAssocVal}"; GroupDescription: "{cm:FileAssoc}"
Name: "fileassoc2"; Description: "{cm:CreateFileAssocVit}"; GroupDescription: "{cm:FileAssoc}"
Name: "fileassoc3"; Description: "{cm:CreateFileAssocVst}"; GroupDescription: "{cm:FileAssoc}"
Name: "fileassoc4"; Description: "{cm:CreateFileAssocVlt}"; GroupDescription: "{cm:FileAssoc}"
Name: "fileassoc5"; Description: "{cm:CreateFileAssocVkm}"; GroupDescription: "{cm:FileAssoc}"
Name: "deletesettings"; Description: "{cm:RemoveAnyExistingSettings}"; GroupDescription: "{cm:ManageSettings}"; Flags: unchecked

[Types]
;Name: "full_armenian"; Description: "{cm:SystemLanguage}"; Languages: armenian;
Name: "full_brazilianportuguese"; Description: "{cm:SystemLanguage}"; Languages: brazilianportuguese;
;Name: "full_catalan"; Description: "{cm:SystemLanguage}"; Languages: catalan;
;Name: "full_corsican"; Description: "{cm:SystemLanguage}"; Languages: corsican;
Name: "full_czech"; Description: "{cm:SystemLanguage}"; Languages: czech;
;Name: "full_danish"; Description: "{cm:SystemLanguage}"; Languages: danish;
Name: "full_dutch"; Description: "{cm:SystemLanguage}"; Languages: dutch;
Name: "full_finnish"; Description: "{cm:SystemLanguage}"; Languages: finnish;
Name: "full_french"; Description: "{cm:SystemLanguage}"; Languages: french;
Name: "full_german"; Description: "{cm:SystemLanguage}"; Languages: german;
;Name: "full_greek"; Description: "{cm:SystemLanguage}"; Languages: greek;
Name: "full_hebrew"; Description: "{cm:SystemLanguage}"; Languages: hebrew;
;Name: "full_hungarian"; Description: "{cm:SystemLanguage}"; Languages: hungarian;
Name: "full_italian"; Description: "{cm:SystemLanguage}"; Languages: italian;
;Name: "full_japanese"; Description: "{cm:SystemLanguage}"; Languages: japanese;
;Name: "full_nepali"; Description: "{cm:SystemLanguage}"; Languages: nepali;
;Name: "full_norwegian"; Description: "{cm:SystemLanguage}"; Languages: norwegian;
Name: "full_polish"; Description: "{cm:SystemLanguage}"; Languages: polish;
;Name: "full_portuguese"; Description: "{cm:SystemLanguage}"; Languages: portuguese;
;Name: "full_scottishgaelic"; Description: "{cm:SystemLanguage}"; Languages: scottishgaelic;
;Name: "full_serbiancyrillic"; Description: "{cm:SystemLanguage}"; Languages: serbiancyrillic;
;Name: "full_serbianlatin"; Description: "{cm:SystemLanguage}"; Languages: serbianlatin;
;Name: "full_slovenian"; Description: "{cm:SystemLanguage}"; Languages: slovenian;
Name: "full_spanish"; Description: "{cm:SystemLanguage}"; Languages: spanish;
;Name: "full_turkish"; Description: "{cm:SystemLanguage}"; Languages: turkish;
Name: "full_ukrainian"; Description: "{cm:SystemLanguage}"; Languages: ukrainian;
Name: "full"; Description: "{cm:FullInstallation}"
Name: "custom"; Description: "{cm:CustomInstallation}"; Flags: iscustom

[Components]
Name: "lang_files"; Description: "{cm:LanguageComponent}"; Types: full custom; Flags: fixed
;Name: "lang_files\armenian"; Description: "Armenian"; Types: full full_armenian custom; Flags: disablenouninstallwarning
Name: "lang_files\brazilianportuguese"; Description: "Brazilian portuguese"; Types: full full_brazilianportuguese custom; Flags: disablenouninstallwarning
;Name: "lang_files\catalan"; Description: "Catalan"; Types: full full_catalan custom; Flags: disablenouninstallwarning 
;Name: "lang_files\corsican"; Description: "Corsican"; Types: full full_orsican custom; Flags: disablenouninstallwarning
Name: "lang_files\czech"; Description: "Czech"; Types: full full_czech custom; Flags: disablenouninstallwarning
;Name: "lang_files\danish"; Description: "Danish"; Types: full full_danish custom; Flags: disablenouninstallwarning
Name: "lang_files\dutch"; Description: "Dutch"; Types: full full_dutch custom; Flags: disablenouninstallwarning
Name: "lang_files\finnish"; Description: "Finnish"; Types: full full_finnish custom; Flags: disablenouninstallwarning
Name: "lang_files\french"; Description: "French"; Types: full full_french custom; Flags: disablenouninstallwarning
Name: "lang_files\german"; Description: "German"; Types: full full_german custom; Flags: disablenouninstallwarning
;Name: "lang_files\greek"; Description: "Greek"; Types: full full_greek custom; Flags: disablenouninstallwarning
Name: "lang_files\hebrew"; Description: "Hebrew"; Types: full full_hebrew custom; Flags: disablenouninstallwarning
;Name: "lang_files\hungarian"; Description: "Hungarian"; Types: full full_hungarian custom; Flags: disablenouninstallwarning
Name: "lang_files\italian"; Description: "Italian"; Types: full full_italian custom; Flags: disablenouninstallwarning
;Name: "lang_files\japanese"; Description: "Japanese"; Types: full full_japanese custom; Flags: disablenouninstallwarning
;Name: "lang_files\nepali"; Description: "Nepali"; Types: full full_nepali custom; Flags: disablenouninstallwarning
;Name: "lang_files\norwegian"; Description: "Norwegian"; Types: full full_norwegian custom; Flags: disablenouninstallwarning
Name: "lang_files\polish"; Description: "Polish"; Types: full full_polish custom; Flags: disablenouninstallwarning
;Name: "lang_files\portuguese"; Description: "Portuguese"; Types: full full_portuguese custom; Flags: disablenouninstallwarning
;Name: "lang_files\scottishgaelic"; Description: "Scottish gaelic"; Types: full full_scottishgaelic custom; Flags: disablenouninstallwarning
;Name: "lang_files\serbiancyrillic"; Description: "Serbian cyrillic"; Types: full full_serbiancyrillic custom; Flags: disablenouninstallwarning
;Name: "lang_files\serbianlatin"; Description: "Serbian latin"; Types: full full_serbianlatin custom; Flags: disablenouninstallwarning
;Name: "lang_files\slovenian"; Description: "Slovenian"; Types: full full_slovenian custom; Flags: disablenouninstallwarning
Name: "lang_files\spanish"; Description: "Spanish"; Types: full full_spanish custom; Flags: disablenouninstallwarning
;Name: "lang_files\turkish"; Description: "Turkish"; Types: full full_turkish custom; Flags: disablenouninstallwarning
Name: "lang_files\ukrainian"; Description: "Ukrainian"; Types: full full_ukrainian custom; Flags: disablenouninstallwarning
Name: "lang_files\indonesian"; Description: "Indonesian"; Types: full custom; Flags: disablenouninstallwarning
Name: "lang_files\romanian"; Description: "Romanian"; Types: full custom; Flags: disablenouninstallwarning
Name: "lang_files\chinese"; Description: "Chinese (China)"; Types: full custom; Flags: disablenouninstallwarning

[Files]
; Signing
Source: "{#buildDirectory}\valentina.exe"; DestDir: "{app}"; Flags: ignoreversion sign
Source: "{#buildDirectory}\tape.exe"; DestDir: "{app}"; Flags: ignoreversion sign
Source: "{#buildDirectory}\puzzle.exe"; DestDir: "{app}"; Flags: ignoreversion sign
Source: "{#buildDirectory}\VPropertyExplorerLib.dll"; DestDir: "{app}"; Flags: ignoreversion sign
Source: "{#buildDirectory}\QMUParserLib.dll"; DestDir: "{app}"; Flags: ignoreversion sign

; Localizations
Source: "{#buildDirectory}\translations\*_uk_UA.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\ukrainian
Source: "{#buildDirectory}\translations\*_uk.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\ukrainian

Source: "{#buildDirectory}\translations\*_de_DE.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\german
Source: "{#buildDirectory}\translations\*_de.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\german

Source: "{#buildDirectory}\translations\*_cs_CZ.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\czech
Source: "{#buildDirectory}\translations\*_cs.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\czech

Source: "{#buildDirectory}\translations\*_he_IL.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\hebrew
Source: "{#buildDirectory}\translations\*_he.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\hebrew

Source: "{#buildDirectory}\translations\*_fr_FR.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\french
Source: "{#buildDirectory}\translations\*_fr.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\french

Source: "{#buildDirectory}\translations\*_it_IT.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\italian
Source: "{#buildDirectory}\translations\*_it.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\italian

Source: "{#buildDirectory}\translations\*_nl_NL.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\dutch
Source: "{#buildDirectory}\translations\*_nl.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\dutch

Source: "{#buildDirectory}\translations\*_id_ID.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\indonesian

Source: "{#buildDirectory}\translations\*_es_ES.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\spanish
Source: "{#buildDirectory}\translations\*_es.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\spanish

Source: "{#buildDirectory}\translations\*_fi_FI.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\finnish
Source: "{#buildDirectory}\translations\*_fi.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\finnish

Source: "{#buildDirectory}\translations\*_ro_RO.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\romanian

Source: "{#buildDirectory}\translations\*_zh_CN.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\chinese

Source: "{#buildDirectory}\translations\*_pl_PL.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\polish
Source: "{#buildDirectory}\translations\*_pl.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\polish

Source: "{#buildDirectory}\translations\*_pt_BR.qm"; DestDir: "{app}\translations"; Flags: ignoreversion; Components: lang_files\brazilianportuguese

Source: "{#buildDirectory}\translations\*_el_GR.qm"; DestDir: "{app}\translations"; Flags: ignoreversion

; Other files
Source: "{#buildDirectory}\bearer\*"; DestDir: "{app}\bearer"; Flags: recursesubdirs createallsubdirs skipifsourcedoesntexist
Source: "{#buildDirectory}\generic\*"; DestDir: "{app}\generic"; Flags: recursesubdirs createallsubdirs skipifsourcedoesntexist
Source: "{#buildDirectory}\iconengines\*"; DestDir: "{app}\iconengines"; Flags: recursesubdirs createallsubdirs
Source: "{#buildDirectory}\imageformats\*"; DestDir: "{app}\imageformats"; Flags: recursesubdirs createallsubdirs
Source: "{#buildDirectory}\networkinformation\*"; DestDir: "{app}\networkinformation"; Flags: recursesubdirs createallsubdirs skipifsourcedoesntexist
Source: "{#buildDirectory}\platforms\*"; DestDir: "{app}\platforms"; Flags: recursesubdirs createallsubdirs
Source: "{#buildDirectory}\styles\*"; DestDir: "{app}\styles"; Flags: recursesubdirs createallsubdirs
Source: "{#buildDirectory}\svgfonts\*"; DestDir: "{app}\svgfonts"; Flags: recursesubdirs createallsubdirs
Source: "{#buildDirectory}\tls\*"; DestDir: "{app}\tls"; Flags: recursesubdirs createallsubdirs skipifsourcedoesntexist
Source: "{#buildDirectory}\printsupport\*"; DestDir: "{app}\printsupport"; Flags: recursesubdirs createallsubdirs skipifsourcedoesntexist
Source: "{#buildDirectory}\*.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#buildDirectory}\*.dll"; DestDir: "{app}"
Source: "{#buildDirectory}\*.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#buildDirectory}\*.rcc"; DestDir: "{app}"; Flags: ignoreversion skipifsourcedoesntexist
Source: "{#buildDirectory}\*.ico"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#buildDirectory}\*.ini"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
; DLL used to check if the target program is running at install time

[InstallDelete]
Type: filesandordirs; Name: "{app}\translations"
Type: files; Name: "{autodocs}\Valentina\common.ini"; Tasks: deletesettings
Type: files; Name: "{autodocs}\Valentina\Valentina.ini"; Tasks: deletesettings
Type: files; Name: "{autodocs}\Valentina\Tape.ini"; Tasks: deletesettings
Type: files; Name: "{autodocs}\Valentina\Puzzle.ini"; Tasks: deletesettings

[Icons]
Name: "{group}\{#MyAppName}{#MyAppStatus}"; Filename: "{app}\valentina.exe"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}{#MyAppStatus}}"; Filename: "{uninstallexe}"
Name: "{group}\Tape"; Filename: "{app}\tape.exe"
Name: "{group}\Puzzle"; Filename: "{app}\puzzle.exe"
Name: "{autodesktop}\{#MyAppName}{#MyAppStatus}"; Filename: "{app}\valentina.exe"; Tasks: desktopicon
Name: "{autodesktop}\Tape"; Filename: "{app}\tape.exe"; Tasks: desktopicon
Name: "{autodesktop}\Puzzle"; Filename: "{app}\puzzle.exe"; Tasks: desktopicon
Name: "{autoappdata}\Microsoft\Internet Explorer\Quick Launch\{#MyAppName}{#MyAppStatus}"; Filename: "{app}\valentina.exe"; Tasks: quicklaunchicon

[Run]
Filename: "{app}\valentina.exe"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent

[Registry]
Root: HKA; Subkey: "Software\Classes\.val\OpenWithProgids"; ValueType: string; ValueName: "{#MyAppName}{#MyAppStatus}.val"; ValueData: ""; Flags: uninsdeletevalue; Tasks: fileassoc1
Root: HKA; Subkey: "Software\Classes\.vit\OpenWithProgids"; ValueType: string; ValueName: "{#MyAppName}{#MyAppStatus}.vit"; ValueData: ""; Flags: uninsdeletevalue; Tasks: fileassoc2
Root: HKA; Subkey: "Software\Classes\.vst\OpenWithProgids"; ValueType: string; ValueName: "{#MyAppName}{#MyAppStatus}.vst"; ValueData: ""; Flags: uninsdeletevalue; Tasks: fileassoc3
Root: HKA; Subkey: "Software\Classes\.vlt\OpenWithProgids"; ValueType: string; ValueName: "{#MyAppName}{#MyAppStatus}.vlt"; ValueData: ""; Flags: uninsdeletevalue; Tasks: fileassoc4
Root: HKA; Subkey: "Software\Classes\.vkm\OpenWithProgids"; ValueType: string; ValueName: "{#MyAppName}{#MyAppStatus}.vkm"; ValueData: ""; Flags: uninsdeletevalue; Tasks: fileassoc5

Root: HKA; Subkey: "Software\Classes\.val"; ValueType: string; ValueName: ""; ValueData: "Valentina pattern file"; Flags: uninsdeletekey; Tasks: fileassoc1
Root: HKA; Subkey: "Software\Classes\.vit"; ValueType: string; ValueName: ""; ValueData: "Valentina individual measurement file"; Flags: uninsdeletekey; Tasks: fileassoc2
Root: HKA; Subkey: "Software\Classes\.vst"; ValueType: string; ValueName: ""; ValueData: "Valentina multisize measurement file"; Flags: uninsdeletekey; Tasks: fileassoc3
Root: HKA; Subkey: "Software\Classes\.vlt"; ValueType: string; ValueName: ""; ValueData: "Valentina layout file"; Flags: uninsdeletekey; Tasks: fileassoc4
Root: HKA; Subkey: "Software\Classes\.vkm"; ValueType: string; ValueName: ""; ValueData: "Valentina known measurement file"; Flags: uninsdeletekey; Tasks: fileassoc5

Root: HKA; Subkey: "Software\Classes\.val\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\pattern.ico,0"; Tasks: fileassoc1
Root: HKA; Subkey: "Software\Classes\.vit\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\i-measurements.ico,0"; Tasks: fileassoc2
Root: HKA; Subkey: "Software\Classes\.vst\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\s-measurements.ico,0"; Tasks: fileassoc3
Root: HKA; Subkey: "Software\Classes\.vlt\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\layout.ico,0"; Tasks: fileassoc4
Root: HKA; Subkey: "Software\Classes\.vkm\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\k-measurements.ico,0"; Tasks: fileassoc5

Root: HKA; Subkey: "Software\Classes\.val\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\valentina.exe"" ""%1"""; Tasks: fileassoc1
Root: HKA; Subkey: "Software\Classes\.vit\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tape.exe"" ""%1"""; Tasks: fileassoc2
Root: HKA; Subkey: "Software\Classes\.vst\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tape.exe"" ""%1"""; Tasks: fileassoc3
Root: HKA; Subkey: "Software\Classes\.vlt\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\puzzle.exe"" ""%1"""; Tasks: fileassoc4
Root: HKA; Subkey: "Software\Classes\.vkm\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tape.exe"" ""%1"""; Tasks: fileassoc5

Root: HKA; Subkey: "Software\Classes\.val\shell\{cm:EditWith} {#MyAppName}{#MyAppStatus}"; ValueType: none; ValueName: ""; ValueData: ""; Flags: uninsdeletekey; Tasks: fileassoc1
Root: HKA; Subkey: "Software\Classes\.val\shell\{cm:EditWith} {#MyAppName}{#MyAppStatus}"; ValueType: string; ValueName: "Icon"; ValueData: "{app}\valentina.exe,0"; Flags: uninsdeletekey; Tasks: fileassoc1
Root: HKA; Subkey: "Software\Classes\.val\shell\{cm:EditWith} {#MyAppName}{#MyAppStatus}\command"; ValueType: string; ValueName: ""; ValueData: """{app}\valentina.exe"" ""%1"""; Flags: uninsdeletekey; Tasks: fileassoc1

Root: HKA; Subkey: "Software\Classes\.vit\shell\{cm:EditWith} Tape{#MyAppStatus}"; ValueType: none; ValueName: ""; ValueData: ""; Flags: uninsdeletekey; Tasks: fileassoc2
Root: HKA; Subkey: "Software\Classes\.vit\shell\{cm:EditWith} Tape{#MyAppStatus}"; ValueType: string; ValueName: "Icon"; ValueData: "{app}\tape.exe,0"; Flags: uninsdeletekey; Tasks: fileassoc2
Root: HKA; Subkey: "Software\Classes\.vit\shell\{cm:EditWith} Tape{#MyAppStatus}\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tape.exe"" ""%1"""; Flags: uninsdeletekey; Tasks: fileassoc2

Root: HKA; Subkey: "Software\Classes\.vst\shell\{cm:EditWith} Tape{#MyAppStatus}"; ValueType: none; ValueName: ""; ValueData: ""; Flags: uninsdeletekey; Tasks: fileassoc3
Root: HKA; Subkey: "Software\Classes\.vst\shell\{cm:EditWith} Tape{#MyAppStatus}"; ValueType: string; ValueName: "Icon"; ValueData: "{app}\tape.exe,0"; Flags: uninsdeletekey; Tasks: fileassoc3
Root: HKA; Subkey: "Software\Classes\.vst\shell\{cm:EditWith} Tape{#MyAppStatus}\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tape.exe"" ""%1"""; Flags: uninsdeletekey; Tasks: fileassoc3

Root: HKA; Subkey: "Software\Classes\.vlt\shell\{cm:EditWith} Puzzle{#MyAppStatus}"; ValueType: none; ValueName: ""; ValueData: ""; Flags: uninsdeletekey; Tasks: fileassoc4
Root: HKA; Subkey: "Software\Classes\.vlt\shell\{cm:EditWith} Puzzle{#MyAppStatus}"; ValueType: string; ValueName: "Icon"; ValueData: "{app}\puzzle.exe,0"; Flags: uninsdeletekey; Tasks: fileassoc4
Root: HKA; Subkey: "Software\Classes\.vlt\shell\{cm:EditWith} Puzzle{#MyAppStatus}\command"; ValueType: string; ValueName: ""; ValueData: """{app}\puzzle.exe"" ""%1"""; Flags: uninsdeletekey; Tasks: fileassoc4

Root: HKA; Subkey: "Software\Classes\.vkm\shell\{cm:EditWith} Tape{#MyAppStatus}"; ValueType: none; ValueName: ""; ValueData: ""; Flags: uninsdeletekey; Tasks: fileassoc5
Root: HKA; Subkey: "Software\Classes\.vkm\shell\{cm:EditWith} Tape{#MyAppStatus}"; ValueType: string; ValueName: "Icon"; ValueData: "{app}\tape.exe,0"; Flags: uninsdeletekey; Tasks: fileassoc5
Root: HKA; Subkey: "Software\Classes\.vkm\shell\{cm:EditWith} Tape{#MyAppStatus}\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tape.exe"" ""%1"""; Flags: uninsdeletekey; Tasks: fileassoc5

Root: HKA; Subkey: "Software\Classes\Applications\valentina.exe\SupportedTypes"; ValueType: string; ValueName: ".val"; ValueData: ""; Tasks: fileassoc1
Root: HKA; Subkey: "Software\Classes\Applications\tape.exe\SupportedTypes"; ValueType: string; ValueName: ".vit"; ValueData: ""; Tasks: fileassoc2
Root: HKA; Subkey: "Software\Classes\Applications\tape.exe\SupportedTypes"; ValueType: string; ValueName: ".vst"; ValueData: ""; Tasks: fileassoc3
Root: HKA; Subkey: "Software\Classes\Applications\puzzle.exe\SupportedTypes"; ValueType: string; ValueName: ".vlt"; ValueData: ""; Tasks: fileassoc4
Root: HKA; Subkey: "Software\Classes\Applications\tape.exe\SupportedTypes"; ValueType: string; ValueName: ".vkm"; ValueData: ""; Tasks: fileassoc5

[CustomMessages]
SystemLanguage = System language
english.SystemLanguage = System language
ukrainian.SystemLanguage = Мова системи
french.SystemLanguage = Langue du système

FullInstallation = Full installation
english.FullInstallation = Full installation
ukrainian.FullInstallation = Повна інсталяція
french.FullInstallation = Installation complète

CustomInstallation = Custom installation
english.CustomInstallation = Custom installation
ukrainian.CustomInstallation = Користувацьке налаштування
french.CustomInstallation = Installation personnalisée

LanguageComponent = Language Component
english.LanguageComponent = Language Component
ukrainian.LanguageComponent = Мовний компонент
french.LanguageComponent = Composant linguistique

FileAssoc = Create file associations
english.FileAssoc = Create file associations
ukrainian.FileAssoc = Створити асоціації файлів
french.FileAssoc = Créer les associations de types de fichiers

CreateFileAssocVal = *.val (Pattern file)
english.CreateFileAssocVal = *.val (Pattern file)
ukrainian.CreateFileAssocVal = *.val (Файл викрійки)
french.CreateFileAssocVal = *.val (Fichier de patron)

CreateFileAssocVit = *.vit (Individual measurement file)
english.CreateFileAssocVit = *.vit (Individual measurement file)
ukrainian.CreateFileAssocVit = *.vit (Файл індивідуальних мірок)
french.CreateFileAssocVit = *.vit (Fichier de mesures individuelles)

CreateFileAssocVst = *.vst (Multisize measurement file)
english.CreateFileAssocVst = *.vst (Multisize measurement file)
ukrainian.CreateFileAssocVst = *.vst (Мультирозмірний файл мірок)
french.CreateFileAssocVst = *.vst (Fichier de mesures multi-tailles)

CreateFileAssocVlt = *.vlt (Layout file)
english.CreateFileAssocVlt = *.vlt (Layout file)
ukrainian.CreateFileAssocVlt = *.vlt (Файл роскладки)
french.CreateFileAssocVlt = *.vlt (Fichier de plan de coupe manuel)

CreateFileAssocVkm = *.vkm (Known measurements file)
english.CreateFileAssocVkm = *.vkm (Known measurements file)
ukrainian.CreateFileAssocVkm = *.vkm (Файл відомих мірок)
french.CreateFileAssocVkm = *.vkm (Fichier de base de données de mesures)

WarnRemoveOld = is installed at the moment. Remove old version?
english.WarnRemoveOld = is installed at the moment. Remove old version?
ukrainian.WarnRemoveOld = встановлено на даний момент. Видалити стару версію?
french.WarnRemoveOld = est déjà installé. Voulez-vous désinstaller l'ancienne version ?

WarnSameVersionExit = is already installed. This installer will exit.
english.WarnSameVersionExit = is already installed. This installer will exit.
ukrainian.WarnSameVersionExit = вже встановлено. Інсталятор завершить свою роботу.
french.WarnSameVersionExit = est déjà installé. Le processus d'installation va s'arrêter.

WarnRunningOnUnInstall1 = is currently running.
english.WarnRunningOnUnInstall1 = is currently running.
ukrainian.WarnRunningOnUnInstall1 = в даний час працює.
french.WarnRunningOnUnInstall1 = est actuellement en cours d'exécution.

WarnRunningOnUnInstall2 = Please close it and then click on ''Retry'' to proceed.
english.WarnRunningOnUnInstall2 = Please close it and then click on ''Retry'' to proceed.
ukrainian.WarnRunningOnUnInstall2 = Закрийте його та натисніть ''Повторити'', щоб продовжити.
french.WarnRunningOnUnInstall2 = Merci de fermer l'application puis de cliquer sur 'Réessayer' pour poursuivre l'installation.

WarnCancelInstall = The installation was canceled.
english.WarnCancelInstall = The installation was canceled.
ukrainian.WarnCancelInstall = Установка була скасована.
french.WarnCancelInstall = Le processus d'installation a été annulé.

WarnCancelUninstall = The uninstallation process was canceled.
english.WarnCancelUninstall = The uninstallation process was canceled.
ukrainian.WarnCancelUninstall = Процес деінсталяції скасовано.
french.WarnCancelUninstall = Le processus de désinstallation a été annulée.

WarnOverwrite = is already installed. Overwrite existing installation?
english.WarnOverwrite= is already installed. Overwrite existing installation?
ukrainian.WarnOverwrite= вже встановлено. Перезаписати існуючу установку?
french.WarnOverwrite= est déjà installé. Voulez-vous réinstaller quand même ?

SetupIsRunningWarning = Valentina setup is already running!
english.SetupIsRunningWarning = Valentina setup is already running!
ukrainian.SetupIsRunningWarning = Встановлення Valentina вже працює!
french.SetupIsRunningWarning = L'installation de Valentina est déjà en cours d'exécution !

DeinstIsRunningWarning = Valentina uninstall is already running!
english.DeinstIsRunningWarning = Valentina uninstall is already running!
ukrainian.DeinstIsRunningWarning = Видалення Valentina вже працює!
french.DeinstIsRunningWarning = La désinstallation de Valentina est déjà en cours d'exécution !

RemoveAnyExistingSettings = Remove any existing settings
english.RemoveAnyExistingSettings = Remove any existing settings
ukrainian.RemoveAnyExistingSettings = Видалити всі існуючі налаштування
french.RemoveAnyExistingSettings = Supprimer tous les paramètres de configuration déjà existants

ManageSettings = Manage settings
english.ManageSettings = Manage settings
ukrainian.ManageSettings = Керування налаштуваннями
french.ManageSettings = Paramètres de configuration

QuestionRemoveAnyExistingSettings = Do you want to remove any existing settings?
english.QuestionRemoveAnyExistingSettings = Do you want to remove any existing settings?
ukrainian.QuestionRemoveAnyExistingSettings = Видалити будь-які існуючі налаштування?
french.QuestionRemoveAnyExistingSettings = Voulez-vous supprimer les paramètres configurés dans la version précédente ?

ErrorFindApp = Unable to check if a program is running. Please, close the program before continue and press OK to continue the installation.
english.ErrorFindApp = Unable to check if a program is running. Please, close the program before continue and press OK to continue the installation.
ukrainian.ErrorFindApp = Неможливо перевірити, чи запущена програма. Будь ласка, закрийте програму перед продовженням та натисніть OK, щоб продовжити встановлення.
french.ErrorFindApp = Impossible de vérifier si le programme est en cours d'exécution. Merci de le fermer avant de continuer s'il est ouvert, puis de cliquer sur OK pour poursuivre l'installation.

EditWith = Edit with
english.EditWith = Edit with
ukrainian.EditWith = Відкрити за допомогою
french.EditWith = Editer avec

[Code]
const

// Executable names to check before any setup/uninstall operation
  ProgramName1 = 'Valentina';
  ProgramExeName1 = 'valentina.exe';
  ProgramName2 = 'Tape';
  ProgramExeName2 = 'tape.exe';
  ProgramName3 = 'Puzzle';
  ProgramExeName3 = 'puzzle.exe';

/////////////////////////////////////////////////////////////////////
// Convert version strings into float and compare
// easier than string comparison

function CompareVersion(str1, str2: String): Integer;
var
  temp1, temp2: String;
  num1, num2 : Variant;
begin
    temp1 := str1;
    temp2 := str2;
    StringChangeEx(temp1, '.', '', True);
    StringChangeEx(temp2, '.', '', True);
    num1 := 100*StrToFloat(temp1);
    num2 := 100*StrToFloat(temp2);
    Result := num1 - num2
end;

// Global variables/constants and general functions
const installer_mutex_name = '{#MyAppName}{#MyAppStatus}' + '_setup_mutex';
const uninstaller_mutex_name = '{#MyAppName}{#MyAppStatus}' + '_uninstall_mutex';

/////////////////////////////////////////////////////////////////////
// Find application by name in current process list
// -> AppName: Name of running exe file
// <- True if the program found, False if not

function FindApp(const AppName: String): Boolean;
var
  WMIService: Variant;
  WbemLocator: Variant;
  WbemObjectSet: Variant;
  InstallationFindAppMessage: String;
begin
  try
    WbemLocator := CreateOleObject('WbemScripting.SWbemLocator');
    WMIService := WbemLocator.ConnectServer('localhost', 'root\CIMV2');
    WbemObjectSet := WMIService.ExecQuery('SELECT * FROM Win32_Process Where Name="' + AppName + '"');
    if not VarIsNull(WbemObjectSet) and (WbemObjectSet.Count > 0) then
    begin
      Result := True;
    end
    else begin
      Result := False;
    end;
  except
    InstallationFindAppMessage := ExpandConstant('{cm:ErrorFindApp}');
    MsgBox( InstallationFindAppMessage, mbError, MB_OK );
    Result := False;
  end;
end;

/////////////////////////////////////////////////////////////////////
// Prompt the user to close a program that's still running.
// Finish when the executable is closed or the user cancels the process.

//  -> ProgramExeName: Name of executable
//  -> Message : User message to prompt to close 
//  <- True if the program was closed (or was not running),
//     False if the user clicked on the Cancel button and didn't close the program

function PromptUntilProgramClosedOrInstallationCanceled(
              ProgramExeName: String;
              Message: String ): Boolean;
var
  ButtonPressed : Integer;
begin
  ButtonPressed := IDRETRY;

  // Check if the program is running or if the user has pressed the cancel button
  while FindApp( ProgramExeName ) and ( ButtonPressed <> IDCANCEL ) do
  begin
    ButtonPressed := MsgBox( message , mbError, MB_RETRYCANCEL );    
  end;

  // Has the program been closed?
  Result := Not FindApp( ProgramExeName );
end;


/////////////////////////////////////////////////////////////////////
// Version comparison on installation

function GetRegistryRootKey(): Integer;
begin
  // Check if the installer is running in administrative install mode
  if IsAdminInstallMode() then
    Result := HKEY_LOCAL_MACHINE
  else
    Result := HKEY_CURRENT_USER;
end;

function VersionCompareAndUninstall(): Boolean;
var
  oldVersion: String;
  uninstaller: String;
  ErrorCode: Integer;
  tmpId : String;
begin
  tmpId := '{#emit SetupSetting("AppId")}';
  Delete(tmpId,1,1);
  if RegKeyExists(GetRegistryRootKey(),
    'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\' + tmpId + '_is1') then
  begin
    RegQueryStringValue(GetRegistryRootKey(),
      'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\' + tmpId + '_is1',
      'DisplayVersion', oldVersion);
    if (CompareVersion(oldVersion, '{#emit SetupSetting("AppVersion")}') < 0) then
    begin
      if MsgBox('Version ' + oldVersion + ExpandConstant('{cm:WarnRemoveOld}'),
        mbConfirmation, MB_YESNO) = IDNO then
      begin
        Result := False;
      end
      else
      begin
          RegQueryStringValue(GetRegistryRootKey(),'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\' + tmpId + '_is1','UninstallString', uninstaller);
          If ShellExec('', uninstaller, '/SILENT', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode) then
          begin
            // handle success if necessary; ResultCode contains the exit code
            Result := True
          end
          else begin
            // handle failure if necessary; ResultCode contains the error code
            Result := False
          end
      end;
    end
    else
    begin
        //MsgBox('Version ' + oldVersion + ExpandConstant('{cm:WarnSameVersionExit}'),mbInformation, MB_OK);
        if MsgBox('Version ' + oldVersion + ExpandConstant('{cm:WarnOverwrite}'),
          mbConfirmation, MB_YESNO) = IDNO then
          Result := False
        else
          Result := True;
    end;
  end
  else
  begin
    Result := True;
  end;
end;

/////////////////////////////////////////////////////////////////////
// Run on setup

function InitializeSetup(): Boolean;
var
 // User messages
 ProgramRunningOnInstallMessage : String;
 InstallationCanceledMessage : String;

 begin
  // Create a mutex for the installer and if it's already running then show a message and stop installation
  if CheckForMutexes(installer_mutex_name) then begin
    SuppressibleMsgBox(ExpandConstant('{cm:SetupIsRunningWarning}'), mbError, MB_OK, MB_OK);
    Result := False;
  end
  else begin
    Result := True;
    CreateMutex(installer_mutex_name);
  
    ProgramRunningOnInstallMessage := ExpandConstant('{cm:WarnRunningOnUnInstall1}') + #13 + #13 + ExpandConstant('{cm:WarnRunningOnUnInstall2}');
    InstallationCanceledMessage := ExpandConstant('{cm:WarnCancelInstall}');
  
    Result := PromptUntilProgramClosedOrInstallationCanceled( ProgramExeName1, ProgramName1 + ProgramRunningOnInstallMessage)
    If Result Then
    begin
      Result := PromptUntilProgramClosedOrInstallationCanceled( ProgramExeName2, ProgramName2 + ProgramRunningOnInstallMessage)
      If Result Then
      begin
        Result := PromptUntilProgramClosedOrInstallationCanceled( ProgramExeName3, ProgramName3 + ProgramRunningOnInstallMessage)
      end;
    end;
  
    if Not Result then
    begin
      MsgBox( InstallationCanceledMessage, mbInformation, MB_OK );
    end else begin
        Result := VersionCompareAndUninstall
    end;
  end;
end;

/////////////////////////////////////////////////////////////////////
// Run on uninstall

function InitializeUninstall(): Boolean;
var
 // User message
 ProgramRunningOnUninstallMessage : String;
 UninstallationCanceledMessage : String;

 begin
  if CheckForMutexes(uninstaller_mutex_name) then begin
    SuppressibleMsgBox(ExpandConstant('{cm:DeinstIsRunningWarning}'), mbError, MB_OK, MB_OK);
    Result := False;
  end else
  begin
    Result := True;
    CreateMutex(uninstaller_mutex_name);

    ProgramRunningOnUninstallMessage := ExpandConstant('{cm:WarnRunningOnUnInstall1}') + #13 + #13 + ExpandConstant('{cm:WarnRunningOnUnInstall2}');
    UninstallationCanceledMessage := ExpandConstant('{cm:WarnCancelUninstall}');

    Result := PromptUntilProgramClosedOrInstallationCanceled( ProgramExeName1, ProgramName1 + ProgramRunningOnUninstallMessage);
    If Result Then
    begin
      Result := PromptUntilProgramClosedOrInstallationCanceled( ProgramExeName2, ProgramName2 + ProgramRunningOnUninstallMessage);
      If Result Then
      begin
        Result := PromptUntilProgramClosedOrInstallationCanceled( ProgramExeName3, ProgramName3 + ProgramRunningOnUninstallMessage);
      end;
    end;

    if not Result then
    begin
      MsgBox( UninstallationCanceledMessage, mbInformation, MB_OK );
    end;  
  end;
end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
  CommonIniPath: string;
  ValentinaIniPath: string;
  TapeIniPath: string;
  PuzzleIniPath: string;
begin
  if CurUninstallStep = usPostUninstall then
  begin
    CommonIniPath := ExpandConstant('{autodocs}\Valentina\common.ini');
    ValentinaIniPath := ExpandConstant('{autodocs}\Valentina\Valentina.ini');
    TapeIniPath := ExpandConstant('{autodocs}\Valentina\Tape.ini');
    PuzzleIniPath := ExpandConstant('{autodocs}\Valentina\Puzzle.ini');

    if FileExists(CommonIniPath) or FileExists(ValentinaIniPath) or FileExists(TapeIniPath) or FileExists(PuzzleIniPath) then
    begin
      if MsgBox(ExpandConstant('{cm:QuestionRemoveAnyExistingSettings}'), mbConfirmation, MB_YESNO or MB_DEFBUTTON2) = IDYES then
      begin
        if FileExists(CommonIniPath) then
          if not DeleteFile(CommonIniPath) then
            MsgBox('Failed to delete common.ini', mbError, MB_OK);

        if FileExists(ValentinaIniPath) then
          if not DeleteFile(ValentinaIniPath) then
            MsgBox('Failed to delete Valentina.ini', mbError, MB_OK);

        if FileExists(TapeIniPath) then
          if not DeleteFile(TapeIniPath) then
            MsgBox('Failed to delete Tape.ini', mbError, MB_OK);

        if FileExists(PuzzleIniPath) then
          if not DeleteFile(PuzzleIniPath) then
            MsgBox('Failed to delete Puzzle.ini', mbError, MB_OK);
      end;
    end;
  end;
end;

