#include <iostream>

#include "CommandlineOptions.hh"

#include "Chirotope.hh"
#include "PlacingTriang.hh"
#include "Cocircuits.hh"
#include "Vertices.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing the vertices of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  PointConfiguration points;
  if (points.read(std::cin)) {
    Chirotope chiro(points, false);

    // circuits method:
    MessageStreams::result() << Vertices(Circuits(chiro)) << std::endl;
    return 0;
  }
  else {
    return 1;
  }
}

// eof points2facets.cc
