## TFSA-2022-041: Memory leak when a graph node is invalid

### CVE Number
CVE-2022-23578

### Impact
If a graph node is invalid, TensorFlow can leak memory in the [implementation of `ImmutableExecutorState::Initialize`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/common_runtime/immutable_executor_state.cc#L84-L262):

```cc
Status s = params_.create_kernel(n->properties(), &item->kernel);
if (!s.ok()) {
  item->kernel = nullptr;
  s = AttachDef(s, *n);
  return s;
}
```

Here, we set `item->kernel` to `nullptr` but it is a simple `OpKernel*` pointer so the memory that was previously allocated to it would leak.

### Patches
We have patched the issue in GitHub commit [c79ccba517dbb1a0ccb9b01ee3bd2a63748b60dd](https://github.com/tensorflow/tensorflow/commit/c79ccba517dbb1a0ccb9b01ee3bd2a63748b60dd).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
