#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    xhtml
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_Parts_XHTML
  require_relative 'generic_parts'                       # generic_parts.rb
  include SiSU_Parts_Generic
  def the_line_break
    '<br />'
  end
  def the_table_close
    '</td></tr>
</table>'
  end
  def the_url
    def home
      'http://www.sisudoc.org/' # used in pdf header
    end
    def site #used as stub... where there are subdirectories and is different from home
      home
    end
    self
  end
  def the_url_decoration
    def xml_open                     #'&lt;'
      Dx[:url_o]
    end
    def xml_close                    #'&gt;'
      Dx[:url_c]
    end
    def txt_open
      '<'
    end
    def txt_close
      '>'
    end
    self
  end
  def the_margin
    def txt_0
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_0} align="right">
</td><td valign="top" align="justify">}
    end
    def txt_1
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_1} align="right"></td><td valign="top" align="justify">}
    end
    def txt_2
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_2} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_3
      %{<table summary="" width=#{the_width.table_txt} border="0" cellpadding="2" align="center">
<tr><td width=#{indent_level_3} align="right">
</td>
<td valign="top" align="justify">}
    end
    def css
      '<table summary="normal text css" width="100%" border="0" cellpadding="2" align="center">
<tr><td valign="top" align="justify"> '
    end
    def num_css
      '</td>
<td width="2%" align="right" valign="top">  '
    end
    self
  end
  def the_font
    def set_fonts
      'verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman'
     #'verdana, arial, georgia, tahoma, sans-serif, helvetica, "times new roman", times, roman'
    end
    def set_small
      'size="3"'
    end
    def set_tiny
      'size="2"'
    end
    def paragraph_font_tiny
      %{<font #{set_tiny} #{set_face}>}
    end
    def paragraph_font_small
      %{<font #{set_small} #{set_face}>}
    end
    self
  end
  def the_nav
    def txt_concordance
      %{  <font face="#{the_font.set_fonts}" size="2">
    &nbsp;&nbsp;A-Z&nbsp;
  </font> }
    end
    def txt_toc_link
      %{  <font face="#{the_font.set_fonts}" size="2">
    &nbsp;&nbsp;toc&nbsp;
  </font> }
    end
    def txt_manifest
      #{png_manifest}&nbsp;document&nbsp;manifest
      %{  <font face="#{the_font.set_fonts}" size="2">
    [&nbsp;document&nbsp;manifest&nbsp;]
  </font> }
    end
    def txt_concordance
      %{  <font face="#{the_font.set_fonts}" size="2">
    &nbsp;&nbsp;A-Z&nbsp;
  </font> }
    end
    self
  end
end
module SiSU_Proj_XHTML
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  class Bits
    include SiSU_Parts_HTML
    def initialize
      @v=SiSU_Env::InfoVersion.instance.get_version
    end
    def credits_sisu_epub
      %{<div class="substance">
<p class="center"><a href="http://www.openebook.org"><b>EPUB</b></a> generated by <a href="http://www.sisudoc.org"><b>#{@v.project}</b></a> v#{@v.version}, GPL3</p>
</div>}
      ''
    end
  end
end
__END__
