---
date: 09 June 2002
section: 8
title: RPM
---

名前
====

rpm - RPM パッケージマネージャ

書式
====

パッケージの検索と検査:
-----------------------

**rpm** {**-q\|\--query**} \[**select-options**\] \[**query-options**\]

**rpm** {**-V\|\--verify**} \[**select-options**\]
\[**verify-options**\]

**rpm \--import ***PUBKEY \...*

**rpm** {**-K\|\--checksig**} \[**\--nogpg**\] \[**\--nopgp**\]
\[**\--nomd5**\]\
* PACKAGE\_FILE \...*

パッケージのインストール・アップグレード・削除:
-----------------------------------------------

**rpm** {**-i\|\--install**} \[**install-options**\] *PACKAGE\_FILE
\...*

**rpm** {**-U\|\--upgrade**} \[**install-options**\] *PACKAGE\_FILE
\...*

**rpm** {**-F\|\--freshen**} \[**install-options**\] *PACKAGE\_FILE
\...*

**rpm** {**-e\|\--erase**} \[**\--allmatches**\] \[**\--nodeps**\]
\[**\--noscripts**\]\
\[**\--notriggers**\] \[**\--test**\] *PACKAGE\_NAME \...*

その他:
-------

**rpm** {**\--initdb\|\--rebuilddb**}

**rpm** {**\--addsign\|\--resign**} *PACKAGE\_FILE \...*

**rpm** {**\--querytags\|\--showrc**}

**rpm** {**\--setperms\|\--setugids**} *PACKAGE\_NAME \...*

select-options(選択オプション)
------------------------------

\[*PACKAGE\_NAME*\] \[**-a**,**\--all**\] \[**-f**,**\--file**
***FILE***\]\
\[**-g**,**\--group** ***GROUP***\] \[**-p**,**\--package**
***PACKAGE\_FILE***\]\
\[**\--hdrid** ***SHA1***\] \[**\--pkgid** ***MD5***\] \[**\--tid**
***TID***\]\
\[**\--querybynumber** ***HDRNUM***\] \[**\--triggerdby**
***PACKAGE\_NAME***\]\
\[**\--whatprovies** ***CAPABILITY***\] \[**\--whatrequires**
***CAPABILITY***\]

query-options(検索オプション)
-----------------------------

\[**\--changelog**\] \[**-c**,**\--configfiles**\]
\[**-d**,**\--docfiles**\] \[**\--dump**\]\
\[**\--filesbypkg**\] \[**-i**,**\--info**\] \[**\--last**\]
\[**-l**,**\--list**\]\
\[**\--provides**\] \[**\--qf**,**\--queryformat** ***QUERYFMT***\]
\[**-R**,**\--requires**\]\
\[**\--scripts**\] \[**-s**,**\--state**\]
\[**\--triggers**,**\--triggerscripts**\]

verify-options(検査オプション)
------------------------------

\[**\--nodeps**\] \[**\--nofiles**\] \[**\--noscripts**\]
\[**\--nodigest**\]\
\[**\--nosignature**\] \[**\--nolinkto**\] \[**\--nomd5**\]
\[**\--nosize**\]\
\[**\--nouser**\] \[**\--nogroup**\] \[**\--nomtime**\]
\[**\--nomode**\] \[**\--nordev**\]

install-options(インストールオプション)
---------------------------------------

\[**\--aid**\] \[**\--allfiles**\] \[**\--badreloc**\]
\[**\--excludepath** ***OLDPATH***\]\
\[**\--excludedocs**\] \[**\--force**\] \[**-h**,**\--hash**\]
\[**\--ignoresize**\]\
\[**\--ignorearch**\] \[**\--ignoreos**\] \[**\--includedocs**\]
\[**\--justdb**\]\
\[**\--nodeps**\] \[**\--nodigest**\] \[**\--nosignature**\]
\[**\--nosuggest**\]\
\[**\--noorder**\] \[**\--noscripts**\] \[**\--notriggers**\]\
\[**\--oldpackage**\] \[**\--percent**\] \[**\--prefix**
***NEWPATH***\]\
\[**\--relocate** ***OLDPATH***=***NEWPATH***\]\
\[**\--replacefiles**\] \[**\--replacepkgs**\] \[**\--test**\]

説明
====

**rpm** は強力な **パッケージマネージャ**
であり、個々のソフトウェアパッケージを
ビルド・インストール・検索・検査・更新・削除するのに使うことができる。
**パッケージ** はファイルのアーカイブと、アーカイブされたファイルの
インストール・アンインストールに使われるメタデータからなる。
メタデータは補助スクリプト、ファイル属性、
そしてパッケージの説明に関する情報からなる。 **パッケージ** には 2
種類ある。
インストールするためのソフトウェアをカプセル化するのに使われるバイナリ
パッケージと、バイナリパッケージを生成するのに必要なレシピとソースコード
からなるソースパッケージである。

以下の基本モードのいずれかが選択されなければならない: **検索**、
**検査**、 **署名の検査**、 **インストール/アップグレード/更新**、
**アンインストール**、 **データベースの初期化**、
**データベースの再作成**、 **再署名**、 **署名の追加**、
**所有者/グループの設定**、 **検索タグの表示**、 **設定の表示**。

共通のオプション
----------------

次のオプションはすべてのモードで使用することができる。

**-?**, **\--help**

:   使い方を通常のものよりも長く表示する。

**\--version**

:   使用される **rpm** のバージョン番号からなる 1 行を表示する。

**\--quiet**

:   できるだけ少なく表示する。
    通常は、エラーメッセージだけが表示される。

**-v**

:   より多くの情報を表示する。
    通常は、ルーチンの進捗メッセージが表示される。

**-vv**

:   沢山の汚いデバッグ情報を表示する。

**\--rcfile ***FILELIST*

:   コロン(\`:\')で区切られた *FILELIST* の各ファイルは、設定情報として
    **rpm** によって順番に読み込まれる。 *FILELIST* のデフォルトは
    */usr/lib/rpm/rpmrc*:*/usr/lib/rpm/\<vendor\>/rpmrc*:*\~/.rpmrc*
    である。

**\--pipe ***CMD*

:   **rpm** コマンドの出力を *CMD* へパイプする。

**\--dbpath ***DIRECTORY*

:   データベースのパスに、デフォルトの */var/lib/rpm* ではなく
    *DIRECTORY* を使う。

**\--root ***DIRECTORY*

:   すべてのオプションに対し、 *DIRECTORY*
    をルートとしたファイルシステムを使う。 これは、
    依存性のチェックとすべてのスクリプト(群)
    (例えば、パッケージインストール時の **%post**
    や、パッケージビルド時の **%prep** など)が *DIRECTORY* に chroot(2)
    した後で、 *DIRECTORY*
    内にあるデータベースが使用されることを意味する。

インストールとアップグレードのオプション
----------------------------------------

rpm をインストールするコマンドの一般的な形式は:

**rpm** {**-i\|\--install**} \[**install-options**\] *PACKAGE\_FILE
\...*

これは新しいパッケージをインストールする。\
アップグレードするコマンドの一般的な形式は:

**rpm** {**-U\|\--upgrade**} \[**install-options**\] *PACKAGE\_FILE
\...*

これは現在インストールされているパッケージを新しいバージョンに
アップグレードするか、パッケージをインストールする。
新しいパッケージがインストールされたら他のすべてのバージョンのものが
削除されることを除けば、インストールと同じである。

**rpm** {**-F\|\--freshen**} \[**install-options**\] *PACKAGE\_FILE
\...*

これは以前のバージョンが、現在インストールされている場合にのみ
パッケージを更新する。

*PACKAGE\_FILE* には **ftp** または **http** の URL
を指定することが可能で、その場合にはパッケージをインストールする前に
ダウンロードする。 **rpm** 内部での **ftp** と **http**
のサポートについての情報は **FTP/HTTP オプション** の節を参照のこと。

**\--aid**

:   指定されたパッケージを、必要があればトランザンクションに加える。

**\--allfiles**

:   パッケージ内の missingok ファイルを、存在する/しないにかかわらず
    インストールまたはアップグレードする。

**\--badreloc**

:   **\--relocate**
    と一緒に使われると、パッケージ再配置のヒント(群)の中にその *OLDPATH*
    が含まれていなくても、すべてのファイルパスの再配置を許可する。

**\--excludepath ***OLDPATH*

:   パスの名前が *OLDPATH* で始まるファイルをインストールしない。

**\--excludedocs**

:   (man ページ、tenxinfo
    文書を含めた)文書であるとマーク付されたファイルを
    インストールしない。

**\--force**

:   **\--replacepkgs**, **\--replacefiles**, **\--oldpackage**
    の組み合わせに同じ。

**-h**, **\--hash**

:   パッケージアーカイブから取り出されるにつれ、50個のハッシュマーク(\"\#\")
    を表示する。 **-v\|\--verbose**
    と一緒に使えば、よりよい表示が得られる。

**\--ignoresize**

:   パッケージをインストールする前に、ディスクに十分な空きがあるかの
    チェックをファイルシステムに対して行わない。

**\--ignorearch**

:   バイナリパッケージのアーキテクチャと、そのホストのアーキテクチャが
    一致しなくても、インストールやアップグレードを行う。

**\--ignoreos**

:   バイナリパッケージのOSと、そのホストのOSが一致しなくても、
    インストールやアップグレードを行う。

**\--includedocs**

:   文書ファイルをインストールする。これはデフォルトの動作である。

**\--justdb**

:   データベースだけを更新し、ファイルシステムを更新しない。

**\--nodigest**

:   読み込み時にパッケージまたはへッダのダイジェストを検査しない。

**\--nosignature**

:   読み込み時にパッケージまたはへッダの署名を検査しない。

**\--nodeps**

:   パッケージのインストールやアップグレードの前に、依存性のチェックをしない。

**\--nosuggest**

:   不明な依存性を解消するパッケージ(群)を提案しない。

**\--noorder**

:   パッケージのインストール順を変更しない。
    通常は依存性を満たすために、パッケージのリストは並び替えられる。

**\--noscriopts**

:   

```{=html}
<!-- -->
```

**\--nopre**

:   

**\--nopost**

:   

**\--nopreun**

:   

**\--nopostun**

:   

それぞれ同じ名前を持ったスクリプトを実行しない。 **\--noscripts**
オプションは

**\--nopre \--nopost \--nopreun \--nopostun**

に等しく、対応する **%pre**, **%post**, **%preun**, **%postun**
スクリプト(群)を実行しない。

**\--notriggers**

:   

```{=html}
<!-- -->
```

**\--notriggerin**

:   

**\--notriggerun**

:   

**\--notriggerpostun**

:   

指定された種類のトリガースクリプトを実行しない。 **\--notriggers**
オプションは

**\--notriggerin \--notriggerun \--notriggerpostun**

に等しく、対応する **%triggerin**, **%triggerun**, **%triggerpostun**
スクリプト(群)を実行しない。

**\--oldpackage**

:   新しいパッケージをそれより古いパッケージでアップグレードできるようにする。

**\--percent**

:   パッケージアーカイブからファイルが取り出されるにつれて、
    その割合をを表示する。 これは **rpm**
    が他のツールから実行されるのを容易にすることを意図している。

**\--prefix ***NEWPATH*

:   再配置可能なバイナリパッケージにおいて、パッケージの再配置ヒント(群)にある
    インストールプレフィックスで始まるファイルのパスを、 *NEWPATH*
    に置き換える。

**\--reloacte ***OLDPATH***=***NEWPATH*

:   再配置可能なバイナリパッケージにおいて、パッケージの再配置ヒント(群)にある
    *OLDPATH* で始まるファイルのパスと *NEWPATH* で置き換える。
    パッケージ内で、複数の *OLDPATH*
    が再配置されなければならないのなら、
    このオプションを繰り返し指定することができる。

**\--replacefiles**

:   既にインストールされた他のパッケージのファイルを置き換えてしまう場合でも、
    パッケージをインストールする。

**\--replacepkgs**

:   指定されたパッケージのうちのいくつかがシステムに既にインストール
    されていても、パッケージをインストールする。

**\--test**

:   パッケージをインストールせず、単にチェックと、
    潜在的な衝突の報告を行う。

削除のオプション
----------------

rpm を削除するコマンドの一般的な形式は:

**rpm** {**-e\|\--erase**} \[**\--allmatches**\] \[**\--nodeps**\]
\[**\--noscripts**\]\
\[**\--notriggers**\] \[**\--test**\] *PACKAGE\_NAME \...*

以下のオプションが使用できる:

**\--allmatces**

:   *PACKAGE\_NAME* に一致するすべてのバージョンのパッケージを削除する。

**\--nodeps**

:   パッケージをアンインストールする前に依存性のチェックをしない。

**\--noscripts**

:   

```{=html}
<!-- -->
```

**\--nopreun**

:   

**\--nopostun**

:   

それぞれ同じ名前を持ったスクリプトを実行しない。 **\--noscripts**
オプションは

**\--nopreun \--nopostun**

に等しく、対応する **%preun** と **%postun**
スクリプト(群)を実行しない。

**\--notriggers**

:   

```{=html}
<!-- -->
```

**\--notriggerun**

:   

**\--notriggerpostun**

:   

指定された種類のトリガースクリプトを実行しない。 オプション
**\--notriggers** は

**\--notriggerun \--notriggerpostun**

に等しく、対応する **%triggerun** と **%triggerpostun**
スクリプト(群)を実行しない。

**\--test**

:   実際には何もアンインストールせず挙動だけを見せる。 オプション
    **-vv** と共に使えばデバッグに有効である。

検索オプション
--------------

rpm 検索の一般的な形式は:

**rpm** {**-q\|\--query**} \[**select-options**\] \[**query-options**\]

表示されるパッケージ情報の書式を指定することができる。
そうするためには、

> **\--qf\|\--queryformat ***QUERYFMT*

オプションを使う。 *QUERYFMT* が書式文字列である。検索の書式は、標準的な
**printf(3)** の書式の修正である。書式は静的な文字列
(改行・タブ・その他の特殊文字の、C
言語の標準的な文字エスケープを含む)と、 **printf(3)**
型の書式文字列からなる。 しかし **rpm**
は表示する型を既に知っているので、型指定は省略されるべきである。
代わりに **{}** で囲まれた、表示されるへッダーのタグ名が使用される。
タグ名に大文字/小文字の区別はなく、タグ名の先頭の **RPMTAG\_**
部分も省略することができる。

以下の **:***typetag*
を付加したタグによって、代替の出力書式を要求できる。
現在、以下の種別がサポートされている:

**:armor**

:   公開鍵をASCII文字で表示する。

**:base64**

:   バイナリデータを base64 で符号化する。

**:date**

:   strftime(3)の \"%c\" 書式を使う。

**:day**

:   strftime(3)の \"%a %b %d %Y\" 書式を使う。

**:depflags**

:   依存フラグで表示。

**:fflags**

:   ファイルフラグで表示。

**:hex**

:   16進数で表示。

**:octal**

:   8進数で表示。

**:perms**

:   ファイルの許可属性で表示。

**:shescape**

:   スクリプト内で使えるようにシングルクォート(\')でエスケープする。

**:triggertype**

:   トリガーの種類を表示。

例えば、検索結果のパッケージ名だけを表示したければ、書式文字列として
**%{NAME}** を使えばよい。 2
カラムでパッケージ名とディストリビューション情報を表示したければ
**%-30{NAME}%{DISTRIBUTUIN}** を使えばよい。 (訳注: 端末によっては末尾に
\\n が必要である)。 引数 **\--querytags** をつけて **rpm**
を実行すれば、使用できるタグすべてを表示することができる。

検索のためのオプションは2種類に分けられる。 パッケージの選択と、(訳注:
表示するための)情報の選択である。

 

> *PACKAGE\_NAME*
>
> :   インストールされている *PACKAGE\_NAME*
>     という名前のパッケージを検索する。
>
> **-a**, **\--all**
>
> :   インストールされているすべてのパッケージを検索する。
>
> **-f**, **\--file** *FILE*
>
> :   *FILE* を所有するパッケージを検索する。
>
> **-g**, **\--group** *GROUP*
>
> :   グループが *GROUP* であるパッケージを検索する。
>
> **\--hdrid*** SHA1*
>
> :   与えられたへッダー識別子、 すなわち書き換え不可能なへッダ領域に
>     *SHA1* ダイジェストををもつパッケージを検索する。
>
> **-p**, **\--package** *PACKAGE\_FILE*
>
> :   (インストールされていない)パッケージ *PACKAGE\_FILE* を検索する。
>     *PACKAGE\_FILE* には **ftp** または **http** の URL
>     形式で指定することができ、
>     その場合にはパッケージへッダーがダウンロードされて検索される。
>     **ftp** と **http** のクライアントに関する **rpm**
>     内部でのサポートについては **FTP/HTTP OPTIONS** を参照のこと。
>     *PACKAGE\_FILE* 引数(群)がバイナリパッケージでなければ、それが
>     ASCII 形式の パッケージのリストを表わすものと解釈される。
>     パッケージのリストファイルでは、\'\#\'
>     で始まる行はコメントである。
>     各行には空白で区切ったパス名展開式が指定可能で、
>     展開されたパスは、検索する *PACKAGE\_FILE*
>     引数への追加として置換される。 パス名展開式には URL
>     のリモートのパス名展開も使うことができる。
>
> **\--pkgid*** *MD5**
>
> :   与えられたパッケージ識別子、
>     すなわちへッダーと内容物との組み合わせが *MD5*
>     ダイジェストををもつパッケージを検索する。
>
> **\--querybynumber*** *HDRNUM**
>
> :   データベースの *HDRNUM* 番目のエントリを直接検索する。
>     デバッグにのみ有効である。
>
> **\--specfile*** *SPECFILE**
>
> :   *SPECFILE* をそれがパッケージであるかのように解析し、検索する。
>     すべての情報が利用できるわけではない(たとえばファイル一覧)にもかかわらず、
>     spec ファイルの解析器を書くこと無しに spec
>     ファイルから情報を取り出すことが この種の検索で可能である。
>
> **\--tid*** *TID**
>
> :   与えられたトランザクション識別子 *TID*
>     を持つパッケージ(群)を検索する。 現在のところ、unix
>     時間がトランザクション識別子として使われている。
>     一つのトランザクションでインストール・削除されたパッケージ(群)は、
>     すべて共通の識別子を持つ。
>
> **\--triggerdby*** *PACKAGE\_NAME**
>
> :   パッケージ(群) *PACKAGE\_NAME*
>     によってトリガーされるパッケージを検索する。
>
> **\--whatprovides*** *CAPABILITY**
>
> :   *CAPABILITY* 能力を提供するパッケージを検索する。
>
> **\--whatrequires*** *CAPABILITY**
>
> :   適切に機能するために *CAPABILITY*
>     を必要とするパッケージを検索する。

 

> **\--changelog**
>
> :   パッケージの更新情報を表示する。
>
> **-c**, **\--configfiles**
>
> :   設定ファイルのみを表示する (**-l** を指定したものとみなす)。
>
> **-d**, **\--docfiles**
>
> :   文書ファイルのみを表示する (**-l** を指定したものとみなす)。
>
> **\--dump**
>
> :   以下の形式でファイル情報をダンプする (**-l**
>     を指定したものとみなす)。
>
> ```{=html}
> <!-- -->
> ```
>     パス サイズ 修正時刻 md5ダイジェスト モード \
>     所有者 グループ 設定ファイル 文書ファイル \
>     ルートデバイス シンボリックリンク
>
> **\--filesbypkg**
>
> :   選択されたパッケージごとにファイルを表示する。
>
> **-i**, **\--info**
>
> :   名前、バージョン、説明を含めたパッケージ情報を表示する。 これは
>     **\--queryformat** を内部で使用している。
>
> **\--last**
>
> :   パッケージをインストール時刻順に、
>     最新のパッケージが先頭になるような順で並べる。
>
> **-l**, **\--list**
>
> :   パッケージ内にあるファイルを表示する。
>
> **\--provides**
>
> :   そのパッケージが提供する能力を表示する。
>
> **-R**, **\--requires**
>
> :   そのパッケージが依存するパッケージを表示する。
>
> **\--scripts**
>
> :   インストール・アンインストールの過程で使用される、
>     パッケージ固有のスクリプトを表示する。
>
> **-s , \--state**
>
> :   パッケージ内のファイルの *状態* を表示する (**-l**
>     を指定したものとみなす)。 各ファイルの状態は *normal(正常)*, *not
>     installed(インストールされていない)*, *replaced(置き換えられた)*
>     のいずれかである。
>
> **\--triggers**, **\--triggerscripts**
>
> :   パッケージにトリガースクリプトが含まれれば表示する。

検査オプション
--------------

rpm を検査するコマンドの一般的な形式は:

**rpm** {**-V\|\--verify**} \[**select-options**\]
\[**verify-options**\]

パッケージの検査では、
パッケージ内のインストールされたファイルに関する情報と、 rpm
データベースに格納されているパッケージのメタデータから得られた
ファイルに関する情報とを比較する。 とりわけ、ファイルのサイズ、MD5
チェックサム、許可属性、タイプ、 所有者、グループを比較する。
インストール時に **\--excludedocs**
オプションを使ったために除外された文書ファイルのように、
パッケージからインストールされていないファイルは静かに無視される。

パッケージ選択オプションは、パッケージ検索のためのものと
(パッケージのリストファイルを引数に指定できることも含め) 一緒である。
その他の、検査モード固有のオプションは:

**\--nodeps**

:   パッケージの依存性について検査しない。

**\--nodigest**

:   読み込み時にパッケージやへッダーのダイジェスト値を検査しない。

**\--nofiles**

:   パッケージ内のファイルのいかなる属性も検査しない。

**\--noscripts**

:   **%verifyscript** がもし存在しても実行しない。

**\--nosignature**

:   読み込み時にパッケージやへッダーの署名を検査しない。

**\--nolinkto**

:   

```{=html}
<!-- -->
```

**\--nomd5**

:   

**\--nosize**

:   

**\--nouser**

:   

**\--nogroup**

:   

**\--nomtime**

:   

**\--nomode**

:   

**\--nordev**

:   

それぞれ関連するファイル属性を検査しない。

出力の形式は 9 個の文字と属性マーク、その後ろにファイル名である。
パッケージのへッダーから得られる属性マークは:

**c**

:   **%config** 設定ファイル。

**d**

:   **%doc** 文書ファイル。

**g**

:   **%ghost**
    ファイル(すなわち、パッケージの内容物としては含まれていないファイル)。

**l**

:   **%license** ライセンスファイル。

**r**

:   **%readme** readme ファイル。

各 9 個の文字は、ファイルの属性とデータベースに記録されているその属性の
値との比較の結果を意味している。 一つの **.** (ピリオド)
はテストを通過したこと意味し、一つの **?** (クエスチョンマーク)
はテストが実施されなかった
(すなわち、ファイルパーミッションにより読み込めなかった)
ことを意味する。でなかれば、 (記憶を助けるために、ボールド化
(em**B**oldened) されている)文字は関連する **\--verify**
テストに失敗したことを意味する:

**S**

:   ファイルのサイズ (**S**ize) が異なる

**M**

:   モード (**M**ode; 許可属性とファイルの種類) が異なる

**5**

:   MD**5** チェックサムが異なる

**D**

:   デバイス (**D**evice) のメジャー/マイナー番号が一致しない

**L**

:   read**L**ink(2) したパスが一致しない

**U**

:   所有者 (**U**ser) が異なる

**G**

:   グループ (**G**roup) が異なる

**T**

:   修正時刻 (m**T**ime) が異なる

電子署名とダイジェストの検査
----------------------------

rpm の電子書名の一般的な形式は:

**rpm \--import ***PUBKEY \...*

**rpm** {**-K\|\--checksig**} \[**\--nogpg**\] \[**\--nopgp**\]
\[**\--nomd5**\]\
* PACKAGE\_FILE \...*

**\--checksig** オプションは、 パッケージの完全性と出所を確認するために
*PACKAGE\_FILE* に含まれるすべてのダイジェスト値と署名をチェックする。
現在ではパッケージが読み込まれたときはいつでも署名が検査される。
**\--checksig** の方はパッケージに付随するすべてのダイジェスト値と署名を
検査するのに有効である。

公開鍵がなければ電子署名の検査はできない。 **\--import** を使えば
**rpm** データベースに ASCII 形式での公開鍵を追加できる。
取り込まれた公開鍵はあるへッダーへと運ばれ、
パッケージ管理のように厳密な鍵リング管理が実行される。
例として、その時点で取り込まれているすべての公開鍵は以下を実行することで
表示できる。

    rpm -qa gpg-pubkey*

(訳注: 多くの場合 \"\*\" はシェルによってメタ文字として解釈されるので、
実際には rpm -qa \"gpg-pubkey\*\" のようにクォーティングする必要がある)

取り込んだ、特定の公開鍵に関する詳細は検索によって表示することができる。
Red Hat の GPG/DSA 鍵に関する情報は:

**rpm -qi gpg-pubkey-db42a60e**

最後に、パッケージでそうできるように、取り込んだ公開鍵を削除することができる。
以下は Red Hat の GPG/DSA 鍵を削除する。

**rpm -e gpg-pubkey-db42a60e**

パッケージへの署名
------------------

**rpm** {**\--addsign\|\--resign**} *PACKAGE\_FILE \...*

オプション **\--addsign** と **\--resign**
の両方とも、与えられた各パッケージ *PACKAGE\_FILE*
に対する新たな署名を生成・挿入し、既に存在する署名があれば置き換える。
歴史的な理由により二つのオプションが存在するが、
現在ではその動作に違いはない。

パッケージへの署名に GPG を使用する
-----------------------------------

GPG を使ってパッケージに署名するためには、 **rpm** が GPG
を実行するように設定されていなければならず、また、
適切な鍵で鍵リングを探すことができなければならない。 **rpm**
はデフォルトで、 GPG が鍵の環を探すのと同じ規則、すなわち環境変数
**\$GPGPATH** を使用する。 GPG が期待する場所に鍵リングが無い場合には、
使用する GPG 鍵リングの場所を **%\_gpg\_path**
マクロに設定する必要がある。

過去のバージョンの GPG, PGP, rpm との互換性のために、 V3 OpenPGP
署名パケットのみが設定されなければならない。 DSA と RSA
の検査アルゴリズムのどちらも使うことができるが、 DSA の方が好ましい。

作成したパッケージに自分自身で署名できるようにしたければ、
公開鍵と秘密鍵のペアを作成しておくことも必要である (GPG
のマニュアルを見ること)。 また、以下の **rpm**
マクロを設定することも必要であろう。

**%\_gpg\_name**

:   パッケージに署名するのに使用したい鍵のユーザ名。

例えば、実行ファイルが */usr/bin/gpg* で、鍵リングが */etc/rpm/.gpg*
にあり、その中のユーザ *\"John Doe \<jdoe\@foo.com\>\"*
としてパッケージに GPG を使って署名する場合には

    %_gpg_path /etc/rpm/.gpg
    %_gpg_name John Doe <jdoe@foo.com>
    %_gpgbin /usr/bin/gpg

をマクロの設定ファイルに含めれば良い。 システム全体の設定には
*/etc/rpm/macros* を、ユーザごとの設定には *\~/.rpmmacros* を使用する。

データベース再作成オプション
----------------------------

データベースを再作成するコマンドの一般的な形式は:

**rpm** {**\--initdb\|\--rebuilddb**} \[**-v**\] \[**\--dbpath
*DIRECTORY***\]\
\[**\--root *DIRECTORY***\]

新たなデータベースを作成する場合には **\--initdb**
を使い、インストールされているパッケージのへッダーから
データベースのインデックスを再作成するには **\--rebuilddb** を使用する。

SHOWRC
------

コマンド

**rpm \--showrc**

は、 **rpm** が使用するすべてのオプションの値を表示する。 値はファイル
*rpmrc* と *macros* で設定される。

FTP/HTTP オプション
-------------------

インターネットからパッケージを検索したりインストールできるようにするために、
**rpm** は FTP と HTTP のクライアントとして動作することができる。
インストール、アップグレード、検索するパッケージファイルは 以下の ftp
または http スタイルの URL で指定することができる。

ftp://USER:PASSWORD\@HOST:PORT/path/to/package.rpm

もし **:PASSWORD** の部分が省略された場合には、パスワードが
(ユーザ/ホスト名の組合わせごとに)尋ねられる。
ユーザとパスワードの両方が省略された場合には、 anonymous(匿名) **ftp**
が使用される。すべての場合において パッシブ (PASV) **ftp**
転送が利用される。

ftp URL において、 **rpm** では次のオプションが可能である。

**\--ftpproxy*** HOST*

:   プロキシを用いたファイアウォールを通してユーザが ftp できるように、
    すべての ftp 転送にホスト *HOST*
    はプロキシサーバーとして使用される。 マクロ **%\_ftpproxy**
    の設定でも、このオプションを指定することができる。

**\--ftpport*** PORT*

:   デフォルトのポートの代わりに、プロキシ ftp サーバの ftp
    接続に使用する TCP *PORT* (ポート)番号。 マクロ **%\_ftpport**
    の設定でも、このオプションを指定することができる。

**http** URL において、 **rpm** では次のオプションが可能である。

**\--httpproxy*** HOST*

:   すべての http 転送にホスト *HOST*
    はプロキシサーバーとして使用される。 マクロ **%\_httpproxy**
    の設定でも、このオプションを指定することができる。

**\--httpport*** PORT*

:   デフォルトのポートの代わりに、http プロキシサーバの接続で使用する
    TCP **PORT** (ポート)番号。

過去の遺産
==========

rpmbuild の実行
---------------

rpm のビルドモードは、現在では */usr/bin/rpmbuild* に含まれる。
過去との互換性は以下の popt によるエイリアスによって提供され、
それはまずまずではあるが完全ではない。 よって popt
のエイリアスを使ったビルドモードの互換性は、 rpm
から取り除かれつつある。 以前の **rpm**(8) に記述されていた **rpm**
ビルドモードについてのすべての文書は、 **rpmbuld**
パッケージをインストールし **rpmbuild**(8) を参照すること。

これからも **rpm** のコマンドラインから **rpmbuild**
を呼び出したければ、以下の行を */etc/popt* に加えればよい。

    rpm     exec --bp               rpmb -bp
    rpm     exec --bc               rpmb -bc
    rpm     exec --bi               rpmb -bi
    rpm     exec --bl               rpmb -bl
    rpm     exec --ba               rpmb -ba
    rpm     exec --bb               rpmb -bb
    rpm     exec --bs               rpmb -bs 
    rpm     exec --tp               rpmb -tp 
    rpm     exec --tc               rpmb -tc 
    rpm     exec --ti               rpmb -ti 
    rpm     exec --tl               rpmb -tl 
    rpm     exec --ta               rpmb -ta
    rpm     exec --tb               rpmb -tb
    rpm     exec --ts               rpmb -ts 
    rpm     exec --rebuild          rpmb --rebuild
    rpm     exec --recompile        rpmb --recompile
    rpm     exec --clean            rpmb --clean
    rpm     exec --rmsource         rpmb --rmsource
    rpm     exec --rmspec           rpmb --rmspec
    rpm     exec --target           rpmb --target
    rpm     exec --short-circuit    rpmb --short-circuit

ファイル
========

rpmrc 設定
----------

    /usr/lib/rpm/rpmrc
    /usr/lib/rpm/<vendor>/rpmrc
    /etc/rpmrc
    ~/.rpmrc

マクロ設定
----------

    /usr/lib/rpm/macros
    /usr/lib/rpm/<vendor>/macros
    /etc/rpm/macros
    ~/.rpmmacros

データベース
------------

    /var/lib/rpm/Basenames
    /var/lib/rpm/Conflictname
    /var/lib/rpm/Dirnames
    /var/lib/rpm/Filemd5s
    /var/lib/rpm/Group
    /var/lib/rpm/Installtid
    /var/lib/rpm/Name
    /var/lib/rpm/Packages
    /var/lib/rpm/Providename
    /var/lib/rpm/Provideversion
    /var/lib/rpm/Pubkeys
    /var/lib/rpm/Removed
    /var/lib/rpm/Requirename
    /var/lib/rpm/Requireversion
    /var/lib/rpm/Sha1header
    /var/lib/rpm/Sigmd5
    /var/lib/rpm/Triggername

一時ファイル
------------

*/var/tmp/rpm\**

関連項目
========

**popt**(3), **rpm2cpio**(8), **rpmbuild**(8),

    http://www.rpm.org/

著者
====

    Marc Ewing <marc@redhat.com>
    Jeff Johnson <jbj@redhat.com>
    Erik Troan <ewt@redhat.com>
