## RabbitMQ 3.6.12

RabbitMQ `3.6.12` is a maintenance release.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading)
for general documentation on upgrades.

This release has no other known incompatibilities with versions 3.6.7 through 3.6.11.
See the upgrade and compatibility sections in the [3.6.7 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7) if upgrading from an earlier release.


### Core Server

#### Bug Fixes

 * Process responsible for running the autoheal partition handling strategy
   could run into a deadlock with its peers, preventing autoheal from completing.

   GitHub issue: [rabbitmq-server#1346](https://github.com/rabbitmq/rabbitmq-server/issues/1346)

 * Garbage collection of mirrored queue metrics on nodes that did not
   host a leader or mirror for a queue affected delivery and acknowledgement rates.
   This could result in rates being 0 or negative when they should not be.
   
   GitHub issue: [rabbitmq-server#1340](https://github.com/rabbitmq/rabbitmq-server/issues/1340)

 * Stats emission could prevent queue mirrors from performing garbage collection
   and consume memory even when they were empty.

   GitHub issue: [rabbitmq-common#220](https://github.com/rabbitmq/rabbitmq-common/pull/220) (continuation to [rabbitmq-common#196](https://github.com/rabbitmq/rabbitmq-common/issues/196))

 * `RABBITMQ_SCHEDULER_BIND_TYPE` and `RABBITMQ_DISTRIBUTION_BUFFER_SIZE` now can be set via `rabbitmq-env.conf`.
 
   GitHub issue: [rabbitmq-server#1338](https://github.com/rabbitmq/rabbitmq-server/issues/1338)


### Shovel Management Plugin

#### Bug Fixes

  * Passwords in source and destination URIs are now redacted out.
  
    GitHub issue: [rabbitmq-federation-management#15](https://github.com/rabbitmq/rabbitmq-federation-management/issues/15)


### Federation Management Plugin

#### Bug Fixes

  * Passwords in upstream URIs are now redacted out.
  
    GitHub issue: [rabbitmq-federation-management#15](https://github.com/rabbitmq/rabbitmq-federation-management/issues/15)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained.
When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.12.tar.gz`.
