% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reclass.R
\name{CLASS}
\alias{CLASS}
\alias{CLASS<-}
\title{Extract and Set .CLASS Attribute}
\usage{
CLASS(x)

CLASS(x) <- value
}
\arguments{
\item{x}{An xts object.}

\item{value}{The new value to assign to the '.CLASS' attribute.}
}
\value{
Called for its side-effect of changing the '.CLASS' attribute.
}
\description{
Extraction and replacement functions to access the xts '.CLASS' attribute.
The '.CLASS' attribute is used by \code{reclass()} to transform an xts object
back to its original class.
}
\details{
This is meant for use in conjunction with \code{try.xts()} and \code{reclass()} and is
is not intended for daily use. While it's possible to interactively coerce
objects to other classes than originally derived from, it's likely to cause
unexpected behavior. It is best to use the usual \code{as.xts()} and other
classes' \code{as} methods.
}
\seealso{
\code{\link[=as.xts]{as.xts()}}, \code{\link[=reclass]{reclass()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
