% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-number.R
\name{comma}
\alias{comma}
\alias{number_format}
\alias{comma_format}
\title{Superseded interface to \code{label_number()}/\code{label_comma()}}
\usage{
comma(
  x,
  accuracy = NULL,
  scale = 1,
  prefix = "",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  digits,
  ...
)

number_format(
  accuracy = NULL,
  scale = 1,
  prefix = "",
  suffix = "",
  big.mark = " ",
  decimal.mark = ".",
  style_positive = c("none", "plus", "space"),
  style_negative = c("hyphen", "minus", "parens"),
  scale_cut = NULL,
  trim = TRUE,
  ...
)

comma_format(
  accuracy = NULL,
  scale = 1,
  prefix = "",
  suffix = "",
  big.mark = ",",
  decimal.mark = ".",
  trim = TRUE,
  digits,
  ...
)
}
\arguments{
\item{x}{A numeric vector to format.}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}

\item{prefix}{Additional text to display before the number. The suffix is
applied to absolute value before \code{style_positive} and \code{style_negative} are
processed so that \code{prefix = "$"} will yield (e.g.) \verb{-$1} and \verb{($1)}.}

\item{suffix}{Additional text to display after the number.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{digits}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{accuracy} instead.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{style_positive}{A string that determines the style of positive numbers:
\itemize{
\item \code{"none"} (the default): no change, e.g. \code{1}.
\item \code{"plus"}: preceded by \code{+}, e.g. \code{+1}.
\item \code{"space"}: preceded by a Unicode "figure space", i.e., a space equally
as wide as a number or \code{+}. Compared to \code{"none"}, adding a figure space
can ensure numbers remain properly aligned when they are left- or
right-justified.
}}

\item{style_negative}{A string that determines the style of negative numbers:
\itemize{
\item \code{"hyphen"} (the default): preceded by a standard hypen \code{-}, e.g. \code{-1}.
\item \code{"minus"}, uses a proper Unicode minus symbol. This is a typographical
nicety that ensures \code{-} aligns with the horizontal bar of the
the horizontal bar of \code{+}.
\item \code{"parens"}, wrapped in parentheses, e.g. \code{(1)}.
}}

\item{scale_cut}{Named numeric vector that allows you to rescale large
(or small) numbers and add a prefix. Built-in helpers include:
\itemize{
\item \code{cut_short_scale()}: [10^3, 10^6) = K, [10^6, 10^9) = M, [10^9, 10^12) = B, [10^12, Inf) = T.
\item \code{cut_long_scale()}: [10^3, 10^6) = K, [10^6, 10^12) = M, [10^12, 10^18) = B, [10^18, Inf) = T.
\item \code{cut_si(unit)}: uses standard SI units.
}

If you supply a vector \code{c(a = 100, b = 1000)}, absolute values in the
range \verb{[0, 100)} will not be rescaled, absolute values in the range \verb{[100, 1000)}
will be divided by 100 and given the suffix "a", and absolute values in
the range \verb{[1000, Inf)} will be divided by 1000 and given the suffix "b".
If the division creates an irrational value (or one with many digits), the
cut value below will be tried to see if it improves the look of the final
label.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These functions are kept for backward compatibility; you should switch
to \code{\link[=label_number]{label_number()}}/\code{\link[=label_comma]{label_comma()}} for new code.
}
\keyword{internal}
