% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg.R
\name{check_required}
\alias{check_required}
\title{Check that argument is supplied}
\usage{
check_required(x, arg = caller_arg(x), call = caller_env())
}
\arguments{
\item{x}{A function argument. Must be a symbol.}

\item{arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}
}
\description{
Throws an error if \code{x} is missing.
}
\examples{
f <- function(x)  {
  check_required(x)
}

# Fails because `x` is not supplied
try(f())

# Succeeds
f(NULL)
}
\seealso{
\code{\link[=arg_match]{arg_match()}}
}
