% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotDistr}
\alias{plotDistr}
\title{Plot a probability density, mass, or distribution function.}
\usage{
plotDistr(
  x,
  p,
  discrete = FALSE,
  cdf = FALSE,
  regions = NULL,
  col = "gray",
  legend = TRUE,
  legend.pos = "topright",
  ...
)
}
\arguments{
\item{x}{horizontal coordinates}

\item{p}{vertical coordinates}

\item{discrete}{is the random variable discrete?}

\item{cdf}{is this a cumulative distribution (as opposed to mass) function?}

\item{regions}{for continuous distributions only, if non-\code{NULL}, a list of regions to fill with color \code{col}; each element of the list is a pair of \code{x} values with the minimum and maximum horizontal coordinates of the corresponding region.}

\item{col}{color for plot, \code{col} may be a single value or a vector.}

\item{legend}{plot a legend of the regions (default \code{TRUE}).}

\item{legend.pos}{position for the legend (see \code{\link[graphics]{legend}}, default \code{"topright"}).}

\item{\dots}{arguments to be passed to \code{plot}.}
}
\value{
Produces a plot; returns \code{NULL} invisibly.
}
\description{
Plot a probability density, mass, or distribution function.
}
\details{
This function plots a probability density, mass, or distribution function, adapting the form of the plot as appropriate.
}
\examples{
x <- seq(-4, 4, length=100)
plotDistr(x, dnorm(x), xlab="Z", ylab="p(z)", main="Standard Normal Density")
plotDistr(x, dnorm(x), xlab="Z", ylab="p(z)", main="Standard Normal Density",
          region=list(c(1.96, Inf), c(-Inf, -1.96)), col=c("red", "blue"), new = TRUE)
plotDistr(x, dnorm(x), xlab="Z", ylab="p(z)", main="Standard Normal Density",
          region=list(c(qnorm(0), qnorm(.025)), c(qnorm(.975), qnorm(1)))) # same

x <- 0:10
plotDistr(x, pbinom(x, 10, 0.5), xlab="successes", discrete=TRUE, cdf=TRUE,
          main="Binomial Distribution Function, p=0.5, n=10")

}
\author{
John Fox
}
\keyword{hplot}
