% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe_call_linter.R
\name{pipe_call_linter}
\alias{pipe_call_linter}
\title{Pipe call linter}
\usage{
pipe_call_linter()
}
\description{
Force explicit calls in magrittr pipes, e.g., \code{1:3 \%>\% sum()} instead of \code{1:3 \%>\% sum}.
Note that native pipe always requires a function call, i.e. \verb{1:3 |> sum} will produce an error.
}
\examples{
# will produce lints
lint(
  text = "1:3 \%>\% mean \%>\% as.character",
  linters = pipe_call_linter()
)

# okay
lint(
  text = "1:3 \%>\% mean() \%>\% as.character()",
  linters = pipe_call_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=readability_linters]{readability}, \link[=style_linters]{style}
}
