% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{allowDirectories}
\alias{allowDirectories}
\title{Allow server to access files in the directory}
\usage{
allowDirectories(dirs = NULL)
}
\arguments{
\item{dirs}{Vector of paths to existing directories. Can be absolute paths, or paths relative to 
the current working directory. If the specified directory doesn't exist, it will be ignored and a
warning will be produced. If \code{NULL}, returns absolute paths to all currently allowed directories.}
}
\value{
Absolute paths to all currently allowed directories, if \code{dirs = NULL}.
}
\description{
This function adds paths to existing directories to the list of allowed directories,
which can be accessed from the server. To any request for files from outside
of the allowed directories the server will response with \code{403 Forbidden} error.
\code{rootDirectory} (see \code{\link{openPage}}) can always be accessed. By default,
when the app is initialized, current working directory  
is added to the list of allowed directories. Further changes
of the working directory will not have any affect on this list or files accessibility.
}
\details{
This function is a wrapper around \code{allowDirectories} method of class \code{\link{App}}.
}
\examples{
\dontrun{
openPage()
# The directories must exist
allowDirectories(c("~/directory1", "../anotherDirectory"))
dirs <- allowDirectories()
closePage()}

}
\seealso{
\code{\link{openPage}} (check arguments \code{rootDirectory} and \code{allowedDirectories}).
}
