% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet_add.R
\name{sheet_add}
\alias{sheet_add}
\title{Add one or more (work)sheets}
\usage{
sheet_add(ss, sheet = NULL, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:as_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[=gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{One or more new sheet names. If unspecified, one new sheet is
added and Sheets autogenerates a name of the form "SheetN".}

\item{...}{Optional parameters to specify additional properties, common to
all of the new sheet(s). Not relevant to most users. Specify fields of the
\href{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/sheets#SheetProperties}{\code{SheetProperties} schema}
in \code{name = value} form.}

\item{.before, .after}{Optional specification of where to put the new sheet(s). Specify, at most, one of \code{.before} and \code{.after}. Refer to an existing sheet by name (via a string) or by position (via a number). If unspecified, Sheets puts the new sheet(s) at the end.}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
Adds one or more (work)sheets to an existing (spread)Sheet. Note that sheet
names must be unique.
}
\examples{
\dontshow{if (gs4_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ss <- gs4_create("add-sheets-to-me")

# the only required argument is the target spreadsheet
ss \%>\% sheet_add()

# but you CAN specify sheet name and/or position
ss \%>\% sheet_add("apple", .after = 1)
ss \%>\% sheet_add("banana", .after = "apple")

# add multiple sheets at once
ss \%>\% sheet_add(c("coconut", "dragonfruit"))

# keeners can even specify additional sheet properties
ss \%>\%
  sheet_add(
    sheet = "eggplant",
    .before = 1,
    gridProperties = list(
      rowCount = 3, columnCount = 6, frozenRowCount = 1
    )
  )

# get an overview of the sheets
sheet_properties(ss)

# clean up
gs4_find("add-sheets-to-me") \%>\%
  googledrive::drive_trash()
\dontshow{\}) # examplesIf}
}
\seealso{
Makes a batch of \code{AddSheetRequest}s (one per sheet):
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#addsheetrequest}
}

Other worksheet functions: 
\code{\link{sheet_append}()},
\code{\link{sheet_copy}()},
\code{\link{sheet_delete}()},
\code{\link{sheet_properties}()},
\code{\link{sheet_relocate}()},
\code{\link{sheet_rename}()},
\code{\link{sheet_resize}()},
\code{\link{sheet_write}()}
}
\concept{worksheet functions}
