% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignment-methods.R
\name{sample_data<-}
\alias{sample_data<-}
\alias{assign-sample_data}
\title{Assign (new) sample_data to \code{x}}
\usage{
sample_data(x) <- value
}
\arguments{
\item{x}{(Required). \code{\link{phyloseq-class}}. The object to modify.}

\item{value}{(Required). Either a \code{\link{sample_data-class}}, 
a \code{data.frame} that can be coerced into \code{\link{sample_data-class}}, 
or a \code{\link{phyloseq-class}} that contains a 
suitable \code{sample_data} component to assign to \code{x}. If unsure,
try \code{\link{sample_data}}\code{(value)}, which should return a 
\code{\link{sample_data-class}} object without error.}
}
\value{
No return. This is an assignment statement.
}
\description{
This replaces the current \code{sample_data} component of \code{x} with 
\code{value}, if \code{value} is a \code{\link{sample_data-class}}. However,
if \code{value} is a \code{data.frame}, then \code{value} is first coerced to
a \code{\link{sample_data-class}}, and then assigned. Alternatively, if 
\code{value} is \code{\link{phyloseq-class}}, then the 
\code{\link{sample_data}} component will first be accessed from \code{value}
 and then assigned. This makes possible some concise assignment/replacement
 statements when adjusting, modifying, or building subsets of 
 experiment-level data. See some examples below.
 
Internally, this re-builds the \code{\link{phyloseq-class}} object using
the standard \code{\link{phyloseq}} constructor. Thus, index mismatches
between sample-describing components will not be allowed, and subsetting
will occurr automatically such that only the intersection of sample IDs
are included in any components. This has the added benefit of re-checking
(internally) for any other issues.
}
\examples{
 data(soilrep)
 soilrep
 head(sample_data(soilrep))
 sample_data(soilrep)$Time <- as.integer(substr(sample_data(soilrep)$Sample, 1, 1))
 head(sample_data(soilrep))
}
