// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (C) 2014, 2015 O.S. Systems Software LTDA.
 * Copyright (C) 2014 Kynetics LLC.
 * Copyright (C) 2014 Revolution Robotics, Inc.
 *
 * Author: Otavio Salvador <otavio@ossystems.com.br>
 */

#include <init.h>
#include <asm/arch/clock.h>
#include <asm/arch/iomux.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/mx6-pins.h>
#include <asm/arch/sys_proto.h>
#include <asm/global_data.h>
#include <asm/gpio.h>
#include <asm/mach-imx/iomux-v3.h>
#include <asm/mach-imx/mxc_i2c.h>
#include <asm/io.h>
#include <linux/sizes.h>
#include <common.h>
#include <watchdog.h>
#include <fsl_esdhc_imx.h>
#include <i2c.h>
#include <mmc.h>
#include <usb.h>
#include <power/pmic.h>

DECLARE_GLOBAL_DATA_PTR;

#define UART_PAD_CTRL (PAD_CTL_PUS_100K_UP | \
	PAD_CTL_SPEED_MED | PAD_CTL_DSE_40ohm | \
	PAD_CTL_SRE_FAST  | PAD_CTL_HYS | \
	PAD_CTL_LVE)

#define USDHC_PAD_CTRL (PAD_CTL_PUS_22K_UP | \
	PAD_CTL_SPEED_LOW | PAD_CTL_DSE_80ohm | \
	PAD_CTL_SRE_FAST  | PAD_CTL_HYS | \
	PAD_CTL_LVE)

#define I2C_PAD_CTRL (PAD_CTL_PKE | PAD_CTL_PUE |		\
		      PAD_CTL_PUS_100K_UP | PAD_CTL_SPEED_MED |	\
		      PAD_CTL_DSE_40ohm | PAD_CTL_HYS |		\
		      PAD_CTL_ODE | PAD_CTL_SRE_FAST)

#define CONFIG_POWER_MAX77696_I2C_ADDR	0x3C

enum {
	L01_CNFG1 =	0x43,
	L01_CNFG2,
	L02_CNFG1,
	L02_CNFG2,
	L03_CNFG1,
	L03_CNFG2,
	L04_CNFG1,
	L04_CNFG2,
	L05_CNFG1,
	L05_CNFG2,
	L06_CNFG1,
	L06_CNFG2,
	L07_CNFG1,
	L07_CNFG2,
	L08_CNFG1,
	L08_CNFG2,
	L09_CNFG1,
	L09_CNFG2,
	L10_CNFG1,
	L10_CNFG2,
	LDO_INT1,
	LDO_INT2,
	LDO_INT1M,
	LDO_INT2M,
	LDO_CNFG3,
	SW1_CNTRL,
	SW2_CNTRL,
	SW3_CNTRL,
	SW4_CNTRL,
	EPDCNFG,
	EPDINTS,
	EPDINT,
	EPDINTM,
	EPDVCOM,
	EPDVEE,
	EPDVNEG,
	EPDVPOS,
	EPDVDDH,
	EPDSEQ,
	EPDOKINTS,
	CID =	0x9c,
	PMIC_NUM_OF_REGS,
};

int dram_init(void)
{
	gd->ram_size = imx_ddr_size();

	return 0;
}

static void setup_iomux_uart(void)
{
	static iomux_v3_cfg_t const uart1_pads[] = {
		MX6_PAD_UART1_TXD__UART1_TXD | MUX_PAD_CTRL(UART_PAD_CTRL),
		MX6_PAD_UART1_RXD__UART1_RXD | MUX_PAD_CTRL(UART_PAD_CTRL),
	};

	imx_iomux_v3_setup_multiple_pads(uart1_pads, ARRAY_SIZE(uart1_pads));
}

static struct fsl_esdhc_cfg usdhc_cfg[1] = {
	{USDHC2_BASE_ADDR, 0, 0, 0, 1},
};

int board_mmc_getcd(struct mmc *mmc)
{
	return 1;	/* Assume boot SD always present */
}

int board_mmc_init(struct bd_info *bis)
{
	static iomux_v3_cfg_t const usdhc2_pads[] = {
		MX6_PAD_SD2_CLK__USDHC2_CLK | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_CMD__USDHC2_CMD | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_RST__USDHC2_RST | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT0__USDHC2_DAT0 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT1__USDHC2_DAT1 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT2__USDHC2_DAT2 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT3__USDHC2_DAT3 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT4__USDHC2_DAT4 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT5__USDHC2_DAT5 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT6__USDHC2_DAT6 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
		MX6_PAD_SD2_DAT7__USDHC2_DAT7 | MUX_PAD_CTRL(USDHC_PAD_CTRL),
	};

	imx_iomux_v3_setup_multiple_pads(usdhc2_pads, ARRAY_SIZE(usdhc2_pads));

	usdhc_cfg[0].sdhc_clk = mxc_get_clock(MXC_ESDHC2_CLK);
	return fsl_esdhc_initialize(bis, &usdhc_cfg[0]);
}

int board_usb_phy_mode(int port)
{
	return USB_INIT_DEVICE;
}

/* I2C1 for PMIC */
#define I2C_PMIC	0
#define PC	MUX_PAD_CTRL(I2C_PAD_CTRL)
struct i2c_pads_info i2c_pad_info1 = {
	.sda = {
		.i2c_mode = MX6_PAD_I2C1_SDA__I2C1_SDA | PC,
		.gpio_mode = MX6_PAD_I2C1_SDA__GPIO_3_13 | PC,
		.gp = IMX_GPIO_NR(3, 13),
	},
	.scl = {
		.i2c_mode = MX6_PAD_I2C1_SCL__I2C1_SCL | PC,
		.gpio_mode = MX6_PAD_I2C1_SCL__GPIO_3_12 | PC,
		.gp = IMX_GPIO_NR(3, 12),
	},
};

static int power_max77696_init(unsigned char bus)
{
	static const char name[] = "MAX77696";
	struct pmic *p = pmic_alloc();

	if (!p) {
		printf("%s: POWER allocation error!\n", __func__);
		return -ENOMEM;
	}

	p->name = name;
	p->interface = PMIC_I2C;
	p->number_of_regs = PMIC_NUM_OF_REGS;
	p->hw.i2c.addr = CONFIG_POWER_MAX77696_I2C_ADDR;
	p->hw.i2c.tx_num = 1;
	p->bus = bus;

	return 0;
}

int power_init_board(void)
{
	struct pmic *p;
	int ret;
	unsigned int reg;

	ret = power_max77696_init(I2C_PMIC);
	if (ret)
		return ret;

	p = pmic_get("MAX77696");
	if (!p)
		return -EINVAL;

	ret = pmic_reg_read(p, CID, &reg);
	if (ret)
		return ret;

	printf("PMIC:  MAX77696 detected, rev=0x%x\n", reg);

	return pmic_probe(p);
}

int board_early_init_f(void)
{
	setup_iomux_uart();
	return 0;
}

int board_init(void)
{
	/* address of boot parameters */
	gd->bd->bi_boot_params = PHYS_SDRAM + 0x100;

	setup_i2c(0, CONFIG_SYS_I2C_SPEED, 0x7f, &i2c_pad_info1);

	return 0;
}

int board_late_init(void)
{
#ifdef CONFIG_HW_WATCHDOG
	hw_watchdog_init();
#endif

	return 0;
}

int checkboard(void)
{
	puts("Board: WaRP Board\n");

	return 0;
}
