# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AddSubscriptionOperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Add Subscription Operation state enum."""

    SUCCEEDED = "Succeeded"
    """Succeeded - State when Add Subscription operation succeeded"""
    UPDATING = "Updating"
    """Updating - State when Add Subscription operation is being Updated"""
    FAILED = "Failed"
    """Failed - State when Add Subscription operation failed"""


class AutonomousDatabaseBackupLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Autonomous database backup lifecycle state enum."""

    CREATING = "Creating"
    """AutonomousDatabase backup is creating"""
    ACTIVE = "Active"
    """AutonomousDatabase backup is active"""
    DELETING = "Deleting"
    """AutonomousDatabase backup is deleting"""
    FAILED = "Failed"
    """AutonomousDatabase backup is failed"""
    UPDATING = "Updating"
    """AutonomousDatabase backup is updating"""


class AutonomousDatabaseBackupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Autonomous database backup type enum."""

    INCREMENTAL = "Incremental"
    """Incremental backup"""
    FULL = "Full"
    """Full backup"""
    LONG_TERM = "LongTerm"
    """LongTerm backup"""


class AutonomousDatabaseLifecycleActionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Autonomous Database Action Enum."""

    START = "Start"
    """Start Autonomous Database"""
    STOP = "Stop"
    """Stop Autonomous Database"""
    RESTART = "Restart"
    """Restart Autonomous Database"""


class AutonomousDatabaseLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Autonomous database lifecycle state enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    STOPPING = "Stopping"
    """Indicates that resource in Stopping state"""
    STOPPED = "Stopped"
    """Indicates that resource in Stopped state"""
    STARTING = "Starting"
    """Indicates that resource in Starting state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    UNAVAILABLE = "Unavailable"
    """Indicates that resource in Unavailable state"""
    RESTORE_IN_PROGRESS = "RestoreInProgress"
    """Indicates that resource in RestoreInProgress state"""
    RESTORE_FAILED = "RestoreFailed"
    """Indicates that resource in RestoreFailed state"""
    BACKUP_IN_PROGRESS = "BackupInProgress"
    """Indicates that resource in BackupInProgress state"""
    SCALE_IN_PROGRESS = "ScaleInProgress"
    """Indicates that resource in ScaleInProgress state"""
    AVAILABLE_NEEDS_ATTENTION = "AvailableNeedsAttention"
    """Indicates that resource is available but needs attention"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    MAINTENANCE_IN_PROGRESS = "MaintenanceInProgress"
    """Indicates that resource maintenance in progress state"""
    RESTARTING = "Restarting"
    """Indicates that resource in Restarting state"""
    RECREATING = "Recreating"
    """Indicates that resource in Recreating state"""
    ROLE_CHANGE_IN_PROGRESS = "RoleChangeInProgress"
    """Indicates that resource role change in progress state"""
    UPGRADING = "Upgrading"
    """Indicates that resource in Upgrading state"""
    INACCESSIBLE = "Inaccessible"
    """IIndicates that resource in Inaccessible state"""
    STANDBY = "Standby"
    """Indicates that resource in Standby state"""


class AutonomousMaintenanceScheduleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Autonomous database maintenance schedule type enum."""

    EARLY = "Early"
    """Early maintenance schedule"""
    REGULAR = "Regular"
    """Regular maintenance schedule"""


class AzureResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Azure Resource Provisioning State enum."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""


class BaseDbSystemShapes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allowed values for BaseDb System Shapes."""

    VM_STANDARD_X86 = "VM.Standard.x86"
    """Vm Standard X86"""


class CloneType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Clone type enum."""

    FULL = "Full"
    """Full clone"""
    METADATA = "Metadata"
    """Metadata only"""


class CloudAccountProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CloudAccountProvisioningState enum."""

    PENDING = "Pending"
    """Pending - Initial state when Oracle cloud account is not configured"""
    PROVISIONING = "Provisioning"
    """Provisioning - State when Oracle cloud account is being provisioned"""
    AVAILABLE = "Available"
    """Available - State when Oracle cloud account cloud linking is complete and it is available"""


class CloudExadataInfrastructureLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CloudExadataInfrastructureLifecycleState enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    MAINTENANCE_IN_PROGRESS = "MaintenanceInProgress"
    """Indicates that resource maintenance in progress state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""


class CloudVmClusterLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cloud VM Cluster lifecycle state enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    MAINTENANCE_IN_PROGRESS = "MaintenanceInProgress"
    """Indicates that resource Maintenance in progress state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""


class ComputeModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Compute model enum."""

    ECPU = "ECPU"
    """ECPU model type"""
    OCPU = "OCPU"
    """OCPU model type"""


class ConsumerGroup(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Consumer group enum."""

    HIGH = "High"
    """High group"""
    MEDIUM = "Medium"
    """Medium group"""
    LOW = "Low"
    """Low group"""
    TP = "Tp"
    """TP group"""
    TPURGENT = "Tpurgent"
    """TPurgent group"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DatabaseEditionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Database edition type enum."""

    STANDARD_EDITION = "StandardEdition"
    """Standard edition"""
    ENTERPRISE_EDITION = "EnterpriseEdition"
    """Enterprise edition"""


class DataBaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Database type enum."""

    REGULAR = "Regular"
    """Regular DB"""
    CLONE = "Clone"
    """Clone DB"""
    CLONE_FROM_BACKUP_TIMESTAMP = "CloneFromBackupTimestamp"
    """Clone DB from backup timestamp"""
    CROSS_REGION_DISASTER_RECOVERY = "CrossRegionDisasterRecovery"
    """Cross Region Disaster Recovery"""


class DataSafeStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataSafe status type enum."""

    REGISTERING = "Registering"
    """Registering status"""
    REGISTERED = "Registered"
    """Registered status"""
    DEREGISTERING = "Deregistering"
    """Deregistering status"""
    NOT_REGISTERED = "NotRegistered"
    """NotRegistered status"""
    FAILED = "Failed"
    """Failed status"""


class DayOfWeekName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DayOfWeekName enum."""

    MONDAY = "Monday"
    """Monday value"""
    TUESDAY = "Tuesday"
    """Tuesday value"""
    WEDNESDAY = "Wednesday"
    """Wednesday value"""
    THURSDAY = "Thursday"
    """Thursday value"""
    FRIDAY = "Friday"
    """Friday value"""
    SATURDAY = "Saturday"
    """Saturday value"""
    SUNDAY = "Sunday"
    """Sunday value"""


class DbNodeActionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DbNode action enum."""

    START = "Start"
    """Start DbNode"""
    STOP = "Stop"
    """Stop DbNode"""
    SOFT_RESET = "SoftReset"
    """Soft reset DbNode"""
    RESET = "Reset"
    """Reset DbNode"""


class DbNodeMaintenanceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of database node maintenance."""

    VMDB_REBOOT_MIGRATION = "VmdbRebootMigration"
    """VMDB reboot migration maintenance type"""


class DbNodeProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DnNode provisioning state enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    STOPPING = "Stopping"
    """Indicates that resource in Stopping state"""
    STOPPED = "Stopped"
    """Indicates that resource in Stopped state"""
    STARTING = "Starting"
    """Indicates that resource in Starting state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""


class DbServerPatchingStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DB Server patching status enum."""

    SCHEDULED = "Scheduled"
    """Patching scheduled"""
    MAINTENANCE_IN_PROGRESS = "MaintenanceInProgress"
    """Patching in progress"""
    FAILED = "Failed"
    """Patching failed"""
    COMPLETE = "Complete"
    """Patching completed"""


class DbServerProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DbServerProvisioningState enum."""

    CREATING = "Creating"
    """Indicates that resource in Creating state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    UNAVAILABLE = "Unavailable"
    """Indicates that resource in Unavailable state"""
    DELETING = "Deleting"
    """Indicates that resource in Deleting state"""
    DELETED = "Deleted"
    """Indicates that resource in Deleted state"""
    MAINTENANCE_IN_PROGRESS = "MaintenanceInProgress"
    """Indicates that resource maintenance in progress state"""


class DbSystemDatabaseEditionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Database edition type enum."""

    STANDARD_EDITION = "StandardEdition"
    """Standard edition"""
    ENTERPRISE_EDITION = "EnterpriseEdition"
    """Enterprise edition"""
    ENTERPRISE_EDITION_HIGH_PERFORMANCE = "EnterpriseEditionHighPerformance"
    """Enterprise edition high performance"""
    ENTERPRISE_EDITION_EXTREME = "EnterpriseEditionExtreme"
    """Enterprise edition extreme"""
    ENTERPRISE_EDITION_DEVELOPER = "EnterpriseEditionDeveloper"
    """Enterprise edition developer"""


class DbSystemLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DB System lifecycle state enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""
    MIGRATED = "Migrated"
    """Indicates that resource is Migrated state"""
    MAINTENANCE_IN_PROGRESS = "MaintenanceInProgress"
    """Indicates that resource maintenance in progress state"""
    NEEDS_ATTENTION = "NeedsAttention"
    """Indicates that resource needs attention state"""
    UPGRADING = "Upgrading"
    """Indicates that resource in Upgrading state"""


class DbSystemSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The DbSystem source type of the database."""

    NONE = "None"
    """for creating a new database."""


class DisasterRecoveryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Disaster recovery type enum."""

    ADG = "Adg"
    """ADG type"""
    BACKUP_BASED = "BackupBased"
    """Backup based type"""


class DiskRedundancy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Disk redundancy enum."""

    HIGH = "High"
    """High redundancy"""
    NORMAL = "Normal"
    """Normal redundancy"""


class DiskRedundancyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Disk redundancy type enum."""

    HIGH = "High"
    """3-way redundancy."""
    NORMAL = "Normal"
    """2-way redundancy."""


class DnsPrivateViewsLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DNS Private Views lifecycle state enum."""

    ACTIVE = "Active"
    """DNS Private View is active"""
    DELETED = "Deleted"
    """DNS Private View is deleted"""
    DELETING = "Deleting"
    """DNS Private View is deleting"""
    UPDATING = "Updating"
    """DNS Private View is updating"""


class DnsPrivateZonesLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DNS Private Zones lifecycle state enum."""

    ACTIVE = "Active"
    """DNS Private Zones is active"""
    CREATING = "Creating"
    """DNS Private Zones is creating"""
    DELETED = "Deleted"
    """DNS Private Zones is deleted"""
    DELETING = "Deleting"
    """DNS Private Zones is deleting"""
    UPDATING = "Updating"
    """DNS Private Zones is updating"""


class ExadataVmClusterStorageManagementType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of storage management for the Cloud VM Cluster if its ASM or Exascale."""

    ASM = "ASM"
    """Indicates that storage management for the Cloud VM Cluster is ASM"""
    EXASCALE = "Exascale"
    """Indicates that storage management for the Cloud VM Cluster is Exascale"""


class ExadbVmClusterLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Exadata VM cluster on Exascale Infrastructure lifecycle state enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    MAINTENANCE_IN_PROGRESS = "MaintenanceInProgress"
    """Indicates that resource Maintenance in progress state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""


class ExascaleDbStorageVaultLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Exadata Database Storage Vault lifecycle state enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""


class GenerateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Generate type enum."""

    SINGLE = "Single"
    """Generate single"""
    ALL = "All"
    """Generate all"""


class GridImageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GridImageType enum."""

    RELEASE_UPDATE = "ReleaseUpdate"
    """Release update"""
    CUSTOM_IMAGE = "CustomImage"
    """Custom image"""


class HardwareType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Hardware Type enum."""

    COMPUTE = "COMPUTE"
    """Hardware type is Database Server"""
    CELL = "CELL"
    """Hardware type is Storage Server"""


class HostFormatType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Host format type enum."""

    FQDN = "Fqdn"
    """FQDN format"""
    IP = "Ip"
    """IP format"""


class Intent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Intent enum."""

    RETAIN = "Retain"
    """Retain intent"""
    RESET = "Reset"
    """Reset intent"""


class IormLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ORM lifecycle state enum."""

    BOOT_STRAPPING = "BootStrapping"
    """Indicates that resource in Provisioning state"""
    ENABLED = "Enabled"
    """Indicates that resource in Enabled state"""
    DISABLED = "Disabled"
    """Indicates that resource in Disabled state"""
    UPDATING = "Updating"
    """Indicates that resource in Updating state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""


class LicenseModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LicenseModel enum."""

    LICENSE_INCLUDED = "LicenseIncluded"
    """License included"""
    BRING_YOUR_OWN_LICENSE = "BringYourOwnLicense"
    """Bring Your Own License"""


class MonthName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MonthName enum."""

    JANUARY = "January"
    """January value"""
    FEBRUARY = "February"
    """February value"""
    MARCH = "March"
    """March value"""
    APRIL = "April"
    """April value"""
    MAY = "May"
    """May value"""
    JUNE = "June"
    """June value"""
    JULY = "July"
    """July value"""
    AUGUST = "August"
    """August value"""
    SEPTEMBER = "September"
    """September value"""
    OCTOBER = "October"
    """October value"""
    NOVEMBER = "November"
    """November value"""
    DECEMBER = "December"
    """December value"""


class Objective(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Objective enum."""

    LOW_LATENCY = "LowLatency"
    """Low latency objective"""
    HIGH_THROUGHPUT = "HighThroughput"
    """High throughput objective"""
    BALANCED = "Balanced"
    """Balanced objective"""
    AUTO = "Auto"
    """Auto objective"""
    BASIC = "Basic"
    """Basic objective"""


class OpenModeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Open mode type enum."""

    READ_ONLY = "ReadOnly"
    """ReadOnly mode"""
    READ_WRITE = "ReadWrite"
    """ReadWrite mode"""


class OperationsInsightsStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operations Insights status type enum."""

    ENABLING = "Enabling"
    """Enabling status"""
    ENABLED = "Enabled"
    """Enabled status"""
    DISABLING = "Disabling"
    """Disabling status"""
    NOT_ENABLED = "NotEnabled"
    """NotEnabled status"""
    FAILED_ENABLING = "FailedEnabling"
    """FailedEnabling status"""
    FAILED_DISABLING = "FailedDisabling"
    """FailedDisabling status"""


class OracleSubscriptionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OracleSubscriptionProvisioningState enum."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PatchingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Patching mode enum."""

    ROLLING = "Rolling"
    """Rolling patching"""
    NON_ROLLING = "NonRolling"
    """Non Rolling patching"""


class PermissionLevelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Permission level type enum."""

    RESTRICTED = "Restricted"
    """Restricted permission level"""
    UNRESTRICTED = "Unrestricted"
    """Unrestricted permission level"""


class Preference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Preference enum."""

    NO_PREFERENCE = "NoPreference"
    """No preference"""
    CUSTOM_PREFERENCE = "CustomPreference"
    """Custom preference"""


class ProtocolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol type enum."""

    TCP = "TCP"
    """TCP protocol"""
    TCPS = "TCPS"
    """TCPS protocol"""


class RefreshableModelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Refreshable model type enum."""

    AUTOMATIC = "Automatic"
    """Automatic refreshable model type"""
    MANUAL = "Manual"
    """Manual refreshable model type"""


class RefreshableStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Refreshable status type enum."""

    REFRESHING = "Refreshing"
    """Refreshing status"""
    NOT_REFRESHING = "NotRefreshing"
    """NotRefreshing status"""


class RepeatCadenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Repeat cadence type enum."""

    ONE_TIME = "OneTime"
    """Repeat one time"""
    WEEKLY = "Weekly"
    """Repeat weekly"""
    MONTHLY = "Monthly"
    """Repeat monthly"""
    YEARLY = "Yearly"
    """Repeat yearly"""


class ResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource type."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class RoleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Role type enum."""

    PRIMARY = "Primary"
    """Primary role"""
    STANDBY = "Standby"
    """Standby role"""
    DISABLED_STANDBY = "DisabledStandby"
    """DisabledStandby role"""
    BACKUP_COPY = "BackupCopy"
    """BackupCopy role"""
    SNAPSHOT_STANDBY = "SnapshotStandby"
    """SnapshotStandby role"""


class SessionModeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Session mode type enum."""

    DIRECT = "Direct"
    """Direct session mode"""
    REDIRECT = "Redirect"
    """Redirect session mode"""


class ShapeAttribute(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of Exascale storage used for Exadata VM cluster. The default is SMART_STORAGE which
    supports Oracle Database 23ai and later.
    """

    SMART_STORAGE = "SMART_STORAGE"
    """Smart storage"""
    BLOCK_STORAGE = "BLOCK_STORAGE"
    """block storage"""


class ShapeFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allowed values for GI Minor Versions shapeFamily filter."""

    EXADATA = "EXADATA"
    """Family value for Exadata Shape"""
    EXADB_XS = "EXADB_XS"
    """Family value for Exadb XS Shape"""


class ShapeFamilyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allowed values for shape family."""

    EXADATA = "EXADATA"
    """Family value for Exadata Shape"""
    EXADB_XS = "EXADB_XS"
    """Family value for Exadb XS Shape"""
    SINGLE_NODE = "SINGLENODE"
    """Family value for Single Node Shape"""
    VIRTUAL_MACHINE = "VIRTUALMACHINE"
    """Family value for Virtual Machine Shape"""


class SourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source type enum."""

    NONE = "None"
    """None source"""
    DATABASE = "Database"
    """Database source"""
    BACKUP_FROM_ID = "BackupFromId"
    """Backup from ID source"""
    BACKUP_FROM_TIMESTAMP = "BackupFromTimestamp"
    """Backup from timestamp source"""
    CLONE_TO_REFRESHABLE = "CloneToRefreshable"
    """Clone to refreshable source"""
    CROSS_REGION_DATAGUARD = "CrossRegionDataguard"
    """Cross region dataguard source"""
    CROSS_REGION_DISASTER_RECOVERY = "CrossRegionDisasterRecovery"
    """cross region disaster recovery source"""


class StorageManagementType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage Management type enum."""

    LVM = "LVM"
    """Logical Volume management"""


class StorageVolumePerformanceMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage volume performance mode."""

    BALANCED = "Balanced"
    """With this option, you are purchasing 10 VPUs per GB/month. For more information, including
    specific throughput and IOPS performance numbers for various volume sizes."""
    HIGH_PERFORMANCE = "HighPerformance"
    """With this option, you are purchasing 20 VPUs per GB/month. For more information, including
    specific throughput and IOPS performance numbers for various volume sizes."""


class SyntaxFormatType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Syntax format type enum."""

    LONG = "Long"
    """Long format"""
    EZCONNECT = "Ezconnect"
    """Ezconnect format"""
    EZCONNECTPLUS = "Ezconnectplus"
    """Ezconnectplus format"""


class SystemShapes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allowed values for System Shapes."""

    EXADATA_X9_M = "Exadata.X9M"
    """Exadata X9M shape"""
    EXADATA_X11_M = "Exadata.X11M"
    """Exadata X11M shape"""
    EXA_DB_XS = "ExaDbXS"
    """Exadata DB on Exascale Infrastructure shape"""


class TlsAuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TLS authentication type enum."""

    SERVER = "Server"
    """Server authentication"""
    MUTUAL = "Mutual"
    """Mutual TLS"""


class VirtualNetworkAddressLifecycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VirtualNetworkAddressLifecycleState enum."""

    PROVISIONING = "Provisioning"
    """Indicates that resource in Provisioning state"""
    AVAILABLE = "Available"
    """Indicates that resource in Available state"""
    TERMINATING = "Terminating"
    """Indicates that resource in Terminating state"""
    TERMINATED = "Terminated"
    """Indicates that resource in Terminated state"""
    FAILED = "Failed"
    """Indicates that resource in Failed state"""


class WorkloadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WorkloadType enum."""

    OLTP = "OLTP"
    """OLTP - indicates an Autonomous Transaction Processing database"""
    DW = "DW"
    """DW - indicates an Autonomous Data Warehouse database"""
    AJD = "AJD"
    """AJD - indicates an Autonomous JSON Database"""
    APEX = "APEX"
    """APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload
    type."""


class ZoneType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Zone type enum."""

    PRIMARY = "Primary"
    """Primary zone"""
    SECONDARY = "Secondary"
    """Secondary zone"""
