---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet node'
canonical: "/puppet/latest/man/node.html"
---

# Man Page: puppet node

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-node** - View and manage node definitions.

## SYNOPSIS
puppet node *action* \[\--terminus \_TERMINUS\]

## DESCRIPTION
This subcommand interacts with node objects, which are used by Puppet to
build a catalog. A node object consists of the node\'s facts,
environment, node parameters (exposed in the parser as top-scope
variables), and classes.

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

\--terminus \_TERMINUS

:   Indirector faces expose indirected subsystems of Puppet. These
    subsystems are each able to retrieve and alter a specific type of
    data (with the familiar actions of **find**, **search**, **save**,
    and **destroy**) from an arbitrary number of pluggable backends. In
    Puppet parlance, these backends are called terminuses.

    Almost all indirected subsystems have a **rest** terminus that
    interacts with the puppet master\'s data. Most of them have
    additional terminuses for various local data models, which are in
    turn used by the indirected subsystem on the puppet master whenever
    it receives a remote request.

    The terminus for an action is often determined by context, but
    occasionally needs to be set explicitly. See the \"Notes\" section
    of this face\'s manpage for more details.

## ACTIONS
**clean** - Clean up signed certs, cached facts, node objects, and reports for a node stored by the puppetmaster

:   **SYNOPSIS**

    puppet node clean \[\--terminus \_TERMINUS\] *host1* \[*host2*
    \...\]

    **DESCRIPTION**

    Cleans up the following information a puppet master knows about a
    node:

    *Signed certificates* - (\$vardir/ssl/ca/signed/node.domain.pem)

    *Cached facts* - (\$vardir/yaml/facts/node.domain.yaml)

    *Cached node objects* - (\$vardir/yaml/node/node.domain.yaml)

    *Reports* - (\$vardir/reports/node.domain)

    NOTE: this action now cleans up certs via Puppet Server\'s CA API. A
    running server is required for certs to be cleaned.

**find** - Retrieve a node object.

:   **SYNOPSIS**

    puppet node find \[\--terminus \_TERMINUS\] *host*

    **DESCRIPTION**

    Retrieve a node object.

    **RETURNS**

    A hash containing the node\'s **classes**, **environment**,
    **expiration**, **name**, **parameters** (its facts, combined with
    any ENC-set parameters), and **time**. When used from the Ruby API:
    a Puppet::Node object.

    RENDERING ISSUES: Rendering as string and json are currently broken;
    node objects can only be rendered as yaml.

**info** - Print the default terminus class for this face.

:   **SYNOPSIS**

    puppet node info \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Prints the default terminus class for this subcommand. Note that
    different run modes may have different default termini; when in
    doubt, specify the run mode with the \'\--run_mode\' option.

## EXAMPLES
**find**

Retrieve an \"empty\" (no classes, no ENC-imposed parameters, and an
environment of \"production\") node:

\$ puppet node find somenode.puppetlabs.lan \--terminus plain
\--render-as yaml

Retrieve a node using the Puppet Server\'s configured ENC:

\$ puppet node find somenode.puppetlabs.lan \--terminus exec \--run_mode
server \--render-as yaml

Retrieve the same node from the Puppet Server:

\$ puppet node find somenode.puppetlabs.lan \--terminus rest
\--render-as yaml

## NOTES
This subcommand is an indirector face, which exposes **find**,
**search**, **save**, and **destroy** actions for an indirected
subsystem of Puppet. Valid termini for this face include:

-   **exec**

-   **json**

-   **memory**

-   **msgpack**

-   **plain**

-   **rest**

-   **store_configs**

-   **yaml**

## COPYRIGHT AND LICENSE
Copyright 2011 by Puppet Inc. Apache 2 license; see COPYING
