/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class TimeScaleWink
implements TimeScale {
    private final double scale;

    public TimeScaleWink(double scale) {
        this.scale = 16.0 * scale;
    }

    @Override
    public double getStartingPosition(Day instant) {
        long wink = instant.getMillis();
        return (double)wink * this.scale / 8.64E7;
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.getStartingPosition(instant) + this.getWidth(instant);
    }

    @Override
    public double getWidth(Day instant) {
        return this.scale;
    }

    @Override
    public boolean isBreaking(Day instant) {
        return true;
    }
}

