/*
 * Copyright (c) 2018 - 2019  Daniel Vrátil <dvratil@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKESERVER_H
#define FAKESERVER_H

#include <QString>

#include <memory>

class FakeServerException : public std::runtime_error
{
public:
    FakeServerException(const char *what)
        : std::runtime_error(what) {}
    FakeServerException(const QString &what)
        : std::runtime_error(what.toStdString()) {}
};

class FakeManager;
class FakeServer
{
public:
    explicit FakeServer(const QString &file);
    explicit FakeServer();
    ~FakeServer();

    static void enableFakeEnv();

    FakeManager *manager() const;
private:
    std::unique_ptr<FakeManager> mManager;
};

#endif
