/*
 * Copyright (c) 2007, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

import java.awt.Dialog;

/*
 * @test
 * @key headful
 * @bug 8047367 8049339
 * @summary Check whether the focus transfer between windows occurs correctly when the following happens:
 *          a frame (F) is shown; a window having F as owner is shown; a document modal dialog having
 *          a hidden dialog owner is shown.
 *
 * @library ../helpers ../../../../lib/testlibrary/
 * @build ExtendedRobot
 * @build Flag
 * @build TestDialog
 * @build TestFrame
 * @build TestWindow
 * @run main FocusTransferFWDDocModal1Test
 */

public class FocusTransferFWDDocModal1Test {

    public static void main(String[] args) throws Exception {
        FocusTransferFWDTest test = new FocusTransferFWDTest(
                Dialog.ModalityType.DOCUMENT_MODAL,
                FocusTransferFWDTest.DialogParent.HIDDEN_DIALOG);
        test.doTest();
    }
}
