      logical function tce_ccsd_lambda_driver(title,thresh,maxiter,
     &        d_y1,k_y1_offset,size_y1,d_y2,k_y2_offset,size_y2,
     &        d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &        d_f1,k_f1_offset,d_v2,k_v2_offset)
c
c $Id$
c 
c Main routine for many-electron theory calculations.
c Some of the subroutines have been generated by 
c operator/tensor contraction engines.
c
c Written by Jeff Hammond, January 2008.
c
      implicit none
#include "mafdecls.fh"
#include "tcgmsg.fh"
#include "global.fh"
#include "bas.fh"
#include "geom.fh"
#include "sym.fh"
#include "util.fh"
#include "msgids.fh"
#include "stdio.fh"
#include "sf.fh"
#include "inp.fh"
#include "errquit.fh"
c#include "tce.fh"
c#include "tce_main.fh"
c#include "tce_prop.fh"
c#include "tce_ints.fh"
c#include "tce_amps.fh"
c#include "tce_diis.fh"
c
c     CI, CC, & MBPT
c
      integer iter,maxiter
      logical nodezero         ! True if node 0
      logical recompf          ! True if recompute Fock
      double precision cpu     ! CPU sec counter
      double precision wall    ! WALL sec counter
      integer irrep
      integer irrep_g
      integer d_f1             ! SF handle for MO 1e integrals
      integer l_f1_offset      ! Offset for 1e integral file
      integer k_f1_offset      ! Offset for 1e integral file
      integer size_1e          ! File size in doubles
      integer d_v2             ! SF handle for MO 2e integrals
      integer l_v2_offset      ! Offset for 2e integral file
      integer k_v2_offset      ! Offset for 2e integral file
      integer size_2e          ! File size in doubles
      integer d_t1             ! SF handle for t1 amplitudes
      integer l_t1_offset      ! Offset for t1 file
      integer k_t1_offset      ! Offset for t1 file
      integer size_t1          ! File size in doubles
      integer d_t2             ! SF handle for t2 amplitudes
      integer l_t2_offset      ! Offset for t2 file
      integer k_t2_offset      ! Offset for t2 file
      integer size_t2          ! File size in doubles
      integer d_y1        ! Lambda 1 file
      integer d_y2        ! Lambda 2 file
      integer d_yr1            ! Lambda 1 residual file
      integer d_yr2            ! Lambda 2 residual file
      integer k_y1_offset      ! Offset for Lambda 1 file
      integer size_y1          ! File size in doubles
      integer k_y2_offset      ! Offset for Lambda 2 file
      integer size_y2          ! File size in doubles
      double precision ref     ! Ground state energy
      double precision corr    ! Correlation energy
      double precision r1      ! Residual t1
      double precision r2      ! Residual t2
      double precision residual! Largest residual
      double precision thresh
      double precision ddotfile
      external ddotfile
      integer dummy            ! Dummy argument for DIIS
      character*255 filename
      character*20 title
      character*4 irrepname
      nodezero=(ga_nodeid().eq.0)
      call tce_diis_init()
      do iter=1,maxiter
        cpu=-util_cpusec()
        wall=-util_wallsec()
        if (nodezero.and.(iter.eq.1)) write(LuOut,9400) title
        call tce_filename('yr1',filename)
        call createfile(filename,d_yr1,size_y1)
        call ccsd_lambda1(d_f1,d_yr1,d_t1,d_t2,d_v2,d_y1,
     1     d_y2,k_f1_offset,k_y1_offset,k_t1_offset,
     2     k_t2_offset,k_v2_offset,k_y1_offset,k_y2_offset)
        call reconcilefile(d_yr1,size_y1)
        call tce_filename('yr2',filename)
        call createfile(filename,d_yr2,size_y2)
        call ccsd_lambda2(d_f1,d_yr2,d_t1,d_t2,d_v2,d_y1,
     1     d_y2,k_f1_offset,k_y2_offset,k_t1_offset,
     2     k_t2_offset,k_v2_offset,k_y1_offset,k_y2_offset)
        call reconcilefile(d_yr2,size_y2)
        r1 = ddotfile(d_yr1,d_yr1,size_y1)
        r2 = ddotfile(d_yr2,d_yr2,size_y2)
        residual = max(r1,r2)
        cpu=cpu+util_cpusec()
        wall=wall+util_wallsec()
        if (nodezero) write(LuOut,9420) iter,residual,cpu,wall
        if (residual .lt. thresh) then
          if (nodezero) then
            write(LuOut,9410)
          endif
          call deletefile(d_yr2)
          call deletefile(d_yr1)
          call tce_diis_tidy()
          tce_ccsd_lambda_driver=.true.
          return
        endif
        call tce_diis(.true.,iter,.true.,.true.,.false.,.false.,
     1                d_yr1,d_y1,k_y1_offset,size_y1,
     2                d_yr2,d_y2,k_y2_offset,size_y2,
     3                dummy,dummy,dummy,dummy,
     4                dummy,dummy,dummy,dummy)
        call deletefile(d_yr2)
        call deletefile(d_yr1)
        if (nodezero) call util_flush(LuOut)
      enddo
      call tce_diis_tidy()
      tce_ccsd_lambda_driver=.false.
      return  
c
c     ======
c     Format
c     ======
c
 9000 format(1x,A,' file size   = ',i16)
 9010 format(1x,A,' file name   = ',A)
 9090 format(1x,A,' file handle = ',i10)
 9020 format(1x,'Cpu & wall time / sec',2f15.1)
 9480 format(1x,'Cpu & wall time / sec for ',A,2f15.1)
 9050 format(/,1x,A,' iterations',/,
     1  1x,'--------------------------------------------------------',/
     2  1x,'Iter          Residuum       Correlation     Cpu    Wall',/
     3  1x,'--------------------------------------------------------')
 9060 format(
     1  1x,'--------------------------------------------------------',/
     2  1x,'Iterations converged')
 9070 format(1x,A,' correlation energy / hartree = ',f25.15)
 9080 format(1x,A,' total energy / hartree       = ',f25.15)
 9100 format(1x,i4,2f18.13,2f8.1)
 9120 format(1x,A)
 9250 format(1x,'Ground-state symmetry is ',A4)
 9210 format(/,1x,'Iteration ',i3,' using ',i4,' trial vectors')
 9230 format(1x,f17.13,f18.13,f11.5,2f8.1)
 9240 format(1x,
     1'--------------------------------------------------------------'
     2,/,1x,'Iterations converged')
 9310 format(1x,A,' ground state energy / hartree  =',f25.15)
 9400 format(/,1x,A,' iterations',/,
     1  1x,'--------------------------------------',/
     2  1x,'Iter          Residuum     Cpu    Wall',/
     3  1x,'--------------------------------------')
 9410 format(
     1  1x,'--------------------------------------',/
     2  1x,'Iterations converged')
 9420 format(1x,i4,f18.13,2f8.1)
 9440 format(1x,A3,' axis ( ',A4,'symmetry)')
      end
