#
# This test is executed once after each test to check the servers
# for unexpected warnings found in the servers error log
#
# NOTE! mysql-test-run.pl has already done a rough filtering
# of the file and written any suspicious lines
# to $error_log.warnings file
#
--disable_query_log

# Don't write these queries to binlog
set SQL_LOG_BIN=0;

# Do not replicate updates to other galera nodes
--error 0,1193
set WSREP_ON=0;

# Turn off any debug crashes, allow the variable to be
# non existent in release builds
--error 0,1193
set debug_dbug="";

use mtr;
# Allow this session to read-write even if server is started
# with --transaction-read-only
set session transaction read write;

create temporary table error_log (
  row int auto_increment primary key,
  suspicious int default 1,
  file_name varchar(255),
  line varchar(1024) default null
) engine=myisam charset=latin1;

# Get the name of servers error log
let $log_error= $MTR_LOG_ERROR;
let $log_warning= $log_error.warnings;

# Try to load the warnings into a temporary table,
# it might fail with error saying "The MySQL server is
# running with the --secure-file-priv" in which case
# an attempt to load the file using LOAD DATA LOCAL is made
--error 0,1290
eval load data infile '$log_warning' into table error_log character set latin1
  fields terminated by 'xykls37' escaped by ''
  ignore 1 lines
  (line)
  set file_name='$log_error';

if ($mysql_errno)
{
  # Try LOAD DATA LOCAL
  eval load data local infile '$log_warning' into table error_log
    fields terminated by 'xykls37' escaped by ''
    ignore 1 lines
    (line)
    set file_name='$log_error';
}

# Call check_warnings to filter out any warning in
# the error_log table
call mtr.check_warnings(@result);
if (`select @result = 0`){
  skip OK;
}
--enable_query_log
echo ^ Found warnings in $log_error;
exit;
