
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsDirectionAttributes.h
    \\brief Definition of EpsDirection Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "EpsDirectionWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


EpsDirectionWrapper::EpsDirectionWrapper(): epsdirection_(new EpsDirection())

{

	
	
	
} 
EpsDirectionWrapper::EpsDirectionWrapper(EpsDirection* epsdirection): epsdirection_(epsdirection)
{
	
	
} 

EpsDirectionWrapper::~EpsDirectionWrapper()
{
	
}

void EpsDirectionWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("EPS_DIRECTION_KEYWORD") ) {
		string keyword_value = request("EPS_DIRECTION_KEYWORD");
		epsdirection_->keyword_ = keyword_value;
		}
	if  (request.countValues("EPS_DIRECTION_LINE_THICKNESS") ) {
		int line_thickness_value = request("EPS_DIRECTION_LINE_THICKNESS");
		epsdirection_->line_thickness_ = line_thickness_value;
		}
	
	if  (request.countValues("EPS_DIRECTION_LINE_COLOUR") ) {
		string line_colour_value = request("EPS_DIRECTION_LINE_COLOUR");
		epsdirection_->line_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(line_colour_value));
	}
		
	
	if  (request.countValues("EPS_DIRECTION_LINE_STYLE") ) {
		string line_style_value = request("EPS_DIRECTION_LINE_STYLE");
		epsdirection_->line_style_ = MagTranslator<string, LineStyle>()(line_style_value);
	}
		
	
}

void EpsDirectionWrapper::print(ostream& out)  const
{
	out << "EpsDirectionWrapper[]";
}


    





