/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JToolBar;

public final class OutLookToolBar {
    private JToolBar m_toolbar = null;

    public OutLookToolBar(JToolBar t) {
        this.m_toolbar = t;
        if (this.m_toolbar == null) {
            throw new NullPointerException("JToolBar instance required for OutLookToolBar is NULL!");
        }
        this.m_toolbar.addContainerListener(new MyContainerListener());
    }

    private static final class MouseOver
    implements MouseListener {
        private MouseOver() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof JButton) {
                JButton b = (JButton)c;
                b.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof JButton) {
                JButton b = (JButton)c;
                b.setBorderPainted(false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private final class MyContainerListener
    implements ContainerListener {
        public MyContainerListener() {
            this.transform();
        }

        private void transform() {
            if (OutLookToolBar.this.m_toolbar != null) {
                int count = OutLookToolBar.this.m_toolbar.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Component c = OutLookToolBar.this.m_toolbar.getComponentAtIndex(i);
                    if (!(c instanceof JButton)) continue;
                    JButton b = (JButton)c;
                    b.setBorderPainted(false);
                    b.setFocusPainted(false);
                    b.addMouseListener(new MouseOver());
                }
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            this.transform();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            OutLookToolBar.this.m_toolbar.repaint();
        }
    }
}

