/*
 * The internal definitions
 *
 * Copyright (C) 2011-2019, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBWRC_INTERNAL_DEFINITIONS_H )
#define _LIBWRC_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <byte_stream.h>

#define LIBWRC_ENDIAN_BIG				_BYTE_STREAM_ENDIAN_BIG
#define LIBWRC_ENDIAN_LITTLE				_BYTE_STREAM_ENDIAN_LITTLE

/* Define HAVE_LOCAL_LIBWRC for local use of libwrc
 */
#if !defined( HAVE_LOCAL_LIBWRC )
#include <libwrc/definitions.h>

/* The definitions in <libwrc/definitions.h> are copied here
 * for local use of libwrc
 */
#else
#define LIBWRC_VERSION					20191221

/* The version string
 */
#define LIBWRC_VERSION_STRING				"20191221"

/* The access flags definitions
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBWRC_ACCESS_FLAGS
{
	LIBWRC_ACCESS_FLAG_READ				= 0x01,
/* Reserved: not supported yet */
	LIBWRC_ACCESS_FLAG_WRITE			= 0x02
};

/* The file access macros
 */
#define LIBWRC_OPEN_READ				( LIBWRC_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBWRC_OPEN_WRITE				( LIBWRC_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBWRC_OPEN_READ_WRITE				( LIBWRC_ACCESS_FLAG_READ | LIBWRC_ACCESS_FLAG_WRITE )

/* The resource identifiers
 */
enum LIBWRC_RESOURCE_IDENTIFIERS
{
	LIBWRC_RESOURCE_IDENTIFIER_CURSOR		= 0x01,
	LIBWRC_RESOURCE_IDENTIFIER_BITMAP		= 0x02,
	LIBWRC_RESOURCE_IDENTIFIER_ICON			= 0x03,
	LIBWRC_RESOURCE_IDENTIFIER_MENU			= 0x04,
	LIBWRC_RESOURCE_IDENTIFIER_DIALOG		= 0x05,
	LIBWRC_RESOURCE_IDENTIFIER_STRING		= 0x06,
	LIBWRC_RESOURCE_IDENTIFIER_FONT_DIRECTORY	= 0x07,
	LIBWRC_RESOURCE_IDENTIFIER_FONT			= 0x08,
	LIBWRC_RESOURCE_IDENTIFIER_ACCELERATOR		= 0x09,
	LIBWRC_RESOURCE_IDENTIFIER_RAW_DATA		= 0x0a,
	LIBWRC_RESOURCE_IDENTIFIER_MESSAGE_TABLE	= 0x0b,
	LIBWRC_RESOURCE_IDENTIFIER_GROUP_CURSOR		= 0x0c,

	LIBWRC_RESOURCE_IDENTIFIER_GROUP_ICON		= 0x0e,

	LIBWRC_RESOURCE_IDENTIFIER_VERSION		= 0x10,
	LIBWRC_RESOURCE_IDENTIFIER_DIALOG_INCLUDE	= 0x11,

	LIBWRC_RESOURCE_IDENTIFIER_PLUG_AND_PLAY	= 0x13,
	LIBWRC_RESOURCE_IDENTIFIER_VXD			= 0x14,
	LIBWRC_RESOURCE_IDENTIFIER_ANIMATED_CURSOR	= 0x15,
	LIBWRC_RESOURCE_IDENTIFIER_ANIMATED_ICON	= 0x16,
	LIBWRC_RESOURCE_IDENTIFIER_HTML			= 0x17,
	LIBWRC_RESOURCE_IDENTIFIER_MANIFEST		= 0x18
};

#define LIBWRC_RESOURCE_IDENTIFIER_FLAG_HAS_NAME	0x80000000UL

/* The resource types
 */
enum LIBWRC_RESOURCE_TYPES
{
	LIBWRC_RESOURCE_TYPE_UNDEFINED,
	LIBWRC_RESOURCE_TYPE_CURSOR,
	LIBWRC_RESOURCE_TYPE_BITMAP,
	LIBWRC_RESOURCE_TYPE_ICON,
	LIBWRC_RESOURCE_TYPE_MENU,
	LIBWRC_RESOURCE_TYPE_DIALOG,
	LIBWRC_RESOURCE_TYPE_STRING,
	LIBWRC_RESOURCE_TYPE_FONT_DIRECTORY,
	LIBWRC_RESOURCE_TYPE_FONT,
	LIBWRC_RESOURCE_TYPE_ACCELERATOR,
	LIBWRC_RESOURCE_TYPE_RAW_DATA,
	LIBWRC_RESOURCE_TYPE_MESSAGE_TABLE,
	LIBWRC_RESOURCE_TYPE_GROUP_CURSOR,

	LIBWRC_RESOURCE_TYPE_GROUP_ICON,

	LIBWRC_RESOURCE_TYPE_VERSION,
	LIBWRC_RESOURCE_TYPE_DIALOG_INCLUDE,

	LIBWRC_RESOURCE_TYPE_PLUG_AND_PLAY,
	LIBWRC_RESOURCE_TYPE_VXD,
	LIBWRC_RESOURCE_TYPE_ANIMATED_CURSOR,
	LIBWRC_RESOURCE_TYPE_ANIMATED_ICON,
	LIBWRC_RESOURCE_TYPE_HTML,
	LIBWRC_RESOURCE_TYPE_MANIFEST,

	LIBWRC_RESOURCE_TYPE_MOFDATA,
	LIBWRC_RESOURCE_TYPE_MUI,
	LIBWRC_RESOURCE_TYPE_WEVT_TEMPLATE,
};

#endif

/* The resource flags
 */
enum LIBWRC_RESOURCE_FLAGS
{
	LIBWRC_RESOURCE_FLAG_NON_MANAGED_FILE_IO_HANDLE	= 0x00,
	LIBWRC_RESOURCE_FLAG_MANAGED_FILE_IO_HANDLE	= 0x01,
};

#define LIBWRC_RESOURCE_FLAGS_DEFAULT			LIBWRC_RESOURCE_FLAG_NON_MANAGED_FILE_IO_HANDLE

#endif

