/*
 * Copyright 2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <QScopedPointer>
#include "test_apn_request_factory.h"

void
TestApnRequestFactory::testProxySet_data() {
    QTest::addColumn<QString>("hostName");
    QTest::addColumn<int>("port");
    QTest::addColumn<QString>("username");
    QTest::addColumn<QString>("password");

    QTest::newRow("First row") << "http://proxy.com" << 88
        << "mandel" << "Qwsxd";
    QTest::newRow("Second row") << "http://lomiri.com" << 99
        << "mark" << "trusty";
    QTest::newRow("Third row") << "http://one.lomiri.com" << 200
        << "one" << "drop";
}

void
TestApnRequestFactory::testProxySet() {
    QFETCH(QString, hostName);
    QFETCH(int, port);
    QFETCH(QString, username);
    QFETCH(QString, password);

    QNetworkProxy proxy(QNetworkProxy::HttpProxy, hostName, port,
        username, password);
    QScopedPointer<PublicApnRequestFactory> nam(
        new PublicApnRequestFactory(proxy));

    QCOMPARE(hostName, nam->proxyHost());
    QCOMPARE(port, nam->proxyPort());
    QCOMPARE(username, nam->proxyUsername());
    QCOMPARE(password, nam->proxyPassword());
}

QTEST_MAIN(TestApnRequestFactory)
