
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsLayoutItem.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsLayoutItem>
#include <QGraphicsItem>
#include <QRectF>
#include <QSizeF>
#include <QSizePolicy>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsLayoutItem

// QRectF QGraphicsLayoutItem::contentsRect()


static void _init_f_contentsRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_contentsRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsLayoutItem *)cls)->contentsRect ());
}


// QSizeF QGraphicsLayoutItem::effectiveSizeHint(Qt::SizeHint which, const QSizeF &constraint)


static void _init_f_effectiveSizeHint_c3330 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint", true, "QSizeF()");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_f_effectiveSizeHint_c3330 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::SizeHint>::target_type & >() (args, heap);
  const QSizeF &arg2 = args ? gsi::arg_reader<const QSizeF & >() (args, heap) : gsi::arg_maker<const QSizeF & >() (QSizeF(), heap);
  ret.write<QSizeF > ((QSizeF)((QGraphicsLayoutItem *)cls)->effectiveSizeHint (qt_gsi::QtToCppAdaptor<Qt::SizeHint>(arg1).cref(), arg2));
}


// QRectF QGraphicsLayoutItem::geometry()


static void _init_f_geometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_geometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsLayoutItem *)cls)->geometry ());
}


// void QGraphicsLayoutItem::getContentsMargins(double *left, double *top, double *right, double *bottom)


static void _init_f_getContentsMargins_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getContentsMargins_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->getContentsMargins (arg1, arg2, arg3, arg4);
}


// QGraphicsItem *QGraphicsLayoutItem::graphicsItem()


static void _init_f_graphicsItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_graphicsItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsLayoutItem *)cls)->graphicsItem ());
}


// bool QGraphicsLayoutItem::isLayout()


static void _init_f_isLayout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLayout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsLayoutItem *)cls)->isLayout ());
}


// double QGraphicsLayoutItem::maximumHeight()


static void _init_f_maximumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maximumHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsLayoutItem *)cls)->maximumHeight ());
}


// QSizeF QGraphicsLayoutItem::maximumSize()


static void _init_f_maximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_maximumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QGraphicsLayoutItem *)cls)->maximumSize ());
}


// double QGraphicsLayoutItem::maximumWidth()


static void _init_f_maximumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maximumWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsLayoutItem *)cls)->maximumWidth ());
}


// double QGraphicsLayoutItem::minimumHeight()


static void _init_f_minimumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_minimumHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsLayoutItem *)cls)->minimumHeight ());
}


// QSizeF QGraphicsLayoutItem::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QGraphicsLayoutItem *)cls)->minimumSize ());
}


// double QGraphicsLayoutItem::minimumWidth()


static void _init_f_minimumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_minimumWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsLayoutItem *)cls)->minimumWidth ());
}


// bool QGraphicsLayoutItem::ownedByLayout()


static void _init_f_ownedByLayout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_ownedByLayout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsLayoutItem *)cls)->ownedByLayout ());
}


// QGraphicsLayoutItem *QGraphicsLayoutItem::parentLayoutItem()


static void _init_f_parentLayoutItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsLayoutItem * > ();
}

static void _call_f_parentLayoutItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsLayoutItem * > ((QGraphicsLayoutItem *)((QGraphicsLayoutItem *)cls)->parentLayoutItem ());
}


// double QGraphicsLayoutItem::preferredHeight()


static void _init_f_preferredHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_preferredHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsLayoutItem *)cls)->preferredHeight ());
}


// QSizeF QGraphicsLayoutItem::preferredSize()


static void _init_f_preferredSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_preferredSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QGraphicsLayoutItem *)cls)->preferredSize ());
}


// double QGraphicsLayoutItem::preferredWidth()


static void _init_f_preferredWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_preferredWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsLayoutItem *)cls)->preferredWidth ());
}


// void QGraphicsLayoutItem::setGeometry(const QRectF &rect)


static void _init_f_setGeometry_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setGeometry (arg1);
}


// void QGraphicsLayoutItem::setMaximumHeight(double height)


static void _init_f_setMaximumHeight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("height");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumHeight_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMaximumHeight (arg1);
}


// void QGraphicsLayoutItem::setMaximumSize(const QSizeF &size)


static void _init_f_setMaximumSize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumSize_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMaximumSize (arg1);
}


// void QGraphicsLayoutItem::setMaximumSize(double w, double h)


static void _init_f_setMaximumSize_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMaximumSize_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMaximumSize (arg1, arg2);
}


// void QGraphicsLayoutItem::setMaximumWidth(double width)


static void _init_f_setMaximumWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumWidth_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMaximumWidth (arg1);
}


// void QGraphicsLayoutItem::setMinimumHeight(double height)


static void _init_f_setMinimumHeight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("height");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumHeight_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMinimumHeight (arg1);
}


// void QGraphicsLayoutItem::setMinimumSize(const QSizeF &size)


static void _init_f_setMinimumSize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSize_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMinimumSize (arg1);
}


// void QGraphicsLayoutItem::setMinimumSize(double w, double h)


static void _init_f_setMinimumSize_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSize_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMinimumSize (arg1, arg2);
}


// void QGraphicsLayoutItem::setMinimumWidth(double width)


static void _init_f_setMinimumWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumWidth_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setMinimumWidth (arg1);
}


// void QGraphicsLayoutItem::setParentLayoutItem(QGraphicsLayoutItem *parent)


static void _init_f_setParentLayoutItem_2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParentLayoutItem_2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setParentLayoutItem (arg1);
}


// void QGraphicsLayoutItem::setPreferredHeight(double height)


static void _init_f_setPreferredHeight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("height");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPreferredHeight_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setPreferredHeight (arg1);
}


// void QGraphicsLayoutItem::setPreferredSize(const QSizeF &size)


static void _init_f_setPreferredSize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPreferredSize_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setPreferredSize (arg1);
}


// void QGraphicsLayoutItem::setPreferredSize(double w, double h)


static void _init_f_setPreferredSize_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPreferredSize_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setPreferredSize (arg1, arg2);
}


// void QGraphicsLayoutItem::setPreferredWidth(double width)


static void _init_f_setPreferredWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPreferredWidth_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setPreferredWidth (arg1);
}


// void QGraphicsLayoutItem::setSizePolicy(const QSizePolicy &policy)


static void _init_f_setSizePolicy_2429 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const QSizePolicy & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizePolicy_2429 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizePolicy &arg1 = gsi::arg_reader<const QSizePolicy & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setSizePolicy (arg1);
}


// void QGraphicsLayoutItem::setSizePolicy(QSizePolicy::Policy hPolicy, QSizePolicy::Policy vPolicy, QSizePolicy::ControlType controlType)


static void _init_f_setSizePolicy_7191 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hPolicy");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vPolicy");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("controlType", true, "QSizePolicy::DefaultType");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setSizePolicy_7191 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSizePolicy::Policy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSizePolicy::Policy>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QSizePolicy::ControlType>(heap, QSizePolicy::DefaultType), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->setSizePolicy (qt_gsi::QtToCppAdaptor<QSizePolicy::Policy>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::Policy>(arg2).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(arg3).cref());
}


// QSizePolicy QGraphicsLayoutItem::sizePolicy()


static void _init_f_sizePolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizePolicy > ();
}

static void _call_f_sizePolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizePolicy > ((QSizePolicy)((QGraphicsLayoutItem *)cls)->sizePolicy ());
}


// void QGraphicsLayoutItem::updateGeometry()


static void _init_f_updateGeometry_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_updateGeometry_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem *)cls)->updateGeometry ();
}


namespace gsi
{

static gsi::Methods methods_QGraphicsLayoutItem () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("contentsRect", "@brief Method QRectF QGraphicsLayoutItem::contentsRect()\n", true, &_init_f_contentsRect_c0, &_call_f_contentsRect_c0);
  methods += new qt_gsi::GenericMethod ("effectiveSizeHint", "@brief Method QSizeF QGraphicsLayoutItem::effectiveSizeHint(Qt::SizeHint which, const QSizeF &constraint)\n", true, &_init_f_effectiveSizeHint_c3330, &_call_f_effectiveSizeHint_c3330);
  methods += new qt_gsi::GenericMethod (":geometry", "@brief Method QRectF QGraphicsLayoutItem::geometry()\n", true, &_init_f_geometry_c0, &_call_f_geometry_c0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@brief Method void QGraphicsLayoutItem::getContentsMargins(double *left, double *top, double *right, double *bottom)\n", true, &_init_f_getContentsMargins_c4704, &_call_f_getContentsMargins_c4704);
  methods += new qt_gsi::GenericMethod ("graphicsItem", "@brief Method QGraphicsItem *QGraphicsLayoutItem::graphicsItem()\n", true, &_init_f_graphicsItem_c0, &_call_f_graphicsItem_c0);
  methods += new qt_gsi::GenericMethod ("isLayout?", "@brief Method bool QGraphicsLayoutItem::isLayout()\n", true, &_init_f_isLayout_c0, &_call_f_isLayout_c0);
  methods += new qt_gsi::GenericMethod (":maximumHeight", "@brief Method double QGraphicsLayoutItem::maximumHeight()\n", true, &_init_f_maximumHeight_c0, &_call_f_maximumHeight_c0);
  methods += new qt_gsi::GenericMethod (":maximumSize", "@brief Method QSizeF QGraphicsLayoutItem::maximumSize()\n", true, &_init_f_maximumSize_c0, &_call_f_maximumSize_c0);
  methods += new qt_gsi::GenericMethod (":maximumWidth", "@brief Method double QGraphicsLayoutItem::maximumWidth()\n", true, &_init_f_maximumWidth_c0, &_call_f_maximumWidth_c0);
  methods += new qt_gsi::GenericMethod (":minimumHeight", "@brief Method double QGraphicsLayoutItem::minimumHeight()\n", true, &_init_f_minimumHeight_c0, &_call_f_minimumHeight_c0);
  methods += new qt_gsi::GenericMethod (":minimumSize", "@brief Method QSizeF QGraphicsLayoutItem::minimumSize()\n", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
  methods += new qt_gsi::GenericMethod (":minimumWidth", "@brief Method double QGraphicsLayoutItem::minimumWidth()\n", true, &_init_f_minimumWidth_c0, &_call_f_minimumWidth_c0);
  methods += new qt_gsi::GenericMethod ("ownedByLayout", "@brief Method bool QGraphicsLayoutItem::ownedByLayout()\n", true, &_init_f_ownedByLayout_c0, &_call_f_ownedByLayout_c0);
  methods += new qt_gsi::GenericMethod (":parentLayoutItem", "@brief Method QGraphicsLayoutItem *QGraphicsLayoutItem::parentLayoutItem()\n", true, &_init_f_parentLayoutItem_c0, &_call_f_parentLayoutItem_c0);
  methods += new qt_gsi::GenericMethod (":preferredHeight", "@brief Method double QGraphicsLayoutItem::preferredHeight()\n", true, &_init_f_preferredHeight_c0, &_call_f_preferredHeight_c0);
  methods += new qt_gsi::GenericMethod (":preferredSize", "@brief Method QSizeF QGraphicsLayoutItem::preferredSize()\n", true, &_init_f_preferredSize_c0, &_call_f_preferredSize_c0);
  methods += new qt_gsi::GenericMethod (":preferredWidth", "@brief Method double QGraphicsLayoutItem::preferredWidth()\n", true, &_init_f_preferredWidth_c0, &_call_f_preferredWidth_c0);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QGraphicsLayoutItem::setGeometry(const QRectF &rect)\n", false, &_init_f_setGeometry_1862, &_call_f_setGeometry_1862);
  methods += new qt_gsi::GenericMethod ("setMaximumHeight|maximumHeight=", "@brief Method void QGraphicsLayoutItem::setMaximumHeight(double height)\n", false, &_init_f_setMaximumHeight_1071, &_call_f_setMaximumHeight_1071);
  methods += new qt_gsi::GenericMethod ("setMaximumSize|maximumSize=", "@brief Method void QGraphicsLayoutItem::setMaximumSize(const QSizeF &size)\n", false, &_init_f_setMaximumSize_1875, &_call_f_setMaximumSize_1875);
  methods += new qt_gsi::GenericMethod ("setMaximumSize", "@brief Method void QGraphicsLayoutItem::setMaximumSize(double w, double h)\n", false, &_init_f_setMaximumSize_2034, &_call_f_setMaximumSize_2034);
  methods += new qt_gsi::GenericMethod ("setMaximumWidth|maximumWidth=", "@brief Method void QGraphicsLayoutItem::setMaximumWidth(double width)\n", false, &_init_f_setMaximumWidth_1071, &_call_f_setMaximumWidth_1071);
  methods += new qt_gsi::GenericMethod ("setMinimumHeight|minimumHeight=", "@brief Method void QGraphicsLayoutItem::setMinimumHeight(double height)\n", false, &_init_f_setMinimumHeight_1071, &_call_f_setMinimumHeight_1071);
  methods += new qt_gsi::GenericMethod ("setMinimumSize|minimumSize=", "@brief Method void QGraphicsLayoutItem::setMinimumSize(const QSizeF &size)\n", false, &_init_f_setMinimumSize_1875, &_call_f_setMinimumSize_1875);
  methods += new qt_gsi::GenericMethod ("setMinimumSize", "@brief Method void QGraphicsLayoutItem::setMinimumSize(double w, double h)\n", false, &_init_f_setMinimumSize_2034, &_call_f_setMinimumSize_2034);
  methods += new qt_gsi::GenericMethod ("setMinimumWidth|minimumWidth=", "@brief Method void QGraphicsLayoutItem::setMinimumWidth(double width)\n", false, &_init_f_setMinimumWidth_1071, &_call_f_setMinimumWidth_1071);
  methods += new qt_gsi::GenericMethod ("setParentLayoutItem|parentLayoutItem=", "@brief Method void QGraphicsLayoutItem::setParentLayoutItem(QGraphicsLayoutItem *parent)\n", false, &_init_f_setParentLayoutItem_2557, &_call_f_setParentLayoutItem_2557);
  methods += new qt_gsi::GenericMethod ("setPreferredHeight|preferredHeight=", "@brief Method void QGraphicsLayoutItem::setPreferredHeight(double height)\n", false, &_init_f_setPreferredHeight_1071, &_call_f_setPreferredHeight_1071);
  methods += new qt_gsi::GenericMethod ("setPreferredSize|preferredSize=", "@brief Method void QGraphicsLayoutItem::setPreferredSize(const QSizeF &size)\n", false, &_init_f_setPreferredSize_1875, &_call_f_setPreferredSize_1875);
  methods += new qt_gsi::GenericMethod ("setPreferredSize", "@brief Method void QGraphicsLayoutItem::setPreferredSize(double w, double h)\n", false, &_init_f_setPreferredSize_2034, &_call_f_setPreferredSize_2034);
  methods += new qt_gsi::GenericMethod ("setPreferredWidth|preferredWidth=", "@brief Method void QGraphicsLayoutItem::setPreferredWidth(double width)\n", false, &_init_f_setPreferredWidth_1071, &_call_f_setPreferredWidth_1071);
  methods += new qt_gsi::GenericMethod ("setSizePolicy|sizePolicy=", "@brief Method void QGraphicsLayoutItem::setSizePolicy(const QSizePolicy &policy)\n", false, &_init_f_setSizePolicy_2429, &_call_f_setSizePolicy_2429);
  methods += new qt_gsi::GenericMethod ("setSizePolicy", "@brief Method void QGraphicsLayoutItem::setSizePolicy(QSizePolicy::Policy hPolicy, QSizePolicy::Policy vPolicy, QSizePolicy::ControlType controlType)\n", false, &_init_f_setSizePolicy_7191, &_call_f_setSizePolicy_7191);
  methods += new qt_gsi::GenericMethod (":sizePolicy", "@brief Method QSizePolicy QGraphicsLayoutItem::sizePolicy()\n", true, &_init_f_sizePolicy_c0, &_call_f_sizePolicy_c0);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@brief Method void QGraphicsLayoutItem::updateGeometry()\n", false, &_init_f_updateGeometry_0, &_call_f_updateGeometry_0);
  return methods;
}

gsi::Class<QGraphicsLayoutItem> decl_QGraphicsLayoutItem ("QtGui", "QGraphicsLayoutItem_Native",
  methods_QGraphicsLayoutItem (),
  "@hide\n@alias QGraphicsLayoutItem");

GSI_QTGUI_PUBLIC gsi::Class<QGraphicsLayoutItem> &qtdecl_QGraphicsLayoutItem () { return decl_QGraphicsLayoutItem; }

}


class QGraphicsLayoutItem_Adaptor : public QGraphicsLayoutItem, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsLayoutItem_Adaptor();

  //  [adaptor ctor] QGraphicsLayoutItem::QGraphicsLayoutItem(QGraphicsLayoutItem *parent, bool isLayout)
  QGraphicsLayoutItem_Adaptor() : QGraphicsLayoutItem()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsLayoutItem::QGraphicsLayoutItem(QGraphicsLayoutItem *parent, bool isLayout)
  QGraphicsLayoutItem_Adaptor(QGraphicsLayoutItem *parent) : QGraphicsLayoutItem(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsLayoutItem::QGraphicsLayoutItem(QGraphicsLayoutItem *parent, bool isLayout)
  QGraphicsLayoutItem_Adaptor(QGraphicsLayoutItem *parent, bool isLayout) : QGraphicsLayoutItem(parent, isLayout)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsLayoutItem::setGraphicsItem(QGraphicsItem *item)
  void fp_QGraphicsLayoutItem_setGraphicsItem_1919 (QGraphicsItem *item) {
    QGraphicsLayoutItem::setGraphicsItem(item);
  }

  //  [expose] void QGraphicsLayoutItem::setOwnedByLayout(bool ownedByLayout)
  void fp_QGraphicsLayoutItem_setOwnedByLayout_864 (bool ownedByLayout) {
    QGraphicsLayoutItem::setOwnedByLayout(ownedByLayout);
  }

  //  [adaptor impl] void QGraphicsLayoutItem::getContentsMargins(double *left, double *top, double *right, double *bottom)
  void cbs_getContentsMargins_c4704_0(double *left, double *top, double *right, double *bottom) const
  {
    QGraphicsLayoutItem::getContentsMargins(left, top, right, bottom);
  }

  virtual void getContentsMargins(double *left, double *top, double *right, double *bottom) const
  {
    if (cb_getContentsMargins_c4704_0.can_issue()) {
      cb_getContentsMargins_c4704_0.issue<QGraphicsLayoutItem_Adaptor, double *, double *, double *, double *>(&QGraphicsLayoutItem_Adaptor::cbs_getContentsMargins_c4704_0, left, top, right, bottom);
    } else {
      QGraphicsLayoutItem::getContentsMargins(left, top, right, bottom);
    }
  }

  //  [adaptor impl] void QGraphicsLayoutItem::setGeometry(const QRectF &rect)
  void cbs_setGeometry_1862_0(const QRectF &rect)
  {
    QGraphicsLayoutItem::setGeometry(rect);
  }

  virtual void setGeometry(const QRectF &rect)
  {
    if (cb_setGeometry_1862_0.can_issue()) {
      cb_setGeometry_1862_0.issue<QGraphicsLayoutItem_Adaptor, const QRectF &>(&QGraphicsLayoutItem_Adaptor::cbs_setGeometry_1862_0, rect);
    } else {
      QGraphicsLayoutItem::setGeometry(rect);
    }
  }

  //  [adaptor impl] void QGraphicsLayoutItem::updateGeometry()
  void cbs_updateGeometry_0_0()
  {
    QGraphicsLayoutItem::updateGeometry();
  }

  virtual void updateGeometry()
  {
    if (cb_updateGeometry_0_0.can_issue()) {
      cb_updateGeometry_0_0.issue<QGraphicsLayoutItem_Adaptor>(&QGraphicsLayoutItem_Adaptor::cbs_updateGeometry_0_0);
    } else {
      QGraphicsLayoutItem::updateGeometry();
    }
  }

  //  [adaptor impl] QSizeF QGraphicsLayoutItem::sizeHint(Qt::SizeHint which, const QSizeF &constraint)
  QSizeF cbs_sizeHint_c3330_1(const qt_gsi::Converter<Qt::SizeHint>::target_type & which, const QSizeF &constraint) const
  {
    __SUPPRESS_UNUSED_WARNING (which);
    __SUPPRESS_UNUSED_WARNING (constraint);
    throw qt_gsi::AbstractMethodCalledException("sizeHint");
  }

  virtual QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const
  {
    if (cb_sizeHint_c3330_1.can_issue()) {
      return cb_sizeHint_c3330_1.issue<QGraphicsLayoutItem_Adaptor, QSizeF, const qt_gsi::Converter<Qt::SizeHint>::target_type &, const QSizeF &>(&QGraphicsLayoutItem_Adaptor::cbs_sizeHint_c3330_1, qt_gsi::CppToQtAdaptor<Qt::SizeHint>(which), constraint);
    } else {
      throw qt_gsi::AbstractMethodCalledException("sizeHint");
    }
  }

  gsi::Callback cb_getContentsMargins_c4704_0;
  gsi::Callback cb_setGeometry_1862_0;
  gsi::Callback cb_updateGeometry_0_0;
  gsi::Callback cb_sizeHint_c3330_1;
};

QGraphicsLayoutItem_Adaptor::~QGraphicsLayoutItem_Adaptor() { }

//  Constructor QGraphicsLayoutItem::QGraphicsLayoutItem(QGraphicsLayoutItem *parent, bool isLayout) (adaptor class)

static void _init_ctor_QGraphicsLayoutItem_Adaptor_3313 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("isLayout", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return_new<QGraphicsLayoutItem_Adaptor> ();
}

static void _call_ctor_QGraphicsLayoutItem_Adaptor_3313 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args ? gsi::arg_reader<QGraphicsLayoutItem * >() (args, heap) : gsi::arg_maker<QGraphicsLayoutItem * >() (0, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  ret.write<QGraphicsLayoutItem_Adaptor *> (new QGraphicsLayoutItem_Adaptor (arg1, arg2));
}


// void QGraphicsLayoutItem::getContentsMargins(double *left, double *top, double *right, double *bottom)

static void _init_cbs_getContentsMargins_c4704_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_getContentsMargins_c4704_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = args.read<double * > (heap);
  double *arg2 = args.read<double * > (heap);
  double *arg3 = args.read<double * > (heap);
  double *arg4 = args.read<double * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem_Adaptor *)cls)->cbs_getContentsMargins_c4704_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_getContentsMargins_c4704_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLayoutItem_Adaptor *)cls)->cb_getContentsMargins_c4704_0 = cb;
}


// void QGraphicsLayoutItem::setGeometry(const QRectF &rect)

static void _init_cbs_setGeometry_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem_Adaptor *)cls)->cbs_setGeometry_1862_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLayoutItem_Adaptor *)cls)->cb_setGeometry_1862_0 = cb;
}


// exposed void QGraphicsLayoutItem::setGraphicsItem(QGraphicsItem *item)

static void _init_fp_setGraphicsItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setGraphicsItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem_Adaptor *)cls)->fp_QGraphicsLayoutItem_setGraphicsItem_1919 (arg1);
}


// exposed void QGraphicsLayoutItem::setOwnedByLayout(bool ownedByLayout)

static void _init_fp_setOwnedByLayout_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ownedByLayout");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOwnedByLayout_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem_Adaptor *)cls)->fp_QGraphicsLayoutItem_setOwnedByLayout_864 (arg1);
}


// QSizeF QGraphicsLayoutItem::sizeHint(Qt::SizeHint which, const QSizeF &constraint)

static void _init_cbs_sizeHint_c3330_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_cbs_sizeHint_c3330_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (heap);
  const QSizeF &arg2 = args.read<const QSizeF & > (heap);
  ret.write<QSizeF > ((QSizeF)((QGraphicsLayoutItem_Adaptor *)cls)->cbs_sizeHint_c3330_1 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c3330_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLayoutItem_Adaptor *)cls)->cb_sizeHint_c3330_1 = cb;
}


// void QGraphicsLayoutItem::updateGeometry()

static void _init_cbs_updateGeometry_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometry_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLayoutItem_Adaptor *)cls)->cbs_updateGeometry_0_0 ();
}

static void _set_callback_cbs_updateGeometry_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLayoutItem_Adaptor *)cls)->cb_updateGeometry_0_0 = cb;
}


namespace gsi
{

gsi::Class<QGraphicsLayoutItem> &qtdecl_QGraphicsLayoutItem ();

static gsi::Methods methods_QGraphicsLayoutItem_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsLayoutItem::QGraphicsLayoutItem(QGraphicsLayoutItem *parent, bool isLayout)\nThis method creates an object of class QGraphicsLayoutItem.", &_init_ctor_QGraphicsLayoutItem_Adaptor_3313, &_call_ctor_QGraphicsLayoutItem_Adaptor_3313);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@brief Virtual method void QGraphicsLayoutItem::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@hide", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0, &_set_callback_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QGraphicsLayoutItem::setGeometry(const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0, &_set_callback_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("*setGraphicsItem", "@brief Method void QGraphicsLayoutItem::setGraphicsItem(QGraphicsItem *item)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setGraphicsItem_1919, &_call_fp_setGraphicsItem_1919);
  methods += new qt_gsi::GenericMethod ("*setOwnedByLayout", "@brief Method void QGraphicsLayoutItem::setOwnedByLayout(bool ownedByLayout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOwnedByLayout_864, &_call_fp_setOwnedByLayout_864);
  methods += new qt_gsi::GenericMethod ("*sizeHint", "@brief Virtual method QSizeF QGraphicsLayoutItem::sizeHint(Qt::SizeHint which, const QSizeF &constraint)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("*sizeHint", "@hide", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1, &_set_callback_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@brief Virtual method void QGraphicsLayoutItem::updateGeometry()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@hide", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0, &_set_callback_cbs_updateGeometry_0_0);
  return methods;
}

gsi::Class<QGraphicsLayoutItem_Adaptor> decl_QGraphicsLayoutItem_Adaptor (qtdecl_QGraphicsLayoutItem (), "QtGui", "QGraphicsLayoutItem",
  methods_QGraphicsLayoutItem_Adaptor (),
  "@qt\n@brief Binding of QGraphicsLayoutItem");

}

