/* 
 * File: gmlsearch.h
 *
 * Medialib search and playlist editor
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires GTK+ 2.6 or better and XMMS2 DR2 or better
 *
 * Released under the GNU General Public License v2
 */

#ifndef __GMLSEARCH_H__
#define __GMLSEARCH_H__

#include <gtk/gtk.h>

struct _GMLSearch
{
	GtkWidget         *frame, *table;
	GtkWidget         *list_results, *scroll_widget;
	GtkWidget         *entry_searchstring;
	GtkWidget         *label_search;
	GtkWidget         *checkbutton_exact, *button_search, *image_search;
	GtkWidget         *button_add,        *search_combo;
	GtkListStore      *ls;

	GtkTreeViewColumn *column_id;
	GtkTreeViewColumn *column_artist, *column_track;
	GtkTreeViewColumn *column_album,  *column_rating;
	gboolean           column_id_visible;
	gboolean           column_artist_visible, column_track_visible;
	gboolean           column_album_visible,  column_rating_visible;

	gchar             *last_search_str;
	gint               last_category;
	gboolean           last_exact;
};

#endif
