// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The user is not authorized to access a resource.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified application is not supported.
type ApplicationNotSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ApplicationNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApplicationNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApplicationNotSupportedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ApplicationNotSupportedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ApplicationNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The compute type of the WorkSpace is not compatible with the application.
type ComputeNotCompatibleException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ComputeNotCompatibleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ComputeNotCompatibleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ComputeNotCompatibleException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ComputeNotCompatibleException"
	}
	return *e.ErrorCodeOverride
}
func (e *ComputeNotCompatibleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified application is not compatible with the resource.
type IncompatibleApplicationsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IncompatibleApplicationsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IncompatibleApplicationsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IncompatibleApplicationsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IncompatibleApplicationsException"
	}
	return *e.ErrorCodeOverride
}
func (e *IncompatibleApplicationsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more parameter values are not valid.
type InvalidParameterValuesException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterValuesException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterValuesException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterValuesException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterValuesException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterValuesException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The state of the resource is not valid for this operation.
type InvalidResourceStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResourceStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResourceStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operating system of the WorkSpace is not compatible with the application.
type OperatingSystemNotCompatibleException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperatingSystemNotCompatibleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperatingSystemNotCompatibleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperatingSystemNotCompatibleException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperatingSystemNotCompatibleException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperatingSystemNotCompatibleException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The properties of this WorkSpace are currently being modified. Try again in a
// moment.
type OperationInProgressException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationInProgressException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationInProgressException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationInProgressException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationInProgressException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation is not supported.
type OperationNotSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	Reason *string

	noSmithyDocumentSerde
}

func (e *OperationNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotSupportedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationNotSupportedException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource is associated with a directory.
type ResourceAssociatedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceAssociatedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceAssociatedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceAssociatedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceAssociatedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceAssociatedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource could not be created.
type ResourceCreationFailedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceCreationFailedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceCreationFailedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceCreationFailedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceCreationFailedException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceCreationFailedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource is currently in use.
type ResourceInUseException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceId *string

	noSmithyDocumentSerde
}

func (e *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your resource limits have been exceeded.
type ResourceLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource could not be found.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceId *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource is not available.
type ResourceUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceId *string

	noSmithyDocumentSerde
}

func (e *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceUnavailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The configuration of this network is not supported for this operation, or your
// network configuration conflicts with the Amazon WorkSpaces management network IP
// range. For more information, see Configure a VPC for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html)
// .
type UnsupportedNetworkConfigurationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedNetworkConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedNetworkConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedNetworkConfigurationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedNetworkConfigurationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedNetworkConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The configuration of this WorkSpace is not supported for this operation. For
// more information, see Required Configuration and Service Components for
// WorkSpaces  (https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html)
// .
type UnsupportedWorkspaceConfigurationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedWorkspaceConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedWorkspaceConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedWorkspaceConfigurationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedWorkspaceConfigurationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedWorkspaceConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The workspaces_DefaultRole role could not be found. If this is the first time
// you are registering a directory, you will need to create the
// workspaces_DefaultRole role before you can register a directory. For more
// information, see Creating the workspaces_DefaultRole Role (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role)
// .
type WorkspacesDefaultRoleNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *WorkspacesDefaultRoleNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WorkspacesDefaultRoleNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WorkspacesDefaultRoleNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "WorkspacesDefaultRoleNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *WorkspacesDefaultRoleNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}
