// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoice

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateConfigurationSet struct {
}

func (*awsRestjson1_serializeOpCreateConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/configuration-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfigurationSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfigurationSetInput(v *CreateConfigurationSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfigurationSetInput(v *CreateConfigurationSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationSetName != nil {
		ok := object.Key("ConfigurationSetName")
		ok.String(*v.ConfigurationSetName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateConfigurationSetEventDestination struct {
}

func (*awsRestjson1_serializeOpCreateConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateConfigurationSetEventDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfigurationSetEventDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfigurationSetEventDestinationInput(v *CreateConfigurationSetEventDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfigurationSetEventDestinationInput(v *CreateConfigurationSetEventDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventDestination != nil {
		ok := object.Key("EventDestination")
		if err := awsRestjson1_serializeDocumentEventDestinationDefinition(v.EventDestination, ok); err != nil {
			return err
		}
	}

	if v.EventDestinationName != nil {
		ok := object.Key("EventDestinationName")
		ok.String(*v.EventDestinationName)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfigurationSet struct {
}

func (*awsRestjson1_serializeOpDeleteConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/configuration-sets/{ConfigurationSetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetInput(v *DeleteConfigurationSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfigurationSetEventDestination struct {
}

func (*awsRestjson1_serializeOpDeleteConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetEventDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetEventDestinationInput(v *DeleteConfigurationSetEventDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	if v.EventDestinationName == nil || len(*v.EventDestinationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EventDestinationName must not be empty")}
	}
	if v.EventDestinationName != nil {
		if err := encoder.SetURI("EventDestinationName").String(*v.EventDestinationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConfigurationSetEventDestinations struct {
}

func (*awsRestjson1_serializeOpGetConfigurationSetEventDestinations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfigurationSetEventDestinations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfigurationSetEventDestinationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfigurationSetEventDestinationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfigurationSetEventDestinationsInput(v *GetConfigurationSetEventDestinationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListConfigurationSets struct {
}

func (*awsRestjson1_serializeOpListConfigurationSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfigurationSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfigurationSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/configuration-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfigurationSetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfigurationSetsInput(v *ListConfigurationSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("PageSize").String(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpSendVoiceMessage struct {
}

func (*awsRestjson1_serializeOpSendVoiceMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSendVoiceMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendVoiceMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/voice/message")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSendVoiceMessageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSendVoiceMessageInput(v *SendVoiceMessageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSendVoiceMessageInput(v *SendVoiceMessageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CallerId != nil {
		ok := object.Key("CallerId")
		ok.String(*v.CallerId)
	}

	if v.ConfigurationSetName != nil {
		ok := object.Key("ConfigurationSetName")
		ok.String(*v.ConfigurationSetName)
	}

	if v.Content != nil {
		ok := object.Key("Content")
		if err := awsRestjson1_serializeDocumentVoiceMessageContent(v.Content, ok); err != nil {
			return err
		}
	}

	if v.DestinationPhoneNumber != nil {
		ok := object.Key("DestinationPhoneNumber")
		ok.String(*v.DestinationPhoneNumber)
	}

	if v.OriginationPhoneNumber != nil {
		ok := object.Key("OriginationPhoneNumber")
		ok.String(*v.OriginationPhoneNumber)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConfigurationSetEventDestination struct {
}

func (*awsRestjson1_serializeOpUpdateConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConfigurationSetEventDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConfigurationSetEventDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConfigurationSetEventDestinationInput(v *UpdateConfigurationSetEventDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	if v.EventDestinationName == nil || len(*v.EventDestinationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EventDestinationName must not be empty")}
	}
	if v.EventDestinationName != nil {
		if err := encoder.SetURI("EventDestinationName").String(*v.EventDestinationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConfigurationSetEventDestinationInput(v *UpdateConfigurationSetEventDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventDestination != nil {
		ok := object.Key("EventDestination")
		if err := awsRestjson1_serializeDocumentEventDestinationDefinition(v.EventDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCallInstructionsMessageType(v *types.CallInstructionsMessageType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchLogsDestination(v *types.CloudWatchLogsDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	if v.LogGroupArn != nil {
		ok := object.Key("LogGroupArn")
		ok.String(*v.LogGroupArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentEventDestinationDefinition(v *types.EventDestinationDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogsDestination != nil {
		ok := object.Key("CloudWatchLogsDestination")
		if err := awsRestjson1_serializeDocumentCloudWatchLogsDestination(v.CloudWatchLogsDestination, ok); err != nil {
			return err
		}
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.KinesisFirehoseDestination != nil {
		ok := object.Key("KinesisFirehoseDestination")
		if err := awsRestjson1_serializeDocumentKinesisFirehoseDestination(v.KinesisFirehoseDestination, ok); err != nil {
			return err
		}
	}

	if v.MatchingEventTypes != nil {
		ok := object.Key("MatchingEventTypes")
		if err := awsRestjson1_serializeDocumentEventTypes(v.MatchingEventTypes, ok); err != nil {
			return err
		}
	}

	if v.SnsDestination != nil {
		ok := object.Key("SnsDestination")
		if err := awsRestjson1_serializeDocumentSnsDestination(v.SnsDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEventTypes(v []types.EventType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentKinesisFirehoseDestination(v *types.KinesisFirehoseDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamArn != nil {
		ok := object.Key("DeliveryStreamArn")
		ok.String(*v.DeliveryStreamArn)
	}

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentPlainTextMessageType(v *types.PlainTextMessageType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LanguageCode != nil {
		ok := object.Key("LanguageCode")
		ok.String(*v.LanguageCode)
	}

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	if v.VoiceId != nil {
		ok := object.Key("VoiceId")
		ok.String(*v.VoiceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSnsDestination(v *types.SnsDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TopicArn != nil {
		ok := object.Key("TopicArn")
		ok.String(*v.TopicArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSSMLMessageType(v *types.SSMLMessageType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LanguageCode != nil {
		ok := object.Key("LanguageCode")
		ok.String(*v.LanguageCode)
	}

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	if v.VoiceId != nil {
		ok := object.Key("VoiceId")
		ok.String(*v.VoiceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentVoiceMessageContent(v *types.VoiceMessageContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CallInstructionsMessage != nil {
		ok := object.Key("CallInstructionsMessage")
		if err := awsRestjson1_serializeDocumentCallInstructionsMessageType(v.CallInstructionsMessage, ok); err != nil {
			return err
		}
	}

	if v.PlainTextMessage != nil {
		ok := object.Key("PlainTextMessage")
		if err := awsRestjson1_serializeDocumentPlainTextMessageType(v.PlainTextMessage, ok); err != nil {
			return err
		}
	}

	if v.SSMLMessage != nil {
		ok := object.Key("SSMLMessage")
		if err := awsRestjson1_serializeDocumentSSMLMessageType(v.SSMLMessage, ok); err != nil {
			return err
		}
	}

	return nil
}
