//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogic

import "time"

// APIDeploymentParameterMetadata - The API deployment parameter metadata.
type APIDeploymentParameterMetadata struct {
	// The description.
	Description *string `json:"description,omitempty"`

	// The display name.
	DisplayName *string `json:"displayName,omitempty"`

	// Indicates whether its required.
	IsRequired *bool `json:"isRequired,omitempty"`

	// The type.
	Type *string `json:"type,omitempty"`

	// The visibility.
	Visibility *APIDeploymentParameterVisibility `json:"visibility,omitempty"`
}

// APIDeploymentParameterMetadataSet - The API deployment parameters metadata.
type APIDeploymentParameterMetadataSet struct {
	// The package content link parameter.
	PackageContentLink *APIDeploymentParameterMetadata `json:"packageContentLink,omitempty"`

	// The package content link parameter.
	RedisCacheConnectionString *APIDeploymentParameterMetadata `json:"redisCacheConnectionString,omitempty"`
}

// APIOperation - The api operation.
type APIOperation struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The api operations properties
	Properties *APIOperationPropertiesDefinition `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// APIOperationAnnotation - The Api Operation Annotation.
type APIOperationAnnotation struct {
	// The family.
	Family *string `json:"family,omitempty"`

	// The revision.
	Revision *int32 `json:"revision,omitempty"`

	// The status annotation.
	Status *StatusAnnotation `json:"status,omitempty"`
}

// APIOperationListResult - The list of managed API operations.
type APIOperationListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The api operation definitions for an API.
	Value []*APIOperation `json:"value,omitempty"`
}

// APIOperationPropertiesDefinition - The api operations properties
type APIOperationPropertiesDefinition struct {
	// The api reference.
	API *APIReference `json:"api,omitempty"`

	// The annotation of api operation.
	Annotation *APIOperationAnnotation `json:"annotation,omitempty"`

	// The description of the api operation.
	Description *string `json:"description,omitempty"`

	// The operation inputs definition schema.
	InputsDefinition *SwaggerSchema `json:"inputsDefinition,omitempty"`

	// Indicates whether the API operation is notification or not.
	IsNotification *bool `json:"isNotification,omitempty"`

	// Indicates whether the API operation is webhook or not.
	IsWebhook *bool `json:"isWebhook,omitempty"`

	// Indicates whether the api operation is pageable.
	Pageable *bool `json:"pageable,omitempty"`

	// The operation responses definition schemas.
	ResponsesDefinition map[string]*SwaggerSchema `json:"responsesDefinition,omitempty"`

	// The summary of the api operation.
	Summary *string `json:"summary,omitempty"`

	// The trigger type of api operation.
	Trigger *string `json:"trigger,omitempty"`

	// The trigger hint for the api operation.
	TriggerHint *string `json:"triggerHint,omitempty"`

	// The visibility of the api operation.
	Visibility *string `json:"visibility,omitempty"`
}

// APIReference - The Api reference.
type APIReference struct {
	// The brand color of the api.
	BrandColor *string `json:"brandColor,omitempty"`

	// The tier.
	Category *APITier `json:"category,omitempty"`

	// The description of the api.
	Description *string `json:"description,omitempty"`

	// The display name of the api.
	DisplayName *string `json:"displayName,omitempty"`

	// The resource id.
	ID *string `json:"id,omitempty"`

	// The icon uri of the api.
	IconURI *string `json:"iconUri,omitempty"`

	// The integration service environment reference.
	IntegrationServiceEnvironment *ResourceReference `json:"integrationServiceEnvironment,omitempty"`

	// The swagger of the api.
	Swagger interface{} `json:"swagger,omitempty"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// APIResourceBackendService - The API backend service.
type APIResourceBackendService struct {
	// The service URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
}

// APIResourceDefinitions - The Api resource definition.
type APIResourceDefinitions struct {
	// The modified swagger url.
	ModifiedSwaggerURL *string `json:"modifiedSwaggerUrl,omitempty"`

	// The original swagger url.
	OriginalSwaggerURL *string `json:"originalSwaggerUrl,omitempty"`
}

// APIResourceGeneralInformation - The API general information.
type APIResourceGeneralInformation struct {
	// The description.
	Description *string `json:"description,omitempty"`

	// The display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The icon url.
	IconURL *string `json:"iconUrl,omitempty"`

	// The release tag.
	ReleaseTag *string `json:"releaseTag,omitempty"`

	// The terms of use url.
	TermsOfUseURL *string `json:"termsOfUseUrl,omitempty"`

	// The tier.
	Tier *APITier `json:"tier,omitempty"`
}

// APIResourceMetadata - The api resource metadata.
type APIResourceMetadata struct {
	// The api type.
	APIType *APIType `json:"ApiType,omitempty"`

	// The brand color.
	BrandColor *string `json:"brandColor,omitempty"`

	// The connection type.
	ConnectionType *string `json:"connectionType,omitempty"`

	// The connector deployment parameters metadata.
	DeploymentParameters *APIDeploymentParameterMetadataSet `json:"deploymentParameters,omitempty"`

	// The hide key.
	HideKey *string `json:"hideKey,omitempty"`

	// The provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty"`

	// The source.
	Source *string `json:"source,omitempty"`

	// The tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The WSDL import method.
	WsdlImportMethod *WsdlImportMethod `json:"wsdlImportMethod,omitempty"`

	// The WSDL service.
	WsdlService *WsdlService `json:"wsdlService,omitempty"`
}

// APIResourcePolicies - The API resource policies.
type APIResourcePolicies struct {
	// The API level only policies XML as embedded content.
	Content *string `json:"content,omitempty"`

	// The content link to the policies.
	ContentLink *string `json:"contentLink,omitempty"`
}

// APIResourceProperties - The API resource properties.
type APIResourceProperties struct {
	// The integration service environment reference.
	IntegrationServiceEnvironment *ResourceReference `json:"integrationServiceEnvironment,omitempty"`

	// READ-ONLY; The API definition.
	APIDefinitionURL *string `json:"apiDefinitionUrl,omitempty" azure:"ro"`

	// READ-ONLY; The api definitions.
	APIDefinitions *APIResourceDefinitions `json:"apiDefinitions,omitempty" azure:"ro"`

	// READ-ONLY; The backend service.
	BackendService *APIResourceBackendService `json:"backendService,omitempty" azure:"ro"`

	// READ-ONLY; The capabilities.
	Capabilities []*string `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The category.
	Category *APITier `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; The connection parameters.
	ConnectionParameters map[string]interface{} `json:"connectionParameters,omitempty" azure:"ro"`

	// READ-ONLY; The api general information.
	GeneralInformation *APIResourceGeneralInformation `json:"generalInformation,omitempty" azure:"ro"`

	// READ-ONLY; The metadata.
	Metadata *APIResourceMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The policies for the API.
	Policies *APIResourcePolicies `json:"policies,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The runtime urls.
	RuntimeUrls []*string `json:"runtimeUrls,omitempty" azure:"ro"`
}

// AS2AcknowledgementConnectionSettings - The AS2 agreement acknowledgement connection settings.
type AS2AcknowledgementConnectionSettings struct {
	// REQUIRED; Indicates whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`

	// REQUIRED; Indicates whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool `json:"keepHttpConnectionAlive,omitempty"`

	// REQUIRED; Indicates whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`

	// REQUIRED; Indicates whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2AgreementContent - The integration account AS2 agreement content.
type AS2AgreementContent struct {
	// REQUIRED; The AS2 one-way receive agreement.
	ReceiveAgreement *AS2OneWayAgreement `json:"receiveAgreement,omitempty"`

	// REQUIRED; The AS2 one-way send agreement.
	SendAgreement *AS2OneWayAgreement `json:"sendAgreement,omitempty"`
}

// AS2EnvelopeSettings - The AS2 agreement envelope settings.
type AS2EnvelopeSettings struct {
	// REQUIRED; The value indicating whether to auto generate file name.
	AutogenerateFileName *bool `json:"autogenerateFileName,omitempty"`

	// REQUIRED; The template for file name.
	FileNameTemplate *string `json:"fileNameTemplate,omitempty"`

	// REQUIRED; The message content type.
	MessageContentType *string `json:"messageContentType,omitempty"`

	// REQUIRED; The value indicating whether to suspend message on file name generation error.
	SuspendMessageOnFileNameGenerationError *bool `json:"suspendMessageOnFileNameGenerationError,omitempty"`

	// REQUIRED; The value indicating whether to transmit file name in mime header.
	TransmitFileNameInMimeHeader *bool `json:"transmitFileNameInMimeHeader,omitempty"`
}

// AS2ErrorSettings - The AS2 agreement error settings.
type AS2ErrorSettings struct {
	// REQUIRED; The value indicating whether to resend message If MDN is not received.
	ResendIfMDNNotReceived *bool `json:"resendIfMDNNotReceived,omitempty"`

	// REQUIRED; The value indicating whether to suspend duplicate message.
	SuspendDuplicateMessage *bool `json:"suspendDuplicateMessage,omitempty"`
}

// AS2MdnSettings - The AS2 agreement mdn settings.
type AS2MdnSettings struct {
	// REQUIRED; The signing or hashing algorithm.
	MicHashingAlgorithm *HashingAlgorithm `json:"micHashingAlgorithm,omitempty"`

	// REQUIRED; The value indicating whether to send or request a MDN.
	NeedMDN *bool `json:"needMDN,omitempty"`

	// REQUIRED; The value indicating whether to send inbound MDN to message box.
	SendInboundMDNToMessageBox *bool `json:"sendInboundMDNToMessageBox,omitempty"`

	// REQUIRED; The value indicating whether to send the asynchronous MDN.
	SendMDNAsynchronously *bool `json:"sendMDNAsynchronously,omitempty"`

	// REQUIRED; The value indicating whether the MDN needs to be signed or not.
	SignMDN *bool `json:"signMDN,omitempty"`

	// REQUIRED; The value indicating whether to sign the outbound MDN if optional.
	SignOutboundMDNIfOptional *bool `json:"signOutboundMDNIfOptional,omitempty"`

	// The disposition notification to header value.
	DispositionNotificationTo *string `json:"dispositionNotificationTo,omitempty"`

	// The MDN text.
	MdnText *string `json:"mdnText,omitempty"`

	// The receipt delivery URL.
	ReceiptDeliveryURL *string `json:"receiptDeliveryUrl,omitempty"`
}

// AS2MessageConnectionSettings - The AS2 agreement message connection settings.
type AS2MessageConnectionSettings struct {
	// REQUIRED; The value indicating whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`

	// REQUIRED; The value indicating whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool `json:"keepHttpConnectionAlive,omitempty"`

	// REQUIRED; The value indicating whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`

	// REQUIRED; The value indicating whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2OneWayAgreement - The integration account AS2 one-way agreement.
type AS2OneWayAgreement struct {
	// REQUIRED; The AS2 protocol settings.
	ProtocolSettings *AS2ProtocolSettings `json:"protocolSettings,omitempty"`

	// REQUIRED; The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`

	// REQUIRED; The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
}

// AS2ProtocolSettings - The AS2 agreement protocol settings.
type AS2ProtocolSettings struct {
	// REQUIRED; The acknowledgement connection settings.
	AcknowledgementConnectionSettings *AS2AcknowledgementConnectionSettings `json:"acknowledgementConnectionSettings,omitempty"`

	// REQUIRED; The envelope settings.
	EnvelopeSettings *AS2EnvelopeSettings `json:"envelopeSettings,omitempty"`

	// REQUIRED; The error settings.
	ErrorSettings *AS2ErrorSettings `json:"errorSettings,omitempty"`

	// REQUIRED; The MDN settings.
	MdnSettings *AS2MdnSettings `json:"mdnSettings,omitempty"`

	// REQUIRED; The message connection settings.
	MessageConnectionSettings *AS2MessageConnectionSettings `json:"messageConnectionSettings,omitempty"`

	// REQUIRED; The security settings.
	SecuritySettings *AS2SecuritySettings `json:"securitySettings,omitempty"`

	// REQUIRED; The validation settings.
	ValidationSettings *AS2ValidationSettings `json:"validationSettings,omitempty"`
}

// AS2SecuritySettings - The AS2 agreement security settings.
type AS2SecuritySettings struct {
	// REQUIRED; The value indicating whether to enable NRR for inbound decoded messages.
	EnableNRRForInboundDecodedMessages *bool `json:"enableNRRForInboundDecodedMessages,omitempty"`

	// REQUIRED; The value indicating whether to enable NRR for inbound encoded messages.
	EnableNRRForInboundEncodedMessages *bool `json:"enableNRRForInboundEncodedMessages,omitempty"`

	// REQUIRED; The value indicating whether to enable NRR for inbound MDN.
	EnableNRRForInboundMDN *bool `json:"enableNRRForInboundMDN,omitempty"`

	// REQUIRED; The value indicating whether to enable NRR for outbound decoded messages.
	EnableNRRForOutboundDecodedMessages *bool `json:"enableNRRForOutboundDecodedMessages,omitempty"`

	// REQUIRED; The value indicating whether to enable NRR for outbound encoded messages.
	EnableNRRForOutboundEncodedMessages *bool `json:"enableNRRForOutboundEncodedMessages,omitempty"`

	// REQUIRED; The value indicating whether to enable NRR for outbound MDN.
	EnableNRRForOutboundMDN *bool `json:"enableNRRForOutboundMDN,omitempty"`

	// REQUIRED; The value indicating whether to send or request a MDN.
	OverrideGroupSigningCertificate *bool `json:"overrideGroupSigningCertificate,omitempty"`

	// The name of the encryption certificate.
	EncryptionCertificateName *string `json:"encryptionCertificateName,omitempty"`

	// The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
	SHA2AlgorithmFormat *string `json:"sha2AlgorithmFormat,omitempty"`

	// The name of the signing certificate.
	SigningCertificateName *string `json:"signingCertificateName,omitempty"`
}

// AS2ValidationSettings - The AS2 agreement validation settings.
type AS2ValidationSettings struct {
	// REQUIRED; The value indicating whether to check for certificate revocation list on receive.
	CheckCertificateRevocationListOnReceive *bool `json:"checkCertificateRevocationListOnReceive,omitempty"`

	// REQUIRED; The value indicating whether to check for certificate revocation list on send.
	CheckCertificateRevocationListOnSend *bool `json:"checkCertificateRevocationListOnSend,omitempty"`

	// REQUIRED; The value indicating whether to check for duplicate message.
	CheckDuplicateMessage *bool `json:"checkDuplicateMessage,omitempty"`

	// REQUIRED; The value indicating whether the message has to be compressed.
	CompressMessage *bool `json:"compressMessage,omitempty"`

	// REQUIRED; The value indicating whether the message has to be encrypted.
	EncryptMessage *bool `json:"encryptMessage,omitempty"`

	// REQUIRED; The encryption algorithm.
	EncryptionAlgorithm *EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The number of days to look back for duplicate interchange.
	InterchangeDuplicatesValidityDays *int32 `json:"interchangeDuplicatesValidityDays,omitempty"`

	// REQUIRED; The value indicating whether to override incoming message properties with those in agreement.
	OverrideMessageProperties *bool `json:"overrideMessageProperties,omitempty"`

	// REQUIRED; The value indicating whether the message has to be signed.
	SignMessage *bool `json:"signMessage,omitempty"`

	// The signing algorithm.
	SigningAlgorithm *SigningAlgorithm `json:"signingAlgorithm,omitempty"`
}

// AgreementContent - The integration account agreement content.
type AgreementContent struct {
	// The AS2 agreement content.
	AS2 *AS2AgreementContent `json:"aS2,omitempty"`

	// The EDIFACT agreement content.
	Edifact *EdifactAgreementContent `json:"edifact,omitempty"`

	// The X12 agreement content.
	X12 *X12AgreementContent `json:"x12,omitempty"`
}

// ArtifactContentPropertiesDefinition - The artifact content properties definition.
type ArtifactContentPropertiesDefinition struct {
	// The artifact changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty"`

	// Anything
	Content interface{} `json:"content,omitempty"`

	// The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`

	// The content type.
	ContentType *string `json:"contentType,omitempty"`

	// The artifact creation time.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Anything
	Metadata interface{} `json:"metadata,omitempty"`
}

// ArtifactProperties - The artifact properties definition.
type ArtifactProperties struct {
	// The artifact changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty"`

	// The artifact creation time.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Anything
	Metadata interface{} `json:"metadata,omitempty"`
}

// AssemblyCollection - A collection of assembly definitions.
type AssemblyCollection struct {
	Value []*AssemblyDefinition `json:"value,omitempty"`
}

// AssemblyDefinition - The assembly definition.
type AssemblyDefinition struct {
	// REQUIRED; The assembly properties.
	Properties *AssemblyProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssemblyProperties - The assembly properties definition.
type AssemblyProperties struct {
	// REQUIRED; The assembly name.
	AssemblyName *string `json:"assemblyName,omitempty"`

	// The assembly culture.
	AssemblyCulture *string `json:"assemblyCulture,omitempty"`

	// The assembly public key token.
	AssemblyPublicKeyToken *string `json:"assemblyPublicKeyToken,omitempty"`

	// The assembly version.
	AssemblyVersion *string `json:"assemblyVersion,omitempty"`

	// The artifact changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty"`

	// Anything
	Content interface{} `json:"content,omitempty"`

	// The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`

	// The content type.
	ContentType *string `json:"contentType,omitempty"`

	// The artifact creation time.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Anything
	Metadata interface{} `json:"metadata,omitempty"`
}

// AzureResourceErrorInfo - The azure resource error info.
type AzureResourceErrorInfo struct {
	// REQUIRED; The error code.
	Code *string `json:"code,omitempty"`

	// REQUIRED; The error message.
	Message *string `json:"message,omitempty"`

	// The error details.
	Details []*AzureResourceErrorInfo `json:"details,omitempty"`
}

// B2BPartnerContent - The B2B partner content.
type B2BPartnerContent struct {
	// The list of partner business identities.
	BusinessIdentities []*BusinessIdentity `json:"businessIdentities,omitempty"`
}

// BatchConfiguration - The batch configuration resource definition.
type BatchConfiguration struct {
	// REQUIRED; The batch configuration properties.
	Properties *BatchConfigurationProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BatchConfigurationCollection - A collection of batch configurations.
type BatchConfigurationCollection struct {
	Value []*BatchConfiguration `json:"value,omitempty"`
}

// BatchConfigurationProperties - The batch configuration properties definition.
type BatchConfigurationProperties struct {
	// REQUIRED; The name of the batch group.
	BatchGroupName *string `json:"batchGroupName,omitempty"`

	// REQUIRED; The batch release criteria.
	ReleaseCriteria *BatchReleaseCriteria `json:"releaseCriteria,omitempty"`

	// The artifact changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty"`

	// The artifact creation time.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Anything
	Metadata interface{} `json:"metadata,omitempty"`
}

// BatchReleaseCriteria - The batch release criteria.
type BatchReleaseCriteria struct {
	// The batch size in bytes.
	BatchSize *int32 `json:"batchSize,omitempty"`

	// The message count.
	MessageCount *int32 `json:"messageCount,omitempty"`

	// The recurrence.
	Recurrence *WorkflowTriggerRecurrence `json:"recurrence,omitempty"`
}

// BusinessIdentity - The integration account partner's business identity.
type BusinessIdentity struct {
	// REQUIRED; The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
	Qualifier *string `json:"qualifier,omitempty"`

	// REQUIRED; The user defined business identity value.
	Value *string `json:"value,omitempty"`
}

// CallbackURL - The callback url.
type CallbackURL struct {
	// The URL value.
	Value *string `json:"value,omitempty"`
}

// ContentHash - The content hash.
type ContentHash struct {
	// The algorithm of the content hash.
	Algorithm *string `json:"algorithm,omitempty"`

	// The value of the content hash.
	Value *string `json:"value,omitempty"`
}

// ContentLink - The content link.
type ContentLink struct {
	// The content link URI.
	URI *string `json:"uri,omitempty"`

	// READ-ONLY; The content hash.
	ContentHash *ContentHash `json:"contentHash,omitempty" azure:"ro"`

	// READ-ONLY; The content size.
	ContentSize *int64 `json:"contentSize,omitempty" azure:"ro"`

	// READ-ONLY; The content version.
	ContentVersion *string `json:"contentVersion,omitempty" azure:"ro"`

	// READ-ONLY; The metadata.
	Metadata interface{} `json:"metadata,omitempty" azure:"ro"`
}

// Correlation - The correlation property.
type Correlation struct {
	// The client tracking id.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// EdifactAcknowledgementSettings - The Edifact agreement acknowledgement settings.
type EdifactAcknowledgementSettings struct {
	// REQUIRED; The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32 `json:"acknowledgementControlNumberLowerBound,omitempty"`

	// REQUIRED; The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32 `json:"acknowledgementControlNumberUpperBound,omitempty"`

	// REQUIRED; The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool `json:"batchFunctionalAcknowledgements,omitempty"`

	// REQUIRED; The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool `json:"batchTechnicalAcknowledgements,omitempty"`

	// REQUIRED; The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool `json:"needFunctionalAcknowledgement,omitempty"`

	// REQUIRED; The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool `json:"needLoopForValidMessages,omitempty"`

	// REQUIRED; The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool `json:"needTechnicalAcknowledgement,omitempty"`

	// REQUIRED; The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool `json:"rolloverAcknowledgementControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool `json:"sendSynchronousAcknowledgement,omitempty"`

	// The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string `json:"acknowledgementControlNumberPrefix,omitempty"`

	// The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string `json:"acknowledgementControlNumberSuffix,omitempty"`
}

// EdifactAgreementContent - The Edifact agreement content.
type EdifactAgreementContent struct {
	// REQUIRED; The EDIFACT one-way receive agreement.
	ReceiveAgreement *EdifactOneWayAgreement `json:"receiveAgreement,omitempty"`

	// REQUIRED; The EDIFACT one-way send agreement.
	SendAgreement *EdifactOneWayAgreement `json:"sendAgreement,omitempty"`
}

// EdifactDelimiterOverride - The Edifact delimiter override settings.
type EdifactDelimiterOverride struct {
	// REQUIRED; The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`

	// REQUIRED; The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`

	// REQUIRED; The decimal point indicator.
	DecimalPointIndicator *EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`

	// REQUIRED; The release indicator.
	ReleaseIndicator *int32 `json:"releaseIndicator,omitempty"`

	// REQUIRED; The repetition separator.
	RepetitionSeparator *int32 `json:"repetitionSeparator,omitempty"`

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`

	// REQUIRED; The segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`

	// The message association assigned code.
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`

	// The message id.
	MessageID *string `json:"messageId,omitempty"`

	// The message release.
	MessageRelease *string `json:"messageRelease,omitempty"`

	// The message version.
	MessageVersion *string `json:"messageVersion,omitempty"`

	// The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// EdifactEnvelopeOverride - The Edifact envelope override settings.
type EdifactEnvelopeOverride struct {
	// The application password.
	ApplicationPassword *string `json:"applicationPassword,omitempty"`

	// The association assigned code.
	AssociationAssignedCode *string `json:"associationAssignedCode,omitempty"`

	// The controlling agency code.
	ControllingAgencyCode *string `json:"controllingAgencyCode,omitempty"`

	// The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`

	// The group header message release.
	GroupHeaderMessageRelease *string `json:"groupHeaderMessageRelease,omitempty"`

	// The group header message version.
	GroupHeaderMessageVersion *string `json:"groupHeaderMessageVersion,omitempty"`

	// The message association assigned code.
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`

	// The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`

	// The message release version on which this envelope settings has to be applied.
	MessageRelease *string `json:"messageRelease,omitempty"`

	// The message version on which this envelope settings has to be applied.
	MessageVersion *string `json:"messageVersion,omitempty"`

	// The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`

	// The receiver application qualifier.
	ReceiverApplicationQualifier *string `json:"receiverApplicationQualifier,omitempty"`

	// The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`

	// The sender application qualifier.
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`

	// The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// EdifactEnvelopeSettings - The Edifact agreement envelope settings.
type EdifactEnvelopeSettings struct {
	// REQUIRED; The value indicating whether to apply delimiter string advice.
	ApplyDelimiterStringAdvice *bool `json:"applyDelimiterStringAdvice,omitempty"`

	// REQUIRED; The value indicating whether to create grouping segments.
	CreateGroupingSegments *bool `json:"createGroupingSegments,omitempty"`

	// REQUIRED; The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool `json:"enableDefaultGroupHeaders,omitempty"`

	// REQUIRED; The group control number lower bound.
	GroupControlNumberLowerBound *int64 `json:"groupControlNumberLowerBound,omitempty"`

	// REQUIRED; The group control number upper bound.
	GroupControlNumberUpperBound *int64 `json:"groupControlNumberUpperBound,omitempty"`

	// REQUIRED; The interchange control number lower bound.
	InterchangeControlNumberLowerBound *int64 `json:"interchangeControlNumberLowerBound,omitempty"`

	// REQUIRED; The interchange control number upper bound.
	InterchangeControlNumberUpperBound *int64 `json:"interchangeControlNumberUpperBound,omitempty"`

	// REQUIRED; The value indicating whether the message is a test interchange.
	IsTestInterchange *bool `json:"isTestInterchange,omitempty"`

	// REQUIRED; The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool `json:"overwriteExistingTransactionSetControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool `json:"rolloverGroupControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool `json:"rolloverInterchangeControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool `json:"rolloverTransactionSetControlNumber,omitempty"`

	// REQUIRED; The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int64 `json:"transactionSetControlNumberLowerBound,omitempty"`

	// REQUIRED; The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int64 `json:"transactionSetControlNumberUpperBound,omitempty"`

	// The application reference id.
	ApplicationReferenceID *string `json:"applicationReferenceId,omitempty"`

	// The communication agreement id.
	CommunicationAgreementID *string `json:"communicationAgreementId,omitempty"`

	// The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`

	// The group application password.
	GroupApplicationPassword *string `json:"groupApplicationPassword,omitempty"`

	// The group application receiver id.
	GroupApplicationReceiverID *string `json:"groupApplicationReceiverId,omitempty"`

	// The group application receiver qualifier.
	GroupApplicationReceiverQualifier *string `json:"groupApplicationReceiverQualifier,omitempty"`

	// The group application sender id.
	GroupApplicationSenderID *string `json:"groupApplicationSenderId,omitempty"`

	// The group application sender qualifier.
	GroupApplicationSenderQualifier *string `json:"groupApplicationSenderQualifier,omitempty"`

	// The group association assigned code.
	GroupAssociationAssignedCode *string `json:"groupAssociationAssignedCode,omitempty"`

	// The group control number prefix.
	GroupControlNumberPrefix *string `json:"groupControlNumberPrefix,omitempty"`

	// The group control number suffix.
	GroupControlNumberSuffix *string `json:"groupControlNumberSuffix,omitempty"`

	// The group controlling agency code.
	GroupControllingAgencyCode *string `json:"groupControllingAgencyCode,omitempty"`

	// The group message release.
	GroupMessageRelease *string `json:"groupMessageRelease,omitempty"`

	// The group message version.
	GroupMessageVersion *string `json:"groupMessageVersion,omitempty"`

	// The interchange control number prefix.
	InterchangeControlNumberPrefix *string `json:"interchangeControlNumberPrefix,omitempty"`

	// The interchange control number suffix.
	InterchangeControlNumberSuffix *string `json:"interchangeControlNumberSuffix,omitempty"`

	// The processing priority code.
	ProcessingPriorityCode *string `json:"processingPriorityCode,omitempty"`

	// The receiver internal identification.
	ReceiverInternalIdentification *string `json:"receiverInternalIdentification,omitempty"`

	// The receiver internal sub identification.
	ReceiverInternalSubIdentification *string `json:"receiverInternalSubIdentification,omitempty"`

	// The receiver reverse routing address.
	ReceiverReverseRoutingAddress *string `json:"receiverReverseRoutingAddress,omitempty"`

	// The recipient reference password qualifier.
	RecipientReferencePasswordQualifier *string `json:"recipientReferencePasswordQualifier,omitempty"`

	// The recipient reference password value.
	RecipientReferencePasswordValue *string `json:"recipientReferencePasswordValue,omitempty"`

	// The sender internal identification.
	SenderInternalIdentification *string `json:"senderInternalIdentification,omitempty"`

	// The sender internal sub identification.
	SenderInternalSubIdentification *string `json:"senderInternalSubIdentification,omitempty"`

	// The sender reverse routing address.
	SenderReverseRoutingAddress *string `json:"senderReverseRoutingAddress,omitempty"`

	// The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string `json:"transactionSetControlNumberPrefix,omitempty"`

	// The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string `json:"transactionSetControlNumberSuffix,omitempty"`
}

// EdifactFramingSettings - The Edifact agreement framing settings.
type EdifactFramingSettings struct {
	// REQUIRED; The EDIFACT frame setting characterSet.
	CharacterSet *EdifactCharacterSet `json:"characterSet,omitempty"`

	// REQUIRED; The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`

	// REQUIRED; The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`

	// REQUIRED; The EDIFACT frame setting decimal indicator.
	DecimalPointIndicator *EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`

	// REQUIRED; The protocol version.
	ProtocolVersion *int32 `json:"protocolVersion,omitempty"`

	// REQUIRED; The release indicator.
	ReleaseIndicator *int32 `json:"releaseIndicator,omitempty"`

	// REQUIRED; The repetition separator.
	RepetitionSeparator *int32 `json:"repetitionSeparator,omitempty"`

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`

	// REQUIRED; The EDIFACT frame setting segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`

	// The character encoding.
	CharacterEncoding *string `json:"characterEncoding,omitempty"`

	// The service code list directory version.
	ServiceCodeListDirectoryVersion *string `json:"serviceCodeListDirectoryVersion,omitempty"`
}

// EdifactMessageFilter - The Edifact message filter for odata query.
type EdifactMessageFilter struct {
	// REQUIRED; The message filter type.
	MessageFilterType *MessageFilterType `json:"messageFilterType,omitempty"`
}

// EdifactMessageIdentifier - The Edifact message identifier.
type EdifactMessageIdentifier struct {
	// REQUIRED; The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
}

// EdifactOneWayAgreement - The Edifact one way agreement.
type EdifactOneWayAgreement struct {
	// REQUIRED; The EDIFACT protocol settings.
	ProtocolSettings *EdifactProtocolSettings `json:"protocolSettings,omitempty"`

	// REQUIRED; The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`

	// REQUIRED; The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
}

// EdifactProcessingSettings - The Edifact agreement protocol settings.
type EdifactProcessingSettings struct {
	// REQUIRED; The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`

	// REQUIRED; The value indicating whether to mask security information.
	MaskSecurityInfo *bool `json:"maskSecurityInfo,omitempty"`

	// REQUIRED; The value indicating whether to preserve interchange.
	PreserveInterchange *bool `json:"preserveInterchange,omitempty"`

	// REQUIRED; The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool `json:"suspendInterchangeOnError,omitempty"`

	// REQUIRED; The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// EdifactProtocolSettings - The Edifact agreement protocol settings.
type EdifactProtocolSettings struct {
	// REQUIRED; The EDIFACT acknowledgement settings.
	AcknowledgementSettings *EdifactAcknowledgementSettings `json:"acknowledgementSettings,omitempty"`

	// REQUIRED; The EDIFACT envelope settings.
	EnvelopeSettings *EdifactEnvelopeSettings `json:"envelopeSettings,omitempty"`

	// REQUIRED; The EDIFACT framing settings.
	FramingSettings *EdifactFramingSettings `json:"framingSettings,omitempty"`

	// REQUIRED; The EDIFACT message filter.
	MessageFilter *EdifactMessageFilter `json:"messageFilter,omitempty"`

	// REQUIRED; The EDIFACT processing Settings.
	ProcessingSettings *EdifactProcessingSettings `json:"processingSettings,omitempty"`

	// REQUIRED; The EDIFACT schema references.
	SchemaReferences []*EdifactSchemaReference `json:"schemaReferences,omitempty"`

	// REQUIRED; The EDIFACT validation settings.
	ValidationSettings *EdifactValidationSettings `json:"validationSettings,omitempty"`

	// The EDIFACT delimiter override settings.
	EdifactDelimiterOverrides []*EdifactDelimiterOverride `json:"edifactDelimiterOverrides,omitempty"`

	// The EDIFACT envelope override settings.
	EnvelopeOverrides []*EdifactEnvelopeOverride `json:"envelopeOverrides,omitempty"`

	// The EDIFACT message filter list.
	MessageFilterList []*EdifactMessageIdentifier `json:"messageFilterList,omitempty"`

	// The EDIFACT validation override settings.
	ValidationOverrides []*EdifactValidationOverride `json:"validationOverrides,omitempty"`
}

// EdifactSchemaReference - The Edifact schema reference.
type EdifactSchemaReference struct {
	// REQUIRED; The message id.
	MessageID *string `json:"messageId,omitempty"`

	// REQUIRED; The message release version.
	MessageRelease *string `json:"messageRelease,omitempty"`

	// REQUIRED; The message version.
	MessageVersion *string `json:"messageVersion,omitempty"`

	// REQUIRED; The schema name.
	SchemaName *string `json:"schemaName,omitempty"`

	// The association assigned code.
	AssociationAssignedCode *string `json:"associationAssignedCode,omitempty"`

	// The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`

	// The sender application qualifier.
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`
}

// EdifactValidationOverride - The Edifact validation override settings.
type EdifactValidationOverride struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The value indicating whether to validate character Set.
	EnforceCharacterSet *bool `json:"enforceCharacterSet,omitempty"`

	// REQUIRED; The message id on which the validation settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The value indicating whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`

	// REQUIRED; The value indicating whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
}

// EdifactValidationSettings - The Edifact agreement validation settings.
type EdifactValidationSettings struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool `json:"checkDuplicateGroupControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool `json:"checkDuplicateInterchangeControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool `json:"checkDuplicateTransactionSetControlNumber,omitempty"`

	// REQUIRED; The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32 `json:"interchangeControlNumberValidityDays,omitempty"`

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`

	// REQUIRED; The value indicating whether to Whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`

	// REQUIRED; The value indicating whether to Whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
}

// ErrorInfo - The error info.
type ErrorInfo struct {
	// REQUIRED; The error code.
	Code *string `json:"code,omitempty"`
}

// ErrorProperties - Error properties indicate why the Logic service was not able to process the incoming request. The reason
// is provided in the error message.
type ErrorProperties struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse - Error response indicates Logic service is not able to process the incoming request. The error property
// contains the error details.
type ErrorResponse struct {
	// The error properties.
	Error *ErrorProperties `json:"error,omitempty"`
}

// Expression - The expression.
type Expression struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo `json:"error,omitempty"`

	// The sub expressions.
	Subexpressions []*Expression `json:"subexpressions,omitempty"`

	// The text.
	Text *string `json:"text,omitempty"`

	// Anything
	Value interface{} `json:"value,omitempty"`
}

// ExpressionRoot - The expression root.
type ExpressionRoot struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo `json:"error,omitempty"`

	// The path.
	Path *string `json:"path,omitempty"`

	// The sub expressions.
	Subexpressions []*Expression `json:"subexpressions,omitempty"`

	// The text.
	Text *string `json:"text,omitempty"`

	// Anything
	Value interface{} `json:"value,omitempty"`
}

// ExpressionTraces - The expression traces.
type ExpressionTraces struct {
	Inputs []*ExpressionRoot `json:"inputs,omitempty"`
}

// ExtendedErrorInfo - The extended error info.
type ExtendedErrorInfo struct {
	// REQUIRED; The error code.
	Code *ErrorResponseCode `json:"code,omitempty"`

	// REQUIRED; The error message.
	Message *string `json:"message,omitempty"`

	// The error message details.
	Details []*ExtendedErrorInfo `json:"details,omitempty"`

	// The inner error.
	InnerError interface{} `json:"innerError,omitempty"`
}

// FlowAccessControlConfiguration - The access control configuration.
type FlowAccessControlConfiguration struct {
	// The access control configuration for workflow actions.
	Actions *FlowAccessControlConfigurationPolicy `json:"actions,omitempty"`

	// The access control configuration for accessing workflow run contents.
	Contents *FlowAccessControlConfigurationPolicy `json:"contents,omitempty"`

	// The access control configuration for invoking workflow triggers.
	Triggers *FlowAccessControlConfigurationPolicy `json:"triggers,omitempty"`

	// The access control configuration for workflow management.
	WorkflowManagement *FlowAccessControlConfigurationPolicy `json:"workflowManagement,omitempty"`
}

// FlowAccessControlConfigurationPolicy - The access control configuration policy.
type FlowAccessControlConfigurationPolicy struct {
	// The allowed caller IP address ranges.
	AllowedCallerIPAddresses []*IPAddressRange `json:"allowedCallerIpAddresses,omitempty"`

	// The authentication policies for workflow.
	OpenAuthenticationPolicies *OpenAuthenticationAccessPolicies `json:"openAuthenticationPolicies,omitempty"`
}

// FlowEndpoints - The flow endpoints configuration.
type FlowEndpoints struct {
	// The access endpoint ip address.
	AccessEndpointIPAddresses []*IPAddress `json:"accessEndpointIpAddresses,omitempty"`

	// The outgoing ip address.
	OutgoingIPAddresses []*IPAddress `json:"outgoingIpAddresses,omitempty"`
}

// FlowEndpointsConfiguration - The endpoints configuration.
type FlowEndpointsConfiguration struct {
	// The connector endpoints.
	Connector *FlowEndpoints `json:"connector,omitempty"`

	// The workflow endpoints.
	Workflow *FlowEndpoints `json:"workflow,omitempty"`
}

// GenerateUpgradedDefinitionParameters - The parameters to generate upgraded definition.
type GenerateUpgradedDefinitionParameters struct {
	// The target schema version.
	TargetSchemaVersion *string `json:"targetSchemaVersion,omitempty"`
}

// GetCallbackURLParameters - The callback url parameters.
type GetCallbackURLParameters struct {
	// The key type.
	KeyType *KeyType `json:"keyType,omitempty"`

	// The expiry time.
	NotAfter *time.Time `json:"notAfter,omitempty"`
}

// IPAddress - The ip address.
type IPAddress struct {
	// The address.
	Address *string `json:"address,omitempty"`
}

// IPAddressRange - The ip address range.
type IPAddressRange struct {
	// The IP address range.
	AddressRange *string `json:"addressRange,omitempty"`
}

// IntegrationAccount - The integration account.
type IntegrationAccount struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The integration account properties.
	Properties *IntegrationAccountProperties `json:"properties,omitempty"`

	// The sku.
	SKU *IntegrationAccountSKU `json:"sku,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationAccountAgreement - The integration account agreement.
type IntegrationAccountAgreement struct {
	// REQUIRED; The integration account agreement properties.
	Properties *IntegrationAccountAgreementProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationAccountAgreementFilter - The integration account agreement filter for odata query.
type IntegrationAccountAgreementFilter struct {
	// REQUIRED; The agreement type of integration account agreement.
	AgreementType *AgreementType `json:"agreementType,omitempty"`
}

// IntegrationAccountAgreementListResult - The list of integration account agreements.
type IntegrationAccountAgreementListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration account agreements.
	Value []*IntegrationAccountAgreement `json:"value,omitempty"`
}

// IntegrationAccountAgreementProperties - The integration account agreement properties.
type IntegrationAccountAgreementProperties struct {
	// REQUIRED; The agreement type.
	AgreementType *AgreementType `json:"agreementType,omitempty"`

	// REQUIRED; The agreement content.
	Content *AgreementContent `json:"content,omitempty"`

	// REQUIRED; The business identity of the guest partner.
	GuestIdentity *BusinessIdentity `json:"guestIdentity,omitempty"`

	// REQUIRED; The integration account partner that is set as guest partner for this agreement.
	GuestPartner *string `json:"guestPartner,omitempty"`

	// REQUIRED; The business identity of the host partner.
	HostIdentity *BusinessIdentity `json:"hostIdentity,omitempty"`

	// REQUIRED; The integration account partner that is set as host partner for this agreement.
	HostPartner *string `json:"hostPartner,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// READ-ONLY; The changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`
}

// IntegrationAccountAgreementsClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountAgreementsClient.CreateOrUpdate
// method.
type IntegrationAccountAgreementsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAgreementsClientDeleteOptions contains the optional parameters for the IntegrationAccountAgreementsClient.Delete
// method.
type IntegrationAccountAgreementsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAgreementsClientGetOptions contains the optional parameters for the IntegrationAccountAgreementsClient.Get
// method.
type IntegrationAccountAgreementsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAgreementsClientListContentCallbackURLOptions contains the optional parameters for the IntegrationAccountAgreementsClient.ListContentCallbackURL
// method.
type IntegrationAccountAgreementsClientListContentCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAgreementsClientListOptions contains the optional parameters for the IntegrationAccountAgreementsClient.List
// method.
type IntegrationAccountAgreementsClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: AgreementType.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountAssembliesClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountAssembliesClient.CreateOrUpdate
// method.
type IntegrationAccountAssembliesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAssembliesClientDeleteOptions contains the optional parameters for the IntegrationAccountAssembliesClient.Delete
// method.
type IntegrationAccountAssembliesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAssembliesClientGetOptions contains the optional parameters for the IntegrationAccountAssembliesClient.Get
// method.
type IntegrationAccountAssembliesClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAssembliesClientListContentCallbackURLOptions contains the optional parameters for the IntegrationAccountAssembliesClient.ListContentCallbackURL
// method.
type IntegrationAccountAssembliesClientListContentCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountAssembliesClientListOptions contains the optional parameters for the IntegrationAccountAssembliesClient.List
// method.
type IntegrationAccountAssembliesClientListOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountBatchConfigurationsClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountBatchConfigurationsClient.CreateOrUpdate
// method.
type IntegrationAccountBatchConfigurationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountBatchConfigurationsClientDeleteOptions contains the optional parameters for the IntegrationAccountBatchConfigurationsClient.Delete
// method.
type IntegrationAccountBatchConfigurationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountBatchConfigurationsClientGetOptions contains the optional parameters for the IntegrationAccountBatchConfigurationsClient.Get
// method.
type IntegrationAccountBatchConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountBatchConfigurationsClientListOptions contains the optional parameters for the IntegrationAccountBatchConfigurationsClient.List
// method.
type IntegrationAccountBatchConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountCertificate - The integration account certificate.
type IntegrationAccountCertificate struct {
	// REQUIRED; The integration account certificate properties.
	Properties *IntegrationAccountCertificateProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationAccountCertificateListResult - The list of integration account certificates.
type IntegrationAccountCertificateListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration account certificates.
	Value []*IntegrationAccountCertificate `json:"value,omitempty"`
}

// IntegrationAccountCertificateProperties - The integration account certificate properties.
type IntegrationAccountCertificateProperties struct {
	// The key details in the key vault.
	Key *KeyVaultKeyReference `json:"key,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// The public certificate.
	PublicCertificate *string `json:"publicCertificate,omitempty"`

	// READ-ONLY; The changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`
}

// IntegrationAccountCertificatesClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountCertificatesClient.CreateOrUpdate
// method.
type IntegrationAccountCertificatesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountCertificatesClientDeleteOptions contains the optional parameters for the IntegrationAccountCertificatesClient.Delete
// method.
type IntegrationAccountCertificatesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountCertificatesClientGetOptions contains the optional parameters for the IntegrationAccountCertificatesClient.Get
// method.
type IntegrationAccountCertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountCertificatesClientListOptions contains the optional parameters for the IntegrationAccountCertificatesClient.List
// method.
type IntegrationAccountCertificatesClientListOptions struct {
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountListResult - The list of integration accounts.
type IntegrationAccountListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration accounts.
	Value []*IntegrationAccount `json:"value,omitempty"`
}

// IntegrationAccountMap - The integration account map.
type IntegrationAccountMap struct {
	// REQUIRED; The integration account map properties.
	Properties *IntegrationAccountMapProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationAccountMapFilter - The integration account map filter for odata query.
type IntegrationAccountMapFilter struct {
	// REQUIRED; The map type of integration account map.
	MapType *MapType `json:"mapType,omitempty"`
}

// IntegrationAccountMapListResult - The list of integration account maps.
type IntegrationAccountMapListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration account maps.
	Value []*IntegrationAccountMap `json:"value,omitempty"`
}

// IntegrationAccountMapProperties - The integration account map.
type IntegrationAccountMapProperties struct {
	// REQUIRED; The map type.
	MapType *MapType `json:"mapType,omitempty"`

	// The content.
	Content *string `json:"content,omitempty"`

	// The content type.
	ContentType *string `json:"contentType,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// The parameters schema of integration account map.
	ParametersSchema *IntegrationAccountMapPropertiesParametersSchema `json:"parametersSchema,omitempty"`

	// READ-ONLY; The changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`
}

// IntegrationAccountMapPropertiesParametersSchema - The parameters schema of integration account map.
type IntegrationAccountMapPropertiesParametersSchema struct {
	// The reference name.
	Ref *string `json:"ref,omitempty"`
}

// IntegrationAccountMapsClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountMapsClient.CreateOrUpdate
// method.
type IntegrationAccountMapsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountMapsClientDeleteOptions contains the optional parameters for the IntegrationAccountMapsClient.Delete
// method.
type IntegrationAccountMapsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountMapsClientGetOptions contains the optional parameters for the IntegrationAccountMapsClient.Get method.
type IntegrationAccountMapsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountMapsClientListContentCallbackURLOptions contains the optional parameters for the IntegrationAccountMapsClient.ListContentCallbackURL
// method.
type IntegrationAccountMapsClientListContentCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountMapsClientListOptions contains the optional parameters for the IntegrationAccountMapsClient.List method.
type IntegrationAccountMapsClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: MapType.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountPartner - The integration account partner.
type IntegrationAccountPartner struct {
	// REQUIRED; The integration account partner properties.
	Properties *IntegrationAccountPartnerProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationAccountPartnerFilter - The integration account partner filter for odata query.
type IntegrationAccountPartnerFilter struct {
	// REQUIRED; The partner type of integration account partner.
	PartnerType *PartnerType `json:"partnerType,omitempty"`
}

// IntegrationAccountPartnerListResult - The list of integration account partners.
type IntegrationAccountPartnerListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration account partners.
	Value []*IntegrationAccountPartner `json:"value,omitempty"`
}

// IntegrationAccountPartnerProperties - The integration account partner properties.
type IntegrationAccountPartnerProperties struct {
	// REQUIRED; The partner content.
	Content *PartnerContent `json:"content,omitempty"`

	// REQUIRED; The partner type.
	PartnerType *PartnerType `json:"partnerType,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// READ-ONLY; The changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`
}

// IntegrationAccountPartnersClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountPartnersClient.CreateOrUpdate
// method.
type IntegrationAccountPartnersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountPartnersClientDeleteOptions contains the optional parameters for the IntegrationAccountPartnersClient.Delete
// method.
type IntegrationAccountPartnersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountPartnersClientGetOptions contains the optional parameters for the IntegrationAccountPartnersClient.Get
// method.
type IntegrationAccountPartnersClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountPartnersClientListContentCallbackURLOptions contains the optional parameters for the IntegrationAccountPartnersClient.ListContentCallbackURL
// method.
type IntegrationAccountPartnersClientListContentCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountPartnersClientListOptions contains the optional parameters for the IntegrationAccountPartnersClient.List
// method.
type IntegrationAccountPartnersClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: PartnerType.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountProperties - The integration account properties.
type IntegrationAccountProperties struct {
	// The integration service environment.
	IntegrationServiceEnvironment *ResourceReference `json:"integrationServiceEnvironment,omitempty"`

	// The workflow state.
	State *WorkflowState `json:"state,omitempty"`
}

// IntegrationAccountSKU - The integration account sku.
type IntegrationAccountSKU struct {
	// REQUIRED; The sku name.
	Name *IntegrationAccountSKUName `json:"name,omitempty"`
}

// IntegrationAccountSchema - The integration account schema.
type IntegrationAccountSchema struct {
	// REQUIRED; The integration account schema properties.
	Properties *IntegrationAccountSchemaProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationAccountSchemaFilter - The integration account schema filter for odata query.
type IntegrationAccountSchemaFilter struct {
	// REQUIRED; The schema type of integration account schema.
	SchemaType *SchemaType `json:"schemaType,omitempty"`
}

// IntegrationAccountSchemaListResult - The list of integration account schemas.
type IntegrationAccountSchemaListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration account schemas.
	Value []*IntegrationAccountSchema `json:"value,omitempty"`
}

// IntegrationAccountSchemaProperties - The integration account schema properties.
type IntegrationAccountSchemaProperties struct {
	// REQUIRED; The schema type.
	SchemaType *SchemaType `json:"schemaType,omitempty"`

	// The content.
	Content *string `json:"content,omitempty"`

	// The content type.
	ContentType *string `json:"contentType,omitempty"`

	// The document name.
	DocumentName *string `json:"documentName,omitempty"`

	// The file name.
	FileName *string `json:"fileName,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// The target namespace of the schema.
	TargetNamespace *string `json:"targetNamespace,omitempty"`

	// READ-ONLY; The changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`
}

// IntegrationAccountSchemasClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountSchemasClient.CreateOrUpdate
// method.
type IntegrationAccountSchemasClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountSchemasClientDeleteOptions contains the optional parameters for the IntegrationAccountSchemasClient.Delete
// method.
type IntegrationAccountSchemasClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountSchemasClientGetOptions contains the optional parameters for the IntegrationAccountSchemasClient.Get
// method.
type IntegrationAccountSchemasClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountSchemasClientListContentCallbackURLOptions contains the optional parameters for the IntegrationAccountSchemasClient.ListContentCallbackURL
// method.
type IntegrationAccountSchemasClientListContentCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountSchemasClientListOptions contains the optional parameters for the IntegrationAccountSchemasClient.List
// method.
type IntegrationAccountSchemasClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: SchemaType.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountSession - The integration account session.
type IntegrationAccountSession struct {
	// REQUIRED; The integration account session properties.
	Properties *IntegrationAccountSessionProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationAccountSessionFilter - The integration account session filter.
type IntegrationAccountSessionFilter struct {
	// REQUIRED; The changed time of integration account sessions.
	ChangedTime *time.Time `json:"changedTime,omitempty"`
}

// IntegrationAccountSessionListResult - The list of integration account sessions.
type IntegrationAccountSessionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration account sessions.
	Value []*IntegrationAccountSession `json:"value,omitempty"`
}

// IntegrationAccountSessionProperties - The integration account session properties.
type IntegrationAccountSessionProperties struct {
	// The session content.
	Content interface{} `json:"content,omitempty"`

	// READ-ONLY; The changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`
}

// IntegrationAccountSessionsClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountSessionsClient.CreateOrUpdate
// method.
type IntegrationAccountSessionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountSessionsClientDeleteOptions contains the optional parameters for the IntegrationAccountSessionsClient.Delete
// method.
type IntegrationAccountSessionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountSessionsClientGetOptions contains the optional parameters for the IntegrationAccountSessionsClient.Get
// method.
type IntegrationAccountSessionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountSessionsClientListOptions contains the optional parameters for the IntegrationAccountSessionsClient.List
// method.
type IntegrationAccountSessionsClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: ChangedTime.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountsClientCreateOrUpdateOptions contains the optional parameters for the IntegrationAccountsClient.CreateOrUpdate
// method.
type IntegrationAccountsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountsClientDeleteOptions contains the optional parameters for the IntegrationAccountsClient.Delete method.
type IntegrationAccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountsClientGetOptions contains the optional parameters for the IntegrationAccountsClient.Get method.
type IntegrationAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountsClientListByResourceGroupOptions contains the optional parameters for the IntegrationAccountsClient.ListByResourceGroup
// method.
type IntegrationAccountsClientListByResourceGroupOptions struct {
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountsClientListBySubscriptionOptions contains the optional parameters for the IntegrationAccountsClient.ListBySubscription
// method.
type IntegrationAccountsClientListBySubscriptionOptions struct {
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationAccountsClientListCallbackURLOptions contains the optional parameters for the IntegrationAccountsClient.ListCallbackURL
// method.
type IntegrationAccountsClientListCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountsClientListKeyVaultKeysOptions contains the optional parameters for the IntegrationAccountsClient.ListKeyVaultKeys
// method.
type IntegrationAccountsClientListKeyVaultKeysOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountsClientLogTrackingEventsOptions contains the optional parameters for the IntegrationAccountsClient.LogTrackingEvents
// method.
type IntegrationAccountsClientLogTrackingEventsOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountsClientRegenerateAccessKeyOptions contains the optional parameters for the IntegrationAccountsClient.RegenerateAccessKey
// method.
type IntegrationAccountsClientRegenerateAccessKeyOptions struct {
	// placeholder for future optional parameters
}

// IntegrationAccountsClientUpdateOptions contains the optional parameters for the IntegrationAccountsClient.Update method.
type IntegrationAccountsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmenEncryptionConfiguration - The encryption configuration for the integration service environment.
type IntegrationServiceEnvironmenEncryptionConfiguration struct {
	// The encryption key reference.
	EncryptionKeyReference *IntegrationServiceEnvironmenEncryptionKeyReference `json:"encryptionKeyReference,omitempty"`
}

// IntegrationServiceEnvironmenEncryptionKeyReference - The encryption key details for the integration service environment.
type IntegrationServiceEnvironmenEncryptionKeyReference struct {
	// Gets the key name in the Key Vault.
	KeyName *string `json:"keyName,omitempty"`

	// The key vault reference.
	KeyVault *ResourceReference `json:"keyVault,omitempty"`

	// Gets the version of the key specified in the keyName property.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// IntegrationServiceEnvironment - The integration service environment.
type IntegrationServiceEnvironment struct {
	// Managed service identity properties.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The integration service environment properties.
	Properties *IntegrationServiceEnvironmentProperties `json:"properties,omitempty"`

	// The sku.
	SKU *IntegrationServiceEnvironmentSKU `json:"sku,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationServiceEnvironmentAccessEndpoint - The integration service environment access endpoint.
type IntegrationServiceEnvironmentAccessEndpoint struct {
	// The access endpoint type.
	Type *IntegrationServiceEnvironmentAccessEndpointType `json:"type,omitempty"`
}

// IntegrationServiceEnvironmentListResult - The list of integration service environments.
type IntegrationServiceEnvironmentListResult struct {
	// The URL to get the next set of results.
	NextLink *string                          `json:"nextLink,omitempty"`
	Value    []*IntegrationServiceEnvironment `json:"value,omitempty"`
}

// IntegrationServiceEnvironmentManagedAPI - The integration service environment managed api.
type IntegrationServiceEnvironmentManagedAPI struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The integration service environment managed api properties.
	Properties *IntegrationServiceEnvironmentManagedAPIProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationServiceEnvironmentManagedAPIDeploymentParameters - The integration service environment managed api deployment
// parameters.
type IntegrationServiceEnvironmentManagedAPIDeploymentParameters struct {
	// The integration service environment managed api content link for deployment.
	ContentLinkDefinition *ContentLink `json:"contentLinkDefinition,omitempty"`
}

// IntegrationServiceEnvironmentManagedAPIListResult - The list of integration service environment managed APIs.
type IntegrationServiceEnvironmentManagedAPIListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The integration service environment managed APIs.
	Value []*IntegrationServiceEnvironmentManagedAPI `json:"value,omitempty"`
}

// IntegrationServiceEnvironmentManagedAPIOperationsClientListOptions contains the optional parameters for the IntegrationServiceEnvironmentManagedAPIOperationsClient.List
// method.
type IntegrationServiceEnvironmentManagedAPIOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmentManagedAPIProperties - The integration service environment managed api properties.
type IntegrationServiceEnvironmentManagedAPIProperties struct {
	// The integration service environment managed api deployment parameters.
	DeploymentParameters *IntegrationServiceEnvironmentManagedAPIDeploymentParameters `json:"deploymentParameters,omitempty"`

	// The integration service environment reference.
	IntegrationServiceEnvironment *ResourceReference `json:"integrationServiceEnvironment,omitempty"`

	// READ-ONLY; The API definition.
	APIDefinitionURL *string `json:"apiDefinitionUrl,omitempty" azure:"ro"`

	// READ-ONLY; The api definitions.
	APIDefinitions *APIResourceDefinitions `json:"apiDefinitions,omitempty" azure:"ro"`

	// READ-ONLY; The backend service.
	BackendService *APIResourceBackendService `json:"backendService,omitempty" azure:"ro"`

	// READ-ONLY; The capabilities.
	Capabilities []*string `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The category.
	Category *APITier `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; The connection parameters.
	ConnectionParameters map[string]interface{} `json:"connectionParameters,omitempty" azure:"ro"`

	// READ-ONLY; The api general information.
	GeneralInformation *APIResourceGeneralInformation `json:"generalInformation,omitempty" azure:"ro"`

	// READ-ONLY; The metadata.
	Metadata *APIResourceMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The policies for the API.
	Policies *APIResourcePolicies `json:"policies,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The runtime urls.
	RuntimeUrls []*string `json:"runtimeUrls,omitempty" azure:"ro"`
}

// IntegrationServiceEnvironmentManagedApisClientBeginDeleteOptions contains the optional parameters for the IntegrationServiceEnvironmentManagedApisClient.BeginDelete
// method.
type IntegrationServiceEnvironmentManagedApisClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationServiceEnvironmentManagedApisClientBeginPutOptions contains the optional parameters for the IntegrationServiceEnvironmentManagedApisClient.BeginPut
// method.
type IntegrationServiceEnvironmentManagedApisClientBeginPutOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationServiceEnvironmentManagedApisClientGetOptions contains the optional parameters for the IntegrationServiceEnvironmentManagedApisClient.Get
// method.
type IntegrationServiceEnvironmentManagedApisClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmentManagedApisClientListOptions contains the optional parameters for the IntegrationServiceEnvironmentManagedApisClient.List
// method.
type IntegrationServiceEnvironmentManagedApisClientListOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmentNetworkDependency - The azure async operation resource.
type IntegrationServiceEnvironmentNetworkDependency struct {
	// The network dependency category type.
	Category *IntegrationServiceEnvironmentNetworkDependencyCategoryType `json:"category,omitempty"`

	// The display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The endpoints.
	Endpoints []*IntegrationServiceEnvironmentNetworkEndpoint `json:"endpoints,omitempty"`
}

// IntegrationServiceEnvironmentNetworkDependencyHealth - The integration service environment subnet network health.
type IntegrationServiceEnvironmentNetworkDependencyHealth struct {
	// The error if any occurred during the operation.
	Error *ExtendedErrorInfo `json:"error,omitempty"`

	// The network dependency health state.
	State *IntegrationServiceEnvironmentNetworkDependencyHealthState `json:"state,omitempty"`
}

// IntegrationServiceEnvironmentNetworkEndpoint - The network endpoint.
type IntegrationServiceEnvironmentNetworkEndpoint struct {
	// The accessibility state.
	Accessibility *IntegrationServiceEnvironmentNetworkEndPointAccessibilityState `json:"accessibility,omitempty"`

	// The domain name.
	DomainName *string `json:"domainName,omitempty"`

	// The ports.
	Ports []*string `json:"ports,omitempty"`
}

// IntegrationServiceEnvironmentNetworkHealthClientGetOptions contains the optional parameters for the IntegrationServiceEnvironmentNetworkHealthClient.Get
// method.
type IntegrationServiceEnvironmentNetworkHealthClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmentProperties - The integration service environment properties.
type IntegrationServiceEnvironmentProperties struct {
	// The encryption configuration.
	EncryptionConfiguration *IntegrationServiceEnvironmenEncryptionConfiguration `json:"encryptionConfiguration,omitempty"`

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration `json:"endpointsConfiguration,omitempty"`

	// Gets the tracking id.
	IntegrationServiceEnvironmentID *string `json:"integrationServiceEnvironmentId,omitempty"`

	// The network configuration.
	NetworkConfiguration *NetworkConfiguration `json:"networkConfiguration,omitempty"`

	// The provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty"`

	// The integration service environment state.
	State *WorkflowState `json:"state,omitempty"`
}

// IntegrationServiceEnvironmentSKU - The integration service environment sku.
type IntegrationServiceEnvironmentSKU struct {
	// The sku capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// The sku name.
	Name *IntegrationServiceEnvironmentSKUName `json:"name,omitempty"`
}

// IntegrationServiceEnvironmentSKUCapacity - The integration service environment sku capacity.
type IntegrationServiceEnvironmentSKUCapacity struct {
	// The default capacity.
	Default *int32 `json:"default,omitempty"`

	// The maximum capacity.
	Maximum *int32 `json:"maximum,omitempty"`

	// The minimum capacity.
	Minimum *int32 `json:"minimum,omitempty"`

	// The sku scale type.
	ScaleType *IntegrationServiceEnvironmentSKUScaleType `json:"scaleType,omitempty"`
}

// IntegrationServiceEnvironmentSKUDefinition - The integration service environment sku definition.
type IntegrationServiceEnvironmentSKUDefinition struct {
	// The sku capacity.
	Capacity *IntegrationServiceEnvironmentSKUCapacity `json:"capacity,omitempty"`

	// The resource type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The sku.
	SKU *IntegrationServiceEnvironmentSKUDefinitionSKU `json:"sku,omitempty"`
}

// IntegrationServiceEnvironmentSKUDefinitionSKU - The sku.
type IntegrationServiceEnvironmentSKUDefinitionSKU struct {
	// The sku name.
	Name *IntegrationServiceEnvironmentSKUName `json:"name,omitempty"`

	// The sku tier.
	Tier *string `json:"tier,omitempty"`
}

// IntegrationServiceEnvironmentSKUList - The list of integration service environment skus.
type IntegrationServiceEnvironmentSKUList struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of integration service environment skus.
	Value []*IntegrationServiceEnvironmentSKUDefinition `json:"value,omitempty"`
}

// IntegrationServiceEnvironmentSKUsClientListOptions contains the optional parameters for the IntegrationServiceEnvironmentSKUsClient.List
// method.
type IntegrationServiceEnvironmentSKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmentSubnetNetworkHealth - The integration service environment subnet network health.
type IntegrationServiceEnvironmentSubnetNetworkHealth struct {
	// REQUIRED; The integration service environment network health state.
	NetworkDependencyHealthState *IntegrationServiceEnvironmentNetworkEndPointAccessibilityState `json:"networkDependencyHealthState,omitempty"`

	// The outbound network dependencies.
	OutboundNetworkDependencies []*IntegrationServiceEnvironmentNetworkDependency `json:"outboundNetworkDependencies,omitempty"`

	// The integration service environment network health.
	OutboundNetworkHealth *IntegrationServiceEnvironmentNetworkDependencyHealth `json:"outboundNetworkHealth,omitempty"`
}

// IntegrationServiceEnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the IntegrationServiceEnvironmentsClient.BeginCreateOrUpdate
// method.
type IntegrationServiceEnvironmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationServiceEnvironmentsClientBeginUpdateOptions contains the optional parameters for the IntegrationServiceEnvironmentsClient.BeginUpdate
// method.
type IntegrationServiceEnvironmentsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationServiceEnvironmentsClientDeleteOptions contains the optional parameters for the IntegrationServiceEnvironmentsClient.Delete
// method.
type IntegrationServiceEnvironmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmentsClientGetOptions contains the optional parameters for the IntegrationServiceEnvironmentsClient.Get
// method.
type IntegrationServiceEnvironmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationServiceEnvironmentsClientListByResourceGroupOptions contains the optional parameters for the IntegrationServiceEnvironmentsClient.ListByResourceGroup
// method.
type IntegrationServiceEnvironmentsClientListByResourceGroupOptions struct {
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationServiceEnvironmentsClientListBySubscriptionOptions contains the optional parameters for the IntegrationServiceEnvironmentsClient.ListBySubscription
// method.
type IntegrationServiceEnvironmentsClientListBySubscriptionOptions struct {
	// The number of items to be included in the result.
	Top *int32
}

// IntegrationServiceEnvironmentsClientRestartOptions contains the optional parameters for the IntegrationServiceEnvironmentsClient.Restart
// method.
type IntegrationServiceEnvironmentsClientRestartOptions struct {
	// placeholder for future optional parameters
}

// JSONSchema - The JSON schema.
type JSONSchema struct {
	// The JSON content.
	Content *string `json:"content,omitempty"`

	// The JSON title.
	Title *string `json:"title,omitempty"`
}

// KeyVaultKey - The key vault key.
type KeyVaultKey struct {
	// The key attributes.
	Attributes *KeyVaultKeyAttributes `json:"attributes,omitempty"`

	// The key id.
	Kid *string `json:"kid,omitempty"`
}

// KeyVaultKeyAttributes - The key attributes.
type KeyVaultKeyAttributes struct {
	// When the key was created.
	Created *int64 `json:"created,omitempty"`

	// Whether the key is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// When the key was updated.
	Updated *int64 `json:"updated,omitempty"`
}

// KeyVaultKeyCollection - Collection of key vault keys.
type KeyVaultKeyCollection struct {
	// The skip token.
	SkipToken *string `json:"skipToken,omitempty"`

	// The key vault keys.
	Value []*KeyVaultKey `json:"value,omitempty"`
}

// KeyVaultKeyReference - The reference to the key vault key.
type KeyVaultKeyReference struct {
	// REQUIRED; The private key name in key vault.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The key vault reference.
	KeyVault *KeyVaultKeyReferenceKeyVault `json:"keyVault,omitempty"`

	// The private key version in key vault.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// KeyVaultKeyReferenceKeyVault - The key vault reference.
type KeyVaultKeyReferenceKeyVault struct {
	// The resource id.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KeyVaultReference - The key vault reference.
type KeyVaultReference struct {
	// The resource id.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ListKeyVaultKeysDefinition - The list key vault keys definition.
type ListKeyVaultKeysDefinition struct {
	// REQUIRED; The key vault reference.
	KeyVault *KeyVaultReference `json:"keyVault,omitempty"`

	// The skip token.
	SkipToken *string `json:"skipToken,omitempty"`
}

// ManagedAPI - The managed api definition.
type ManagedAPI struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The api resource properties.
	Properties *APIResourceProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedAPIListResult - The list of managed APIs.
type ManagedAPIListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The managed APIs.
	Value []*ManagedAPI `json:"value,omitempty"`
}

// ManagedServiceIdentity - Managed service identity properties.
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity. The type 'SystemAssigned' includes an implicitly created identity. The type
	// 'None' will remove any identities from the resource.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The list of user assigned identities associated with the resource. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; Principal Id of managed service identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Tenant of managed service identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// NetworkConfiguration - The network configuration.
type NetworkConfiguration struct {
	// The access endpoint.
	AccessEndpoint *IntegrationServiceEnvironmentAccessEndpoint `json:"accessEndpoint,omitempty"`

	// The subnets.
	Subnets []*ResourceReference `json:"subnets,omitempty"`

	// Gets the virtual network address space.
	VirtualNetworkAddressSpace *string `json:"virtualNetworkAddressSpace,omitempty"`
}

// OpenAuthenticationAccessPolicies - AuthenticationPolicy of type Open.
type OpenAuthenticationAccessPolicies struct {
	// Open authentication policies.
	Policies map[string]*OpenAuthenticationAccessPolicy `json:"policies,omitempty"`
}

// OpenAuthenticationAccessPolicy - Open authentication access policy defined by user.
type OpenAuthenticationAccessPolicy struct {
	// The access policy claims.
	Claims []*OpenAuthenticationPolicyClaim `json:"claims,omitempty"`

	// Type of provider for OAuth.
	Type *OpenAuthenticationProviderType `json:"type,omitempty"`
}

// OpenAuthenticationPolicyClaim - Open authentication policy claim.
type OpenAuthenticationPolicyClaim struct {
	// The name of the claim.
	Name *string `json:"name,omitempty"`

	// The value of the claim.
	Value *string `json:"value,omitempty"`
}

// Operation - Logic REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Operation: origin
	Origin *string `json:"origin,omitempty"`

	// The properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation: description.
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Logic
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Logic operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Logic operations supported by the Logic resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationResult - The operation result definition.
type OperationResult struct {
	// The workflow scope repetition code.
	Code *string `json:"code,omitempty"`

	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// The end time of the workflow scope repetition.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Anything
	Error          interface{} `json:"error,omitempty"`
	IterationCount *int32      `json:"iterationCount,omitempty"`

	// Gets the retry histories.
	RetryHistory []*RetryHistory `json:"retryHistory,omitempty"`

	// The start time of the workflow scope repetition.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the workflow scope repetition.
	Status *WorkflowStatus `json:"status,omitempty"`

	// READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// OperationResultProperties - The run operation result properties.
type OperationResultProperties struct {
	// The workflow scope repetition code.
	Code *string `json:"code,omitempty"`

	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// The end time of the workflow scope repetition.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Anything
	Error interface{} `json:"error,omitempty"`

	// The start time of the workflow scope repetition.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the workflow scope repetition.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PartnerContent - The integration account partner content.
type PartnerContent struct {
	// The B2B partner content.
	B2B *B2BPartnerContent `json:"b2b,omitempty"`
}

// RecurrenceSchedule - The recurrence schedule.
type RecurrenceSchedule struct {
	// The hours.
	Hours []*int32 `json:"hours,omitempty"`

	// The minutes.
	Minutes []*int32 `json:"minutes,omitempty"`

	// The month days.
	MonthDays []*int32 `json:"monthDays,omitempty"`

	// The monthly occurrences.
	MonthlyOccurrences []*RecurrenceScheduleOccurrence `json:"monthlyOccurrences,omitempty"`

	// The days of the week.
	WeekDays []*DaysOfWeek `json:"weekDays,omitempty"`
}

// RecurrenceScheduleOccurrence - The recurrence schedule occurrence.
type RecurrenceScheduleOccurrence struct {
	// The day of the week.
	Day *DayOfWeek `json:"day,omitempty"`

	// The occurrence.
	Occurrence *int32 `json:"occurrence,omitempty"`
}

// RegenerateActionParameter - The access key regenerate action content.
type RegenerateActionParameter struct {
	// The key type.
	KeyType *KeyType `json:"keyType,omitempty"`
}

// RepetitionIndex - The workflow run action repetition index.
type RepetitionIndex struct {
	// REQUIRED; The index.
	ItemIndex *int32 `json:"itemIndex,omitempty"`

	// The scope.
	ScopeName *string `json:"scopeName,omitempty"`
}

// Request - A request.
type Request struct {
	// A list of all the headers attached to the request.
	Headers interface{} `json:"headers,omitempty"`

	// The HTTP method used for the request.
	Method *string `json:"method,omitempty"`

	// The destination for the request.
	URI *string `json:"uri,omitempty"`
}

// RequestHistory - The request history.
type RequestHistory struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The request history properties.
	Properties *RequestHistoryProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RequestHistoryListResult - The list of workflow request histories.
type RequestHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow request histories.
	Value []*RequestHistory `json:"value,omitempty"`
}

// RequestHistoryProperties - The request history.
type RequestHistoryProperties struct {
	// The time the request ended.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The request.
	Request *Request `json:"request,omitempty"`

	// The response.
	Response *Response `json:"response,omitempty"`

	// The time the request started.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// Resource - The base resource type.
type Resource struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceReference - The resource reference.
type ResourceReference struct {
	// The resource id.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Response - A response.
type Response struct {
	// Details on the location of the body content.
	BodyLink *ContentLink `json:"bodyLink,omitempty"`

	// A list of all the headers attached to the response.
	Headers interface{} `json:"headers,omitempty"`

	// The status code of the response.
	StatusCode *int32 `json:"statusCode,omitempty"`
}

// RetryHistory - The retry history.
type RetryHistory struct {
	// Gets the client request Id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`

	// Gets the status code.
	Code *string `json:"code,omitempty"`

	// Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Gets the error response.
	Error *ErrorResponse `json:"error,omitempty"`

	// Gets the service request Id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty"`

	// Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// RunActionCorrelation - The workflow run action correlation properties.
type RunActionCorrelation struct {
	// The action tracking identifier.
	ActionTrackingID *string `json:"actionTrackingId,omitempty"`

	// The client keywords.
	ClientKeywords []*string `json:"clientKeywords,omitempty"`

	// The client tracking identifier.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// RunCorrelation - The correlation properties.
type RunCorrelation struct {
	// The client keywords.
	ClientKeywords []*string `json:"clientKeywords,omitempty"`

	// The client tracking identifier.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// SKU - The sku type.
type SKU struct {
	// REQUIRED; The name.
	Name *SKUName `json:"name,omitempty"`

	// The reference to plan.
	Plan *ResourceReference `json:"plan,omitempty"`
}

// SetTriggerStateActionDefinition - The set trigger state action definition.
type SetTriggerStateActionDefinition struct {
	// REQUIRED; The source.
	Source *WorkflowTriggerReference `json:"source,omitempty"`
}

// SubResource - The sub resource type.
type SubResource struct {
	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SwaggerCustomDynamicList - The swagger custom dynamic list.
type SwaggerCustomDynamicList struct {
	// The built in operation.
	BuiltInOperation *string `json:"builtInOperation,omitempty"`

	// The path to an item property which defines the display name of the item.
	ItemTitlePath *string `json:"itemTitlePath,omitempty"`

	// The path to a property which defines the value which should be used.
	ItemValuePath *string `json:"itemValuePath,omitempty"`

	// The path to a response property (relative to the response object, not the response body) which contains an array of dynamic
	// value items.
	ItemsPath *string `json:"itemsPath,omitempty"`

	// The operation id to fetch dynamic schema.
	OperationID *string `json:"operationId,omitempty"`

	// The parameters.
	Parameters map[string]*SwaggerCustomDynamicProperties `json:"parameters,omitempty"`
}

// SwaggerCustomDynamicProperties - The swagger custom dynamic properties.
type SwaggerCustomDynamicProperties struct {
	// The operation id to fetch dynamic schema.
	OperationID *string `json:"operationId,omitempty"`

	// The operation parameters.
	Parameters map[string]*SwaggerCustomDynamicProperties `json:"parameters,omitempty"`

	// Json pointer to the dynamic schema on the response body.
	ValuePath *string `json:"valuePath,omitempty"`
}

// SwaggerCustomDynamicSchema - The swagger custom dynamic schema.
type SwaggerCustomDynamicSchema struct {
	// The operation id to fetch dynamic schema.
	OperationID *string `json:"operationId,omitempty"`

	// The operation parameters.
	Parameters map[string]interface{} `json:"parameters,omitempty"`

	// Json pointer to the dynamic schema on the response body.
	ValuePath *string `json:"valuePath,omitempty"`
}

// SwaggerCustomDynamicTree - The swagger custom dynamic tree.
type SwaggerCustomDynamicTree struct {
	// The tree on-browse configuration
	Browse *SwaggerCustomDynamicTreeCommand `json:"browse,omitempty"`

	// The tree on-open configuration
	Open *SwaggerCustomDynamicTreeCommand `json:"open,omitempty"`

	// The tree settings
	Settings *SwaggerCustomDynamicTreeSettings `json:"settings,omitempty"`
}

// SwaggerCustomDynamicTreeCommand - The swagger tree command.
type SwaggerCustomDynamicTreeCommand struct {
	// The path to an item property which defines the display name of the item.
	ItemFullTitlePath *string `json:"itemFullTitlePath,omitempty"`

	// The path to an item property which defines the display name of the item.
	ItemIsParent *string `json:"itemIsParent,omitempty"`

	// The path to an item property which defines the display name of the item.
	ItemTitlePath *string `json:"itemTitlePath,omitempty"`

	// The path to an item property which defines the display name of the item.
	ItemValuePath *string `json:"itemValuePath,omitempty"`

	// The path to an item property which defines the display name of the item.
	ItemsPath *string `json:"itemsPath,omitempty"`

	// The path to an item property which defines the display name of the item.
	OperationID *string `json:"operationId,omitempty"`

	// Dictionary of
	Parameters map[string]*SwaggerCustomDynamicTreeParameter `json:"parameters,omitempty"`

	// The path to an item property which defines the display name of the item.
	SelectableFilter *string `json:"selectableFilter,omitempty"`
}

// SwaggerCustomDynamicTreeParameter - The swagger custom dynamic tree parameter.
type SwaggerCustomDynamicTreeParameter struct {
	// The parameter reference.
	ParameterReference *string `json:"parameterReference,omitempty"`

	// Indicates whether the parameter is required.
	Required *bool `json:"required,omitempty"`

	// Gets or sets a path to a property in the currently selected item to pass as a value to a parameter for the given operation.
	SelectedItemValuePath *string `json:"selectedItemValuePath,omitempty"`

	// The parameter value.
	Value interface{} `json:"value,omitempty"`
}

// SwaggerCustomDynamicTreeSettings - The swagger custom dynamic tree settings.
type SwaggerCustomDynamicTreeSettings struct {
	// Indicates whether leaf nodes can be selected.
	CanSelectLeafNodes *bool `json:"CanSelectLeafNodes,omitempty"`

	// Indicates whether parent nodes can be selected.
	CanSelectParentNodes *bool `json:"CanSelectParentNodes,omitempty"`
}

// SwaggerExternalDocumentation - The swagger external documentation
type SwaggerExternalDocumentation struct {
	// The document description.
	Description *string `json:"description,omitempty"`

	// The vendor extensions.
	Extensions map[string]interface{} `json:"extensions,omitempty"`

	// The documentation Uri.
	URI *string `json:"uri,omitempty"`
}

// SwaggerSchema - The swagger schema.
type SwaggerSchema struct {
	// The additional properties.
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`

	// The schemas which must pass validation when this schema is used.
	AllOf []*SwaggerSchema `json:"allOf,omitempty"`

	// The discriminator.
	Discriminator *string `json:"discriminator,omitempty"`

	// The dynamic list.
	DynamicListNew *SwaggerCustomDynamicList `json:"dynamicListNew,omitempty"`

	// The dynamic schema configuration.
	DynamicSchemaNew *SwaggerCustomDynamicProperties `json:"dynamicSchemaNew,omitempty"`

	// The dynamic schema configuration.
	DynamicSchemaOld *SwaggerCustomDynamicSchema `json:"dynamicSchemaOld,omitempty"`

	// The dynamic values tree configuration.
	DynamicTree *SwaggerCustomDynamicTree `json:"dynamicTree,omitempty"`

	// The example value.
	Example interface{} `json:"example,omitempty"`

	// The external documentation.
	ExternalDocs *SwaggerExternalDocumentation `json:"externalDocs,omitempty"`

	// The items schema.
	Items *SwaggerSchema `json:"items,omitempty"`

	// The maximum number of allowed properties.
	MaxProperties *int32 `json:"maxProperties,omitempty"`

	// The minimum number of allowed properties.
	MinProperties *int32 `json:"minProperties,omitempty"`

	// Indicates the notification url extension. If this is set, the property's value should be a callback url for a webhook.
	NotificationURLExtension *bool `json:"notificationUrlExtension,omitempty"`

	// The object properties
	Properties map[string]*SwaggerSchema `json:"properties,omitempty"`

	// Indicates whether this property must be present in the a request.
	ReadOnly *bool `json:"readOnly,omitempty"`

	// The reference.
	Ref *string `json:"ref,omitempty"`

	// The object required properties.
	Required []*string `json:"required,omitempty"`

	// The title.
	Title *string `json:"title,omitempty"`

	// The type
	Type *SwaggerSchemaType `json:"type,omitempty"`

	// The xml representation format for a property.
	XML *SwaggerXML `json:"xml,omitempty"`
}

// SwaggerXML - The Swagger XML.
type SwaggerXML struct {
	// Indicates whether the property should be an attribute instead of an element.
	Attribute *bool `json:"attribute,omitempty"`

	// The vendor extensions.
	Extensions map[string]interface{} `json:"extensions,omitempty"`

	// The xml element or attribute name.
	Name *string `json:"name,omitempty"`

	// The xml namespace.
	Namespace *string `json:"namespace,omitempty"`

	// The name prefix.
	Prefix *string `json:"prefix,omitempty"`

	// Indicates whether the array elements are wrapped in a container element.
	Wrapped *bool `json:"wrapped,omitempty"`
}

// TrackingEvent - The tracking event.
type TrackingEvent struct {
	// REQUIRED; The event level.
	EventLevel *EventLevel `json:"eventLevel,omitempty"`

	// REQUIRED; The event time.
	EventTime *time.Time `json:"eventTime,omitempty"`

	// REQUIRED; The record type.
	RecordType *TrackingRecordType `json:"recordType,omitempty"`

	// The error.
	Error *TrackingEventErrorInfo `json:"error,omitempty"`

	// The record.
	Record interface{} `json:"record,omitempty"`
}

// TrackingEventErrorInfo - The tracking event error info.
type TrackingEventErrorInfo struct {
	// The code.
	Code *string `json:"code,omitempty"`

	// The message.
	Message *string `json:"message,omitempty"`
}

// TrackingEventsDefinition - The tracking events definition.
type TrackingEventsDefinition struct {
	// REQUIRED; The events.
	Events []*TrackingEvent `json:"events,omitempty"`

	// REQUIRED; The source type.
	SourceType *string `json:"sourceType,omitempty"`

	// The track events options.
	TrackEventsOptions *TrackEventsOperationOptions `json:"trackEventsOptions,omitempty"`
}

// UserAssignedIdentity - User Assigned identity properties.
type UserAssignedIdentity struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// Workflow - The workflow type.
type Workflow struct {
	// Managed service identity properties.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The workflow properties.
	Properties *WorkflowProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowFilter - The workflow filter.
type WorkflowFilter struct {
	// The state of workflows.
	State *WorkflowState `json:"state,omitempty"`
}

// WorkflowListResult - The list of workflows.
type WorkflowListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of workflows.
	Value []*Workflow `json:"value,omitempty"`
}

// WorkflowOutputParameter - The workflow output parameter.
type WorkflowOutputParameter struct {
	// The description.
	Description *string `json:"description,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// The type.
	Type *ParameterType `json:"type,omitempty"`

	// The value.
	Value interface{} `json:"value,omitempty"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`
}

// WorkflowParameter - The workflow parameters.
type WorkflowParameter struct {
	// The description.
	Description *string `json:"description,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// The type.
	Type *ParameterType `json:"type,omitempty"`

	// The value.
	Value interface{} `json:"value,omitempty"`
}

// WorkflowProperties - The workflow properties.
type WorkflowProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration `json:"accessControl,omitempty"`

	// The definition.
	Definition interface{} `json:"definition,omitempty"`

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration `json:"endpointsConfiguration,omitempty"`

	// The integration account.
	IntegrationAccount *ResourceReference `json:"integrationAccount,omitempty"`

	// The integration service environment.
	IntegrationServiceEnvironment *ResourceReference `json:"integrationServiceEnvironment,omitempty"`

	// The parameters.
	Parameters map[string]*WorkflowParameter `json:"parameters,omitempty"`

	// The state.
	State *WorkflowState `json:"state,omitempty"`

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string `json:"accessEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The sku.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Gets the version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// WorkflowReference - The workflow reference.
type WorkflowReference struct {
	// The resource id.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRun - The workflow run.
type WorkflowRun struct {
	// The workflow run properties.
	Properties *WorkflowRunProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRunAction - The workflow run action.
type WorkflowRunAction struct {
	// The workflow run action properties.
	Properties *WorkflowRunActionProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run action name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run action type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRunActionFilter - The workflow run action filter.
type WorkflowRunActionFilter struct {
	// The status of workflow run action.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunActionListResult - The list of workflow run actions.
type WorkflowRunActionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow run actions.
	Value []*WorkflowRunAction `json:"value,omitempty"`
}

// WorkflowRunActionProperties - The workflow run action properties.
type WorkflowRunActionProperties struct {
	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// Gets the retry histories.
	RetryHistory []*RetryHistory `json:"retryHistory,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowRunActionRepetitionDefinition - The workflow run action repetition definition.
type WorkflowRunActionRepetitionDefinition struct {
	// REQUIRED; The workflow run action repetition properties definition.
	Properties *WorkflowRunActionRepetitionProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRunActionRepetitionDefinitionCollection - A collection of workflow run action repetitions.
type WorkflowRunActionRepetitionDefinitionCollection struct {
	// The link used to get the next page of recommendations.
	NextLink *string                                  `json:"nextLink,omitempty"`
	Value    []*WorkflowRunActionRepetitionDefinition `json:"value,omitempty"`
}

// WorkflowRunActionRepetitionProperties - The workflow run action repetition properties definition.
type WorkflowRunActionRepetitionProperties struct {
	// The workflow scope repetition code.
	Code *string `json:"code,omitempty"`

	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// The end time of the workflow scope repetition.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Anything
	Error          interface{} `json:"error,omitempty"`
	IterationCount *int32      `json:"iterationCount,omitempty"`

	// The repetition indexes.
	RepetitionIndexes []*RepetitionIndex `json:"repetitionIndexes,omitempty"`

	// Gets the retry histories.
	RetryHistory []*RetryHistory `json:"retryHistory,omitempty"`

	// The start time of the workflow scope repetition.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the workflow scope repetition.
	Status *WorkflowStatus `json:"status,omitempty"`

	// READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowRunActionRepetitionsClientGetOptions contains the optional parameters for the WorkflowRunActionRepetitionsClient.Get
// method.
type WorkflowRunActionRepetitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsClientListExpressionTracesOptions contains the optional parameters for the WorkflowRunActionRepetitionsClient.ListExpressionTraces
// method.
type WorkflowRunActionRepetitionsClientListExpressionTracesOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsClientListOptions contains the optional parameters for the WorkflowRunActionRepetitionsClient.List
// method.
type WorkflowRunActionRepetitionsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsRequestHistoriesClientGetOptions contains the optional parameters for the WorkflowRunActionRepetitionsRequestHistoriesClient.Get
// method.
type WorkflowRunActionRepetitionsRequestHistoriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsRequestHistoriesClientListOptions contains the optional parameters for the WorkflowRunActionRepetitionsRequestHistoriesClient.List
// method.
type WorkflowRunActionRepetitionsRequestHistoriesClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRequestHistoriesClientGetOptions contains the optional parameters for the WorkflowRunActionRequestHistoriesClient.Get
// method.
type WorkflowRunActionRequestHistoriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRequestHistoriesClientListOptions contains the optional parameters for the WorkflowRunActionRequestHistoriesClient.List
// method.
type WorkflowRunActionRequestHistoriesClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionScopeRepetitionsClientGetOptions contains the optional parameters for the WorkflowRunActionScopeRepetitionsClient.Get
// method.
type WorkflowRunActionScopeRepetitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionScopeRepetitionsClientListOptions contains the optional parameters for the WorkflowRunActionScopeRepetitionsClient.List
// method.
type WorkflowRunActionScopeRepetitionsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionsClientGetOptions contains the optional parameters for the WorkflowRunActionsClient.Get method.
type WorkflowRunActionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionsClientListExpressionTracesOptions contains the optional parameters for the WorkflowRunActionsClient.ListExpressionTraces
// method.
type WorkflowRunActionsClientListExpressionTracesOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionsClientListOptions contains the optional parameters for the WorkflowRunActionsClient.List method.
type WorkflowRunActionsClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: Status.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowRunFilter - The workflow run filter.
type WorkflowRunFilter struct {
	// The status of workflow run.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunListResult - The list of workflow runs.
type WorkflowRunListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow runs.
	Value []*WorkflowRun `json:"value,omitempty"`
}

// WorkflowRunOperationsClientGetOptions contains the optional parameters for the WorkflowRunOperationsClient.Get method.
type WorkflowRunOperationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunProperties - The workflow run properties.
type WorkflowRunProperties struct {
	// The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the correlation id.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs map[string]*WorkflowOutputParameter `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the response of the flow run.
	Response *WorkflowRunTrigger `json:"response,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the fired trigger.
	Trigger *WorkflowRunTrigger `json:"trigger,omitempty" azure:"ro"`

	// READ-ONLY; Gets the wait end time.
	WaitEndTime *time.Time `json:"waitEndTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reference to workflow version.
	Workflow *ResourceReference `json:"workflow,omitempty" azure:"ro"`
}

// WorkflowRunTrigger - The workflow run trigger.
type WorkflowRunTrigger struct {
	// The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the scheduled time.
	ScheduledTime *time.Time `json:"scheduledTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowRunsClientCancelOptions contains the optional parameters for the WorkflowRunsClient.Cancel method.
type WorkflowRunsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunsClientGetOptions contains the optional parameters for the WorkflowRunsClient.Get method.
type WorkflowRunsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunsClientListOptions contains the optional parameters for the WorkflowRunsClient.List method.
type WorkflowRunsClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: Status, StartTime, and ClientTrackingId.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowTrigger - The workflow trigger.
type WorkflowTrigger struct {
	// The workflow trigger properties.
	Properties *WorkflowTriggerProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowTriggerCallbackURL - The workflow trigger callback URL.
type WorkflowTriggerCallbackURL struct {
	// Gets the workflow trigger callback URL query parameters.
	Queries *WorkflowTriggerListCallbackURLQueries `json:"queries,omitempty"`

	// Gets the workflow trigger callback URL relative path parameters.
	RelativePathParameters []*string `json:"relativePathParameters,omitempty"`

	// READ-ONLY; Gets the workflow trigger callback URL base path.
	BasePath *string `json:"basePath,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger callback URL HTTP method.
	Method *string `json:"method,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger callback URL relative path.
	RelativePath *string `json:"relativePath,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger callback URL.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// WorkflowTriggerFilter - The workflow trigger filter.
type WorkflowTriggerFilter struct {
	// The state of workflow trigger.
	State *WorkflowState `json:"state,omitempty"`
}

// WorkflowTriggerHistoriesClientGetOptions contains the optional parameters for the WorkflowTriggerHistoriesClient.Get method.
type WorkflowTriggerHistoriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggerHistoriesClientListOptions contains the optional parameters for the WorkflowTriggerHistoriesClient.List
// method.
type WorkflowTriggerHistoriesClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: Status, StartTime, and ClientTrackingId.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowTriggerHistoriesClientResubmitOptions contains the optional parameters for the WorkflowTriggerHistoriesClient.Resubmit
// method.
type WorkflowTriggerHistoriesClientResubmitOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggerHistory - The workflow trigger history.
type WorkflowTriggerHistory struct {
	// Gets the workflow trigger history properties.
	Properties *WorkflowTriggerHistoryProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger history name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger history type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowTriggerHistoryFilter - The workflow trigger history filter.
type WorkflowTriggerHistoryFilter struct {
	// The status of workflow trigger history.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// WorkflowTriggerHistoryListResult - The list of workflow trigger histories.
type WorkflowTriggerHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow trigger histories.
	Value []*WorkflowTriggerHistory `json:"value,omitempty"`
}

// WorkflowTriggerHistoryProperties - The workflow trigger history properties.
type WorkflowTriggerHistoryProperties struct {
	// The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The value indicating whether trigger was fired.
	Fired *bool `json:"fired,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to input parameters.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to output parameters.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reference to workflow run.
	Run *ResourceReference `json:"run,omitempty" azure:"ro"`

	// READ-ONLY; The scheduled time.
	ScheduledTime *time.Time `json:"scheduledTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowTriggerListCallbackURLQueries - Gets the workflow trigger callback URL query parameters.
type WorkflowTriggerListCallbackURLQueries struct {
	// The api version.
	APIVersion *string `json:"api-version,omitempty"`

	// The SAS timestamp.
	Se *string `json:"se,omitempty"`

	// The SAS signature.
	Sig *string `json:"sig,omitempty"`

	// The SAS permissions.
	Sp *string `json:"sp,omitempty"`

	// The SAS version.
	Sv *string `json:"sv,omitempty"`
}

// WorkflowTriggerListResult - The list of workflow triggers.
type WorkflowTriggerListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow triggers.
	Value []*WorkflowTrigger `json:"value,omitempty"`
}

// WorkflowTriggerProperties - The workflow trigger properties.
type WorkflowTriggerProperties struct {
	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last execution time.
	LastExecutionTime *time.Time `json:"lastExecutionTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the next execution time.
	NextExecutionTime *time.Time `json:"nextExecutionTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowTriggerProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger recurrence.
	Recurrence *WorkflowTriggerRecurrence `json:"recurrence,omitempty" azure:"ro"`

	// READ-ONLY; Gets the state.
	State *WorkflowState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reference to workflow.
	Workflow *ResourceReference `json:"workflow,omitempty" azure:"ro"`
}

// WorkflowTriggerRecurrence - The workflow trigger recurrence.
type WorkflowTriggerRecurrence struct {
	// The end time.
	EndTime *string `json:"endTime,omitempty"`

	// The frequency.
	Frequency *RecurrenceFrequency `json:"frequency,omitempty"`

	// The interval.
	Interval *int32 `json:"interval,omitempty"`

	// The recurrence schedule.
	Schedule *RecurrenceSchedule `json:"schedule,omitempty"`

	// The start time.
	StartTime *string `json:"startTime,omitempty"`

	// The time zone.
	TimeZone *string `json:"timeZone,omitempty"`
}

// WorkflowTriggerReference - The workflow trigger reference.
type WorkflowTriggerReference struct {
	// The workflow name.
	FlowName *string `json:"flowName,omitempty"`

	// The resource id.
	ID *string `json:"id,omitempty"`

	// The workflow trigger name.
	TriggerName *string `json:"triggerName,omitempty"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowTriggersClientGetOptions contains the optional parameters for the WorkflowTriggersClient.Get method.
type WorkflowTriggersClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientGetSchemaJSONOptions contains the optional parameters for the WorkflowTriggersClient.GetSchemaJSON
// method.
type WorkflowTriggersClientGetSchemaJSONOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientListCallbackURLOptions contains the optional parameters for the WorkflowTriggersClient.ListCallbackURL
// method.
type WorkflowTriggersClientListCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientListOptions contains the optional parameters for the WorkflowTriggersClient.List method.
type WorkflowTriggersClientListOptions struct {
	// The filter to apply on the operation.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowTriggersClientResetOptions contains the optional parameters for the WorkflowTriggersClient.Reset method.
type WorkflowTriggersClientResetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientRunOptions contains the optional parameters for the WorkflowTriggersClient.Run method.
type WorkflowTriggersClientRunOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientSetStateOptions contains the optional parameters for the WorkflowTriggersClient.SetState method.
type WorkflowTriggersClientSetStateOptions struct {
	// placeholder for future optional parameters
}

// WorkflowVersion - The workflow version.
type WorkflowVersion struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The workflow version properties.
	Properties *WorkflowVersionProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowVersionListResult - The list of workflow versions.
type WorkflowVersionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow versions.
	Value []*WorkflowVersion `json:"value,omitempty"`
}

// WorkflowVersionProperties - The workflow version properties.
type WorkflowVersionProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration `json:"accessControl,omitempty"`

	// The definition.
	Definition interface{} `json:"definition,omitempty"`

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration `json:"endpointsConfiguration,omitempty"`

	// The integration account.
	IntegrationAccount *ResourceReference `json:"integrationAccount,omitempty"`

	// The parameters.
	Parameters map[string]*WorkflowParameter `json:"parameters,omitempty"`

	// The state.
	State *WorkflowState `json:"state,omitempty"`

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string `json:"accessEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The sku.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Gets the version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// WorkflowVersionTriggersClientListCallbackURLOptions contains the optional parameters for the WorkflowVersionTriggersClient.ListCallbackURL
// method.
type WorkflowVersionTriggersClientListCallbackURLOptions struct {
	// The callback URL parameters.
	Parameters *GetCallbackURLParameters
}

// WorkflowVersionsClientGetOptions contains the optional parameters for the WorkflowVersionsClient.Get method.
type WorkflowVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowVersionsClientListOptions contains the optional parameters for the WorkflowVersionsClient.List method.
type WorkflowVersionsClientListOptions struct {
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowsClientBeginMoveOptions contains the optional parameters for the WorkflowsClient.BeginMove method.
type WorkflowsClientBeginMoveOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkflowsClientCreateOrUpdateOptions contains the optional parameters for the WorkflowsClient.CreateOrUpdate method.
type WorkflowsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientDeleteOptions contains the optional parameters for the WorkflowsClient.Delete method.
type WorkflowsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientDisableOptions contains the optional parameters for the WorkflowsClient.Disable method.
type WorkflowsClientDisableOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientEnableOptions contains the optional parameters for the WorkflowsClient.Enable method.
type WorkflowsClientEnableOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientGenerateUpgradedDefinitionOptions contains the optional parameters for the WorkflowsClient.GenerateUpgradedDefinition
// method.
type WorkflowsClientGenerateUpgradedDefinitionOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientGetOptions contains the optional parameters for the WorkflowsClient.Get method.
type WorkflowsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientListByResourceGroupOptions contains the optional parameters for the WorkflowsClient.ListByResourceGroup
// method.
type WorkflowsClientListByResourceGroupOptions struct {
	// The filter to apply on the operation. Options for filters include: State, Trigger, and ReferencedResourceId.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowsClientListBySubscriptionOptions contains the optional parameters for the WorkflowsClient.ListBySubscription method.
type WorkflowsClientListBySubscriptionOptions struct {
	// The filter to apply on the operation. Options for filters include: State, Trigger, and ReferencedResourceId.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowsClientListCallbackURLOptions contains the optional parameters for the WorkflowsClient.ListCallbackURL method.
type WorkflowsClientListCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientListSwaggerOptions contains the optional parameters for the WorkflowsClient.ListSwagger method.
type WorkflowsClientListSwaggerOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientRegenerateAccessKeyOptions contains the optional parameters for the WorkflowsClient.RegenerateAccessKey
// method.
type WorkflowsClientRegenerateAccessKeyOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientUpdateOptions contains the optional parameters for the WorkflowsClient.Update method.
type WorkflowsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientValidateByLocationOptions contains the optional parameters for the WorkflowsClient.ValidateByLocation method.
type WorkflowsClientValidateByLocationOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientValidateByResourceGroupOptions contains the optional parameters for the WorkflowsClient.ValidateByResourceGroup
// method.
type WorkflowsClientValidateByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WsdlService - The WSDL service.
type WsdlService struct {
	// The list of endpoints' qualified names.
	EndpointQualifiedNames []*string `json:"EndpointQualifiedNames,omitempty"`

	// The qualified name.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// X12AcknowledgementSettings - The X12 agreement acknowledgement settings.
type X12AcknowledgementSettings struct {
	// REQUIRED; The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32 `json:"acknowledgementControlNumberLowerBound,omitempty"`

	// REQUIRED; The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32 `json:"acknowledgementControlNumberUpperBound,omitempty"`

	// REQUIRED; The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool `json:"batchFunctionalAcknowledgements,omitempty"`

	// REQUIRED; The value indicating whether to batch implementation acknowledgements.
	BatchImplementationAcknowledgements *bool `json:"batchImplementationAcknowledgements,omitempty"`

	// REQUIRED; The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool `json:"batchTechnicalAcknowledgements,omitempty"`

	// REQUIRED; The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool `json:"needFunctionalAcknowledgement,omitempty"`

	// REQUIRED; The value indicating whether implementation acknowledgement is needed.
	NeedImplementationAcknowledgement *bool `json:"needImplementationAcknowledgement,omitempty"`

	// REQUIRED; The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool `json:"needLoopForValidMessages,omitempty"`

	// REQUIRED; The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool `json:"needTechnicalAcknowledgement,omitempty"`

	// REQUIRED; The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool `json:"rolloverAcknowledgementControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool `json:"sendSynchronousAcknowledgement,omitempty"`

	// The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string `json:"acknowledgementControlNumberPrefix,omitempty"`

	// The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string `json:"acknowledgementControlNumberSuffix,omitempty"`

	// The functional acknowledgement version.
	FunctionalAcknowledgementVersion *string `json:"functionalAcknowledgementVersion,omitempty"`

	// The implementation acknowledgement version.
	ImplementationAcknowledgementVersion *string `json:"implementationAcknowledgementVersion,omitempty"`
}

// X12AgreementContent - The X12 agreement content.
type X12AgreementContent struct {
	// REQUIRED; The X12 one-way receive agreement.
	ReceiveAgreement *X12OneWayAgreement `json:"receiveAgreement,omitempty"`

	// REQUIRED; The X12 one-way send agreement.
	SendAgreement *X12OneWayAgreement `json:"sendAgreement,omitempty"`
}

// X12DelimiterOverrides - The X12 delimiter override settings.
type X12DelimiterOverrides struct {
	// REQUIRED; The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`

	// REQUIRED; The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`

	// REQUIRED; The replacement character.
	ReplaceCharacter *int32 `json:"replaceCharacter,omitempty"`

	// REQUIRED; The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool `json:"replaceSeparatorsInPayload,omitempty"`

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`

	// REQUIRED; The segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`

	// The message id.
	MessageID *string `json:"messageId,omitempty"`

	// The protocol version.
	ProtocolVersion *string `json:"protocolVersion,omitempty"`

	// The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// X12EnvelopeOverride - The X12 envelope override settings.
type X12EnvelopeOverride struct {
	// REQUIRED; The date format.
	DateFormat *X12DateFormat `json:"dateFormat,omitempty"`

	// REQUIRED; The header version.
	HeaderVersion *string `json:"headerVersion,omitempty"`

	// REQUIRED; The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`

	// REQUIRED; The protocol version on which this envelope settings has to be applied.
	ProtocolVersion *string `json:"protocolVersion,omitempty"`

	// REQUIRED; The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`

	// REQUIRED; The responsible agency code.
	ResponsibleAgencyCode *string `json:"responsibleAgencyCode,omitempty"`

	// REQUIRED; The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`

	// REQUIRED; The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`

	// REQUIRED; The time format.
	TimeFormat *X12TimeFormat `json:"timeFormat,omitempty"`

	// The functional identifier code.
	FunctionalIdentifierCode *string `json:"functionalIdentifierCode,omitempty"`
}

// X12EnvelopeSettings - The X12 agreement envelope settings.
type X12EnvelopeSettings struct {
	// REQUIRED; The controls standards id.
	ControlStandardsID *int32 `json:"controlStandardsId,omitempty"`

	// REQUIRED; The control version number.
	ControlVersionNumber *string `json:"controlVersionNumber,omitempty"`

	// REQUIRED; The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool `json:"enableDefaultGroupHeaders,omitempty"`

	// REQUIRED; The group control number lower bound.
	GroupControlNumberLowerBound *int32 `json:"groupControlNumberLowerBound,omitempty"`

	// REQUIRED; The group control number upper bound.
	GroupControlNumberUpperBound *int32 `json:"groupControlNumberUpperBound,omitempty"`

	// REQUIRED; The group header agency code.
	GroupHeaderAgencyCode *string `json:"groupHeaderAgencyCode,omitempty"`

	// REQUIRED; The group header date format.
	GroupHeaderDateFormat *X12DateFormat `json:"groupHeaderDateFormat,omitempty"`

	// REQUIRED; The group header time format.
	GroupHeaderTimeFormat *X12TimeFormat `json:"groupHeaderTimeFormat,omitempty"`

	// REQUIRED; The group header version.
	GroupHeaderVersion *string `json:"groupHeaderVersion,omitempty"`

	// REQUIRED; The interchange control number lower bound.
	InterchangeControlNumberLowerBound *int32 `json:"interchangeControlNumberLowerBound,omitempty"`

	// REQUIRED; The interchange control number upper bound.
	InterchangeControlNumberUpperBound *int32 `json:"interchangeControlNumberUpperBound,omitempty"`

	// REQUIRED; The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool `json:"overwriteExistingTransactionSetControlNumber,omitempty"`

	// REQUIRED; The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`

	// REQUIRED; The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool `json:"rolloverGroupControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool `json:"rolloverInterchangeControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool `json:"rolloverTransactionSetControlNumber,omitempty"`

	// REQUIRED; The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`

	// REQUIRED; The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int32 `json:"transactionSetControlNumberLowerBound,omitempty"`

	// REQUIRED; The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int32 `json:"transactionSetControlNumberUpperBound,omitempty"`

	// REQUIRED; The usage indicator.
	UsageIndicator *UsageIndicator `json:"usageIndicator,omitempty"`

	// REQUIRED; The value indicating whether to use control standards id as repetition character.
	UseControlStandardsIDAsRepetitionCharacter *bool `json:"useControlStandardsIdAsRepetitionCharacter,omitempty"`

	// The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`

	// The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string `json:"transactionSetControlNumberPrefix,omitempty"`

	// The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string `json:"transactionSetControlNumberSuffix,omitempty"`
}

// X12FramingSettings - The X12 agreement framing settings.
type X12FramingSettings struct {
	// REQUIRED; The X12 character set.
	CharacterSet *X12CharacterSet `json:"characterSet,omitempty"`

	// REQUIRED; The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`

	// REQUIRED; The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`

	// REQUIRED; The replacement character.
	ReplaceCharacter *int32 `json:"replaceCharacter,omitempty"`

	// REQUIRED; The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool `json:"replaceSeparatorsInPayload,omitempty"`

	// REQUIRED; The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`

	// REQUIRED; The segment terminator suffix.
	SegmentTerminatorSuffix *SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// X12MessageFilter - The X12 message filter for odata query.
type X12MessageFilter struct {
	// REQUIRED; The message filter type.
	MessageFilterType *MessageFilterType `json:"messageFilterType,omitempty"`
}

// X12MessageIdentifier - The X12 message identifier.
type X12MessageIdentifier struct {
	// REQUIRED; The message id.
	MessageID *string `json:"messageId,omitempty"`
}

// X12OneWayAgreement - The X12 one-way agreement.
type X12OneWayAgreement struct {
	// REQUIRED; The X12 protocol settings.
	ProtocolSettings *X12ProtocolSettings `json:"protocolSettings,omitempty"`

	// REQUIRED; The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`

	// REQUIRED; The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
}

// X12ProcessingSettings - The X12 processing settings.
type X12ProcessingSettings struct {
	// REQUIRED; The value indicating whether to convert numerical type to implied decimal.
	ConvertImpliedDecimal *bool `json:"convertImpliedDecimal,omitempty"`

	// REQUIRED; The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`

	// REQUIRED; The value indicating whether to mask security information.
	MaskSecurityInfo *bool `json:"maskSecurityInfo,omitempty"`

	// REQUIRED; The value indicating whether to preserve interchange.
	PreserveInterchange *bool `json:"preserveInterchange,omitempty"`

	// REQUIRED; The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool `json:"suspendInterchangeOnError,omitempty"`

	// REQUIRED; The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// X12ProtocolSettings - The X12 agreement protocol settings.
type X12ProtocolSettings struct {
	// REQUIRED; The X12 acknowledgment settings.
	AcknowledgementSettings *X12AcknowledgementSettings `json:"acknowledgementSettings,omitempty"`

	// REQUIRED; The X12 envelope settings.
	EnvelopeSettings *X12EnvelopeSettings `json:"envelopeSettings,omitempty"`

	// REQUIRED; The X12 framing settings.
	FramingSettings *X12FramingSettings `json:"framingSettings,omitempty"`

	// REQUIRED; The X12 message filter.
	MessageFilter *X12MessageFilter `json:"messageFilter,omitempty"`

	// REQUIRED; The X12 processing settings.
	ProcessingSettings *X12ProcessingSettings `json:"processingSettings,omitempty"`

	// REQUIRED; The X12 schema references.
	SchemaReferences []*X12SchemaReference `json:"schemaReferences,omitempty"`

	// REQUIRED; The X12 security settings.
	SecuritySettings *X12SecuritySettings `json:"securitySettings,omitempty"`

	// REQUIRED; The X12 validation settings.
	ValidationSettings *X12ValidationSettings `json:"validationSettings,omitempty"`

	// The X12 envelope override settings.
	EnvelopeOverrides []*X12EnvelopeOverride `json:"envelopeOverrides,omitempty"`

	// The X12 message filter list.
	MessageFilterList []*X12MessageIdentifier `json:"messageFilterList,omitempty"`

	// The X12 validation override settings.
	ValidationOverrides []*X12ValidationOverride `json:"validationOverrides,omitempty"`

	// The X12 delimiter override settings.
	X12DelimiterOverrides []*X12DelimiterOverrides `json:"x12DelimiterOverrides,omitempty"`
}

// X12SchemaReference - The X12 schema reference.
type X12SchemaReference struct {
	// REQUIRED; The message id.
	MessageID *string `json:"messageId,omitempty"`

	// REQUIRED; The schema name.
	SchemaName *string `json:"schemaName,omitempty"`

	// REQUIRED; The schema version.
	SchemaVersion *string `json:"schemaVersion,omitempty"`

	// The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
}

// X12SecuritySettings - The X12 agreement security settings.
type X12SecuritySettings struct {
	// REQUIRED; The authorization qualifier.
	AuthorizationQualifier *string `json:"authorizationQualifier,omitempty"`

	// REQUIRED; The security qualifier.
	SecurityQualifier *string `json:"securityQualifier,omitempty"`

	// The authorization value.
	AuthorizationValue *string `json:"authorizationValue,omitempty"`

	// The password value.
	PasswordValue *string `json:"passwordValue,omitempty"`
}

// X12ValidationOverride - The X12 validation override settings.
type X12ValidationOverride struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The message id on which the validation settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The value indicating whether to validate character Set.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`

	// REQUIRED; The value indicating whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`

	// REQUIRED; The value indicating whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
}

// X12ValidationSettings - The X12 agreement validation settings.
type X12ValidationSettings struct {
	// REQUIRED; The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool `json:"checkDuplicateGroupControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool `json:"checkDuplicateInterchangeControlNumber,omitempty"`

	// REQUIRED; The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool `json:"checkDuplicateTransactionSetControlNumber,omitempty"`

	// REQUIRED; The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32 `json:"interchangeControlNumberValidityDays,omitempty"`

	// REQUIRED; The trailing separator policy.
	TrailingSeparatorPolicy *TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`

	// REQUIRED; The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`

	// REQUIRED; The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`

	// REQUIRED; The value indicating whether to Whether to validate EDI types.
	ValidateEDITypes *bool `json:"validateEDITypes,omitempty"`

	// REQUIRED; The value indicating whether to Whether to validate XSD types.
	ValidateXSDTypes *bool `json:"validateXSDTypes,omitempty"`
}
