## Fontbakery report

Fontbakery version: 0.7.1

<details>
<summary><b>[31] Family checks</b></summary>
<details>
<summary>🔥 <b>FAIL:</b> Check font has a license.</summary>

* [com.google.fonts/check/family/has_license](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/has_license)
* 🔥 **FAIL** No license file was found. Please add an OFL.txt or a LICENSE.txt file. If you are running fontbakery on a Google Fonts upstream repo, which is fine, just make sure there is a temporary license file in the same folder. [code: no-license]

</details>
<details>
<summary>ℹ <b>INFO:</b> Do we have the latest version of FontBakery installed?</summary>

* [com.google.fonts/check/fontbakery_version](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fontbakery_version)
* ℹ **INFO** fontbakery (0.7.1)  - Well designed Font QA tool, written in Python 3
  INSTALLED: 0.7.1 (latest)

* 🍞 **PASS** Font Bakery is up-to-date

</details>
<details>
<summary>🍞 <b>PASS:</b> Fonts have equal numbers of glyphs?</summary>

* [com.google.fonts/check/family/equal_numbers_of_glyphs](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/equal_numbers_of_glyphs)
* 🍞 **PASS** All font files in this family have an equal total ammount of glyphs.

</details>
<details>
<summary>🍞 <b>PASS:</b> Fonts have equal glyph names?</summary>

* [com.google.fonts/check/family/equal_glyph_names](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/equal_glyph_names)
* 🍞 **PASS** All font files have identical glyph names.

</details>
<details>
<summary>🍞 <b>PASS:</b> All tabular figures must have the same width across the RIBBI-family.</summary>

* [com.google.fonts/check/family/tnum_horizontal_metrics](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/tnum_horizontal_metrics)
* 🍞 **PASS** OK

</details>
<details>
<summary>🍞 <b>PASS:</b> Does font file include unacceptable control character glyphs?</summary>

* [com.google.fonts/check/family/control_chars](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/control_chars)
* 🍞 **PASS** Unacceptable control characters were not identified.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking all files are in the same directory.</summary>

* [com.google.fonts/check/family/single_directory](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/single_directory)
* 🍞 **PASS** All files are in the same directory.

</details>
<details>
<summary>🍞 <b>PASS:</b> Is the command `ftxvalidator` (Apple Font Tool Suite) available?</summary>

* [com.google.fonts/check/ftxvalidator_is_available](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/ftxvalidator_is_available)
* 🍞 **PASS** ftxvalidator is available.

</details>
<details>
<summary>🍞 <b>PASS:</b> Fonts have equal unicode encodings?</summary>

* [com.google.fonts/check/family/equal_unicode_encodings](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/equal_unicode_encodings)
* 🍞 **PASS** Fonts have equal unicode encodings.

</details>
<details>
<summary>🍞 <b>PASS:</b> Make sure all font files have the same version value.</summary>

* [com.google.fonts/check/family/equal_font_versions](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/equal_font_versions)
* 🍞 **PASS** All font files have the same version.

</details>
<details>
<summary>🍞 <b>PASS:</b> Fonts have consistent PANOSE proportion?</summary>

* [com.google.fonts/check/family/panose_proportion](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/panose_proportion)
* 🍞 **PASS** Fonts have consistent PANOSE proportion.

</details>
<details>
<summary>🍞 <b>PASS:</b> Fonts have consistent PANOSE family type?</summary>

* [com.google.fonts/check/family/panose_familytype](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/panose_familytype)
* 🍞 **PASS** Fonts have consistent PANOSE family type.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check that OS/2.fsSelection bold & italic settings are unique for each NameID1</summary>

* [com.adobe.fonts/check/family/bold_italic_unique_for_nameid1](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/family/bold_italic_unique_for_nameid1)
* 🍞 **PASS** The OS/2.fsSelection bold & italic settings were unique within each compatible family group.

</details>
<details>
<summary>🍞 <b>PASS:</b> Fonts have consistent underline thickness?</summary>

* [com.google.fonts/check/family/underline_thickness](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/underline_thickness)
* 🍞 **PASS** Fonts have consistent underline thickness.

</details>
<details>
<summary>🍞 <b>PASS:</b> Verify that each group of fonts with the same nameID 1 has maximum of 4 fonts</summary>

* [com.adobe.fonts/check/family/max_4_fonts_per_family_name](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/family/max_4_fonts_per_family_name)
* 🍞 **PASS** There were no more than 4 fonts per family name.

</details>
<details>
<summary>💤 <b>SKIP:</b> Does DESCRIPTION file contain broken links?</summary>

* [com.google.fonts/check/description/broken_links](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/description/broken_links)
* 💤 **SKIP** Unfulfilled Conditions: description

</details>
<details>
<summary>💤 <b>SKIP:</b> Is this a proper HTML snippet?</summary>

* [com.google.fonts/check/description/valid_html](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/description/valid_html)
* 💤 **SKIP** Unfulfilled Conditions: descfile

</details>
<details>
<summary>💤 <b>SKIP:</b> DESCRIPTION.en_us.html must have more than 200 bytes.</summary>

* [com.google.fonts/check/description/min_length](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/description/min_length)
* 💤 **SKIP** Unfulfilled Conditions: description

</details>
<details>
<summary>💤 <b>SKIP:</b> DESCRIPTION.en_us.html must have less than 1000 bytes.</summary>

* [com.google.fonts/check/description/max_length](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/description/max_length)
* 💤 **SKIP** Unfulfilled Conditions: description

</details>
<details>
<summary>💤 <b>SKIP:</b> Check METADATA.pb parse correctly. </summary>

* [com.google.fonts/check/metadata/parses](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/parses)
* 💤 **SKIP** Font family at 'static' lacks a METADATA.pb file.

</details>
<details>
<summary>💤 <b>SKIP:</b> Font designer field in METADATA.pb must not be 'unknown'.</summary>

* [com.google.fonts/check/metadata/unknown_designer](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/unknown_designer)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Fontfamily is listed on Google Fonts API?</summary>

* [com.google.fonts/check/metadata/listed_on_gfonts](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/listed_on_gfonts)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: check if fonts field only has unique "full_name" values.</summary>

* [com.google.fonts/check/metadata/unique_full_name_values](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/unique_full_name_values)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: check if fonts field only contains unique style:weight pairs.</summary>

* [com.google.fonts/check/metadata/unique_weight_style_pairs](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/unique_weight_style_pairs)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb license is "APACHE2", "UFL" or "OFL"?</summary>

* [com.google.fonts/check/metadata/license](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/license)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb should contain at least "menu" and "latin" subsets.</summary>

* [com.google.fonts/check/metadata/menu_and_latin](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/menu_and_latin)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb subsets should be alphabetically ordered.</summary>

* [com.google.fonts/check/metadata/subsets_order](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/subsets_order)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Copyright notice is the same in all fonts?</summary>

* [com.google.fonts/check/metadata/copyright](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/copyright)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> Check that METADATA.pb family values are all the same.</summary>

* [com.google.fonts/check/metadata/familyname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/familyname)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: According Google Fonts standards, families should have a Regular style.</summary>

* [com.google.fonts/check/metadata/has_regular](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/has_regular)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Regular should be 400.</summary>

* [com.google.fonts/check/metadata/regular_is_400](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/regular_is_400)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata, has_regular_style

</details>
<br>
</details>
<details>
<summary><b>[122] FiraCode-Regular.ttf</b></summary>
<details>
<summary>🔥 <b>FAIL:</b> Copyright notices match canonical pattern in fonts</summary>

* [com.google.fonts/check/font_copyright](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/font_copyright)
* 🔥 **FAIL** Name Table entry: Copyright notices should match a pattern similar to: 'Copyright 2017 The Familyname Project Authors (git url)'
But instead we have got: 'Copyright 2012-2015 The Fira Code Project Authors (https://github.com/tonsky/FiraCode)'

</details>
<details>
<summary>🔥 <b>FAIL:</b> PPEM must be an integer on hinted fonts.</summary>

* [com.google.fonts/check/integer_ppem_if_hinted](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/integer_ppem_if_hinted)
* 🔥 **FAIL** This is a hinted font, so it must have bit 3 set on the flags of the head table, so that PPEM values will be rounded into and integer value.

</details>
<details>
<summary>🔥 <b>FAIL:</b> Glyph names are all valid?</summary>

* [com.google.fonts/check/valid_glyphnames](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/valid_glyphnames)
* 🔥 **FAIL** The following glyph names do not comply with naming conventions: ['numbersign_numbersign_numbersign.liga', 'numbersign_numbersign_numbersign_numbersign.liga', 'numbersign_underscore_parenleft.liga', 'quadrantUpperLeftAndLowerLeftAndLowerRight', 'quadrantUpperLeftAndUpperRightAndLowerLeft', 'quadrantUpperLeftAndUpperRightAndLowerRight', 'quadrantUpperRightAndLowerLeftAndLowerRight', 'whiteSquareWithUpperLeftQuadrant', 'whiteSquareWithLowerLeftQuadrant', 'whiteSquareWithLowerRightQuadrant', 'whiteSquareWithUpperRightQuadrant', 'asciitilde_asciitilde_greater.liga'] A glyph name may be up to 31 characters in length, must be entirely comprised of characters from the following set: A-Z a-z 0-9 .(period) _(underscore). and must not start with a digit or period. There are a few exceptions such as the special character ".notdef". The glyph names "twocents", "a1", and "_" are all valid, while "2cents" and ".twocents" are not.

</details>
<details>
<summary>⚠ <b>WARN:</b> Checking OS/2 achVendID.</summary>

* [com.google.fonts/check/vendor_id](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/vendor_id)
* ⚠ **WARN** OS/2 VendorID value 'CTDB' is not a known registered id. You should set it to your own 4 character code, and register that code with Microsoft at https://www.microsoft.com/typography/links/vendorlist.aspx [code: unknown]

</details>
<details>
<summary>⚠ <b>WARN:</b> Check if each glyph has the recommended amount of contours.</summary>

* [com.google.fonts/check/contour_count](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/contour_count)
* ⚠ **WARN** This check inspects the glyph outlines and detects the total number of contours in each of them. The expected values are infered from the typical ammounts of contours observed in a large collection of reference font families. The divergences listed below may simply indicate a significantly different design on some of your glyphs. On the other hand, some of these may flag actual bugs in the font such as glyphs mapped to an incorrect codepoint. Please consider reviewing the design and codepoint assignment of these to make sure they are correct.

The following glyphs do not have the recommended number of contours:

Glyph name: uniE000	Contours detected: 5	Expected: 1
Glyph name: aogonek	Contours detected: 3	Expected: 2
Glyph name: eogonek	Contours detected: 3	Expected: 2
Glyph name: Eng	Contours detected: 2	Expected: 1
Glyph name: Uogonek	Contours detected: 2	Expected: 1
Glyph name: uogonek	Contours detected: 2	Expected: 1
Glyph name: Kappa	Contours detected: 2	Expected: 1
Glyph name: kappa	Contours detected: 2	Expected: 1
Glyph name: uni03CF	Contours detected: 2	Expected: 1
Glyph name: uni040F	Contours detected: 2	Expected: 1
Glyph name: uni0426	Contours detected: 2	Expected: 1
Glyph name: uni0429	Contours detected: 2	Expected: 1
Glyph name: uni0446	Contours detected: 2	Expected: 1
Glyph name: uni0449	Contours detected: 2	Expected: 1
Glyph name: uni04C7	Contours detected: 2	Expected: 1
Glyph name: uni04C8	Contours detected: 2	Expected: 1
Glyph name: uni04FE	Contours detected: 2	Expected: 1
Glyph name: uni0524	Contours detected: 2	Expected: 1
Glyph name: uni0525	Contours detected: 2	Expected: 1
Glyph name: uni0527	Contours detected: 2	Expected: 1
Glyph name: uni0528	Contours detected: 2	Expected: 1
Glyph name: uni0529	Contours detected: 2	Expected: 1
Glyph name: uni2552	Contours detected: 1	Expected: 2
Glyph name: uni2553	Contours detected: 1	Expected: 2
Glyph name: uni2555	Contours detected: 1	Expected: 2
Glyph name: uni2556	Contours detected: 1	Expected: 2
Glyph name: uni2558	Contours detected: 1	Expected: 2
Glyph name: uni2559	Contours detected: 1	Expected: 2
Glyph name: uni255B	Contours detected: 1	Expected: 2
Glyph name: uni255C	Contours detected: 1	Expected: 2
Glyph name: uni255E	Contours detected: 1	Expected: 2
Glyph name: uni2561	Contours detected: 1	Expected: 2
Glyph name: ltshade	Contours detected: 60	Expected: 46
Glyph name: shade	Contours detected: 91	Expected: 85
Glyph name: dkshade	Contours detected: 46	Expected: 73
Glyph name: trademark	Contours detected: 1	Expected: 2
Glyph name: uni2158	Contours detected: 3	Expected: 4

</details>
<details>
<summary>⚠ <b>WARN:</b> Checking correctness of monospaced metadata.</summary>

* [com.google.fonts/check/monospace](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/monospace)
* ⚠ **WARN** Font is monospaced but 26 glyphs (1.5643802647412757%) have a different width. You should check the widths of: ['uni200B', 'uniFEFF', 'uni0308', 'uni0307', 'gravecomb', 'acutecomb', 'uni030B', 'uni0302', 'uni030C', 'uni0306', 'uni030A', 'tildecomb', 'uni0304', 'uni0305', 'uni030F', 'uni0313', 'uni0314', 'uni0326', 'uni0327', 'uni0342', 'uni0345', 'null', '_part.numbersign', 'uniE000', 'uniE001', 'uniE002'] [code: mono-outliers]

</details>
<details>
<summary>⚠ <b>WARN:</b> Monospace font has hhea.advanceWidthMax equal to each glyph's advanceWidth?</summary>

* [com.google.fonts/check/monospace_max_advancewidth](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/monospace_max_advancewidth)
* ⚠ **WARN** This seems to be a monospaced font, so advanceWidth value should be the same across all glyphs, but 99.88% of them have a different value: A, Aacute, Abreve, Acircumflex, Adieresis, Agrave, Amacron, Aogonek, Aring, Atilde, AE, AEacute, B, C, Cacute, Ccaron, Ccedilla, Ccircumflex, Cdotaccent, D, Eth, Dcaron, Dcroat, E, Eacute, Ebreve, Ecaron, Ecircumflex, Edieresis, Edotaccent, Egrave, Emacron, Eogonek, F, G, Gbreve, Gcircumflex, uni0122, Gdotaccent, H, Hbar, Hcircumflex, I, IJ, Iacute, Ibreve, Icircumflex, Idieresis, Idotaccent, Igrave, Imacron, Iogonek, Itilde, J, Jcircumflex, K, uni0136, L, Lacute, Lcaron, uni013B, Ldot, Lslash, M, N, Nacute, Ncaron, uni0145, Eng, Ntilde, O, Oacute, Obreve, Ocircumflex, Odieresis, Ograve, Ohungarumlaut, Omacron, Oslash, Oslashacute, Otilde, OE, P, Thorn, Q, R, Racute, Rcaron, uni0156, S, Sacute, Scaron, Scedilla, Scircumflex, uni0218, T, Tbar, Tcaron, uni0162, uni021A, U, Uacute, Ubreve, Ucircumflex, Udieresis, Ugrave, Uhungarumlaut, Umacron, Uogonek, Uring, Utilde, V, W, Wacute, Wcircumflex, Wdieresis, Wgrave, X, Y, Yacute, Ycircumflex, Ydieresis, Ygrave, Z, Zacute, Zcaron, Zdotaccent, Cacute.loclPLK, Nacute.loclPLK, Oacute.loclPLK, Sacute.loclPLK, Zacute.loclPLK, a, aacute, abreve, acircumflex, adieresis, agrave, amacron, aogonek, aring, atilde, ae, aeacute, b, c, cacute, ccaron, ccedilla, ccircumflex, cdotaccent, d, eth, dcaron, dcroat, e, eacute, ebreve, ecaron, ecircumflex, edieresis, edotaccent, egrave, emacron, eogonek, f, g, gbreve, gcircumflex, uni0123, gdotaccent, h, hbar, hcircumflex, i, dotlessi, iacute, ibreve, icircumflex, idieresis, i.loclTRK, igrave, ij, imacron, iogonek, itilde, j, uni0237, jcircumflex, k, uni0137, kgreenlandic, l, lacute, lcaron, uni013C, ldot, lslash, m, n, nacute, napostrophe, ncaron, uni0146, eng, ntilde, o, oacute, obreve, ocircumflex, odieresis, ograve, ohungarumlaut, omacron, oslash, oslashacute, otilde, oe, p, thorn, q, r, racute, rcaron, uni0157, s, sacute, scaron, scedilla, scircumflex, uni0219, germandbls, t, tbar, tcaron, uni0163, uni021B, u, uacute, ubreve, ucircumflex, udieresis, ugrave, uhungarumlaut, umacron, uogonek, uring, utilde, v, w, wacute, wcircumflex, wdieresis, wgrave, x, y, yacute, ycircumflex, ydieresis, ygrave, z, zacute, zcaron, zdotaccent, cacute.loclPLK, nacute.loclPLK, oacute.loclPLK, sacute.loclPLK, zacute.loclPLK, x.multiply, r.ss01, w_w_w.liga, ordfeminine, ordmasculine, uni207F, uni052C, uni052A, uni052E, uni0528, uni0410, uni0411, uni0412, uni0413, uni0403, uni0490, uni0414, uni0415, uni0400, uni0401, uni0416, uni0417, uni0418, uni0419, uni040D, uni048A, uni041A, uni040C, uni041B, uni041C, uni041D, uni041E, uni041F, uni0420, uni0421, uni0422, uni0423, uni040E, uni0424, uni0425, uni0427, uni0426, uni0428, uni0429, uni040F, uni042C, uni042A, uni042B, uni0409, uni040A, uni0405, uni0404, uni042D, uni0406, uni0407, uni0408, uni040B, uni042E, uni042F, uni0402, uni0460, uni0462, uni0464, uni0466, uni0468, uni046A, uni046C, uni046E, uni0470, uni0472, uni0474, uni0476, uni0478, uni0492, uni0494, uni0496, uni0498, uni049A, uni049C, uni049E, uni04A0, uni04A2, uni04A4, uni04A6, uni0524, uni04A8, uni04AA, uni04AC, Ustraitcy, Ustraitstrokecy, uni04B2, uni04B4, uni04B6, uni04B8, uni04BA, uni0526, uni04BC, uni04BE, uni04C0, uni04C1, uni04C3, uni04C5, uni04C7, uni04C9, uni04CB, uni04CD, uni04D0, uni04D2, uni04D4, uni04D6, uni04D8, uni04DA, uni04DC, uni04DE, uni04E0, uni04E2, uni04E4, uni04E6, uni04E8, uni04EA, uni04EC, uni04EE, uni04F0, uni04F2, uni04F4, uni04F6, uni04F8, uni04FA, uni04FC, uni04FE, uni0500, uni0502, uni0504, uni0506, uni0508, uni050A, uni050C, uni050E, uni0510, uni0512, uni0514, uni0516, uni0518, uni051A, uni051C, uni051E, uni0520, uni0522, uni048C, uni048E, uni0430, uni0431, uni0432, uni0433, uni0453, uni0491, uni0434, uni0435, uni0450, uni0451, uni0436, uni0437, uni0438, uni0439, uni045D, uni048B, uni043A, uni045C, uni043B, uni043C, uni043D, uni043E, uni043F, uni0440, uni0441, uni0442, uni0443, uni045E, uni0444, uni0445, uni0447, uni0446, uni0448, uni0449, uni045F, uni044C, uni044A, uni044B, uni0459, uni045A, uni0455, uni0454, uni044D, uni0456, uni0457, uni0458, uni045B, uni044E, uni044F, uni0452, uni0461, uni0463, uni0465, uni0467, uni0469, uni046B, uni046D, uni046F, uni0471, uni0473, uni0475, uni0477, uni0479, uni0493, uni0495, uni0497, uni0499, uni049B, uni049D, uni049F, uni04A1, uni04A3, uni04A5, uni0525, uni04A7, uni04A9, uni04AB, uni04AD, ustraitcy, ustraitstrokecy, uni04B3, uni04B5, uni04B7, uni04B9, uni04BB, uni0527, uni04BD, uni04BF, uni04CF, uni04C2, uni04C4, uni04C6, uni04C8, uni04CA, uni04CC, uni04CE, uni04D1, uni04D3, uni04D5, uni04D7, uni04D9, uni04DB, uni04DD, uni04DF, uni04E1, uni04E3, uni04E5, uni04E7, uni04E9, uni04EB, uni04ED, uni04EF, uni04F1, uni04F3, uni04F5, uni04F7, uni04F9, uni04FB, uni04FD, uni04FF, uni0501, uni0503, uni0505, uni0507, uni0509, uni050B, uni050D, uni050F, uni0511, uni0513, uni0515, uni0517, uni0519, uni051B, uni051D, uni051F, uni0521, uni0523, uni048D, uni048F, uni052D, uni052B, uni052F, uni0529, Yotgreek, Alpha, Beta, Gamma, uni0394, Epsilon, Zeta, Eta, Theta, Iota, Kappa, Lambda, Mu, Nu, Xi, Omicron, Pi, Rho, Sigma, Tau, Upsilon, Phi, Chi, Psi, uni03A9, Alphatonos, Epsilontonos, Etatonos, Iotatonos, Omicrontonos, Upsilontonos, Omegatonos, Iotadieresis, Upsilondieresis, uni0370, uni0372, uni0376, uni03D8, uni03DA, uni03DC, uni03DE, uni03E0, uni03CF, uni03D2, uni03D3, uni03D4, uni03F4, uni03F7, uni03F9, uni03FA, uni03FD, uni03FE, uni03FF, uni1F08, uni1F09, uni1F0A, uni1F0B, uni1F0C, uni1F0D, uni1F0E, uni1F0F, uni1FBA, uni1FBB, uni1FB8, uni1FB9, uni1FBC, uni1F88, uni1F89, uni1F8A, uni1F8B, uni1F8C, uni1F8D, uni1F8E, uni1F8F, uni1F18, uni1F19, uni1F1A, uni1F1B, uni1F1C, uni1F1D, uni1FC8, uni1FC9, uni1F28, uni1F29, uni1F2A, uni1F2B, uni1F2C, uni1F2D, uni1F2E, uni1F2F, uni1FCA, uni1FCB, uni1FCC, uni1F98, uni1F99, uni1F9A, uni1F9B, uni1F9C, uni1F9D, uni1F9E, uni1F9F, uni1F38, uni1F39, uni1F3A, uni1F3B, uni1F3C, uni1F3D, uni1F3E, uni1F3F, uni1FDA, uni1FDB, uni1FD8, uni1FD9, uni1F48, uni1F49, uni1F4A, uni1F4B, uni1F4C, uni1F4D, uni1FF8, uni1FF9, uni1FEC, uni1F59, uni1F5B, uni1F5D, uni1F5F, uni1FEA, uni1FEB, uni1FE8, uni1FE9, uni1F68, uni1F69, uni1F6A, uni1F6B, uni1F6C, uni1F6D, uni1F6E, uni1F6F, uni1FFA, uni1FFB, uni1FFC, uni1FA8, uni1FA9, uni1FAA, uni1FAB, uni1FAC, uni1FAD, uni1FAE, uni1FAF, alpha, beta, gamma, delta, epsilon, zeta, eta, theta, iota, kappa, lambda, uni03BC, nu, xi, omicron, pi, rho, uni03C2, sigma, tau, upsilon, phi, chi, psi, omega, iotatonos, iotadieresis, iotadieresistonos, upsilontonos, upsilondieresis, upsilondieresistonos, omicrontonos, omegatonos, alphatonos, epsilontonos, etatonos, uni0371, uni0373, uni0377, reversedlunatesigmasymbol, dottedlunatesigmasymbol, reverseddottedlunatesigmasymbol, uni03D9, uni03DB, uni03DD, uni03DF, uni03E1, uni03D7, uni03D0, uni03D1, uni03D5, uni03D6, uni03F0, uni03F1, uni03F2, uni03F3, uni03F5, uni03F8, uni03FB, uni03FC, uni1F00, uni1F01, uni1F02, uni1F03, uni1F04, uni1F05, uni1F06, uni1F07, uni1F70, uni1F71, uni1FB6, uni1FB0, uni1FB1, uni1FB3, uni1FB2, uni1FB4, uni1F80, uni1F81, uni1F82, uni1F83, uni1F84, uni1F85, uni1F86, uni1F87, uni1FB7, uni1F10, uni1F11, uni1F12, uni1F13, uni1F14, uni1F15, uni1F72, uni1F73, uni1F20, uni1F21, uni1F22, uni1F23, uni1F24, uni1F25, uni1F26, uni1F27, uni1F74, uni1F75, uni1FC6, uni1FC3, uni1FC2, uni1FC4, uni1F90, uni1F91, uni1F92, uni1F93, uni1F94, uni1F95, uni1F96, uni1F97, uni1FC7, uni1F30, uni1F31, uni1F32, uni1F33, uni1F34, uni1F35, uni1F36, uni1F37, uni1F76, uni1F77, uni1FD6, uni1FD0, uni1FD1, uni1FD2, uni1FD3, uni1FD7, uni1F40, uni1F41, uni1F42, uni1F43, uni1F44, uni1F45, uni1F78, uni1F79, uni1FE4, uni1FE5, uni1F50, uni1F51, uni1F52, uni1F53, uni1F54, uni1F55, uni1F56, uni1F57, uni1F7A, uni1F7B, uni1FE6, uni1FE0, uni1FE1, uni1FE2, uni1FE3, uni1FE7, uni1F60, uni1F61, uni1F62, uni1F63, uni1F64, uni1F65, uni1F66, uni1F67, uni1F7C, uni1F7D, uni1FF6, uni1FF3, uni1FF2, uni1FF4, uni1FA0, uni1FA1, uni1FA2, uni1FA3, uni1FA4, uni1FA5, uni1FA6, uni1FA7, uni1FF7, uni1FBE, uni037A, zero, one, two, three, four, five, six, seven, eight, nine, zero.tosf, one.tosf, two.tosf, three.tosf, four.tosf, five.tosf, six.tosf, seven.tosf, eight.tosf, nine.tosf, zero.tosf.zero, zero.zero, uni2080, uni2081, uni2082, uni2083, uni2084, uni2085, uni2086, uni2087, uni2088, uni2089, zero.dnom, one.dnom, two.dnom, three.dnom, four.dnom, five.dnom, six.dnom, seven.dnom, eight.dnom, nine.dnom, zero.numr, one.numr, two.numr, three.numr, four.numr, five.numr, six.numr, seven.numr, eight.numr, nine.numr, uni2070, uni00B9, uni00B2, uni00B3, uni2074, uni2075, uni2076, uni2077, uni2078, uni2079, fraction, uni215F, onehalf, uni2153, uni2154, onequarter, threequarters, uni2155, uni2156, uni2157, uni2158, uni2159, uni215A, oneeighth, threeeighths, fiveeighths, seveneighths, asterisk, backslash, periodcentered, bullet, colon, comma, ellipsis, exclam, exclamdown, numbersign, period, question, questiondown, quotedbl, quotesingle, semicolon, slash, uni204A, underscore, underscoredbl, exclamdown.case, questiondown.case, asterisk.lc, numbersign.tosf, colon.uc, uni208D, uni208E, braceleft, braceright, bracketleft, bracketright, parenleft, parenright, uni207D, uni207E, braceleft.case, braceright.case, bracketleft.case, bracketright.case, parenleft.case, parenright.case, parenleft.dnom, parenright.dnom, parenleft.numr, parenright.numr, uni2015, emdash, endash, figuredash, hyphen, uni00AD, emdash.case, endash.case, hyphen.case, uni00AD.case, hyphen.lc, figuredash.tosf, guillemotleft, guillemotright, guilsinglleft, guilsinglright, quotedblbase, quotedblleft, quotedblright, quoteleft, quoteright, quotesinglbase, guillemotleft.case, guillemotright.case, guilsinglleft.case, guilsinglright.case, asterisk_asterisk.liga, asterisk_asterisk_asterisk.liga, asterisk_greater.liga, asterisk_slash.liga, braceleft_bar.liga, bracketleft_bar.liga, bracketright_numbersign.liga, colon_colon.liga, colon_colon_colon.liga, colon_colon_equal.liga, colon_equal.liga, colon_greater.liga, colon_less.liga, exclam_exclam.liga, exclam_exclam_period.liga, exclam_equal.liga, exclam_equal_equal.liga, hyphen_bar.liga, hyphen_hyphen.liga, hyphen_hyphen_hyphen.liga, hyphen_hyphen_greater.liga, hyphen_greater.liga, hyphen_greater_greater.liga, hyphen_less.liga, hyphen_less_less.liga, hyphen_asciitilde.liga, numbersign_braceleft.liga, numbersign_bracketleft.liga, numbersign_colon.liga, numbersign_exclam.liga, numbersign_numbersign.liga, numbersign_numbersign_numbersign.liga, numbersign_numbersign_numbersign_numbersign.liga, numbersign_equal.liga, numbersign_parenleft.liga, numbersign_question.liga, numbersign_underscore.liga, numbersign_underscore_parenleft.liga, period_hyphen.liga, period_equal.liga, period_period.liga, period_period_equal.liga, period_period_less.liga, period_period_period.liga, period_question.liga, question_colon.liga, question_equal.liga, question_period.liga, question_question.liga, semicolon_semicolon.liga, slash_asterisk.liga, slash_equal.liga, slash_equal_equal.liga, slash_greater.liga, slash_slash.liga, slash_slash_slash.liga, underscore_bar_underscore.liga, underscore_underscore.liga, numbersign_colon.liga_rem, anoteleia, uni037E, uni2007, uni2008, space, uni00A0, uni200B, space.frac, uni2007.tf, uni2007.tosf, CR, uniFEFF, cent, currency, dollar, uni20AF, Euro, florin, uni20BA, uni20BD, uni20B9, sterling, yen, cent.tosf, currency.tosf, dollar.tosf, uni20AF.tosf, Euro.tosf, uni20BA.tosf, uni20BD.tosf, uni20B9.tosf, sterling.tosf, yen.tosf, uni2219, uni2215, equalsinferior, uni207C, equivalence, integralbt, integraltp, uni208B, uni207B, plus, minus, multiply, divide, equal, notequal, greater, less, greaterequal, lessequal, plusminus, approxequal, asciitilde, logicalnot, infinity, intersection, integral, uni2206, product, summation, radical, uni00B5, partialdiff, percent, perthousand, uni208A, uni207A, revlogicalnot, infinity.case, plus.dnom, minus.dnom, equal.dnom, plus.lc, plus.numr, minus.numr, equal.numr, plus.tosf, minus.tosf, multiply.tosf, divide.tosf, equal.tosf, notequal.tosf, greater.tosf, less.tosf, greaterequal.tosf, lessequal.tosf, plusminus.tosf, approxequal.tosf, asciitilde.tosf, logicalnot.tosf, infinity.tosf, integral.tosf, product.tosf, summation.tosf, radical.tosf, partialdiff.tosf, percent.tosf, perthousand.tosf, arrowup, uni2197, arrowright, uni2198, arrowdown, uni2199, arrowleft, uni2196, arrowboth, arrowupdown, uni21E7, uni21E8, uni21E9, uni21E6, uni2B06, uni2B07, uni2B05, blackRightArrow, uni2581, uni2582, uni2583, downBlock, uni2585, uni2586, uni2587, block, upBlock, uni2594, uni258F, uni258E, uni258D, lfblock, uni258B, uni258A, uni2589, rtblock, uni2595, quadrantLowerLeft, quadrantLowerRight, quadrantUpperLeft, quadrantUpperLeftAndLowerLeftAndLowerRight, quadrantUpperLeftAndLowerRight, quadrantUpperLeftAndUpperRightAndLowerLeft, quadrantUpperLeftAndUpperRightAndLowerRight, quadrantUpperRight, quadrantUpperRightAndLowerLeft, quadrantUpperRightAndLowerLeftAndLowerRight, ltshade, shade, dkshade, uni25CF, circle, uni25EF, uni25D0, uni25D1, uni25D2, uni25D3, uni25D6, uni25D7, uni25D5, uni25F4, uni25F5, uni25F6, uni25F7, uni25C9, uni25CE, invcircle, uni25DA, uni25DB, uni25E0, uni25E1, uni25DC, uni25DD, uni25DE, uni25DF, uni25C6, uni25C7, lozenge, uni25AE, filledrect, uni25AD, uni25AF, uni250C, uni2514, uni2510, uni2518, uni253C, uni252C, uni2534, uni251C, uni2524, uni2500, uni2502, uni2561, uni2562, uni2556, uni2555, uni2563, uni2551, uni2557, uni255D, uni255C, uni255B, uni255E, uni255F, uni255A, uni2554, uni2569, uni2566, uni2560, uni2550, uni256C, uni2567, uni2568, uni2564, uni2565, uni2559, uni2558, uni2552, uni2553, uni256B, uni256A, filledbox, uni25A1, whiteSquareWithRoundedCorners, uni25A3, uni25AA, uni25AB, uni25E7, uni25E8, uni25E9, uni25EA, uni25EB, whiteSquareWithUpperLeftQuadrant, whiteSquareWithLowerLeftQuadrant, whiteSquareWithLowerRightQuadrant, whiteSquareWithUpperRightQuadrant, triagupTriangle, uni25B6, triangledown, uni25C0, triangleright, triaglf, blackUpperRightTriangle, blackLowerRightTriangle, blackLowerLeftTriangle, blackUpperLeftTriangle, uni2530, uni2512, uni2527, uni250E, uni251F, uni2541, uni252F, uni2511, uni2529, uni250D, uni2521, uni2547, uni254D, uni254F, uni257B, uni2533, uni2513, uni250F, uni2501, uni2578, uni257E, uni257A, uni2579, uni253B, uni251B, uni257F, uni2517, uni2503, uni254B, uni252B, uni2523, uni2545, uni252D, uni2535, uni253D, uni2532, uni253A, uni254A, uni2543, uni2573, uni2572, uni2571, uni254C, uni254E, uni2577, uni2574, uni257C, uni2576, uni2575, uni257D, uni2546, uni252E, uni2536, uni253E, uni2531, uni2539, uni2549, uni2544, uni2540, uni2538, uni2526, uni251A, uni251E, uni2516, uni2548, uni2537, uni252A, uni2519, uni2522, uni2515, uni2542, uni2528, uni2520, uni253F, uni2525, uni251D, lozenge.tosf, uni2610, uni2611, uni2612, uni2620, uni2639, smileface, invsmileface, sun, female, male, spade, club, heart, diamond, musicalnote, musicalnotedbl, uni2713, at, ampersand, paragraph, section, copyright, registered, trademark, degree, bar, brokenbar, uni2113, dagger, daggerdbl, estimated, uni2116, asciicircum, globeWithMeridians, house, uni21EA, uni2327, uni232B, uni2326, uni2328, uni23CE, uni218B, uni218A, section.tosf, degree.tosf, dagger.tosf, daggerdbl.tosf, ampersand_ampersand.liga, bar_bar.liga, bar_bar_bar_greater.liga, bar_bar_equal.liga, bar_bar_greater.liga, bar_braceright.liga, bar_bracketright.liga, bar_hyphen.liga, bar_equal.liga, bar_greater.liga, asciicircum_equal.liga, dollar_greater.liga, plus_plus.liga, plus_plus_plus.liga, plus_greater.liga, equal_colon_equal.liga, equal_exclam_equal.liga, equal_equal.liga, equal_equal_equal.liga, equal_equal_greater.liga, equal_greater.liga, equal_greater_greater.liga, equal_less_less.liga, equal_slash_equal.liga, greater_colon.liga, greater_hyphen.liga, greater_hyphen_greater.liga, greater_equal.liga, greater_equal_greater.liga, greater_greater.liga, greater_greater_hyphen.liga, greater_greater_equal.liga, greater_greater_greater.liga, less_asterisk.liga, less_asterisk_greater.liga, less_bar.liga, less_bar_bar.liga, less_bar_bar_bar.liga, less_bar_greater.liga, less_colon.liga, less_dollar.liga, less_dollar_greater.liga, less_exclam_hyphen_hyphen.liga, less_hyphen.liga, less_hyphen_hyphen.liga, less_hyphen_greater.liga, less_hyphen_less.liga, less_plus.liga, less_plus_greater.liga, less_equal.liga, less_equal_equal.liga, less_equal_equal_greater.liga, less_equal_greater.liga, less_equal_less.liga, less_greater.liga, less_less.liga, less_less_hyphen.liga, less_less_equal.liga, less_less_less.liga, less_asciitilde.liga, less_asciitilde_greater.liga, less_asciitilde_asciitilde.liga, less_slash.liga, less_slash_greater.liga, asciitilde_at.liga, asciitilde_hyphen.liga, asciitilde_equal.liga, asciitilde_greater.liga, asciitilde_asciitilde.liga, asciitilde_asciitilde_greater.liga, percent_percent.liga, uni03F6, uni0374, uni0375, uni0308, uni0307, gravecomb, acutecomb, uni030B, uni0302, uni030C, uni0306, uni030A, tildecomb, uni0304, uni0305, uni030F, uni0313, uni0314, uni0326, uni0327, strokeshortoverlay, strokelongoverlay, uni0326.case, uni02BC, uni02BA, uni02C9, uni02B9, acute, breve, caron, cedilla, circumflex, dieresis, dotaccent, grave, hungarumlaut, macron, ogonek, ring, tilde, caron.alt, acute.case, breve.case, caron.case, cedilla.case, circumflex.case, dieresis.case, dotaccent.case, grave.case, hungarumlaut.case, macron.case, ring.case, tilde.case, acute.loclPLK, acute.case.loclPLK, ogonek.thin, uni0342, uni0345, tonos, tonos.case, dieresistonos, uni1FBF, uni1FBD, uni1FFE, uni1FCD, uni1FDD, uni1FCE, uni1FDE, uni1FCF, uni1FDF, uni1FED, uni1FEE, uni1FC1, uni1FEF, uni1FFD, uni1FC0, uni1FEF.case, uni1FFD.case, LIG, TseHelpercy, tsehelpercy, descRoundcy, descStraightcy, descStraightcy.case, brevecy, brevecy.case, null, dieresisacutecomb, dieresisgravecomb, descTailcy.case, KsicyHELPER, hookHELPER, hookHELPER.case, ksicyHELPER, dieresistilde, _part.greater, _part.question, _part.ampersand, _part.less2, _part.greater2, _part.asterisk, _part.plus, _part.dot, uniE000, uniE001, uniE002, uniE003, uniE0A0, uniE0A1, uniE0A2, uniE0B0, uniE0B1, uniE0B2, uniE0B3 [code: should-be-monospaced]
* ⚠ **WARN** Double-width and/or zero-width glyphs were detected. These glyphs should be set to the same width as all others and then add GPOS single pos lookups that zeros/doubles the widths as needed: uni200B, uniFEFF, uni0308, uni0307, gravecomb, acutecomb, uni030B, uni0302, uni030C, uni0306, uni030A, tildecomb, uni0304, uni0305, uni030F, uni0313, uni0314, uni0326, uni0327, uni0342, uni0345, null, uniE000, uniE001, uniE002 [code: variable-monospaced]

</details>
<details>
<summary>⚠ <b>WARN:</b> Does GPOS table have kerning information?</summary>

* [com.google.fonts/check/gpos_kerning_info](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/gpos_kerning_info)
* ⚠ **WARN** GPOS table lacks kerning information.

</details>
<details>
<summary>💤 <b>SKIP:</b> Check copyright namerecords match license file.</summary>

* [com.google.fonts/check/name/license](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/license)
* 💤 **SKIP** Unfulfilled Conditions: license

</details>
<details>
<summary>💤 <b>SKIP:</b> Checks METADATA.pb font.name field matches family name declared on the name table.</summary>

* [com.google.fonts/check/metadata/nameid/family_name](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/nameid/family_name)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> Checks METADATA.pb font.post_script_name matches postscript name declared on the name table.</summary>

* [com.google.fonts/check/metadata/nameid/post_script_name](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/nameid/post_script_name)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.full_name value matches fullname declared on the name table?</summary>

* [com.google.fonts/check/metadata/nameid/full_name](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/nameid/full_name)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.name value should be same as the family name declared on the name table.</summary>

* [com.google.fonts/check/metadata/nameid/font_name](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/nameid/font_name)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.full_name and font.post_script_name fields have equivalent values ?</summary>

* [com.google.fonts/check/metadata/match_fullname_postscript](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/match_fullname_postscript)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.filename and font.post_script_name fields have equivalent values?</summary>

* [com.google.fonts/check/metadata/match_filename_postscript](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/match_filename_postscript)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.name field contains font name in right format?</summary>

* [com.google.fonts/check/metadata/valid_name_values](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/valid_name_values)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.full_name field contains font name in right format?</summary>

* [com.google.fonts/check/metadata/valid_full_name_values](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/valid_full_name_values)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.filename field contains font name in right format?</summary>

* [com.google.fonts/check/metadata/valid_filename_values](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/valid_filename_values)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.post_script_name field contains font name in right format?</summary>

* [com.google.fonts/check/metadata/valid_post_script_name_values](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/valid_post_script_name_values)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> Copyright notices match canonical pattern in METADATA.pb</summary>

* [com.google.fonts/check/metadata/valid_copyright](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/valid_copyright)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> Copyright notice on METADATA.pb should not contain 'Reserved Font Name'.</summary>

* [com.google.fonts/check/metadata/reserved_font_name](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/reserved_font_name)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Copyright notice shouldn't exceed 500 chars.</summary>

* [com.google.fonts/check/metadata/copyright_max_length](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/copyright_max_length)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Filename is set canonically?</summary>

* [com.google.fonts/check/metadata/canonical_filename](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/canonical_filename)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata, canonical_filename

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.style "italic" matches font internals?</summary>

* [com.google.fonts/check/metadata/italic_style](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/italic_style)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.style "normal" matches font internals?</summary>

* [com.google.fonts/check/metadata/normal_style](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/normal_style)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb font.name and font.full_name fields match the values declared on the name table?</summary>

* [com.google.fonts/check/metadata/nameid/family_and_full_names](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/nameid/family_and_full_names)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Check if fontname is not camel cased.</summary>

* [com.google.fonts/check/metadata/fontname_not_camel_cased](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/fontname_not_camel_cased)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Check font name is the same as family name.</summary>

* [com.google.fonts/check/metadata/match_name_familyname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/match_name_familyname)
* 💤 **SKIP** Unfulfilled Conditions: family_metadata, font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Check that font weight has a canonical value.</summary>

* [com.google.fonts/check/metadata/canonical_weight_value](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/canonical_weight_value)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> Checking OS/2 usWeightClass matches weight specified at METADATA.pb.</summary>

* [com.google.fonts/check/metadata/os2_weightclass](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/os2_weightclass)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb weight matches postScriptName.</summary>

* [com.google.fonts/check/metadata/match_weight_postscript](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/match_weight_postscript)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> METADATA.pb: Font styles are named canonically?</summary>

* [com.google.fonts/check/metatada/canonical_style_names](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metatada/canonical_style_names)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> Version number has increased since previous release on Google Fonts?</summary>

* [com.google.fonts/check/version_bump](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/version_bump)
* 💤 **SKIP** Unfulfilled Conditions: api_gfonts_ttFont, github_gfonts_ttFont

</details>
<details>
<summary>💤 <b>SKIP:</b> Glyphs are similiar to Google Fonts version?</summary>

* [com.google.fonts/check/production_glyphs_similarity](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/production_glyphs_similarity)
* 💤 **SKIP** Unfulfilled Conditions: api_gfonts_ttFont

</details>
<details>
<summary>💤 <b>SKIP:</b> Check font has same encoded glyphs as version hosted on fonts.google.com</summary>

* [com.google.fonts/check/production_encoded_glyphs](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/production_encoded_glyphs)
* 💤 **SKIP** Unfulfilled Conditions: api_gfonts_ttFont

</details>
<details>
<summary>💤 <b>SKIP:</b> Copyright field for this font on METADATA.pb matches all copyright notice entries on the name table ?</summary>

* [com.google.fonts/check/metadata/nameid/copyright](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/metadata/nameid/copyright)
* 💤 **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>💤 <b>SKIP:</b> Check a static ttf can be generated from a variable font. </summary>

* [com.google.fonts/check/varfont/generate_static](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/generate_static)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font

</details>
<details>
<summary>💤 <b>SKIP:</b> Check that variable fonts have an HVAR table. </summary>

* [com.google.fonts/check/varfont/has_HVAR](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/has_HVAR)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font

</details>
<details>
<summary>💤 <b>SKIP:</b> All name entries referenced by fvar instances exist on the name table?</summary>

* [com.google.fonts/check/fvar_name_entries](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fvar_name_entries)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font

</details>
<details>
<summary>💤 <b>SKIP:</b> A variable font must have named instances.</summary>

* [com.google.fonts/check/varfont_has_instances](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont_has_instances)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font

</details>
<details>
<summary>💤 <b>SKIP:</b> Variable font weight coordinates must be multiples of 100.</summary>

* [com.google.fonts/check/varfont_weight_instances](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont_weight_instances)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font

</details>
<details>
<summary>💤 <b>SKIP:</b> Are there caret positions declared for every ligature?</summary>

* [com.google.fonts/check/ligature_carets](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/ligature_carets)
* 💤 **SKIP** Unfulfilled Conditions: ligature_glyphs

</details>
<details>
<summary>💤 <b>SKIP:</b> Is there kerning info for non-ligated sequences?</summary>

* [com.google.fonts/check/kerning_for_non_ligated_sequences](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/kerning_for_non_ligated_sequences)
* 💤 **SKIP** Unfulfilled Conditions: ligatures, has_kerning_info

</details>
<details>
<summary>💤 <b>SKIP:</b> FontForge validation outputs error messages?</summary>

* [com.google.fonts/check/fontforge_stderr](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fontforge_stderr)
* 💤 **SKIP** Unfulfilled Conditions: fontforge_check_results

</details>
<details>
<summary>💤 <b>SKIP:</b> FontForge checks.</summary>

* [com.google.fonts/check/fontforge](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fontforge)
* 💤 **SKIP** Unfulfilled Conditions: fontforge_check_results

</details>
<details>
<summary>💤 <b>SKIP:</b> Is the CFF subr/gsubr call depth > 10?</summary>

* [com.adobe.fonts/check/cff_call_depth](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/cff_call_depth)
* 💤 **SKIP** Unfulfilled Conditions: is_cff

</details>
<details>
<summary>💤 <b>SKIP:</b> Is the CFF2 subr/gsubr call depth > 10?</summary>

* [com.adobe.fonts/check/cff2_call_depth](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/cff2_call_depth)
* 💤 **SKIP** Unfulfilled Conditions: is_cff2

</details>
<details>
<summary>💤 <b>SKIP:</b> CFF table FontName must match name table ID 6 (PostScript name).</summary>

* [com.adobe.fonts/check/name/postscript_vs_cff](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/name/postscript_vs_cff)
* 💤 **SKIP** Unfulfilled Conditions: is_cff

</details>
<details>
<summary>💤 <b>SKIP:</b> The variable font 'wght' (Weight) axis coordinate must be 400 on the 'Regular' instance.</summary>

* [com.google.fonts/check/varfont/regular_wght_coord](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/regular_wght_coord)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font, regular_wght_coord

</details>
<details>
<summary>💤 <b>SKIP:</b> The variable font 'wdth' (Width) axis coordinate must be 100 on the 'Regular' instance.</summary>

* [com.google.fonts/check/varfont/regular_wdth_coord](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/regular_wdth_coord)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font, regular_wdth_coord

</details>
<details>
<summary>💤 <b>SKIP:</b> The variable font 'slnt' (Slant) axis coordinate must be zero on the 'Regular' instance.</summary>

* [com.google.fonts/check/varfont/regular_slnt_coord](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/regular_slnt_coord)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font, regular_slnt_coord

</details>
<details>
<summary>💤 <b>SKIP:</b> The variable font 'ital' (Italic) axis coordinate must be zero on the 'Regular' instance.</summary>

* [com.google.fonts/check/varfont/regular_ital_coord](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/regular_ital_coord)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font, regular_ital_coord

</details>
<details>
<summary>💤 <b>SKIP:</b> The variable font 'opsz' (Optical Size) axis coordinate should be between 9 and 13 on the 'Regular' instance.</summary>

* [com.google.fonts/check/varfont/regular_opsz_coord](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/regular_opsz_coord)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font, regular_opsz_coord

</details>
<details>
<summary>💤 <b>SKIP:</b> The variable font 'wght' (Weight) axis coordinate must be 700 on the 'Bold' instance.</summary>

* [com.google.fonts/check/varfont/bold_wght_coord](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/varfont/bold_wght_coord)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font, bold_wght_coord

</details>
<details>
<summary>💤 <b>SKIP:</b> The variable font 'wght' (Weight) axis coordinate must be within spec range of 1 to 1000 on all instances.</summary>

* [com.google.fonts/check/wght_valid_range](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/wght_valid_range)
* 💤 **SKIP** Unfulfilled Conditions: is_variable_font

</details>
<details>
<summary>ℹ <b>INFO:</b> Show hinting filesize impact.</summary>

* [com.google.fonts/check/hinting_impact](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/hinting_impact)
* ℹ **INFO** Hinting filesize impact:

|  | static/FiraCode-Regular.ttf |
|:--- | ---:|
| Dehinted Size | 160.0kb |
| Hinted Size | 216.6kb |
| Increase | 56.6kb |
| Change   | 35.3 % |


</details>
<details>
<summary>ℹ <b>INFO:</b> EPAR table present in font?</summary>

* [com.google.fonts/check/epar](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/epar)
* ℹ **INFO** EPAR table not present in font. To learn more see https://github.com/googlefonts/fontbakery/issues/818

</details>
<details>
<summary>ℹ <b>INFO:</b> Is 'gasp' table set to optimize rendering?</summary>

* [com.google.fonts/check/gasp](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/gasp)
* ℹ **INFO** These are the ppm ranges declared on the gasp table:

PPM <= 65535:
	flag = 0x0F
	- Use gridfitting
	- Use grayscale rendering
	- Use gridfitting with ClearType symmetric smoothing
	- Use smoothing along multiple axes with ClearType®

* 🍞 **PASS** 'gasp' table is correctly set, with one gaspRange:value of 0xFFFF:0x0F.

</details>
<details>
<summary>ℹ <b>INFO:</b> Check for font-v versioning </summary>

* [com.google.fonts/check/fontv](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fontv)
* ℹ **INFO** Version string is: "Version 1.207; ttfautohint (v1.8.2) -l 8 -r 50 -G 200 -x 14 -D latn -f none -a nnn -X """
The version string must ideally include a git commit hash and either a 'dev' or a 'release' suffix such as in the example below:
"Version 1.3; git-0d08353-release"

</details>
<details>
<summary>ℹ <b>INFO:</b> Font contains all required tables?</summary>

* [com.google.fonts/check/required_tables](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/required_tables)
* ℹ **INFO** This font contains the following optional tables [prep, DSIG, gasp, GSUB, fpgm, loca, cvt , GPOS]
* 🍞 **PASS** Font contains all required tables.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking file is named canonically.</summary>

* [com.google.fonts/check/canonical_filename](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/canonical_filename)
* 🍞 **PASS** static/FiraCode-Regular.ttf is named canonically.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking OS/2 fsType.</summary>

* [com.google.fonts/check/fstype](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fstype)
* 🍞 **PASS** OS/2 fsType is properly set to zero.

</details>
<details>
<summary>🍞 <b>PASS:</b> Substitute copyright, registered and trademark symbols in name table entries.</summary>

* [com.google.fonts/check/name/unwanted_chars](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/unwanted_chars)
* 🍞 **PASS** No need to substitute copyright, registered and trademark symbols in name table entries of this font.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking OS/2 usWeightClass.</summary>

* [com.google.fonts/check/usweightclass](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/usweightclass)
* 🍞 **PASS** OS/2 usWeightClass value looks good!

</details>
<details>
<summary>🍞 <b>PASS:</b> "License URL matches License text on name table?</summary>

* [com.google.fonts/check/name/license_url](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/license_url)
* 🍞 **PASS** Font has a valid license URL in NAME table.

</details>
<details>
<summary>🍞 <b>PASS:</b> Description strings in the name table must not exceed 200 characters.</summary>

* [com.google.fonts/check/name/description_max_length](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/description_max_length)
* 🍞 **PASS** All description name records have reasonably small lengths.

</details>
<details>
<summary>🍞 <b>PASS:</b> Version format is correct in 'name' table?</summary>

* [com.google.fonts/check/name/version_format](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/version_format)
* 🍞 **PASS** Version format in NAME table entries is correct.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font has ttfautohint params? </summary>

* [com.google.fonts/check/has_ttfautohint_params](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/has_ttfautohint_params)
* 🍞 **PASS** Font has ttfautohint params (-l 8 -r 50 -G 200 -x 14 -D latn -f none -a nnn -X "")

</details>
<details>
<summary>🍞 <b>PASS:</b> Font has old ttfautohint applied?</summary>

* [com.google.fonts/check/old_ttfautohint](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/old_ttfautohint)
* 🍞 **PASS** ttfautohint available in the system (1.8.2) is older than the one used in the font (1.8.2).

</details>
<details>
<summary>🍞 <b>PASS:</b> Make sure family name does not begin with a digit.</summary>

* [com.google.fonts/check/name/familyname_first_char](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/familyname_first_char)
* 🍞 **PASS** Font family name first character is not a digit.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font has all expected currency sign characters?</summary>

* [com.google.fonts/check/currency_chars](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/currency_chars)
* 🍞 **PASS** Font has all expected currency sign characters.

</details>
<details>
<summary>🍞 <b>PASS:</b> Are there non-ASCII characters in ASCII-only NAME table entries?</summary>

* [com.google.fonts/check/name/ascii_only_entries](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/ascii_only_entries)
* 🍞 **PASS** None of the ASCII-only NAME table entries contain non-ASCII characteres.

</details>
<details>
<summary>🍞 <b>PASS:</b> Stricter unitsPerEm criteria for Google Fonts. </summary>

* [com.google.fonts/check/unitsperem_strict](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/unitsperem_strict)
* 🍞 **PASS** Font em size is good (unitsPerEm = 2000).

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking OS/2 fsSelection value.</summary>

* [com.google.fonts/check/fsselection](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fsselection)
* 🍞 **PASS** OS/2 fsSelection REGULAR bit is properly set.
* 🍞 **PASS** OS/2 fsSelection ITALIC bit is properly set.
* 🍞 **PASS** OS/2 fsSelection BOLD bit is properly set.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking post.italicAngle value.</summary>

* [com.google.fonts/check/italic_angle](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/italic_angle)
* 🍞 **PASS** Value of post.italicAngle is 0.0 with style='Regular'.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking head.macStyle value.</summary>

* [com.google.fonts/check/mac_style](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/mac_style)
* 🍞 **PASS** head macStyle ITALIC bit is properly set.
* 🍞 **PASS** head macStyle BOLD bit is properly set.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font has all mandatory 'name' table entries ?</summary>

* [com.google.fonts/check/name/mandatory_entries](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/mandatory_entries)
* 🍞 **PASS** Font contains values for all mandatory name table entries.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check name table: FONT_FAMILY_NAME entries. </summary>

* [com.google.fonts/check/name/familyname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/familyname)
* 🍞 **PASS** FONT_FAMILY_NAME entries are all good.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check name table: FONT_SUBFAMILY_NAME entries. </summary>

* [com.google.fonts/check/name/subfamilyname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/subfamilyname)
* 🍞 **PASS** FONT_SUBFAMILY_NAME entries are all good.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check name table: FULL_FONT_NAME entries. </summary>

* [com.google.fonts/check/name/fullfontname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/fullfontname)
* 🍞 **PASS** FULL_FONT_NAME entries are all good.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check name table: POSTSCRIPT_NAME entries. </summary>

* [com.google.fonts/check/name/postscriptname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/postscriptname)
* 🍞 **PASS** POSTCRIPT_NAME entries are all good.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check name table: TYPOGRAPHIC_FAMILY_NAME entries. </summary>

* [com.google.fonts/check/name/typographicfamilyname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/typographicfamilyname)
* 🍞 **PASS** TYPOGRAPHIC_FAMILY_NAME entries are all good.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check name table: TYPOGRAPHIC_SUBFAMILY_NAME entries. </summary>

* [com.google.fonts/check/name/typographicsubfamilyname](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/typographicsubfamilyname)
* 🍞 **PASS** TYPOGRAPHIC_SUBFAMILY_NAME entries are all good.

</details>
<details>
<summary>🍞 <b>PASS:</b> Length of copyright notice must not exceed 500 characters. </summary>

* [com.google.fonts/check/name/copyright_length](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/copyright_length)
* 🍞 **PASS** All copyright notice name entries on the 'name' table are shorter than 500 characters.

</details>
<details>
<summary>🍞 <b>PASS:</b> Familyname must be unique according to namecheck.fontdata.com </summary>

* [com.google.fonts/check/fontdata_namecheck](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/fontdata_namecheck)
* 🍞 **PASS** Font familyname seems to be unique.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font enables smart dropout control in "prep" table instructions?</summary>

* [com.google.fonts/check/smart_dropout](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/smart_dropout)
* 🍞 **PASS** 'prep' table contains instructions enabling smart dropout control.

</details>
<details>
<summary>🍞 <b>PASS:</b> There must not be VTT Talk sources in the font.</summary>

* [com.google.fonts/check/vttclean](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/vttclean)
* 🍞 **PASS** There are no tables with VTT Talk sources embedded in the font.

</details>
<details>
<summary>🍞 <b>PASS:</b> Are there unwanted Apple tables?</summary>

* [com.google.fonts/check/aat](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/aat)
* 🍞 **PASS** There are no unwanted AAT tables.

</details>
<details>
<summary>🍞 <b>PASS:</b> Combined length of family and style must not exceed 20 characters.</summary>

* [com.google.fonts/check/name/family_and_style_max_length](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/family_and_style_max_length)
* 🍞 **PASS** All name entries are good.

</details>
<details>
<summary>🍞 <b>PASS:</b> Name table records must not have trailing spaces.</summary>

* [com.google.fonts/check/name/trailing_spaces](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/trailing_spaces)
* 🍞 **PASS** No trailing spaces on name table entries.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking OS/2 usWinAscent & usWinDescent.</summary>

* [com.google.fonts/check/family/win_ascent_and_descent](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family/win_ascent_and_descent)
* 🍞 **PASS** OS/2 usWinAscent & usWinDescent values look good!

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking OS/2 Metrics match hhea Metrics.</summary>

* [com.google.fonts/check/os2_metrics_match_hhea](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/os2_metrics_match_hhea)
* 🍞 **PASS** OS/2.sTypoAscender/Descender values match hhea.ascent/descent.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking with ftxvalidator.</summary>

* [com.google.fonts/check/ftxvalidator](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/ftxvalidator)
* 🍞 **PASS** ftxvalidator passed this file

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking with ots-sanitize.</summary>

* [com.google.fonts/check/ots](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/ots)
* 🍞 **PASS** ots-sanitize passed this file

</details>
<details>
<summary>🍞 <b>PASS:</b> Font contains .notdef as first glyph?</summary>

* [com.google.fonts/check/mandatory_glyphs](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/mandatory_glyphs)
* 🍞 **PASS** Font contains the .notdef glyph as the first glyph, it does not have a Unicode value assigned and contains a drawing.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font contains glyphs for whitespace characters?</summary>

* [com.google.fonts/check/whitespace_glyphs](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/whitespace_glyphs)
* 🍞 **PASS** Font contains glyphs for whitespace characters.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font has **proper** whitespace glyph names?</summary>

* [com.google.fonts/check/whitespace_glyphnames](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/whitespace_glyphnames)
* 🍞 **PASS** Font has **proper** whitespace glyph names.

</details>
<details>
<summary>🍞 <b>PASS:</b> Whitespace glyphs have ink?</summary>

* [com.google.fonts/check/whitespace_ink](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/whitespace_ink)
* 🍞 **PASS** There is no whitespace glyph with ink.

</details>
<details>
<summary>🍞 <b>PASS:</b> Are there unwanted tables?</summary>

* [com.google.fonts/check/unwanted_tables](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/unwanted_tables)
* 🍞 **PASS** There are no unwanted tables.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font contains unique glyph names?</summary>

* [com.google.fonts/check/unique_glyphnames](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/unique_glyphnames)
* 🍞 **PASS** Font contains unique glyph names.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking with fontTools.ttx</summary>

* [com.google.fonts/check/ttx-roundtrip](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/ttx-roundtrip)
* 🍞 **PASS** Hey! It all looks good!

</details>
<details>
<summary>🍞 <b>PASS:</b> Check all glyphs have codepoints assigned.</summary>

* [com.google.fonts/check/all_glyphs_have_codepoints](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/all_glyphs_have_codepoints)
* 🍞 **PASS** All glyphs have a codepoint value assigned.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking unitsPerEm value is reasonable.</summary>

* [com.google.fonts/check/unitsperem](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/unitsperem)
* 🍞 **PASS** unitsPerEm value (2000) on the 'head' table is reasonable.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking font version fields (head and name table).</summary>

* [com.google.fonts/check/font_version](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/font_version)
* 🍞 **PASS** All font version fields match.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check if OS/2 xAvgCharWidth is correct.</summary>

* [com.google.fonts/check/xavgcharwidth](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/xavgcharwidth)
* 🍞 **PASS** OS/2 xAvgCharWidth value is correct.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check if OS/2 fsSelection matches head macStyle bold and italic bits.</summary>

* [com.adobe.fonts/check/fsselection_matches_macstyle](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/fsselection_matches_macstyle)
* 🍞 **PASS** The OS/2.fsSelection and head.macStyle bold and italic settings match.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font has correct post table version (2 for TTF, 3 for OTF)?</summary>

* [com.google.fonts/check/post_table_version](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/post_table_version)
* 🍞 **PASS** Font has post table version 2.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check name table for empty records.</summary>

* [com.adobe.fonts/check/name/empty_records](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/name/empty_records)
* 🍞 **PASS** No empty name table records found.

</details>
<details>
<summary>🍞 <b>PASS:</b> Description strings in the name table must not contain copyright info.</summary>

* [com.google.fonts/check/name/no_copyright_on_description](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/no_copyright_on_description)
* 🍞 **PASS** Description strings in the name table do not contain any copyright string.

</details>
<details>
<summary>🍞 <b>PASS:</b> Name table entries should not contain line-breaks.</summary>

* [com.google.fonts/check/name/line_breaks](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/line_breaks)
* 🍞 **PASS** Name table entries are all single-line (no line-breaks found).

</details>
<details>
<summary>🍞 <b>PASS:</b> Does full font name begin with the font family name?</summary>

* [com.google.fonts/check/name/match_familyname_fullfont](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/match_familyname_fullfont)
* 🍞 **PASS** Full font name begins with the font family name.

</details>
<details>
<summary>🍞 <b>PASS:</b> Font follows the family naming recommendations?</summary>

* [com.google.fonts/check/family_naming_recommendations](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/family_naming_recommendations)
* 🍞 **PASS** Font follows the family naming recommendations.

</details>
<details>
<summary>🍞 <b>PASS:</b> Name table strings must not contain the string 'Reserved Font Name'.</summary>

* [com.google.fonts/check/name/rfn](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/name/rfn)
* 🍞 **PASS** None of the name table strings contain "Reserved Font Name".

</details>
<details>
<summary>🍞 <b>PASS:</b> Name table ID 6 (PostScript name) must be consistent across platforms.</summary>

* [com.adobe.fonts/check/name/postscript_name_consistency](https://github.com/googlefonts/fontbakery/search?q=com.adobe.fonts/check/name/postscript_name_consistency)
* 🍞 **PASS** Entries in the 'name' table for ID 6 (PostScript name) are consistent.

</details>
<details>
<summary>🍞 <b>PASS:</b> Does the number of glyphs in the loca table match the maxp table?</summary>

* [com.google.fonts/check/loca/maxp_num_glyphs](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/loca/maxp_num_glyphs)
* 🍞 **PASS** 'loca' table matches numGlyphs in 'maxp' table.

</details>
<details>
<summary>🍞 <b>PASS:</b> Checking Vertical Metric Linegaps.</summary>

* [com.google.fonts/check/linegaps](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/linegaps)
* 🍞 **PASS** OS/2 sTypoLineGap and hhea lineGap are both 0.

</details>
<details>
<summary>🍞 <b>PASS:</b> MaxAdvanceWidth is consistent with values in the Hmtx and Hhea tables?</summary>

* [com.google.fonts/check/maxadvancewidth](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/maxadvancewidth)
* 🍞 **PASS** MaxAdvanceWidth is consistent with values in the Hmtx and Hhea tables.

</details>
<details>
<summary>🍞 <b>PASS:</b> Does the font have a DSIG table?</summary>

* [com.google.fonts/check/dsig](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/dsig)
* 🍞 **PASS** Digital Signature (DSIG) exists.

</details>
<details>
<summary>🍞 <b>PASS:</b> Whitespace and non-breaking space have the same width?</summary>

* [com.google.fonts/check/whitespace_widths](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/whitespace_widths)
* 🍞 **PASS** Whitespace and non-breaking space have the same width.

</details>
<details>
<summary>🍞 <b>PASS:</b> Is there a "kern" table declared in the font?</summary>

* [com.google.fonts/check/kern_table](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/kern_table)
* 🍞 **PASS** Font does not declare an optional "kern" table.

</details>
<details>
<summary>🍞 <b>PASS:</b> Is there any unused data at the end of the glyf table?</summary>

* [com.google.fonts/check/glyf_unused_data](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/glyf_unused_data)
* 🍞 **PASS** There is no unused data at the end of the glyf table.

</details>
<details>
<summary>🍞 <b>PASS:</b> Check for points out of bounds.</summary>

* [com.google.fonts/check/points_out_of_bounds](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/points_out_of_bounds)
* 🍞 **PASS** All glyph paths have coordinates within bounds!

</details>
<br>
</details>

### Summary

| 💔 ERROR | 🔥 FAIL | ⚠ WARN | 💤 SKIP | ℹ INFO | 🍞 PASS |
|:-----:|:----:|:----:|:----:|:----:|:----:|
| 0 | 4 | 5 | 63 | 6 | 75 |
| 0% | 3% | 3% | 41% | 4% | 49% |
