spgrps = {
    'P 1'         : (
        (('P', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 1, 'crystal_system': 'triclinic', 'short-hm': 'P1', 'is_reference': True},
    ),
    'P -1'        : (
        (('P', 'italic'),
         ('1', 'overline'),
         ), {'itnumber': 2, 'crystal_system': 'triclinic', 'short-hm': 'P-1', 'is_reference': True},
    ),
    'P 1 2 1'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 3, 'crystal_system': 'monoclinic', 'short-hm': 'P2', 'is_reference': True},
    ),
    'P 1 1 2'     : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 3, 'crystal_system': 'monoclinic', 'short-hm': 'P112', 'is_reference': False},
    ),
    'P 2 1 1'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 3, 'crystal_system': 'monoclinic', 'short-hm': 'P211', 'is_reference': False},
    ),
    'P 1 21 1'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 4, 'crystal_system': 'monoclinic', 'short-hm': 'P21', 'is_reference': True},
    ),
    'P 1 1 21'    : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 4, 'crystal_system': 'monoclinic', 'short-hm': 'P1121', 'is_reference': False},
    ),
    'P 21 1 1'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 4, 'crystal_system': 'monoclinic', 'short-hm': 'P2111', 'is_reference': False},
    ),
    'C 1 2 1'     : (
        (('C', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'C2', 'is_reference': True},
    ),
    'A 1 2 1'     : (
        (('A', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'A2', 'is_reference': False},
    ),
    'I 1 2 1'     : (
        (('I', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'I2', 'is_reference': False},
    ),
    'A 1 1 2'     : (
        (('A', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'A112', 'is_reference': False},
    ),
    'B 1 1 2'     : (
        (('B', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'B112', 'is_reference': False},
    ),
    'I 1 1 2'     : (
        (('I', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'I112', 'is_reference': False},
    ),
    'B 2 1 1'     : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'B211', 'is_reference': False},
    ),
    'C 2 1 1'     : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'C211', 'is_reference': False},
    ),
    'I 2 1 1'     : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'I211', 'is_reference': False},
    ),
    'P 1 m 1'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 6, 'crystal_system': 'monoclinic', 'short-hm': 'Pm', 'is_reference': True},
    ),
    'P 1 1 m'     : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 6, 'crystal_system': 'monoclinic', 'short-hm': 'P11m', 'is_reference': False},
    ),
    'P m 1 1'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 6, 'crystal_system': 'monoclinic', 'short-hm': 'Pm11', 'is_reference': False},
    ),
    'P 1 c 1'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'Pc', 'is_reference': True},
    ),
    'P 1 n 1'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'Pn', 'is_reference': False},
    ),
    'P 1 a 1'     : (
        (('P', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'Pa', 'is_reference': False},
    ),
    'P 1 1 a'     : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'P11a', 'is_reference': False},
    ),
    'P 1 1 n'     : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'P11n', 'is_reference': False},
    ),
    'P 1 1 b'     : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'P11b', 'is_reference': False},
    ),
    'P b 1 1'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'Pb11', 'is_reference': False},
    ),
    'P n 1 1'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'Pn11', 'is_reference': False},
    ),
    'P c 1 1'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 7, 'crystal_system': 'monoclinic', 'short-hm': 'Pc11', 'is_reference': False},
    ),
    'C 1 m 1'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'Cm', 'is_reference': True},
    ),
    'A 1 m 1'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'Am', 'is_reference': False},
    ),
    'I 1 m 1'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'Im', 'is_reference': False},
    ),
    'A 1 1 m'     : (
        (('A', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'A11m', 'is_reference': False},
    ),
    'B 1 1 m'     : (
        (('B', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'B11m', 'is_reference': False},
    ),
    'I 1 1 m'     : (
        (('I', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'I11m', 'is_reference': False},
    ),
    'B m 1 1'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'Bm11', 'is_reference': False},
    ),
    'C m 1 1'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'Cm11', 'is_reference': False},
    ),
    'I m 1 1'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 8, 'crystal_system': 'monoclinic', 'short-hm': 'Im11', 'is_reference': False},
    ),
    'C 1 c 1'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Cc', 'is_reference': True},
    ),
    'A 1 n 1'     : (
        (('A', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'An', 'is_reference': False},
    ),
    'I 1 a 1'     : (
        (('I', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Ia', 'is_reference': False},
    ),
    'A 1 a 1'     : (
        (('A', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Aa', 'is_reference': False},
    ),
    'C 1 n 1'     : (
        (('C', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Cn', 'is_reference': False},
    ),
    'I 1 c 1'     : (
        (('I', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Ic', 'is_reference': False},
    ),
    'A 1 1 a'     : (
        (('A', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'A11a', 'is_reference': False},
    ),
    'B 1 1 n'     : (
        (('B', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'B11n', 'is_reference': False},
    ),
    'I 1 1 b'     : (
        (('I', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'I11b', 'is_reference': False},
    ),
    'B 1 1 b'     : (
        (('B', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'B11b', 'is_reference': False},
    ),
    'A 1 1 n'     : (
        (('A', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'A11n', 'is_reference': False},
    ),
    'I 1 1 a'     : (
        (('I', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'I11a', 'is_reference': False},
    ),
    'B b 1 1'     : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Bb11', 'is_reference': False},
    ),
    'C n 1 1'     : (
        (('C', 'italic'),
         ('n', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Cn11', 'is_reference': False},
    ),
    'I c 1 1'     : (
        (('I', 'italic'),
         ('c', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Ic11', 'is_reference': False},
    ),
    'C c 1 1'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Cc11', 'is_reference': False},
    ),
    'B n 1 1'     : (
        (('B', 'italic'),
         ('n', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Bn11', 'is_reference': False},
    ),
    'I b 1 1'     : (
        (('I', 'italic'),
         ('b', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 9, 'crystal_system': 'monoclinic', 'short-hm': 'Ib11', 'is_reference': False},
    ),
    'P 1 2/m 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 10, 'crystal_system': 'monoclinic', 'short-hm': 'P2/m', 'is_reference': True},
    ),
    'P 1 1 2/m'   : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 10, 'crystal_system': 'monoclinic', 'short-hm': 'P112/m', 'is_reference': False},
    ),
    'P 2/m 1 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 10, 'crystal_system': 'monoclinic', 'short-hm': 'P2/m11', 'is_reference': False},
    ),
    'P 1 21/m 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 11, 'crystal_system': 'monoclinic', 'short-hm': 'P21/m', 'is_reference': True},
    ),
    'P 1 1 21/m'  : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 11, 'crystal_system': 'monoclinic', 'short-hm': 'P1121/m', 'is_reference': False},
    ),
    'P 21/m 1 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 11, 'crystal_system': 'monoclinic', 'short-hm': 'P21/m11', 'is_reference': False},
    ),
    'C 1 2/m 1'   : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'C2/m', 'is_reference': True},
    ),
    'A 1 2/m 1'   : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'A2/m', 'is_reference': False},
    ),
    'I 1 2/m 1'   : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'I2/m', 'is_reference': False},
    ),
    'A 1 1 2/m'   : (
        (('A', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'A112/m', 'is_reference': False},
    ),
    'B 1 1 2/m'   : (
        (('B', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'B112/m', 'is_reference': False},
    ),
    'I 1 1 2/m'   : (
        (('I', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'I112/m', 'is_reference': False},
    ),
    'B 2/m 1 1'   : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'B2/m11', 'is_reference': False},
    ),
    'C 2/m 1 1'   : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'C2/m11', 'is_reference': False},
    ),
    'I 2/m 1 1'   : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'I2/m11', 'is_reference': False},
    ),
    'P 1 2/c 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P2/c', 'is_reference': True},
    ),
    'P 1 2/n 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P2/n', 'is_reference': False},
    ),
    'P 1 2/a 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P2/a', 'is_reference': False},
    ),
    'P 1 1 2/a'   : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P112/a', 'is_reference': False},
    ),
    'P 1 1 2/n'   : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P112/n', 'is_reference': False},
    ),
    'P 1 1 2/b'   : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P112/b', 'is_reference': False},
    ),
    'P 2/b 1 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('b', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P2/b11', 'is_reference': False},
    ),
    'P 2/n 1 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P2/n11', 'is_reference': False},
    ),
    'P 2/c 1 1'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('c', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 13, 'crystal_system': 'monoclinic', 'short-hm': 'P2/c11', 'is_reference': False},
    ),
    'P 1 21/c 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P21/c', 'is_reference': True},
    ),
    'P 1 21/n 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P21/n', 'is_reference': False},
    ),
    'P 1 21/a 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P21/a', 'is_reference': False},
    ),
    'P 1 1 21/a'  : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P1121/a', 'is_reference': False},
    ),
    'P 1 1 21/n'  : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P1121/n', 'is_reference': False},
    ),
    'P 1 1 21/b'  : (
        (('P', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P1121/b', 'is_reference': False},
    ),
    'P 21/b 1 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('b', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P21/b11', 'is_reference': False},
    ),
    'P 21/n 1 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P21/n11', 'is_reference': False},
    ),
    'P 21/c 1 1'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('c', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 14, 'crystal_system': 'monoclinic', 'short-hm': 'P21/c11', 'is_reference': False},
    ),
    'C 1 2/c 1'   : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'C2/c', 'is_reference': True},
    ),
    'A 1 2/n 1'   : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'A2/n', 'is_reference': False},
    ),
    'I 1 2/a 1'   : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'I2/a', 'is_reference': False},
    ),
    'A 1 2/a 1'   : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'A2/a', 'is_reference': False},
    ),
    'C 1 2/n 1'   : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'C2/n', 'is_reference': False},
    ),
    'I 1 2/c 1'   : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'I2/c', 'is_reference': False},
    ),
    'A 1 1 2/a'   : (
        (('A', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'A112/a', 'is_reference': False},
    ),
    'B 1 1 2/n'   : (
        (('B', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'B112/n', 'is_reference': False},
    ),
    'I 1 1 2/b'   : (
        (('I', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'I112/b', 'is_reference': False},
    ),
    'B 1 1 2/b'   : (
        (('B', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'B112/b', 'is_reference': False},
    ),
    'A 1 1 2/n'   : (
        (('A', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'A112/n', 'is_reference': False},
    ),
    'I 1 1 2/a'   : (
        (('I', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'I112/a', 'is_reference': False},
    ),
    'B 2/b 1 1'   : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('b', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'B2/b11', 'is_reference': False},
    ),
    'C 2/n 1 1'   : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'C2/n11', 'is_reference': False},
    ),
    'I 2/c 1 1'   : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('c', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'I2/c11', 'is_reference': False},
    ),
    'C 2/c 1 1'   : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('c', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'C2/c11', 'is_reference': False},
    ),
    'B 2/n 1 1'   : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'B2/n11', 'is_reference': False},
    ),
    'I 2/b 1 1'   : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('b', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 15, 'crystal_system': 'monoclinic', 'short-hm': 'I2/b11', 'is_reference': False},
    ),
    'P 2 2 2'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 16, 'crystal_system': 'orthorhombic', 'short-hm': 'P222', 'is_reference': True},
    ),
    'P 2 2 21'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 17, 'crystal_system': 'orthorhombic', 'short-hm': 'P2221', 'is_reference': True},
    ),
    'P 21 2 2'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 17, 'crystal_system': 'orthorhombic', 'short-hm': 'P2122', 'is_reference': False},
    ),
    'P 2 21 2'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ), {'itnumber': 17, 'crystal_system': 'orthorhombic', 'short-hm': 'P2212', 'is_reference': False},
    ),
    'P 21 21 2'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ), {'itnumber': 18, 'crystal_system': 'orthorhombic', 'short-hm': 'P21212', 'is_reference': True},
    ),
    'P 2 21 21'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 18, 'crystal_system': 'orthorhombic', 'short-hm': 'P22121', 'is_reference': False},
    ),
    'P 21 2 21'   : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 18, 'crystal_system': 'orthorhombic', 'short-hm': 'P21221', 'is_reference': False},
    ),
    'P 21 21 21'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 19, 'crystal_system': 'orthorhombic', 'short-hm': 'P212121', 'is_reference': True},
    ),
    'C 2 2 21'    : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 20, 'crystal_system': 'orthorhombic', 'short-hm': 'C2221', 'is_reference': True},
    ),
    'A 21 2 2'    : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 20, 'crystal_system': 'orthorhombic', 'short-hm': 'A2122', 'is_reference': False},
    ),
    'B 2 21 2'    : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ), {'itnumber': 20, 'crystal_system': 'orthorhombic', 'short-hm': 'B2212', 'is_reference': False},
    ),
    'C 2 2 2'     : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 21, 'crystal_system': 'orthorhombic', 'short-hm': 'C222', 'is_reference': True},
    ),
    'A 2 2 2'     : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 21, 'crystal_system': 'orthorhombic', 'short-hm': 'A222', 'is_reference': False},
    ),
    'B 2 2 2'     : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 21, 'crystal_system': 'orthorhombic', 'short-hm': 'B222', 'is_reference': False},
    ),
    'F 2 2 2'     : (
        (('F', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 22, 'crystal_system': 'orthorhombic', 'short-hm': 'F222', 'is_reference': True},
    ),
    'I 2 2 2'     : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 23, 'crystal_system': 'orthorhombic', 'short-hm': 'I222', 'is_reference': True},
    ),
    'I 21 21 21'  : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 24, 'crystal_system': 'orthorhombic', 'short-hm': 'I212121', 'is_reference': True},
    ),
    'P m m 2'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 25, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmm2', 'is_reference': True},
    ),
    'P 2 m m'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 25, 'crystal_system': 'orthorhombic', 'short-hm': 'P2mm', 'is_reference': False},
    ),
    'P m 2 m'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 25, 'crystal_system': 'orthorhombic', 'short-hm': 'Pm2m', 'is_reference': False},
    ),
    'P m c 21'    : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 26, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmc21', 'is_reference': True},
    ),
    'P c m 21'    : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 26, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcm21', 'is_reference': False},
    ),
    'P 21 m a'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 26, 'crystal_system': 'orthorhombic', 'short-hm': 'P21ma', 'is_reference': False},
    ),
    'P 21 a m'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 26, 'crystal_system': 'orthorhombic', 'short-hm': 'P21am', 'is_reference': False},
    ),
    'P b 21 m'    : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ), {'itnumber': 26, 'crystal_system': 'orthorhombic', 'short-hm': 'Pb21m', 'is_reference': False},
    ),
    'P m 21 b'    : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('b', 'italic'),
         ), {'itnumber': 26, 'crystal_system': 'orthorhombic', 'short-hm': 'Pm21b', 'is_reference': False},
    ),
    'P c c 2'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 27, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcc2', 'is_reference': True},
    ),
    'P 2 a a'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 27, 'crystal_system': 'orthorhombic', 'short-hm': 'P2aa', 'is_reference': False},
    ),
    'P b 2 b'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('2', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 27, 'crystal_system': 'orthorhombic', 'short-hm': 'Pb2b', 'is_reference': False},
    ),
    'P m a 2'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 28, 'crystal_system': 'orthorhombic', 'short-hm': 'Pma2', 'is_reference': True},
    ),
    'P b m 2'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 28, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbm2', 'is_reference': False},
    ),
    'P 2 m b'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 28, 'crystal_system': 'orthorhombic', 'short-hm': 'P2mb', 'is_reference': False},
    ),
    'P 2 c m'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 28, 'crystal_system': 'orthorhombic', 'short-hm': 'P2cm', 'is_reference': False},
    ),
    'P c 2 m'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 28, 'crystal_system': 'orthorhombic', 'short-hm': 'Pc2m', 'is_reference': False},
    ),
    'P m 2 a'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 28, 'crystal_system': 'orthorhombic', 'short-hm': 'Pm2a', 'is_reference': False},
    ),
    'P c a 21'    : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 29, 'crystal_system': 'orthorhombic', 'short-hm': 'Pca21', 'is_reference': True},
    ),
    'P b c 21'    : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 29, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbc21', 'is_reference': False},
    ),
    'P 21 a b'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 29, 'crystal_system': 'orthorhombic', 'short-hm': 'P21ab', 'is_reference': False},
    ),
    'P 21 c a'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 29, 'crystal_system': 'orthorhombic', 'short-hm': 'P21ca', 'is_reference': False},
    ),
    'P c 21 b'    : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('b', 'italic'),
         ), {'itnumber': 29, 'crystal_system': 'orthorhombic', 'short-hm': 'Pc21b', 'is_reference': False},
    ),
    'P b 21 a'    : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('a', 'italic'),
         ), {'itnumber': 29, 'crystal_system': 'orthorhombic', 'short-hm': 'Pb21a', 'is_reference': False},
    ),
    'P n c 2'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 30, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnc2', 'is_reference': True},
    ),
    'P c n 2'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 30, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcn2', 'is_reference': False},
    ),
    'P 2 n a'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('n', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 30, 'crystal_system': 'orthorhombic', 'short-hm': 'P2na', 'is_reference': False},
    ),
    'P 2 a n'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 30, 'crystal_system': 'orthorhombic', 'short-hm': 'P2an', 'is_reference': False},
    ),
    'P b 2 n'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('2', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 30, 'crystal_system': 'orthorhombic', 'short-hm': 'Pb2n', 'is_reference': False},
    ),
    'P n 2 b'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 30, 'crystal_system': 'orthorhombic', 'short-hm': 'Pn2b', 'is_reference': False},
    ),
    'P m n 21'    : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 31, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmn21', 'is_reference': True},
    ),
    'P n m 21'    : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 31, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnm21', 'is_reference': False},
    ),
    'P 21 m n'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 31, 'crystal_system': 'orthorhombic', 'short-hm': 'P21mn', 'is_reference': False},
    ),
    'P 21 n m'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 31, 'crystal_system': 'orthorhombic', 'short-hm': 'P21nm', 'is_reference': False},
    ),
    'P n 21 m'    : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ), {'itnumber': 31, 'crystal_system': 'orthorhombic', 'short-hm': 'Pn21m', 'is_reference': False},
    ),
    'P m 21 n'    : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('n', 'italic'),
         ), {'itnumber': 31, 'crystal_system': 'orthorhombic', 'short-hm': 'Pm21n', 'is_reference': False},
    ),
    'P b a 2'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 32, 'crystal_system': 'orthorhombic', 'short-hm': 'Pba2', 'is_reference': True},
    ),
    'P 2 c b'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 32, 'crystal_system': 'orthorhombic', 'short-hm': 'P2cb', 'is_reference': False},
    ),
    'P c 2 a'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 32, 'crystal_system': 'orthorhombic', 'short-hm': 'Pc2a', 'is_reference': False},
    ),
    'P n a 21'    : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 33, 'crystal_system': 'orthorhombic', 'short-hm': 'Pna21', 'is_reference': True},
    ),
    'P b n 21'    : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 33, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbn21', 'is_reference': False},
    ),
    'P 21 n b'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('n', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 33, 'crystal_system': 'orthorhombic', 'short-hm': 'P21nb', 'is_reference': False},
    ),
    'P 21 c n'    : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('c', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 33, 'crystal_system': 'orthorhombic', 'short-hm': 'P21cn', 'is_reference': False},
    ),
    'P c 21 n'    : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('n', 'italic'),
         ), {'itnumber': 33, 'crystal_system': 'orthorhombic', 'short-hm': 'Pc21n', 'is_reference': False},
    ),
    'P n 21 a'    : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('a', 'italic'),
         ), {'itnumber': 33, 'crystal_system': 'orthorhombic', 'short-hm': 'Pn21a', 'is_reference': False},
    ),
    'P n n 2'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 34, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnn2', 'is_reference': True},
    ),
    'P 2 n n'     : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('n', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 34, 'crystal_system': 'orthorhombic', 'short-hm': 'P2nn', 'is_reference': False},
    ),
    'P n 2 n'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('2', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 34, 'crystal_system': 'orthorhombic', 'short-hm': 'Pn2n', 'is_reference': False},
    ),
    'C m m 2'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 35, 'crystal_system': 'orthorhombic', 'short-hm': 'Cmm2', 'is_reference': True},
    ),
    'A 2 m m'     : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 35, 'crystal_system': 'orthorhombic', 'short-hm': 'A2mm', 'is_reference': False},
    ),
    'B m 2 m'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 35, 'crystal_system': 'orthorhombic', 'short-hm': 'Bm2m', 'is_reference': False},
    ),
    'C m c 21'    : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 36, 'crystal_system': 'orthorhombic', 'short-hm': 'Cmc21', 'is_reference': True},
    ),
    'C c m 21'    : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 36, 'crystal_system': 'orthorhombic', 'short-hm': 'Ccm21', 'is_reference': False},
    ),
    'A 21 m a'    : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 36, 'crystal_system': 'orthorhombic', 'short-hm': 'A21ma', 'is_reference': False},
    ),
    'A 21 a m'    : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 36, 'crystal_system': 'orthorhombic', 'short-hm': 'A21am', 'is_reference': False},
    ),
    'B b 21 m'    : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ), {'itnumber': 36, 'crystal_system': 'orthorhombic', 'short-hm': 'Bb21m', 'is_reference': False},
    ),
    'B m 21 b'    : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('b', 'italic'),
         ), {'itnumber': 36, 'crystal_system': 'orthorhombic', 'short-hm': 'Bm21b', 'is_reference': False},
    ),
    'C c c 2'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 37, 'crystal_system': 'orthorhombic', 'short-hm': 'Ccc2', 'is_reference': True},
    ),
    'A 2 a a'     : (
        (('A', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 37, 'crystal_system': 'orthorhombic', 'short-hm': 'A2aa', 'is_reference': False},
    ),
    'B b 2 b'     : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('2', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 37, 'crystal_system': 'orthorhombic', 'short-hm': 'Bb2b', 'is_reference': False},
    ),
    'A m m 2'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 38, 'crystal_system': 'orthorhombic', 'short-hm': 'Amm2', 'is_reference': True},
    ),
    'B m m 2'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 38, 'crystal_system': 'orthorhombic', 'short-hm': 'Bmm2', 'is_reference': False},
    ),
    'B 2 m m'     : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 38, 'crystal_system': 'orthorhombic', 'short-hm': 'B2mm', 'is_reference': False},
    ),
    'C 2 m m'     : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 38, 'crystal_system': 'orthorhombic', 'short-hm': 'C2mm', 'is_reference': False},
    ),
    'C m 2 m'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 38, 'crystal_system': 'orthorhombic', 'short-hm': 'Cm2m', 'is_reference': False},
    ),
    'A m 2 m'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 38, 'crystal_system': 'orthorhombic', 'short-hm': 'Am2m', 'is_reference': False},
    ),
    'A b m 2'     : (
        (('A', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 39, 'crystal_system': 'orthorhombic', 'short-hm': 'Abm2', 'is_reference': True},
    ),
    'B m a 2'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 39, 'crystal_system': 'orthorhombic', 'short-hm': 'Bma2', 'is_reference': False},
    ),
    'B 2 c m'     : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 39, 'crystal_system': 'orthorhombic', 'short-hm': 'B2cm', 'is_reference': False},
    ),
    'C 2 m b'     : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 39, 'crystal_system': 'orthorhombic', 'short-hm': 'C2mb', 'is_reference': False},
    ),
    'C m 2 a'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 39, 'crystal_system': 'orthorhombic', 'short-hm': 'Cm2a', 'is_reference': False},
    ),
    'A c 2 m'     : (
        (('A', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 39, 'crystal_system': 'orthorhombic', 'short-hm': 'Ac2m', 'is_reference': False},
    ),
    'A m a 2'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 40, 'crystal_system': 'orthorhombic', 'short-hm': 'Ama2', 'is_reference': True},
    ),
    'B b m 2'     : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 40, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbm2', 'is_reference': False},
    ),
    'B 2 m b'     : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 40, 'crystal_system': 'orthorhombic', 'short-hm': 'B2mb', 'is_reference': False},
    ),
    'C 2 c m'     : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 40, 'crystal_system': 'orthorhombic', 'short-hm': 'C2cm', 'is_reference': False},
    ),
    'C c 2 m'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 40, 'crystal_system': 'orthorhombic', 'short-hm': 'Cc2m', 'is_reference': False},
    ),
    'A m 2 a'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 40, 'crystal_system': 'orthorhombic', 'short-hm': 'Am2a', 'is_reference': False},
    ),
    'A b a 2'     : (
        (('A', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 41, 'crystal_system': 'orthorhombic', 'short-hm': 'Aba2', 'is_reference': True},
    ),
    'B b a 2'     : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 41, 'crystal_system': 'orthorhombic', 'short-hm': 'Bba2', 'is_reference': False},
    ),
    'B 2 c b'     : (
        (('B', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 41, 'crystal_system': 'orthorhombic', 'short-hm': 'B2cb', 'is_reference': False},
    ),
    'C 2 c b'     : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 41, 'crystal_system': 'orthorhombic', 'short-hm': 'C2cb', 'is_reference': False},
    ),
    'C c 2 a'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 41, 'crystal_system': 'orthorhombic', 'short-hm': 'Cc2a', 'is_reference': False},
    ),
    'A c 2 a'     : (
        (('A', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 41, 'crystal_system': 'orthorhombic', 'short-hm': 'Ac2a', 'is_reference': False},
    ),
    'F m m 2'     : (
        (('F', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 42, 'crystal_system': 'orthorhombic', 'short-hm': 'Fmm2', 'is_reference': True},
    ),
    'F 2 m m'     : (
        (('F', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 42, 'crystal_system': 'orthorhombic', 'short-hm': 'F2mm', 'is_reference': False},
    ),
    'F m 2 m'     : (
        (('F', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 42, 'crystal_system': 'orthorhombic', 'short-hm': 'Fm2m', 'is_reference': False},
    ),
    'F d d 2'     : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('d', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 43, 'crystal_system': 'orthorhombic', 'short-hm': 'Fdd2', 'is_reference': True},
    ),
    'F 2 d d'     : (
        (('F', 'italic'),
         ('2', 'regular'),
         ('d', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 43, 'crystal_system': 'orthorhombic', 'short-hm': 'F2dd', 'is_reference': False},
    ),
    'F d 2 d'     : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('2', 'regular'),
         ('d', 'italic'),
         ), {'itnumber': 43, 'crystal_system': 'orthorhombic', 'short-hm': 'Fd2d', 'is_reference': False},
    ),
    'I m m 2'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 44, 'crystal_system': 'orthorhombic', 'short-hm': 'Imm2', 'is_reference': True},
    ),
    'I 2 m m'     : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 44, 'crystal_system': 'orthorhombic', 'short-hm': 'I2mm', 'is_reference': False},
    ),
    'I m 2 m'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 44, 'crystal_system': 'orthorhombic', 'short-hm': 'Im2m', 'is_reference': False},
    ),
    'I b a 2'     : (
        (('I', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 45, 'crystal_system': 'orthorhombic', 'short-hm': 'Iba2', 'is_reference': True},
    ),
    'I 2 c b'     : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 45, 'crystal_system': 'orthorhombic', 'short-hm': 'I2cb', 'is_reference': False},
    ),
    'I c 2 a'     : (
        (('I', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 45, 'crystal_system': 'orthorhombic', 'short-hm': 'Ic2a', 'is_reference': False},
    ),
    'I m a 2'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 46, 'crystal_system': 'orthorhombic', 'short-hm': 'Ima2', 'is_reference': True},
    ),
    'I b m 2'     : (
        (('I', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 46, 'crystal_system': 'orthorhombic', 'short-hm': 'Ibm2', 'is_reference': False},
    ),
    'I 2 m b'     : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 46, 'crystal_system': 'orthorhombic', 'short-hm': 'I2mb', 'is_reference': False},
    ),
    'I 2 c m'     : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 46, 'crystal_system': 'orthorhombic', 'short-hm': 'I2cm', 'is_reference': False},
    ),
    'I c 2 m'     : (
        (('I', 'italic'),
         ('c', 'italic'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 46, 'crystal_system': 'orthorhombic', 'short-hm': 'Ic2m', 'is_reference': False},
    ),
    'I m 2 a'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 46, 'crystal_system': 'orthorhombic', 'short-hm': 'Im2a', 'is_reference': False},
    ),
    'P m m m'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 47, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmmm', 'is_reference': True},
    ),
    'P n n n:1'   : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 48, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnnn', 'is_reference': False},
    ),
    'P n n n:2'   : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 48, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnnn', 'is_reference': True},
    ),
    'P c c m'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 49, 'crystal_system': 'orthorhombic', 'short-hm': 'Pccm', 'is_reference': True},
    ),
    'P m a a'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 49, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmaa', 'is_reference': False},
    ),
    'P b m b'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 49, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbmb', 'is_reference': False},
    ),
    'P b a n:1'   : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 50, 'crystal_system': 'orthorhombic', 'short-hm': 'Pban', 'is_reference': False},
    ),
    'P b a n:2'   : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 50, 'crystal_system': 'orthorhombic', 'short-hm': 'Pban', 'is_reference': True},
    ),
    'P n c b:1'   : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 50, 'crystal_system': 'orthorhombic', 'short-hm': 'Pncb', 'is_reference': False},
    ),
    'P n c b:2'   : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 50, 'crystal_system': 'orthorhombic', 'short-hm': 'Pncb', 'is_reference': False},
    ),
    'P c n a:1'   : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 50, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcna', 'is_reference': False},
    ),
    'P c n a:2'   : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 50, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcna', 'is_reference': False},
    ),
    'P m m a'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 51, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmma', 'is_reference': True},
    ),
    'P m m b'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 51, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmmb', 'is_reference': False},
    ),
    'P b m m'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 51, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbmm', 'is_reference': False},
    ),
    'P c m m'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 51, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcmm', 'is_reference': False},
    ),
    'P m c m'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 51, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmcm', 'is_reference': False},
    ),
    'P m a m'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 51, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmam', 'is_reference': False},
    ),
    'P n n a'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 52, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnna', 'is_reference': True},
    ),
    'P n n b'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 52, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnnb', 'is_reference': False},
    ),
    'P b n n'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 52, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbnn', 'is_reference': False},
    ),
    'P c n n'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 52, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcnn', 'is_reference': False},
    ),
    'P n c n'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 52, 'crystal_system': 'orthorhombic', 'short-hm': 'Pncn', 'is_reference': False},
    ),
    'P n a n'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 52, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnan', 'is_reference': False},
    ),
    'P m n a'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 53, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmna', 'is_reference': True},
    ),
    'P n m b'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 53, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnmb', 'is_reference': False},
    ),
    'P b m n'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 53, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbmn', 'is_reference': False},
    ),
    'P c n m'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 53, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcnm', 'is_reference': False},
    ),
    'P n c m'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 53, 'crystal_system': 'orthorhombic', 'short-hm': 'Pncm', 'is_reference': False},
    ),
    'P m a n'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 53, 'crystal_system': 'orthorhombic', 'short-hm': 'Pman', 'is_reference': False},
    ),
    'P c c a'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 54, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcca', 'is_reference': True},
    ),
    'P c c b'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 54, 'crystal_system': 'orthorhombic', 'short-hm': 'Pccb', 'is_reference': False},
    ),
    'P b a a'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 54, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbaa', 'is_reference': False},
    ),
    'P c a a'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 54, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcaa', 'is_reference': False},
    ),
    'P b c b'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 54, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbcb', 'is_reference': False},
    ),
    'P b a b'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 54, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbab', 'is_reference': False},
    ),
    'P b a m'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 55, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbam', 'is_reference': True},
    ),
    'P m c b'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 55, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmcb', 'is_reference': False},
    ),
    'P c m a'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 55, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcma', 'is_reference': False},
    ),
    'P c c n'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 56, 'crystal_system': 'orthorhombic', 'short-hm': 'Pccn', 'is_reference': True},
    ),
    'P n a a'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 56, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnaa', 'is_reference': False},
    ),
    'P b n b'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('n', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 56, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbnb', 'is_reference': False},
    ),
    'P b c m'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 57, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbcm', 'is_reference': True},
    ),
    'P c a m'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 57, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcam', 'is_reference': False},
    ),
    'P m c a'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 57, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmca', 'is_reference': False},
    ),
    'P m a b'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 57, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmab', 'is_reference': False},
    ),
    'P b m a'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 57, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbma', 'is_reference': False},
    ),
    'P c m b'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 57, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcmb', 'is_reference': False},
    ),
    'P n n m'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 58, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnnm', 'is_reference': True},
    ),
    'P m n n'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 58, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmnn', 'is_reference': False},
    ),
    'P n m n'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 58, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnmn', 'is_reference': False},
    ),
    'P m m n:1'   : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 59, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmmn', 'is_reference': False},
    ),
    'P m m n:2'   : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 59, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmmn', 'is_reference': True},
    ),
    'P n m m:1'   : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 59, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnmm', 'is_reference': False},
    ),
    'P n m m:2'   : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 59, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnmm', 'is_reference': False},
    ),
    'P m n m:1'   : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 59, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmnm', 'is_reference': False},
    ),
    'P m n m:2'   : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 59, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmnm', 'is_reference': False},
    ),
    'P b c n'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 60, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbcn', 'is_reference': True},
    ),
    'P c a n'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 60, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcan', 'is_reference': False},
    ),
    'P n c a'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 60, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnca', 'is_reference': False},
    ),
    'P n a b'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 60, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnab', 'is_reference': False},
    ),
    'P b n a'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 60, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbna', 'is_reference': False},
    ),
    'P c n b'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 60, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcnb', 'is_reference': False},
    ),
    'P b c a'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 61, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbca', 'is_reference': True},
    ),
    'P c a b'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 61, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcab', 'is_reference': False},
    ),
    'P n m a'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 62, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnma', 'is_reference': True},
    ),
    'P m n b'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 62, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmnb', 'is_reference': False},
    ),
    'P b n m'     : (
        (('P', 'italic'),
         ('b', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 62, 'crystal_system': 'orthorhombic', 'short-hm': 'Pbnm', 'is_reference': False},
    ),
    'P c m n'     : (
        (('P', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 62, 'crystal_system': 'orthorhombic', 'short-hm': 'Pcmn', 'is_reference': False},
    ),
    'P m c n'     : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('n', 'italic'),
         ), {'itnumber': 62, 'crystal_system': 'orthorhombic', 'short-hm': 'Pmcn', 'is_reference': False},
    ),
    'P n a m'     : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 62, 'crystal_system': 'orthorhombic', 'short-hm': 'Pnam', 'is_reference': False},
    ),
    'C m c m'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 63, 'crystal_system': 'orthorhombic', 'short-hm': 'Cmcm', 'is_reference': True},
    ),
    'C c m m'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 63, 'crystal_system': 'orthorhombic', 'short-hm': 'Ccmm', 'is_reference': False},
    ),
    'A m m a'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 63, 'crystal_system': 'orthorhombic', 'short-hm': 'Amma', 'is_reference': False},
    ),
    'A m a m'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 63, 'crystal_system': 'orthorhombic', 'short-hm': 'Amam', 'is_reference': False},
    ),
    'B b m m'     : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 63, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbmm', 'is_reference': False},
    ),
    'B m m b'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 63, 'crystal_system': 'orthorhombic', 'short-hm': 'Bmmb', 'is_reference': False},
    ),
    'C m c a'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 64, 'crystal_system': 'orthorhombic', 'short-hm': 'Cmca', 'is_reference': True},
    ),
    'C c m b'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 64, 'crystal_system': 'orthorhombic', 'short-hm': 'Ccmb', 'is_reference': False},
    ),
    'A b m a'     : (
        (('A', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 64, 'crystal_system': 'orthorhombic', 'short-hm': 'Abma', 'is_reference': False},
    ),
    'A c a m'     : (
        (('A', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 64, 'crystal_system': 'orthorhombic', 'short-hm': 'Acam', 'is_reference': False},
    ),
    'B b c m'     : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 64, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbcm', 'is_reference': False},
    ),
    'B m a b'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 64, 'crystal_system': 'orthorhombic', 'short-hm': 'Bmab', 'is_reference': False},
    ),
    'C m m m'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 65, 'crystal_system': 'orthorhombic', 'short-hm': 'Cmmm', 'is_reference': True},
    ),
    'A m m m'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 65, 'crystal_system': 'orthorhombic', 'short-hm': 'Ammm', 'is_reference': False},
    ),
    'B m m m'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 65, 'crystal_system': 'orthorhombic', 'short-hm': 'Bmmm', 'is_reference': False},
    ),
    'C c c m'     : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 66, 'crystal_system': 'orthorhombic', 'short-hm': 'Cccm', 'is_reference': True},
    ),
    'A m a a'     : (
        (('A', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 66, 'crystal_system': 'orthorhombic', 'short-hm': 'Amaa', 'is_reference': False},
    ),
    'B b m b'     : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 66, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbmb', 'is_reference': False},
    ),
    'C m m a'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 67, 'crystal_system': 'orthorhombic', 'short-hm': 'Cmma', 'is_reference': True},
    ),
    'C m m b'     : (
        (('C', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 67, 'crystal_system': 'orthorhombic', 'short-hm': 'Cmmb', 'is_reference': False},
    ),
    'A b m m'     : (
        (('A', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 67, 'crystal_system': 'orthorhombic', 'short-hm': 'Abmm', 'is_reference': False},
    ),
    'A c m m'     : (
        (('A', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 67, 'crystal_system': 'orthorhombic', 'short-hm': 'Acmm', 'is_reference': False},
    ),
    'B m c m'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 67, 'crystal_system': 'orthorhombic', 'short-hm': 'Bmcm', 'is_reference': False},
    ),
    'B m a m'     : (
        (('B', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 67, 'crystal_system': 'orthorhombic', 'short-hm': 'Bmam', 'is_reference': False},
    ),
    'C c c a:1'   : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Ccca', 'is_reference': False},
    ),
    'C c c a:2'   : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Ccca', 'is_reference': True},
    ),
    'C c c b:1'   : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Cccb', 'is_reference': False},
    ),
    'C c c b:2'   : (
        (('C', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Cccb', 'is_reference': False},
    ),
    'A b a a:1'   : (
        (('A', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Abaa', 'is_reference': False},
    ),
    'A b a a:2'   : (
        (('A', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Abaa', 'is_reference': False},
    ),
    'A c a a:1'   : (
        (('A', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Acaa', 'is_reference': False},
    ),
    'A c a a:2'   : (
        (('A', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Acaa', 'is_reference': False},
    ),
    'B b c b:1'   : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbcb', 'is_reference': False},
    ),
    'B b c b:2'   : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbcb', 'is_reference': False},
    ),
    'B b a b:1'   : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbab', 'is_reference': False},
    ),
    'B b a b:2'   : (
        (('B', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 68, 'crystal_system': 'orthorhombic', 'short-hm': 'Bbab', 'is_reference': False},
    ),
    'F m m m'     : (
        (('F', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 69, 'crystal_system': 'orthorhombic', 'short-hm': 'Fmmm', 'is_reference': True},
    ),
    'F d d d:1'   : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('d', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 70, 'crystal_system': 'orthorhombic', 'short-hm': 'Fddd', 'is_reference': False},
    ),
    'F d d d:2'   : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('d', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 70, 'crystal_system': 'orthorhombic', 'short-hm': 'Fddd', 'is_reference': True},
    ),
    'I m m m'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 71, 'crystal_system': 'orthorhombic', 'short-hm': 'Immm', 'is_reference': True},
    ),
    'I b a m'     : (
        (('I', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 72, 'crystal_system': 'orthorhombic', 'short-hm': 'Ibam', 'is_reference': True},
    ),
    'I m c b'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 72, 'crystal_system': 'orthorhombic', 'short-hm': 'Imcb', 'is_reference': False},
    ),
    'I c m a'     : (
        (('I', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 72, 'crystal_system': 'orthorhombic', 'short-hm': 'Icma', 'is_reference': False},
    ),
    'I b c a'     : (
        (('I', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 73, 'crystal_system': 'orthorhombic', 'short-hm': 'Ibca', 'is_reference': True},
    ),
    'I c a b'     : (
        (('I', 'italic'),
         ('c', 'italic'),
         ('a', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 73, 'crystal_system': 'orthorhombic', 'short-hm': 'Icab', 'is_reference': False},
    ),
    'I m m a'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ), {'itnumber': 74, 'crystal_system': 'orthorhombic', 'short-hm': 'Imma', 'is_reference': True},
    ),
    'I m m b'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('b', 'italic'),
         ), {'itnumber': 74, 'crystal_system': 'orthorhombic', 'short-hm': 'Immb', 'is_reference': False},
    ),
    'I b m m'     : (
        (('I', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 74, 'crystal_system': 'orthorhombic', 'short-hm': 'Ibmm', 'is_reference': False},
    ),
    'I c m m'     : (
        (('I', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 74, 'crystal_system': 'orthorhombic', 'short-hm': 'Icmm', 'is_reference': False},
    ),
    'I m c m'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 74, 'crystal_system': 'orthorhombic', 'short-hm': 'Imcm', 'is_reference': False},
    ),
    'I m a m'     : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 74, 'crystal_system': 'orthorhombic', 'short-hm': 'Imam', 'is_reference': False},
    ),
    'P 4'         : (
        (('P', 'italic'),
         ('4', 'regular'),
         ), {'itnumber': 75, 'crystal_system': 'tetragonal', 'short-hm': 'P4', 'is_reference': True},
    ),
    'P 41'        : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 76, 'crystal_system': 'tetragonal', 'short-hm': 'P41', 'is_reference': True},
    ),
    'P 42'        : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ), {'itnumber': 77, 'crystal_system': 'tetragonal', 'short-hm': 'P42', 'is_reference': True},
    ),
    'P 43'        : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('3', 'sub'),
         ), {'itnumber': 78, 'crystal_system': 'tetragonal', 'short-hm': 'P43', 'is_reference': True},
    ),
    'I 4'         : (
        (('I', 'italic'),
         ('4', 'regular'),
         ), {'itnumber': 79, 'crystal_system': 'tetragonal', 'short-hm': 'I4', 'is_reference': True},
    ),
    'I 41'        : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 80, 'crystal_system': 'tetragonal', 'short-hm': 'I41', 'is_reference': True},
    ),
    'P -4'        : (
        (('P', 'italic'),
         ('4', 'overline'),
         ), {'itnumber': 81, 'crystal_system': 'tetragonal', 'short-hm': 'P-4', 'is_reference': True},
    ),
    'I -4'        : (
        (('I', 'italic'),
         ('4', 'overline'),
         ), {'itnumber': 82, 'crystal_system': 'tetragonal', 'short-hm': 'I-4', 'is_reference': True},
    ),
    'P 4/m'       : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 83, 'crystal_system': 'tetragonal', 'short-hm': 'P4/m', 'is_reference': True},
    ),
    'P 42/m'      : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 84, 'crystal_system': 'tetragonal', 'short-hm': 'P42/m', 'is_reference': True},
    ),
    'P 4/n:1'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 85, 'crystal_system': 'tetragonal', 'short-hm': 'P4/n', 'is_reference': False},
    ),
    'P 4/n:2'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 85, 'crystal_system': 'tetragonal', 'short-hm': 'P4/n', 'is_reference': True},
    ),
    'P 42/n:1'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 86, 'crystal_system': 'tetragonal', 'short-hm': 'P42/n', 'is_reference': False},
    ),
    'P 42/n:2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 86, 'crystal_system': 'tetragonal', 'short-hm': 'P42/n', 'is_reference': True},
    ),
    'I 4/m'       : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 87, 'crystal_system': 'tetragonal', 'short-hm': 'I4/m', 'is_reference': True},
    ),
    'I 41/a:1'    : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 88, 'crystal_system': 'tetragonal', 'short-hm': 'I41/a', 'is_reference': False},
    ),
    'I 41/a:2'    : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 88, 'crystal_system': 'tetragonal', 'short-hm': 'I41/a', 'is_reference': True},
    ),
    'P 4 2 2'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 89, 'crystal_system': 'tetragonal', 'short-hm': 'P422', 'is_reference': True},
    ),
    'P 4 21 2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ), {'itnumber': 90, 'crystal_system': 'tetragonal', 'short-hm': 'P4212', 'is_reference': True},
    ),
    'P 41 2 2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 91, 'crystal_system': 'tetragonal', 'short-hm': 'P4122', 'is_reference': True},
    ),
    'P 41 21 2'   : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ), {'itnumber': 92, 'crystal_system': 'tetragonal', 'short-hm': 'P41212', 'is_reference': True},
    ),
    'P 42 2 2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 93, 'crystal_system': 'tetragonal', 'short-hm': 'P4222', 'is_reference': True},
    ),
    'P 42 21 2'   : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ), {'itnumber': 94, 'crystal_system': 'tetragonal', 'short-hm': 'P42212', 'is_reference': True},
    ),
    'P 43 2 2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('3', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 95, 'crystal_system': 'tetragonal', 'short-hm': 'P4322', 'is_reference': True},
    ),
    'P 43 21 2'   : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('3', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ), {'itnumber': 96, 'crystal_system': 'tetragonal', 'short-hm': 'P43212', 'is_reference': True},
    ),
    'I 4 2 2'     : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 97, 'crystal_system': 'tetragonal', 'short-hm': 'I422', 'is_reference': True},
    ),
    'I 41 2 2'    : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 98, 'crystal_system': 'tetragonal', 'short-hm': 'I4122', 'is_reference': True},
    ),
    'P 4 m m'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 99, 'crystal_system': 'tetragonal', 'short-hm': 'P4mm', 'is_reference': True},
    ),
    'P 4 b m'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('b', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 100, 'crystal_system': 'tetragonal', 'short-hm': 'P4bm', 'is_reference': True},
    ),
    'P 42 c m'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 101, 'crystal_system': 'tetragonal', 'short-hm': 'P42cm', 'is_reference': True},
    ),
    'P 42 n m'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 102, 'crystal_system': 'tetragonal', 'short-hm': 'P42nm', 'is_reference': True},
    ),
    'P 4 c c'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('c', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 103, 'crystal_system': 'tetragonal', 'short-hm': 'P4cc', 'is_reference': True},
    ),
    'P 4 n c'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('n', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 104, 'crystal_system': 'tetragonal', 'short-hm': 'P4nc', 'is_reference': True},
    ),
    'P 42 m c'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('m', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 105, 'crystal_system': 'tetragonal', 'short-hm': 'P42mc', 'is_reference': True},
    ),
    'P 42 b c'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('b', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 106, 'crystal_system': 'tetragonal', 'short-hm': 'P42bc', 'is_reference': True},
    ),
    'I 4 m m'     : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 107, 'crystal_system': 'tetragonal', 'short-hm': 'I4mm', 'is_reference': True},
    ),
    'I 4 c m'     : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 108, 'crystal_system': 'tetragonal', 'short-hm': 'I4cm', 'is_reference': True},
    ),
    'I 41 m d'    : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 109, 'crystal_system': 'tetragonal', 'short-hm': 'I41md', 'is_reference': True},
    ),
    'I 41 c d'    : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('c', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 110, 'crystal_system': 'tetragonal', 'short-hm': 'I41cd', 'is_reference': True},
    ),
    'P -4 2 m'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 111, 'crystal_system': 'tetragonal', 'short-hm': 'P-42m', 'is_reference': True},
    ),
    'P -4 2 c'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('2', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 112, 'crystal_system': 'tetragonal', 'short-hm': 'P-42c', 'is_reference': True},
    ),
    'P -4 21 m'   : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('m', 'italic'),
         ), {'itnumber': 113, 'crystal_system': 'tetragonal', 'short-hm': 'P-421m', 'is_reference': True},
    ),
    'P -4 21 c'   : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('c', 'italic'),
         ), {'itnumber': 114, 'crystal_system': 'tetragonal', 'short-hm': 'P-421c', 'is_reference': True},
    ),
    'P -4 m 2'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 115, 'crystal_system': 'tetragonal', 'short-hm': 'P-4m2', 'is_reference': True},
    ),
    'P -4 c 2'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('c', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 116, 'crystal_system': 'tetragonal', 'short-hm': 'P-4c2', 'is_reference': True},
    ),
    'P -4 b 2'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('b', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 117, 'crystal_system': 'tetragonal', 'short-hm': 'P-4b2', 'is_reference': True},
    ),
    'P -4 n 2'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('n', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 118, 'crystal_system': 'tetragonal', 'short-hm': 'P-4n2', 'is_reference': True},
    ),
    'I -4 m 2'    : (
        (('I', 'italic'),
         ('4', 'overline'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 119, 'crystal_system': 'tetragonal', 'short-hm': 'I-4m2', 'is_reference': True},
    ),
    'I -4 c 2'    : (
        (('I', 'italic'),
         ('4', 'overline'),
         ('c', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 120, 'crystal_system': 'tetragonal', 'short-hm': 'I-4c2', 'is_reference': True},
    ),
    'I -4 2 m'    : (
        (('I', 'italic'),
         ('4', 'overline'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 121, 'crystal_system': 'tetragonal', 'short-hm': 'I-42m', 'is_reference': True},
    ),
    'I -4 2 d'    : (
        (('I', 'italic'),
         ('4', 'overline'),
         ('2', 'regular'),
         ('d', 'italic'),
         ), {'itnumber': 122, 'crystal_system': 'tetragonal', 'short-hm': 'I-42d', 'is_reference': True},
    ),
    'P 4/m m m'   : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 123, 'crystal_system': 'tetragonal', 'short-hm': 'P4/mmm', 'is_reference': True},
    ),
    'P 4/m c c'   : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 124, 'crystal_system': 'tetragonal', 'short-hm': 'P4/mcc', 'is_reference': True},
    ),
    'P 4/n b m:1' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 125, 'crystal_system': 'tetragonal', 'short-hm': 'P4/nbm', 'is_reference': False},
    ),
    'P 4/n b m:2' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 125, 'crystal_system': 'tetragonal', 'short-hm': 'P4/nbm', 'is_reference': True},
    ),
    'P 4/n n c:1' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 126, 'crystal_system': 'tetragonal', 'short-hm': 'P4/nnc', 'is_reference': False},
    ),
    'P 4/n n c:2' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 126, 'crystal_system': 'tetragonal', 'short-hm': 'P4/nnc', 'is_reference': True},
    ),
    'P 4/m b m'   : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('b', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 127, 'crystal_system': 'tetragonal', 'short-hm': 'P4/mbm', 'is_reference': True},
    ),
    'P 4/m n c'   : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 128, 'crystal_system': 'tetragonal', 'short-hm': 'P4/mnc', 'is_reference': True},
    ),
    'P 4/n m m:1' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 129, 'crystal_system': 'tetragonal', 'short-hm': 'P4/nmm', 'is_reference': False},
    ),
    'P 4/n m m:2' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 129, 'crystal_system': 'tetragonal', 'short-hm': 'P4/nmm', 'is_reference': True},
    ),
    'P 4/n c c:1' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 130, 'crystal_system': 'tetragonal', 'short-hm': 'P4/ncc', 'is_reference': False},
    ),
    'P 4/n c c:2' : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 130, 'crystal_system': 'tetragonal', 'short-hm': 'P4/ncc', 'is_reference': True},
    ),
    'P 42/m m c'  : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 131, 'crystal_system': 'tetragonal', 'short-hm': 'P42/mmc', 'is_reference': True},
    ),
    'P 42/m c m'  : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 132, 'crystal_system': 'tetragonal', 'short-hm': 'P42/mcm', 'is_reference': True},
    ),
    'P 42/n b c:1': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 133, 'crystal_system': 'tetragonal', 'short-hm': 'P42/nbc', 'is_reference': False},
    ),
    'P 42/n b c:2': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 133, 'crystal_system': 'tetragonal', 'short-hm': 'P42/nbc', 'is_reference': True},
    ),
    'P 42/n n m:1': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 134, 'crystal_system': 'tetragonal', 'short-hm': 'P42/nnm', 'is_reference': False},
    ),
    'P 42/n n m:2': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 134, 'crystal_system': 'tetragonal', 'short-hm': 'P42/nnm', 'is_reference': True},
    ),
    'P 42/m b c'  : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('b', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 135, 'crystal_system': 'tetragonal', 'short-hm': 'P42/mbc', 'is_reference': True},
    ),
    'P 42/m n m'  : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('n', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 136, 'crystal_system': 'tetragonal', 'short-hm': 'P42/mnm', 'is_reference': True},
    ),
    'P 42/n m c:1': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 137, 'crystal_system': 'tetragonal', 'short-hm': 'P42/nmc', 'is_reference': False},
    ),
    'P 42/n m c:2': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 137, 'crystal_system': 'tetragonal', 'short-hm': 'P42/nmc', 'is_reference': True},
    ),
    'P 42/n c m:1': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 138, 'crystal_system': 'tetragonal', 'short-hm': 'P42/ncm', 'is_reference': False},
    ),
    'P 42/n c m:2': (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('/', 'regular'),
         ('n', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 138, 'crystal_system': 'tetragonal', 'short-hm': 'P42/ncm', 'is_reference': True},
    ),
    'I 4/m m m'   : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 139, 'crystal_system': 'tetragonal', 'short-hm': 'I4/mmm', 'is_reference': True},
    ),
    'I 4/m c m'   : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 140, 'crystal_system': 'tetragonal', 'short-hm': 'I4/mcm', 'is_reference': True},
    ),
    'I 41/a m d:1': (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ('m', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 141, 'crystal_system': 'tetragonal', 'short-hm': 'I41/amd', 'is_reference': False},
    ),
    'I 41/a m d:2': (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ('m', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 141, 'crystal_system': 'tetragonal', 'short-hm': 'I41/amd', 'is_reference': True},
    ),
    'I 41/a c d:1': (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ('c', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 142, 'crystal_system': 'tetragonal', 'short-hm': 'I41/acd', 'is_reference': False},
    ),
    'I 41/a c d:2': (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('/', 'regular'),
         ('a', 'italic'),
         ('c', 'italic'),
         ('d', 'italic'),
         ), {'itnumber': 142, 'crystal_system': 'tetragonal', 'short-hm': 'I41/acd', 'is_reference': True},
    ),
    'P 3'         : (
        (('P', 'italic'),
         ('3', 'regular'),
         ), {'itnumber': 143, 'crystal_system': 'trigonal', 'short-hm': 'P3', 'is_reference': True},
    ),
    'P 31'        : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 144, 'crystal_system': 'trigonal', 'short-hm': 'P31', 'is_reference': True},
    ),
    'P 32'        : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('2', 'sub'),
         ), {'itnumber': 145, 'crystal_system': 'trigonal', 'short-hm': 'P32', 'is_reference': True},
    ),
    'R 3:H'       : (
        (('R', 'italic'),
         ('3', 'regular'),
         (':', 'regular'),
         ('H', 'italic'),
         ), {'itnumber': 146, 'crystal_system': 'trigonal', 'short-hm': 'H3', 'is_reference': True},
    ),
    'R 3:R'       : (
        (('R', 'italic'),
         ('3', 'regular'),
         ), {'itnumber': 146, 'crystal_system': 'trigonal', 'short-hm': 'R3', 'is_reference': False},
    ),
    'P -3'        : (
        (('P', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 147, 'crystal_system': 'trigonal', 'short-hm': 'P-3', 'is_reference': True},
    ),
    'R -3:H'      : (
        (('R', 'italic'),
         (3, 'overline'),
         (':', 'regular'),
         ('H', 'italic'),
         ), {'itnumber': 148, 'crystal_system': 'trigonal', 'short-hm': 'H-3', 'is_reference': True},
    ),
    'R -3:R'      : (
        (('R', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 148, 'crystal_system': 'trigonal', 'short-hm': 'R-3', 'is_reference': False},
    ),
    'P 3 1 2'     : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 149, 'crystal_system': 'trigonal', 'short-hm': 'P312', 'is_reference': True},
    ),
    'P 3 2 1'     : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('2', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 150, 'crystal_system': 'trigonal', 'short-hm': 'P321', 'is_reference': True},
    ),
    'P 31 1 2'    : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('1', 'sub'),
         ('1', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 151, 'crystal_system': 'trigonal', 'short-hm': 'P3112', 'is_reference': True},
    ),
    'P 31 2 1'    : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 152, 'crystal_system': 'trigonal', 'short-hm': 'P3121', 'is_reference': True},
    ),
    'P 32 1 2'    : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('2', 'sub'),
         ('1', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 153, 'crystal_system': 'trigonal', 'short-hm': 'P3212', 'is_reference': True},
    ),
    'P 32 2 1'    : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('2', 'sub'),
         ('2', 'regular'),
         ('1', 'regular'),
         ), {'itnumber': 154, 'crystal_system': 'trigonal', 'short-hm': 'P3221', 'is_reference': True},
    ),
    'R 3 2:H'     : (
        (('R', 'italic'),
         ('3', 'regular'),
         ('2', 'regular'),
         (':', 'regular'),
         ('H', 'italic'),
         ), {'itnumber': 155, 'crystal_system': 'trigonal', 'short-hm': 'H32', 'is_reference': True},
    ),
    'R 3 2:R'     : (
        (('R', 'italic'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 155, 'crystal_system': 'trigonal', 'short-hm': 'R32', 'is_reference': False},
    ),
    'P 3 m 1'     : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('m', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 156, 'crystal_system': 'trigonal', 'short-hm': 'P3m1', 'is_reference': True},
    ),
    'P 3 1 m'     : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('1', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 157, 'crystal_system': 'trigonal', 'short-hm': 'P31m', 'is_reference': True},
    ),
    'P 3 c 1'     : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('c', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 158, 'crystal_system': 'trigonal', 'short-hm': 'P3c1', 'is_reference': True},
    ),
    'P 3 1 c'     : (
        (('P', 'italic'),
         ('3', 'regular'),
         ('1', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 159, 'crystal_system': 'trigonal', 'short-hm': 'P31c', 'is_reference': True},
    ),
    'R 3 m:H'     : (
        (('R', 'italic'),
         ('3', 'regular'),
         ('m', 'italic'),
         (':', 'regular'),
         ('H', 'italic'),
         ), {'itnumber': 160, 'crystal_system': 'trigonal', 'short-hm': 'H3m', 'is_reference': True},
    ),
    'R 3 m:R'     : (
        (('R', 'italic'),
         ('3', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 160, 'crystal_system': 'trigonal', 'short-hm': 'R3m', 'is_reference': False},
    ),
    'R 3 c:H'     : (
        (('R', 'italic'),
         ('3', 'regular'),
         ('c', 'italic'),
         (':', 'regular'),
         ('H', 'italic'),
         ), {'itnumber': 161, 'crystal_system': 'trigonal', 'short-hm': 'H3c', 'is_reference': True},
    ),
    'R 3 c:R'     : (
        (('R', 'italic'),
         ('3', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 161, 'crystal_system': 'trigonal', 'short-hm': 'R3c', 'is_reference': False},
    ),
    'P -3 1 m'    : (
        (('P', 'italic'),
         ('3', 'overline'),
         ('1', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 162, 'crystal_system': 'trigonal', 'short-hm': 'P-31m', 'is_reference': True},
    ),
    'P -3 1 c'    : (
        (('P', 'italic'),
         ('3', 'overline'),
         ('1', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 163, 'crystal_system': 'trigonal', 'short-hm': 'P-31c', 'is_reference': True},
    ),
    'P -3 m 1'    : (
        (('P', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 164, 'crystal_system': 'trigonal', 'short-hm': 'P-3m1', 'is_reference': True},
    ),
    'P -3 c 1'    : (
        (('P', 'italic'),
         ('3', 'overline'),
         ('c', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 165, 'crystal_system': 'trigonal', 'short-hm': 'P-3c1', 'is_reference': True},
    ),
    'R -3 m:H'    : (
        (('R', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         (':', 'regular'),
         ('H', 'italic'),
         ), {'itnumber': 166, 'crystal_system': 'trigonal', 'short-hm': 'H-3m', 'is_reference': True},
    ),
    'R -3 m:R'    : (
        (('R', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 166, 'crystal_system': 'trigonal', 'short-hm': 'R-3m', 'is_reference': False},
    ),
    'R -3 c:H'    : (
        (('R', 'italic'),
         ('3', 'overline'),
         ('c', 'italic'),
         (':', 'regular'),
         ('H', 'italic'),
         ), {'itnumber': 167, 'crystal_system': 'trigonal', 'short-hm': 'H-3c', 'is_reference': True},
    ),
    'R -3 c:R'    : (
        (('R', 'italic'),
         ('3', 'overline'),
         ('c', 'italic'),
         ), {'itnumber': 167, 'crystal_system': 'trigonal', 'short-hm': 'R-3c', 'is_reference': False},
    ),
    'P 6'         : (
        (('P', 'italic'),
         ('6', 'regular'),
         ), {'itnumber': 168, 'crystal_system': 'hexagonal', 'short-hm': 'P6', 'is_reference': True},
    ),
    'P 61'        : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 169, 'crystal_system': 'hexagonal', 'short-hm': 'P61', 'is_reference': True},
    ),
    'P 65'        : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('5', 'sub'),
         ), {'itnumber': 170, 'crystal_system': 'hexagonal', 'short-hm': 'P65', 'is_reference': True},
    ),
    'P 62'        : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('2', 'sub'),
         ), {'itnumber': 171, 'crystal_system': 'hexagonal', 'short-hm': 'P62', 'is_reference': True},
    ),
    'P 64'        : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('4', 'sub'),
         ), {'itnumber': 172, 'crystal_system': 'hexagonal', 'short-hm': 'P64', 'is_reference': True},
    ),
    'P 63'        : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('3', 'sub'),
         ), {'itnumber': 173, 'crystal_system': 'hexagonal', 'short-hm': 'P63', 'is_reference': True},
    ),
    'P -6'        : (
        (('P', 'italic'),
         ('6', 'overline'),
         ), {'itnumber': 174, 'crystal_system': 'hexagonal', 'short-hm': 'P-6', 'is_reference': True},
    ),
    'P 6/m'       : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 175, 'crystal_system': 'hexagonal', 'short-hm': 'P6/m', 'is_reference': True},
    ),
    'P 63/m'      : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('3', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 176, 'crystal_system': 'hexagonal', 'short-hm': 'P63/m', 'is_reference': True},
    ),
    'P 6 2 2'     : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 177, 'crystal_system': 'hexagonal', 'short-hm': 'P622', 'is_reference': True},
    ),
    'P 61 2 2'    : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 178, 'crystal_system': 'hexagonal', 'short-hm': 'P6122', 'is_reference': True},
    ),
    'P 65 2 2'    : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('5', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 179, 'crystal_system': 'hexagonal', 'short-hm': 'P6522', 'is_reference': True},
    ),
    'P 62 2 2'    : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('2', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 180, 'crystal_system': 'hexagonal', 'short-hm': 'P6222', 'is_reference': True},
    ),
    'P 64 2 2'    : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('4', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 181, 'crystal_system': 'hexagonal', 'short-hm': 'P6422', 'is_reference': True},
    ),
    'P 63 2 2'    : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('3', 'sub'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 182, 'crystal_system': 'hexagonal', 'short-hm': 'P6322', 'is_reference': True},
    ),
    'P 6 m m'     : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 183, 'crystal_system': 'hexagonal', 'short-hm': 'P6mm', 'is_reference': True},
    ),
    'P 6 c c'     : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('c', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 184, 'crystal_system': 'hexagonal', 'short-hm': 'P6cc', 'is_reference': True},
    ),
    'P 63 c m'    : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('3', 'sub'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 185, 'crystal_system': 'hexagonal', 'short-hm': 'P63cm', 'is_reference': True},
    ),
    'P 63 m c'    : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('3', 'sub'),
         ('m', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 186, 'crystal_system': 'hexagonal', 'short-hm': 'P63mc', 'is_reference': True},
    ),
    'P -6 m 2'    : (
        (('P', 'italic'),
         ('6', 'overline'),
         ('m', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 187, 'crystal_system': 'hexagonal', 'short-hm': 'P-6m2', 'is_reference': True},
    ),
    'P -6 c 2'    : (
        (('P', 'italic'),
         ('6', 'overline'),
         ('c', 'italic'),
         ('2', 'regular'),
         ), {'itnumber': 188, 'crystal_system': 'hexagonal', 'short-hm': 'P-6c2', 'is_reference': True},
    ),
    'P -6 2 m'    : (
        (('P', 'italic'),
         ('6', 'overline'),
         ('2', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 189, 'crystal_system': 'hexagonal', 'short-hm': 'P-62m', 'is_reference': True},
    ),
    'P -6 2 c'    : (
        (('P', 'italic'),
         ('6', 'overline'),
         ('2', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 190, 'crystal_system': 'hexagonal', 'short-hm': 'P-62c', 'is_reference': True},
    ),
    'P 6/m m m'   : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 191, 'crystal_system': 'hexagonal', 'short-hm': 'P6/mmm', 'is_reference': True},
    ),
    'P 6/m c c'   : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 192, 'crystal_system': 'hexagonal', 'short-hm': 'P6/mcc', 'is_reference': True},
    ),
    'P 63/m c m'  : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('3', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('c', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 193, 'crystal_system': 'hexagonal', 'short-hm': 'P63/mcm', 'is_reference': True},
    ),
    'P 63/m m c'  : (
        (('P', 'italic'),
         ('6', 'regular'),
         ('3', 'sub'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('c', 'italic'),
         ), {'itnumber': 194, 'crystal_system': 'hexagonal', 'short-hm': 'P63/mmc', 'is_reference': True},
    ),
    'P 2 3'       : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('3', 'regular'),
         ), {'itnumber': 195, 'crystal_system': 'cubic', 'short-hm': 'P23', 'is_reference': True},
    ),
    'F 2 3'       : (
        (('F', 'italic'),
         ('2', 'regular'),
         ('3', 'regular'),
         ), {'itnumber': 196, 'crystal_system': 'cubic', 'short-hm': 'F23', 'is_reference': True},
    ),
    'I 2 3'       : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('3', 'regular'),
         ), {'itnumber': 197, 'crystal_system': 'cubic', 'short-hm': 'I23', 'is_reference': True},
    ),
    'P 21 3'      : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('3', 'regular'),
         ), {'itnumber': 198, 'crystal_system': 'cubic', 'short-hm': 'P213', 'is_reference': True},
    ),
    'I 21 3'      : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('3', 'regular'),
         ), {'itnumber': 199, 'crystal_system': 'cubic', 'short-hm': 'I213', 'is_reference': True},
    ),
    'P m -3'      : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 200, 'crystal_system': 'cubic', 'short-hm': 'Pm-3', 'is_reference': True},
    ),
    'P n -3:1'    : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 201, 'crystal_system': 'cubic', 'short-hm': 'Pn-3', 'is_reference': False},
    ),
    'P n -3:2'    : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 201, 'crystal_system': 'cubic', 'short-hm': 'Pn-3', 'is_reference': True},
    ),
    'F m -3'      : (
        (('F', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 202, 'crystal_system': 'cubic', 'short-hm': 'Fm-3', 'is_reference': True},
    ),
    'F d -3:1'    : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 203, 'crystal_system': 'cubic', 'short-hm': 'Fd-3', 'is_reference': False},
    ),
    'F d -3:2'    : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 203, 'crystal_system': 'cubic', 'short-hm': 'Fd-3', 'is_reference': True},
    ),
    'I m -3'      : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 204, 'crystal_system': 'cubic', 'short-hm': 'Im-3', 'is_reference': True},
    ),
    'P a -3'      : (
        (('P', 'italic'),
         ('a', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 205, 'crystal_system': 'cubic', 'short-hm': 'Pa-3', 'is_reference': True},
    ),
    'I a -3'      : (
        (('I', 'italic'),
         ('a', 'italic'),
         ('3', 'overline'),
         ), {'itnumber': 206, 'crystal_system': 'cubic', 'short-hm': 'Ia-3', 'is_reference': True},
    ),
    'P 4 3 2'     : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 207, 'crystal_system': 'cubic', 'short-hm': 'P432', 'is_reference': True},
    ),
    'P 42 3 2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 208, 'crystal_system': 'cubic', 'short-hm': 'P4232', 'is_reference': True},
    ),
    'F 4 3 2'     : (
        (('F', 'italic'),
         ('4', 'regular'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 209, 'crystal_system': 'cubic', 'short-hm': 'F432', 'is_reference': True},
    ),
    'F 41 3 2'    : (
        (('F', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 210, 'crystal_system': 'cubic', 'short-hm': 'F4132', 'is_reference': True},
    ),
    'I 4 3 2'     : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 211, 'crystal_system': 'cubic', 'short-hm': 'I432', 'is_reference': True},
    ),
    'P 43 3 2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('3', 'sub'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 212, 'crystal_system': 'cubic', 'short-hm': 'P4332', 'is_reference': True},
    ),
    'P 41 3 2'    : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 213, 'crystal_system': 'cubic', 'short-hm': 'P4132', 'is_reference': True},
    ),
    'I 41 3 2'    : (
        (('I', 'italic'),
         ('4', 'regular'),
         ('1', 'sub'),
         ('3', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 214, 'crystal_system': 'cubic', 'short-hm': 'I4132', 'is_reference': True},
    ),
    'P -4 3 m'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('3', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 215, 'crystal_system': 'cubic', 'short-hm': 'P-43m', 'is_reference': True},
    ),
    'F -4 3 m'    : (
        (('F', 'italic'),
         ('4', 'overline'),
         ('3', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 216, 'crystal_system': 'cubic', 'short-hm': 'F-43m', 'is_reference': True},
    ),
    'I -4 3 m'    : (
        (('I', 'italic'),
         ('4', 'overline'),
         ('3', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 217, 'crystal_system': 'cubic', 'short-hm': 'I-43m', 'is_reference': True},
    ),
    'P -4 3 n'    : (
        (('P', 'italic'),
         ('4', 'overline'),
         ('3', 'regular'),
         ('n', 'italic'),
         ), {'itnumber': 218, 'crystal_system': 'cubic', 'short-hm': 'P-43n', 'is_reference': True},
    ),
    'F -4 3 c'    : (
        (('F', 'italic'),
         ('4', 'overline'),
         ('3', 'regular'),
         ('c', 'italic'),
         ), {'itnumber': 219, 'crystal_system': 'cubic', 'short-hm': 'F-43c', 'is_reference': True},
    ),
    'I -4 3 d'    : (
        (('I', 'italic'),
         ('4', 'overline'),
         ('3', 'regular'),
         ('d', 'italic'),
         ), {'itnumber': 220, 'crystal_system': 'cubic', 'short-hm': 'I-43d', 'is_reference': True},
    ),
    'P m -3 m'    : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 221, 'crystal_system': 'cubic', 'short-hm': 'Pm-3m', 'is_reference': True},
    ),
    'P n -3 n:1'  : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('3', 'overline'),
         ('n', 'italic'),
         ), {'itnumber': 222, 'crystal_system': 'cubic', 'short-hm': 'Pn-3n', 'is_reference': False},
    ),
    'P n -3 n:2'  : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('3', 'overline'),
         ('n', 'italic'),
         ), {'itnumber': 222, 'crystal_system': 'cubic', 'short-hm': 'Pn-3n', 'is_reference': True},
    ),
    'P m -3 n'    : (
        (('P', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ('n', 'italic'),
         ), {'itnumber': 223, 'crystal_system': 'cubic', 'short-hm': 'Pm-3n', 'is_reference': True},
    ),
    'P n -3 m:1'  : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 224, 'crystal_system': 'cubic', 'short-hm': 'Pn-3m', 'is_reference': False},
    ),
    'P n -3 m:2'  : (
        (('P', 'italic'),
         ('n', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 224, 'crystal_system': 'cubic', 'short-hm': 'Pn-3m', 'is_reference': True},
    ),
    'F m -3 m'    : (
        (('F', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 225, 'crystal_system': 'cubic', 'short-hm': 'Fm-3m', 'is_reference': True},
    ),
    'F m -3 c'    : (
        (('F', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ('c', 'italic'),
         ), {'itnumber': 226, 'crystal_system': 'cubic', 'short-hm': 'Fm-3c', 'is_reference': True},
    ),
    'F d -3 m:1'  : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 227, 'crystal_system': 'cubic', 'short-hm': 'Fd-3m', 'is_reference': False},
    ),
    'F d -3 m:2'  : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 227, 'crystal_system': 'cubic', 'short-hm': 'Fd-3m', 'is_reference': True},
    ),
    'F d -3 c:1'  : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('3', 'overline'),
         ('c', 'italic'),
         ), {'itnumber': 228, 'crystal_system': 'cubic', 'short-hm': 'Fd-3c', 'is_reference': False},
    ),
    'F d -3 c:2'  : (
        (('F', 'italic'),
         ('d', 'italic'),
         ('3', 'overline'),
         ('c', 'italic'),
         ), {'itnumber': 228, 'crystal_system': 'cubic', 'short-hm': 'Fd-3c', 'is_reference': True},
    ),
    'I m -3 m'    : (
        (('I', 'italic'),
         ('m', 'italic'),
         ('3', 'overline'),
         ('m', 'italic'),
         ), {'itnumber': 229, 'crystal_system': 'cubic', 'short-hm': 'Im-3m', 'is_reference': True},
    ),
    'I a -3 d'    : (
        (('I', 'italic'),
         ('a', 'italic'),
         ('3', 'overline'),
         ('d', 'italic'),
         ), {'itnumber': 230, 'crystal_system': 'cubic', 'short-hm': 'Ia-3d', 'is_reference': True},
    ),
    'I 1 21 1'    : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'I21', 'is_reference': False},
    ),
    'C 1 21 1'    : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 5, 'crystal_system': 'monoclinic', 'short-hm': 'C21', 'is_reference': False},
    ),
    'P 21212(a)'  : (
        (('P', 'italic'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2(a)', 'regular'),
         ), {'itnumber': 18, 'crystal_system': 'orthorhombic', 'short-hm': 'P21212(a)', 'is_reference': False},
    ),
    'C 2 2 21a)'  : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('a', 'italic'),
         (')', 'regular'),
         ), {'itnumber': 20, 'crystal_system': 'orthorhombic', 'short-hm': 'C2221a)', 'is_reference': False},
    ),
    'C 2 2 2a'    : (
        (('C', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 21, 'crystal_system': 'orthorhombic', 'short-hm': 'C222a', 'is_reference': False},
    ),
    'F 2 2 2a'    : (
        (('F', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 22, 'crystal_system': 'orthorhombic', 'short-hm': 'F222a', 'is_reference': False},
    ),
    'I 2 2 2a'    : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 23, 'crystal_system': 'orthorhombic', 'short-hm': 'I222a', 'is_reference': False},
    ),
    'P 42 21 2a'  : (
        (('P', 'italic'),
         ('4', 'regular'),
         ('2', 'sub'),
         ('2', 'regular'),
         ('1', 'sub'),
         ('2', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 94, 'crystal_system': 'tetragonal', 'short-hm': 'P42212a', 'is_reference': False},
    ),
    'I 2 3a'      : (
        (('I', 'italic'),
         ('2', 'regular'),
         ('3', 'regular'),
         ('a', 'italic'),
         ), {'itnumber': 197, 'crystal_system': 'cubic', 'short-hm': 'I23a', 'is_reference': False},
    ),
    'A 1'         : (
        (('A', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 1, 'crystal_system': 'triclinic', 'short-hm': 'A1', 'is_reference': False},
    ),
    'B 1'         : (
        (('B', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 1, 'crystal_system': 'triclinic', 'short-hm': 'B1', 'is_reference': False},
    ),
    'C 1'         : (
        (('C', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 1, 'crystal_system': 'triclinic', 'short-hm': 'C1', 'is_reference': False},
    ),
    'F 1'         : (
        (('F', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 1, 'crystal_system': 'triclinic', 'short-hm': 'F1', 'is_reference': False},
    ),
    'I 1'         : (
        (('I', 'italic'),
         ('1', 'regular'),
         ), {'itnumber': 1, 'crystal_system': 'triclinic', 'short-hm': 'I1', 'is_reference': False},
    ),
    'A -1'        : (
        (('A', 'italic'),
         ('1', 'overline'),
         ), {'itnumber': 2, 'crystal_system': 'triclinic', 'short-hm': 'A-1', 'is_reference': False},
    ),
    'B -1'        : (
        (('B', 'italic'),
         ('1', 'overline'),
         ), {'itnumber': 2, 'crystal_system': 'triclinic', 'short-hm': 'B-1', 'is_reference': False},
    ),
    'C -1'        : (
        (('C', 'italic'),
         ('1', 'overline'),
         ), {'itnumber': 2, 'crystal_system': 'triclinic', 'short-hm': 'C-1', 'is_reference': False},
    ),
    'F -1'        : (
        (('F', 'italic'),
         ('1', 'overline'),
         ), {'itnumber': 2, 'crystal_system': 'triclinic', 'short-hm': 'F-1', 'is_reference': False},
    ),
    'I -1'        : (
        (('I', 'italic'),
         ('1', 'overline'),
         ), {'itnumber': 2, 'crystal_system': 'triclinic', 'short-hm': 'I-1', 'is_reference': False},
    ),
    'C 1 1 21'    : (
        (('C', 'italic'),
         ('1', 'regular'),
         ('1', 'regular'),
         ('2', 'regular'),
         ('1', 'sub'),
         ), {'itnumber': 4, 'crystal_system': 'monoclinic', 'short-hm': 'C1121', 'is_reference': False},
    ),
    'F 1 2/m 1'   : (
        (('F', 'italic'),
         ('2', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ), {'itnumber': 12, 'crystal_system': 'monoclinic', 'short-hm': 'F2/m', 'is_reference': False},
    ),
    'A b a m'     : (
        (('A', 'italic'),
         ('b', 'italic'),
         ('a', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 64, 'crystal_system': 'orthorhombic', 'short-hm': 'Abam', 'is_reference': False},
    ),
    'C -4 2 b'    : (
        (('C', 'italic'),
         ('4', 'overline'),
         ('2', 'regular'),
         ('b', 'italic'),
         ), {'itnumber': 117, 'crystal_system': 'tetragonal', 'short-hm': 'C-42b', 'is_reference': False},
    ),
    'F 4 2 2'     : (
        (('F', 'italic'),
         ('4', 'regular'),
         ('2', 'regular'),
         ('2', 'regular'),
         ), {'itnumber': 97, 'crystal_system': 'tetragonal', 'short-hm': 'F422', 'is_reference': False},
    ),
    'F 4/m m m'   : (
        (('F', 'italic'),
         ('4', 'regular'),
         ('/', 'regular'),
         ('m', 'italic'),
         ('m', 'italic'),
         ('m', 'italic'),
         ), {'itnumber': 139, 'crystal_system': 'tetragonal', 'short-hm': 'F4/mmm', 'is_reference': False},
    ),

}
