/* A very simplistic .mol (or .sdf) writer */

/* A mol file contains no unit cell -- it is for molecules
 * and the entries on each line need to be in precisely the correct column,
 * so the format strings are very important
 *
 * This writer writes the V2000 format only
 */

#include<stdio.h>

#include "c2xsf.h"

void mol_write(FILE* outfile, struct contents *m){
  int i;
  
  if (m->title)
    fprintf(outfile,"%s\n",m->title);
  else
    fprintf(outfile,"\n");

  fprintf(outfile,"\n\n");

  if (m->n>999) error_exit("Too many atoms for .mol output");
  if (m->n<1) error_exit("No atoms for .mol output");

  fprintf(outfile,"%3d  0  0  0  0  0  0  0  0  0999 V2000\n",m->n);

  for(i=0;i<m->n;i++){
    fprintf(outfile,"%10.4f%10.4f%10.4f %-3s\n",m->atoms[i].abs[0],
	    m->atoms[i].abs[1],m->atoms[i].abs[2],atno2sym(m->atoms[i].atno));
  }

  fprintf(outfile,"M  END\n");
}
