/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/TextF.h>

#define shared_IMPORT
#include "shared.h"

#include "dialog.h"
#include "gutil.h"
#include "gutil1.h"
#include "edit.h"
#include "io.h"


void SetCursor (int id)
{

	Cursor cursor;

	switch (id) {

	case CURSOR_POINT:
		cursor = cursors[CURSOR_POINT];
		break;

	case CURSOR_POLY_PLANE:
		cursor = cursors[CURSOR_POLY];
		break;

	case CURSOR_CIRCLE:
	case CURSOR_POLY:
		cursor = cursors[CURSOR_POLY];
		break;

	case CURSOR_ORIGIN:
		cursor = cursors[CURSOR_ORIGIN];
		break;

	case CURSOR_MARKER:
		cursor = cursors[CURSOR_MARKER];
		break;
	}

	XDefineCursor (XtDisplay(twindow), XtWindow(twindow), cursor);
	XDefineCursor (XtDisplay(bwindow), XtWindow(bwindow), cursor);
}


void
MenuCB (Widget w, void *client_data, void *call_data)
{

	int     menu_id = shared_PtrToInt(client_data);
	Boolean         value;
	VPoint          extent;
	XmString        string;
	char            s[64], *factor_s;
	double          factor;

	if (menu_id >= MENU_MARKER && menu_id < MENU_MARKER+32) {
		current_marker = menu_id - MENU_MARKER;
		if (marker_list[current_marker].defined)
			DisplayPoint(&marker_list[current_marker].location);
		SetCursor (CURSOR_MARKER);
		edit_state = STATE_MARKER;
		return;
	}

	switch (menu_id) {

	case MENU_MIRROR_XZ:
	case MENU_MIRROR_XY:
	case MENU_MIRROR_YZ:
		Mirror (menu_id);
		break;

	case MENU_CLEAR:
		ClearSelection();
		break;

	case MENU_COPY:
		CopySelection();
		break;

	case MENU_PASTE:
		PasteSelection();
		break;

	case MENU_ROTATE_X:
		RotateXSelection();
		break;

	case MENU_SAVE:
		if (filename_valid)
			WriteGeditFile (filename);
		else
			XtManageChild (save_as_dialog);
		break;

	case MENU_GRID:
		XtVaGetValues (w,
			XmNset, &value,
			NULL);

		if (value != app_data.show_grid) {
			app_data.show_grid = value;
			DrawWidget (twindow, False);
			DrawWidget (bwindow, False);
		}
		else {
			app_data.show_grid = value;
		}
		break;

	case MENU_RULER:
		XtVaGetValues (w,
			XmNset, &value,
			NULL);

		if (value != app_data.show_ruler) {
			app_data.show_ruler = value;
			DrawWidget (twindow, False);
			DrawWidget (bwindow, False);
		}
		else {
			app_data.show_ruler = value;
		}
		break;

	case MENU_OPEN:
		XtManageChild (open_dialog);
		break;

	case MENU_SAVE_AS:
		XtManageChild (save_as_dialog);
		break;

	case MENU_SET_VIEWS:
		XtManageChild (set_views_dialog);
		break;

	case MENU_SET_VIEWS_COMPLETE:
		switch (desired_view) {

		case VIEW_LEFT_TOP:
			t_info.layout = VL_NXZ;
			b_info.layout = VL_NXNY;
			break;

		case VIEW_FRONT_TOP:
			t_info.layout = VL_NYZ;
			b_info.layout = VL_NYX;
			break;
		}

		RescaleView (twindow, 1.0);
		XtUnmanageChild (set_views_dialog);
		break;

	case MENU_SET_VIEWS_CANCEL:
		XtUnmanageChild (set_views_dialog);
		break;

	case MENU_RESCALE:
		DetermineObjectExtent (&extent);

		sprintf (s, "   %s :   %f", "X", extent.x);
		string = XmStringCreateSimple(s);
		XtVaSetValues (extent_x,
			XmNlabelString, string,
			NULL);
		XmStringFree (string);

		sprintf (s, "   %s :   %f", "Y", extent.y);
		string = XmStringCreateSimple(s);
		XtVaSetValues (extent_y,
			XmNlabelString, string,
			NULL);
		XmStringFree (string);

		sprintf (s, "   %s :   %f", "Z", extent.z);
		string = XmStringCreateSimple(s);
		XtVaSetValues (extent_z,
			XmNlabelString, string,
			NULL);
		XmStringFree (string);

		XtManageChild (rescale_dialog);
		break;

	case MENU_RESCALE_APPLY:
		factor_s = XmTextFieldGetString (rescale_field);
		factor = atof(factor_s);
		if (factor != 0.0)
			RescaleObject (factor);
		break;

	case MENU_RESCALE_CANCEL:
		XtUnmanageChild (rescale_dialog);
		break;
		
	case MENU_GEAR:
		XtManageChild (gear_dialog);
		break;

	case MENU_GEAR_CANCEL:
		GetCraftInfo (&c);
		XtUnmanageChild (gear_dialog);
		break;

	case MENU_GEAR_CALCULATE:
		GearCalculate (&c);
		GetCraftInfo (&c);
		break;

	case MENU_INFO:
		XtManageChild (info_dialog);
		break;

	case MENU_INFO_CANCEL:
		GetCraftInfo (&c);
		XtUnmanageChild (info_dialog);
		break;

	case MENU_INFO_CALCULATE:
		GetCraftInfo (&c);
		break;

	case MENU_DERIV:
		XtManageChild (deriv_dialog);
		break;

	case MENU_DERIV_CANCEL:
		GetCraftInfo (&c);
		XtUnmanageChild (deriv_dialog);
		break;

	case MENU_DERIV_CALCULATE:
		GetCraftInfo (&c);
		break;

	case MENU_PWR:
		XtManageChild (powerplant_dialog);
		break;

	case MENU_PWR_CANCEL:
		GetCraftInfo (&c);
		XtUnmanageChild (powerplant_dialog);
		break;

	case MENU_PWR_CALCULATE:
		GetCraftInfo (&c);
		break;
	}

}