#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sticky Business
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251013.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='sticky-business'
GAME_NAME='Sticky Business'

ARCHIVE_BASE_1_NAME='setup_sticky_business_2025.159a_(64bit)_(83289).exe'
ARCHIVE_BASE_1_MD5='22e369b7c4c88054d3f694b2a0792f15'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='199097'
ARCHIVE_BASE_1_VERSION='2025.159a-gog83289'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/sticky_business'

ARCHIVE_BASE_0_NAME='setup_sticky_business_2023.2084_(64bit)_(69872).exe'
ARCHIVE_BASE_0_MD5='9d32598a90429c8464f6e44fd721ef46'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='193345'
ARCHIVE_BASE_0_VERSION='2023.2084-gog69872'

UNITY3D_NAME='stickybusiness'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Spellgarden Games/Sticky Business'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
