/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

class SampleResponse {
    static final int ERROR_PAGE_RFC = 0;
    static final int ERROR_PAGE_NON_RFC = 1;
    static final int ERROR_PAGE_REDIRECT = 2;
    static final int ERROR_PAGE_STATIC = 3;
    static final int ERROR_PAGE_DYNAMIC_BUT_DETERMINISTIC = 4;
    static final int ERROR_PAGE_UNDETERMINISTIC = 5;
    private HistoryReference historyReference = null;
    private int errorPageType = 0;

    SampleResponse(HttpMessage message, int errorPageType) throws HttpMalformedHeaderException, DatabaseException {
        this.historyReference = SampleResponse.createHistoryReference(message);
        this.errorPageType = errorPageType;
    }

    public HttpMessage getMessage() throws HttpMalformedHeaderException, DatabaseException {
        return this.historyReference.getHttpMessage();
    }

    public void setMessage(HttpMessage message) throws HttpMalformedHeaderException, DatabaseException {
        this.historyReference = SampleResponse.createHistoryReference(message);
    }

    public int getErrorPageType() {
        return this.errorPageType;
    }

    public void setErrorPageType(int errorPageType) {
        this.errorPageType = errorPageType;
    }

    private static HistoryReference createHistoryReference(HttpMessage message) throws HttpMalformedHeaderException, DatabaseException {
        return new HistoryReference(Model.getSingleton().getSession(), 0, message);
    }
}

