/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.tomcat.util.http.FastHttpDateFormat;

public class ResponseIncludeWrapper
extends HttpServletResponseWrapper {
    private static final String LAST_MODIFIED = "last-modified";
    protected long lastModified = -1L;
    protected final ServletOutputStream captureServletOutputStream;
    protected ServletOutputStream servletOutputStream;
    protected PrintWriter printWriter;

    public ResponseIncludeWrapper(HttpServletResponse httpServletResponse, ServletOutputStream servletOutputStream) {
        super(httpServletResponse);
        this.captureServletOutputStream = servletOutputStream;
    }

    public void flushOutputStreamOrWriter() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public PrintWriter getWriter() throws IOException {
        if (this.servletOutputStream == null) {
            if (this.printWriter == null) {
                this.setCharacterEncoding(this.getCharacterEncoding());
                this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.captureServletOutputStream, this.getCharacterEncoding()));
            }
            return this.printWriter;
        }
        throw new IllegalStateException();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter == null) {
            if (this.servletOutputStream == null) {
                this.servletOutputStream = this.captureServletOutputStream;
            }
            return this.servletOutputStream;
        }
        throw new IllegalStateException();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void addDateHeader(String string, long l) {
        super.addDateHeader(string, l);
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals(LAST_MODIFIED)) {
            this.lastModified = l;
        }
    }

    public void addHeader(String string, String string2) {
        long l;
        super.addHeader(string, string2);
        String string3 = string.toLowerCase(Locale.ENGLISH);
        if (string3.equals(LAST_MODIFIED) && (l = FastHttpDateFormat.parseDate((String)string2)) != -1L) {
            this.lastModified = l;
        }
    }

    public void setDateHeader(String string, long l) {
        super.setDateHeader(string, l);
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals(LAST_MODIFIED)) {
            this.lastModified = l;
        }
    }

    public void setHeader(String string, String string2) {
        long l;
        super.setHeader(string, string2);
        String string3 = string.toLowerCase(Locale.ENGLISH);
        if (string3.equals(LAST_MODIFIED) && (l = FastHttpDateFormat.parseDate((String)string2)) != -1L) {
            this.lastModified = l;
        }
    }
}

