import ts from 'typescript';
import { CancellationToken, CompletionContext, Position, TextDocumentIdentifier, TextEdit } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { LSConfigManager } from '../../../ls-config';
import { AppCompletionItem, AppCompletionList, CompletionsProvider } from '../../interfaces';
import { SvelteDocumentSnapshot } from '../DocumentSnapshot';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
export interface CompletionResolveInfo extends Pick<ts.CompletionEntry, 'data' | 'name' | 'source'>, TextDocumentIdentifier {
    position: Position;
    __is_sveltekit$typeImport?: boolean;
    __is_custom_element?: boolean;
}
export declare class CompletionsProviderImpl implements CompletionsProvider<CompletionResolveInfo> {
    private readonly lsAndTsDocResolver;
    private readonly configManager;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, configManager: LSConfigManager);
    /**
     * The language service throws an error if the character is not a valid trigger character.
     * Also, the completions are worse.
     * Therefore, only use the characters the typescript compiler treats as valid.
     */
    private readonly validTriggerCharacters;
    private commitCharacters;
    /**
     * For performance reasons, try to reuse the last completion if possible.
     */
    private lastCompletion?;
    private isValidTriggerCharacter;
    getCompletions(document: Document, position: Position, completionContext?: CompletionContext, cancellationToken?: CancellationToken): Promise<AppCompletionList<CompletionResolveInfo> | null>;
    private getWordAtPosition;
    private mightBeAtStartTagWhitespace;
    private canReuseLastCompletion;
    private getExistingImports;
    private getEventAndSlotLetCompletions;
    private getCustomElementCompletions;
    private componentInfoToCompletionEntry;
    private getCompletionListForDirectiveOrProps;
    private toCompletionItem;
    private getCompletionLabelAndInsert;
    private getCommitCharactersOptions;
    private getCommitCharacters;
    private isExistingSvelteComponentImport;
    private fixTextEditRange;
    /**
     * TypeScript throws a debug assertion error if the importModuleSpecifierEnding config is
     * 'js' and there's an unknown file extension - which is the case for `.svelte`. Therefore
     * rewrite the importModuleSpecifierEnding for this case to silence the error.
     */
    fixUserPreferencesForSvelteComponentImport(userPreferences: ts.UserPreferences): ts.UserPreferences;
    resolveCompletion(document: Document, completionItem: AppCompletionItem<CompletionResolveInfo>, cancellationToken?: CancellationToken): Promise<AppCompletionItem<CompletionResolveInfo>>;
    private getCompletionDocument;
    private codeActionChangesToTextEdit;
    codeActionChangeToTextEdit(doc: Document, snapshot: SvelteDocumentSnapshot, change: ts.TextChange, isImport: boolean, originalTriggerPosition: Position, newLine: string, is$typeImport?: boolean, isCombinedCodeAction?: boolean): TextEdit;
    private mapRangeForNewImport;
    private offsetLinesAndMovetoStartOfLine;
    private fixImportNewText;
}
