/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.plugin;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.protege.editor.core.plugin.PluginExtensionMatcher;
import org.protege.editor.core.plugin.PluginUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginExtensionFilter {
    private final Logger logger = LoggerFactory.getLogger((String)PluginExtensionFilter.class.getName());
    private String pluginId;
    private String extensionPointId;
    private PluginExtensionMatcher extensionMatcher;

    public PluginExtensionFilter(String pluginId, String extensionPointId, PluginExtensionMatcher extensionMatcher) {
        this.pluginId = pluginId;
        this.extensionPointId = extensionPointId;
        this.extensionMatcher = extensionMatcher;
    }

    public Set<IExtension> getExtensions() {
        HashSet<IExtension> result = new HashSet<IExtension>();
        IExtensionRegistry registry = PluginUtilities.getInstance().getExtensionRegistry();
        IExtensionPoint extpt = registry.getExtensionPoint(this.pluginId, this.extensionPointId);
        if (extpt == null) {
            this.logger.warn("Extension point not defined: {}@{}", (Object)this.extensionPointId, (Object)this.pluginId);
            return Collections.emptySet();
        }
        IExtension[] extensions = extpt.getExtensions();
        if (extensions == null) {
            return Collections.emptySet();
        }
        for (IExtension ext : extensions) {
            if (!this.extensionMatcher.matches(ext)) continue;
            if (ext.getUniqueIdentifier() != null) {
                result.add(ext);
                continue;
            }
            this.logger.warn("No ID found for {} in bundle: {}", (Object)this.extensionPointId, (Object)ext.getContributor().getName());
        }
        return result;
    }
}

