/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class DirectionProcessor
implements ILayoutProcessor<TGraph> {
    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Process directions", 1.0f);
        Direction d = tGraph.getProperty(MrTreeOptions.DIRECTION);
        if (d != Direction.DOWN) {
            for (TNode n : tGraph.getNodes()) {
                int x = n.getProperty(InternalProperties.XCOOR);
                int y = n.getProperty(InternalProperties.YCOOR);
                switch (d) {
                    case UP: {
                        y *= -1;
                        break;
                    }
                    case RIGHT: {
                        int tmp = x;
                        x = y;
                        y = tmp;
                        break;
                    }
                    case LEFT: {
                        int tmp2 = x;
                        x = -y;
                        y = tmp2;
                    }
                }
                n.setProperty(InternalProperties.XCOOR, (Object)x);
                n.setProperty(InternalProperties.YCOOR, (Object)y);
            }
        }
        progressMonitor.done();
    }
}

