/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineClassesUtilsKt {
    @NotNull
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");

    @Nullable
    public static final ValueParameterDescriptor underlyingRepresentation(@NotNull ClassDescriptor $this$underlyingRepresentation) {
        List<ValueParameterDescriptor> list;
        Intrinsics.checkNotNullParameter((Object)$this$underlyingRepresentation, (String)"<this>");
        if (!InlineClassesUtilsKt.isInlineClass($this$underlyingRepresentation)) {
            return null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = $this$underlyingRepresentation.getUnsubstitutedPrimaryConstructor();
        return classConstructorDescriptor == null ? null : ((list = classConstructorDescriptor.getValueParameters()) == null ? null : (ValueParameterDescriptor)CollectionsKt.singleOrNull(list));
    }

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $this$isInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClass, (String)"<this>");
        return $this$isInlineClass instanceof ClassDescriptor && (((ClassDescriptor)$this$isInlineClass).isInline() || ((ClassDescriptor)$this$isInlineClass).isValue());
    }

    @Nullable
    public static final ValueParameterDescriptor unsubstitutedUnderlyingParameter(@NotNull KotlinType $this$unsubstitutedUnderlyingParameter) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$unsubstitutedUnderlyingParameter, (String)"<this>");
        ClassifierDescriptor $this$safeAs$iv = $this$unsubstitutedUnderlyingParameter.getConstructor().getDeclarationDescriptor();
        boolean $i$f$safeAs = false;
        ClassifierDescriptor classifierDescriptor = $this$safeAs$iv;
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (classDescriptor = (ClassDescriptor)classifierDescriptor) == null ? null : InlineClassesUtilsKt.underlyingRepresentation(classDescriptor);
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $this$isInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isInlineClassType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor == null ? false : InlineClassesUtilsKt.isInlineClass(classifierDescriptor);
    }

    @Nullable
    public static final KotlinType substitutedUnderlyingType(@NotNull KotlinType $this$substitutedUnderlyingType) {
        Intrinsics.checkNotNullParameter((Object)$this$substitutedUnderlyingType, (String)"<this>");
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.unsubstitutedUnderlyingParameter($this$substitutedUnderlyingType);
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        return TypeSubstitutor.create($this$substitutedUnderlyingType).substitute(parameter.getType(), Variance.INVARIANT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGetterOfUnderlyingPropertyOfInlineClass(@NotNull CallableDescriptor $this$isGetterOfUnderlyingPropertyOfInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isGetterOfUnderlyingPropertyOfInlineClass, (String)"<this>");
        if (!($this$isGetterOfUnderlyingPropertyOfInlineClass instanceof PropertyGetterDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)$this$isGetterOfUnderlyingPropertyOfInlineClass).getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"correspondingProperty");
        if (!InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(propertyDescriptor)) return false;
        return true;
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(@NotNull VariableDescriptor $this$isUnderlyingPropertyOfInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnderlyingPropertyOfInlineClass, (String)"<this>");
        if ($this$isUnderlyingPropertyOfInlineClass.getExtensionReceiverParameter() != null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = $this$isUnderlyingPropertyOfInlineClass.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"this.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!InlineClassesUtilsKt.isInlineClass(containingDeclaration)) {
            return false;
        }
        declarationDescriptor = InlineClassesUtilsKt.underlyingRepresentation((ClassDescriptor)containingDeclaration);
        return Intrinsics.areEqual((Object)(declarationDescriptor == null ? null : declarationDescriptor.getName()), (Object)$this$isUnderlyingPropertyOfInlineClass.getName());
    }
}

