/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.GotoExpressionKind;
import org.apache.calcite.linq4j.tree.GotoStatement;
import org.apache.calcite.linq4j.tree.LabelTarget;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;
import org.opensearch.sql.monitor.profile.ProfilePlanNode;
import org.opensearch.sql.monitor.profile.ProfilePlanNodeMetrics;

public class ProfileEnumerableRel
extends AbstractRelNode
implements EnumerableRel {
    private final EnumerableRel delegate;
    private final List<RelNode> inputs;
    protected final ProfilePlanNode planNode;

    public ProfileEnumerableRel(EnumerableRel delegate, List<RelNode> inputs, ProfilePlanNode planNode) {
        super(Objects.requireNonNull(delegate, "delegate").getCluster(), Objects.requireNonNull(delegate, "delegate").getTraitSet());
        this.delegate = delegate;
        this.inputs = new ArrayList<RelNode>((Collection)Objects.requireNonNull(inputs, "inputs"));
        this.planNode = Objects.requireNonNull(planNode, "planNode");
    }

    public List<RelNode> getInputs() {
        return this.inputs;
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        this.inputs.set(ordinalInParent, p);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ProfileEnumerableRel(this.delegate, inputs, this.planNode);
    }

    protected RelDataType deriveRowType() {
        return this.delegate.getRowType();
    }

    public String getRelTypeName() {
        return this.delegate.getRelTypeName();
    }

    public RelWriter explainTerms(RelWriter pw) {
        RelWriter writer = pw;
        for (RelNode input : this.inputs) {
            writer = writer.input("input", input);
        }
        return writer;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        EnumerableRel rewritten = (EnumerableRel)this.delegate.copy(this.delegate.getTraitSet(), this.inputs);
        EnumerableRel.Result result = rewritten.implement(implementor, pref);
        return new EnumerableRel.Result(ProfileEnumerableRel.wrapBlock(result.block, implementor.stash((Object)this.planNode.metrics(), ProfilePlanNodeMetrics.class)), result.physType, result.format);
    }

    private static BlockStatement wrapBlock(BlockStatement block, Expression metricsExpression) {
        List statements = block.statements;
        if (statements.isEmpty()) {
            return block;
        }
        Statement last = (Statement)statements.get(statements.size() - 1);
        if (!(last instanceof GotoStatement)) {
            return block;
        }
        GotoStatement gotoStatement = (GotoStatement)last;
        if (gotoStatement.kind != GotoExpressionKind.Return || gotoStatement.expression == null) {
            return block;
        }
        MethodCallExpression profiled = Expressions.call(ProfileEnumerableRel.class, (String)"profile", (Expression[])new Expression[]{gotoStatement.expression, metricsExpression});
        BlockBuilder builder = new BlockBuilder();
        for (int i = 0; i < statements.size() - 1; ++i) {
            builder.add((Statement)statements.get(i));
        }
        builder.add((Statement)Expressions.return_((LabelTarget)gotoStatement.labelTarget, (Expression)profiled));
        return builder.toBlock();
    }

    public static <T> Enumerable<T> profile(final Enumerable<T> enumerable, final ProfilePlanNodeMetrics metrics) {
        if (metrics == null) {
            return enumerable;
        }
        return new AbstractEnumerable<T>(){

            public Enumerator<T> enumerator() {
                long start = System.nanoTime();
                Enumerator delegate = enumerable.enumerator();
                metrics.addTimeNanos(System.nanoTime() - start);
                return new ProfileEnumerator(delegate, metrics);
            }
        };
    }

    private static final class ProfileEnumerator<T>
    implements Enumerator<T> {
        private final Enumerator<T> delegate;
        private final ProfilePlanNodeMetrics metrics;

        private ProfileEnumerator(Enumerator<T> delegate, ProfilePlanNodeMetrics metrics) {
            this.delegate = delegate;
            this.metrics = metrics;
        }

        public T current() {
            return (T)this.delegate.current();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            long start = System.nanoTime();
            try {
                boolean hasNext = this.delegate.moveNext();
                if (hasNext) {
                    this.metrics.incrementRows();
                }
                boolean bl = hasNext;
                return bl;
            }
            finally {
                this.metrics.addTimeNanos(System.nanoTime() - start);
            }
        }

        public void reset() {
            this.delegate.reset();
        }

        public void close() {
            long start = System.nanoTime();
            try {
                this.delegate.close();
            }
            finally {
                this.metrics.addTimeNanos(System.nanoTime() - start);
            }
        }
    }
}

