/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.messaging.context.ChannelBindingsContext;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.util.SOAPSupport;
import org.slf4j.Logger;

public class AddChannelBindingsHeaderHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddChannelBindingsHeaderHandler.class);
    @Nonnull
    private Function<MessageContext, ChannelBindingsContext> channelBindingsContextLookupStrategy = new ChildContextLookup<MessageContext, ChannelBindingsContext>(ChannelBindingsContext.class);
    @Nullable
    private ChannelBindingsContext channelBindingsContext;

    public void setChannelBindingsContextLookupStrategy(@Nonnull Function<MessageContext, ChannelBindingsContext> strategy) {
        this.checkSetterPreconditions();
        this.channelBindingsContextLookupStrategy = Constraint.isNotNull(strategy, "ChannelBindingsContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        ChannelBindingsContext cbCtx = this.channelBindingsContextLookupStrategy.apply(messageContext);
        if (cbCtx == null || cbCtx.getChannelBindings().isEmpty()) {
            this.log.debug("{} No ChannelBindings to add, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.channelBindingsContext = cbCtx;
        return true;
    }

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLObjectBuilder cbBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(ChannelBindings.DEFAULT_ELEMENT_NAME);
        assert (this.channelBindingsContext != null);
        for (ChannelBindings cb : this.channelBindingsContext.getChannelBindings()) {
            ChannelBindings header = (ChannelBindings)cbBuilder.buildObject();
            header.setType(cb.getType());
            SOAPSupport.addSOAP11MustUnderstandAttribute(header, true);
            SOAPSupport.addSOAP11ActorAttribute(header, "http://schemas.xmlsoap.org/soap/actor/next");
            try {
                SOAPMessagingSupport.addHeaderBlock(messageContext, header);
            }
            catch (Exception e) {
                throw new MessageHandlerException(e);
            }
        }
    }
}

