/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly;

import java.util.Objects;
import org.tribuo.Output;

public final class Event
implements Output<Event> {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_SCORE = Double.NaN;
    private final EventType type;
    private final double score;

    public Event(EventType type, double score) {
        this.type = type;
        this.score = score;
    }

    public Event(EventType type) {
        this(type, Double.NaN);
    }

    public double getScore() {
        return this.score;
    }

    public EventType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        return this.type == event.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public boolean fullEquals(Event o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(Double.isNaN(o.score) && Double.isNaN(this.score) || Double.compare(o.score, this.score) == 0)) {
            return false;
        }
        return this.type != null ? this.type.equals((Object)o.type) : o.type == null;
    }

    public String toString() {
        if (Double.isNaN(this.score)) {
            return this.type.toString();
        }
        return "(" + this.type.toString() + "," + this.score + ")";
    }

    public Event copy() {
        return new Event(this.type, this.score);
    }

    public String getSerializableForm(boolean includeConfidence) {
        if (includeConfidence && !Double.isNaN(this.score)) {
            return this.type.toString() + ",score=" + this.score;
        }
        return this.type.toString();
    }

    public static enum EventType {
        ANOMALOUS(1),
        EXPECTED(0),
        UNKNOWN(-1);

        private final int value;

        private EventType(int value) {
            this.value = value;
        }

        protected int getID() {
            return this.value;
        }
    }
}

