"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;
var _configSchema = require("@osd/config-schema");
var _server = require("../../../src/core/server");
var _shared = require("../common/constants/shared");
var _migrations = require("./adaptors/integrations/migrations");
var _opensearch_observability_plugin = require("./adaptors/opensearch_observability_plugin");
var _ppl_plugin = require("./adaptors/ppl_plugin");
var _ppl_parser = require("./parsers/ppl_parser");
var _register_settings = require("./plugin_helper/register_settings");
var _index = require("./routes/index");
var _observability_saved_object = require("./saved_objects/observability_saved_object");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class ObservabilityPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  async setup(core, deps) {
    const {
      assistantDashboards,
      dataSource
    } = deps;
    this.logger.debug('Observability: Setup');
    const router = core.http.createRouter();
    const dataSourceEnabled = !!dataSource;
    const openSearchObservabilityClient = core.opensearch.legacy.createClient('opensearch_observability', {
      plugins: [_ppl_plugin.PPLPlugin, _opensearch_observability_plugin.OpenSearchObservabilityPlugin]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_ppl_plugin.PPLPlugin);
      dataSource.registerCustomApiSchema(_opensearch_observability_plugin.OpenSearchObservabilityPlugin);
    }
    // @ts-ignore
    core.http.registerRouteHandlerContext('observability_plugin', (_context, _request) => {
      return {
        logger: this.logger,
        observabilityClient: openSearchObservabilityClient
      };
    });
    const obsPanelType = {
      name: 'observability-panel',
      hidden: false,
      namespaceType: 'single',
      mappings: {
        dynamic: false,
        properties: {
          title: {
            type: 'text'
          },
          description: {
            type: 'text'
          }
        }
      },
      management: {
        importableAndExportable: true,
        getInAppUrl(obj) {
          return {
            path: dataSourceEnabled ? '' : `/app/${_shared.observabilityPanelsID}#/${obj.id}`,
            uiCapabilitiesPath: 'advancedSettings.show'
          };
        },
        getTitle(obj) {
          return `Observability Settings [${obj.id}]`;
        }
      },
      migrations: {
        '3.0.0': doc => ({
          ...doc,
          description: ''
        }),
        '3.0.1': doc => ({
          ...doc,
          description: 'Some Description Text'
        }),
        '3.0.2': doc => ({
          ...doc,
          dateCreated: parseInt(doc.dateCreated || '0', 10)
        })
      }
    };
    const integrationInstanceType = {
      name: 'integration-instance',
      hidden: false,
      namespaceType: 'single',
      management: {
        importableAndExportable: true,
        getInAppUrl(obj) {
          return {
            path: `/app/integrations#/installed/${obj.id}`,
            uiCapabilitiesPath: 'advancedSettings.show'
          };
        },
        getTitle(obj) {
          return obj.attributes.name;
        }
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'text'
          },
          templateName: {
            type: 'text'
          },
          dataSource: {
            type: 'text'
          },
          creationDate: {
            type: 'date'
          },
          assets: {
            type: 'nested'
          }
        }
      }
    };
    const integrationTemplateType = {
      name: 'integration-template',
      hidden: false,
      namespaceType: 'single',
      management: {
        importableAndExportable: true,
        getInAppUrl(obj) {
          return {
            path: `/app/integrations#/available/${obj.attributes.name}`,
            uiCapabilitiesPath: 'advancedSettings.show'
          };
        },
        getTitle(obj) {
          var _obj$attributes$displ;
          return (_obj$attributes$displ = obj.attributes.displayName) !== null && _obj$attributes$displ !== void 0 ? _obj$attributes$displ : obj.attributes.name;
        }
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'text'
          },
          version: {
            type: 'text'
          },
          displayName: {
            type: 'text'
          },
          license: {
            type: 'text'
          },
          type: {
            type: 'text'
          },
          labels: {
            type: 'text'
          },
          author: {
            type: 'text'
          },
          description: {
            type: 'text'
          },
          sourceUrl: {
            type: 'text'
          },
          statics: {
            type: 'nested'
          },
          components: {
            type: 'nested'
          },
          assets: {
            type: 'nested'
          },
          sampleData: {
            type: 'nested'
          }
        }
      },
      migrations: {
        '3.0.0': _migrations.migrateV1IntegrationToV2Integration
      }
    };
    core.savedObjects.registerType(obsPanelType);
    core.savedObjects.registerType(integrationInstanceType);
    core.savedObjects.registerType(integrationTemplateType);

    // Register server side APIs
    (0, _index.setupRoutes)({
      router,
      client: openSearchObservabilityClient,
      dataSourceEnabled,
      logger: this.logger
    });
    core.savedObjects.registerType((0, _observability_saved_object.getVisualizationSavedObject)(dataSourceEnabled));
    core.savedObjects.registerType((0, _observability_saved_object.getSearchSavedObject)(dataSourceEnabled));
    if (!deps.investigationDashboards) {
      core.savedObjects.registerType(_observability_saved_object.notebookSavedObject);
    }
    core.capabilities.registerProvider(() => ({
      observability: {
        show: true
      }
    }));
    assistantDashboards === null || assistantDashboards === void 0 || assistantDashboards.registerMessageParser(_ppl_parser.PPLParsers);
    (0, _register_settings.registerObservabilityUISettings)(core.uiSettings);
    core.uiSettings.register({
      'observability:defaultDashboard': {
        name: 'Observability default dashboard',
        value: '',
        description: 'The default dashboard to display in Observability overview page',
        schema: _configSchema.schema.string(),
        scope: core.workspace.isWorkspaceEnabled() ? _server.UiSettingScope.WORKSPACE : _server.UiSettingScope.GLOBAL
      }
    });
    core.uiSettings.register({
      'observability:overviewCardsDisplay': {
        name: 'Observability overview cards',
        value: true,
        description: 'Show the Observability overview page cards',
        schema: _configSchema.schema.boolean(),
        scope: core.workspace.isWorkspaceEnabled() ? _server.UiSettingScope.WORKSPACE : _server.UiSettingScope.GLOBAL
      }
    });
    return {};
  }
  start(_core) {
    this.logger.debug('Observability: Started');
    return {};
  }
  stop() {}
}
exports.ObservabilityPlugin = ObservabilityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9zZXJ2ZXIiLCJfc2hhcmVkIiwiX21pZ3JhdGlvbnMiLCJfb3BlbnNlYXJjaF9vYnNlcnZhYmlsaXR5X3BsdWdpbiIsIl9wcGxfcGx1Z2luIiwiX3BwbF9wYXJzZXIiLCJfcmVnaXN0ZXJfc2V0dGluZ3MiLCJfaW5kZXgiLCJfb2JzZXJ2YWJpbGl0eV9zYXZlZF9vYmplY3QiLCJfZGVmaW5lUHJvcGVydHkiLCJlIiwiciIsInQiLCJfdG9Qcm9wZXJ0eUtleSIsIk9iamVjdCIsImRlZmluZVByb3BlcnR5IiwidmFsdWUiLCJlbnVtZXJhYmxlIiwiY29uZmlndXJhYmxlIiwid3JpdGFibGUiLCJpIiwiX3RvUHJpbWl0aXZlIiwiU3ltYm9sIiwidG9QcmltaXRpdmUiLCJjYWxsIiwiVHlwZUVycm9yIiwiU3RyaW5nIiwiTnVtYmVyIiwiT2JzZXJ2YWJpbGl0eVBsdWdpbiIsImNvbnN0cnVjdG9yIiwiaW5pdGlhbGl6ZXJDb250ZXh0IiwibG9nZ2VyIiwiZ2V0Iiwic2V0dXAiLCJjb3JlIiwiZGVwcyIsImFzc2lzdGFudERhc2hib2FyZHMiLCJkYXRhU291cmNlIiwiZGVidWciLCJyb3V0ZXIiLCJodHRwIiwiY3JlYXRlUm91dGVyIiwiZGF0YVNvdXJjZUVuYWJsZWQiLCJvcGVuU2VhcmNoT2JzZXJ2YWJpbGl0eUNsaWVudCIsIm9wZW5zZWFyY2giLCJsZWdhY3kiLCJjcmVhdGVDbGllbnQiLCJwbHVnaW5zIiwiUFBMUGx1Z2luIiwiT3BlblNlYXJjaE9ic2VydmFiaWxpdHlQbHVnaW4iLCJyZWdpc3RlckN1c3RvbUFwaVNjaGVtYSIsInJlZ2lzdGVyUm91dGVIYW5kbGVyQ29udGV4dCIsIl9jb250ZXh0IiwiX3JlcXVlc3QiLCJvYnNlcnZhYmlsaXR5Q2xpZW50Iiwib2JzUGFuZWxUeXBlIiwibmFtZSIsImhpZGRlbiIsIm5hbWVzcGFjZVR5cGUiLCJtYXBwaW5ncyIsImR5bmFtaWMiLCJwcm9wZXJ0aWVzIiwidGl0bGUiLCJ0eXBlIiwiZGVzY3JpcHRpb24iLCJtYW5hZ2VtZW50IiwiaW1wb3J0YWJsZUFuZEV4cG9ydGFibGUiLCJnZXRJbkFwcFVybCIsIm9iaiIsInBhdGgiLCJvYnNlcnZhYmlsaXR5UGFuZWxzSUQiLCJpZCIsInVpQ2FwYWJpbGl0aWVzUGF0aCIsImdldFRpdGxlIiwibWlncmF0aW9ucyIsImRvYyIsImRhdGVDcmVhdGVkIiwicGFyc2VJbnQiLCJpbnRlZ3JhdGlvbkluc3RhbmNlVHlwZSIsImF0dHJpYnV0ZXMiLCJ0ZW1wbGF0ZU5hbWUiLCJjcmVhdGlvbkRhdGUiLCJhc3NldHMiLCJpbnRlZ3JhdGlvblRlbXBsYXRlVHlwZSIsIl9vYmokYXR0cmlidXRlcyRkaXNwbCIsImRpc3BsYXlOYW1lIiwidmVyc2lvbiIsImxpY2Vuc2UiLCJsYWJlbHMiLCJhdXRob3IiLCJzb3VyY2VVcmwiLCJzdGF0aWNzIiwiY29tcG9uZW50cyIsInNhbXBsZURhdGEiLCJtaWdyYXRlVjFJbnRlZ3JhdGlvblRvVjJJbnRlZ3JhdGlvbiIsInNhdmVkT2JqZWN0cyIsInJlZ2lzdGVyVHlwZSIsInNldHVwUm91dGVzIiwiY2xpZW50IiwiZ2V0VmlzdWFsaXphdGlvblNhdmVkT2JqZWN0IiwiZ2V0U2VhcmNoU2F2ZWRPYmplY3QiLCJpbnZlc3RpZ2F0aW9uRGFzaGJvYXJkcyIsIm5vdGVib29rU2F2ZWRPYmplY3QiLCJjYXBhYmlsaXRpZXMiLCJyZWdpc3RlclByb3ZpZGVyIiwib2JzZXJ2YWJpbGl0eSIsInNob3ciLCJyZWdpc3Rlck1lc3NhZ2VQYXJzZXIiLCJQUExQYXJzZXJzIiwicmVnaXN0ZXJPYnNlcnZhYmlsaXR5VUlTZXR0aW5ncyIsInVpU2V0dGluZ3MiLCJyZWdpc3RlciIsInNjaGVtYSIsInN0cmluZyIsInNjb3BlIiwid29ya3NwYWNlIiwiaXNXb3Jrc3BhY2VFbmFibGVkIiwiVWlTZXR0aW5nU2NvcGUiLCJXT1JLU1BBQ0UiLCJHTE9CQUwiLCJib29sZWFuIiwic3RhcnQiLCJfY29yZSIsInN0b3AiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsicGx1Z2luLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcbmltcG9ydCB7XG4gIENvcmVTZXR1cCxcbiAgQ29yZVN0YXJ0LFxuICBJTGVnYWN5Q2x1c3RlckNsaWVudCxcbiAgTG9nZ2VyLFxuICBQbHVnaW4sXG4gIFBsdWdpbkluaXRpYWxpemVyQ29udGV4dCxcbiAgU2F2ZWRPYmplY3QsXG4gIFNhdmVkT2JqZWN0c1R5cGUsXG4gIFVpU2V0dGluZ1Njb3BlLFxufSBmcm9tICcuLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xuaW1wb3J0IHsgRGF0YVNvdXJjZVBsdWdpblNldHVwIH0gZnJvbSAnLi4vLi4vLi4vc3JjL3BsdWdpbnMvZGF0YV9zb3VyY2Uvc2VydmVyL3R5cGVzJztcbmltcG9ydCB7IERhdGFTb3VyY2VNYW5hZ2VtZW50UGx1Z2luIH0gZnJvbSAnLi4vLi4vLi4vc3JjL3BsdWdpbnMvZGF0YV9zb3VyY2VfbWFuYWdlbWVudC9wdWJsaWMvcGx1Z2luJztcbmltcG9ydCB7IG9ic2VydmFiaWxpdHlQYW5lbHNJRCB9IGZyb20gJy4uL2NvbW1vbi9jb25zdGFudHMvc2hhcmVkJztcbmltcG9ydCB7IG1pZ3JhdGVWMUludGVncmF0aW9uVG9WMkludGVncmF0aW9uIH0gZnJvbSAnLi9hZGFwdG9ycy9pbnRlZ3JhdGlvbnMvbWlncmF0aW9ucyc7XG5pbXBvcnQgeyBPcGVuU2VhcmNoT2JzZXJ2YWJpbGl0eVBsdWdpbiB9IGZyb20gJy4vYWRhcHRvcnMvb3BlbnNlYXJjaF9vYnNlcnZhYmlsaXR5X3BsdWdpbic7XG5pbXBvcnQgeyBQUExQbHVnaW4gfSBmcm9tICcuL2FkYXB0b3JzL3BwbF9wbHVnaW4nO1xuaW1wb3J0IHsgUFBMUGFyc2VycyB9IGZyb20gJy4vcGFyc2Vycy9wcGxfcGFyc2VyJztcbmltcG9ydCB7IHJlZ2lzdGVyT2JzZXJ2YWJpbGl0eVVJU2V0dGluZ3MgfSBmcm9tICcuL3BsdWdpbl9oZWxwZXIvcmVnaXN0ZXJfc2V0dGluZ3MnO1xuaW1wb3J0IHsgc2V0dXBSb3V0ZXMgfSBmcm9tICcuL3JvdXRlcy9pbmRleCc7XG5pbXBvcnQge1xuICBnZXRTZWFyY2hTYXZlZE9iamVjdCxcbiAgZ2V0VmlzdWFsaXphdGlvblNhdmVkT2JqZWN0LFxuICBub3RlYm9va1NhdmVkT2JqZWN0LFxufSBmcm9tICcuL3NhdmVkX29iamVjdHMvb2JzZXJ2YWJpbGl0eV9zYXZlZF9vYmplY3QnO1xuaW1wb3J0IHsgQXNzaXN0YW50UGx1Z2luU2V0dXAsIE9ic2VydmFiaWxpdHlQbHVnaW5TZXR1cCwgT2JzZXJ2YWJpbGl0eVBsdWdpblN0YXJ0IH0gZnJvbSAnLi90eXBlcyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgT2JzZXJ2YWJpbGl0eVBsdWdpblNldHVwRGVwZW5kZW5jaWVzIHtcbiAgZGF0YVNvdXJjZU1hbmFnZW1lbnQ6IFJldHVyblR5cGU8RGF0YVNvdXJjZU1hbmFnZW1lbnRQbHVnaW5bJ3NldHVwJ10+O1xuICBkYXRhU291cmNlOiBEYXRhU291cmNlUGx1Z2luU2V0dXA7XG59XG5cbmV4cG9ydCBjbGFzcyBPYnNlcnZhYmlsaXR5UGx1Z2luXG4gIGltcGxlbWVudHMgUGx1Z2luPE9ic2VydmFiaWxpdHlQbHVnaW5TZXR1cCwgT2JzZXJ2YWJpbGl0eVBsdWdpblN0YXJ0PiB7XG4gIHByaXZhdGUgcmVhZG9ubHkgbG9nZ2VyOiBMb2dnZXI7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBpbml0aWFsaXplckNvbnRleHQ6IFBsdWdpbkluaXRpYWxpemVyQ29udGV4dCkge1xuICAgIHRoaXMubG9nZ2VyID0gaW5pdGlhbGl6ZXJDb250ZXh0LmxvZ2dlci5nZXQoKTtcbiAgfVxuXG4gIHB1YmxpYyBhc3luYyBzZXR1cChcbiAgICBjb3JlOiBDb3JlU2V0dXAsXG4gICAgZGVwczoge1xuICAgICAgYXNzaXN0YW50RGFzaGJvYXJkcz86IEFzc2lzdGFudFBsdWdpblNldHVwO1xuICAgICAgZGF0YVNvdXJjZTogT2JzZXJ2YWJpbGl0eVBsdWdpblNldHVwRGVwZW5kZW5jaWVzO1xuICAgICAgaW52ZXN0aWdhdGlvbkRhc2hib2FyZHM/OiB1bmtub3duO1xuICAgIH1cbiAgKSB7XG4gICAgY29uc3QgeyBhc3Npc3RhbnREYXNoYm9hcmRzLCBkYXRhU291cmNlIH0gPSBkZXBzO1xuICAgIHRoaXMubG9nZ2VyLmRlYnVnKCdPYnNlcnZhYmlsaXR5OiBTZXR1cCcpO1xuICAgIGNvbnN0IHJvdXRlciA9IGNvcmUuaHR0cC5jcmVhdGVSb3V0ZXIoKTtcblxuICAgIGNvbnN0IGRhdGFTb3VyY2VFbmFibGVkID0gISFkYXRhU291cmNlO1xuICAgIGNvbnN0IG9wZW5TZWFyY2hPYnNlcnZhYmlsaXR5Q2xpZW50OiBJTGVnYWN5Q2x1c3RlckNsaWVudCA9IGNvcmUub3BlbnNlYXJjaC5sZWdhY3kuY3JlYXRlQ2xpZW50KFxuICAgICAgJ29wZW5zZWFyY2hfb2JzZXJ2YWJpbGl0eScsXG4gICAgICB7XG4gICAgICAgIHBsdWdpbnM6IFtQUExQbHVnaW4sIE9wZW5TZWFyY2hPYnNlcnZhYmlsaXR5UGx1Z2luXSxcbiAgICAgIH1cbiAgICApO1xuICAgIGlmIChkYXRhU291cmNlRW5hYmxlZCkge1xuICAgICAgZGF0YVNvdXJjZS5yZWdpc3RlckN1c3RvbUFwaVNjaGVtYShQUExQbHVnaW4pO1xuICAgICAgZGF0YVNvdXJjZS5yZWdpc3RlckN1c3RvbUFwaVNjaGVtYShPcGVuU2VhcmNoT2JzZXJ2YWJpbGl0eVBsdWdpbik7XG4gICAgfVxuICAgIC8vIEB0cy1pZ25vcmVcbiAgICBjb3JlLmh0dHAucmVnaXN0ZXJSb3V0ZUhhbmRsZXJDb250ZXh0KCdvYnNlcnZhYmlsaXR5X3BsdWdpbicsIChfY29udGV4dCwgX3JlcXVlc3QpID0+IHtcbiAgICAgIHJldHVybiB7XG4gICAgICAgIGxvZ2dlcjogdGhpcy5sb2dnZXIsXG4gICAgICAgIG9ic2VydmFiaWxpdHlDbGllbnQ6IG9wZW5TZWFyY2hPYnNlcnZhYmlsaXR5Q2xpZW50LFxuICAgICAgfTtcbiAgICB9KTtcblxuICAgIGNvbnN0IG9ic1BhbmVsVHlwZTogU2F2ZWRPYmplY3RzVHlwZSA9IHtcbiAgICAgIG5hbWU6ICdvYnNlcnZhYmlsaXR5LXBhbmVsJyxcbiAgICAgIGhpZGRlbjogZmFsc2UsXG4gICAgICBuYW1lc3BhY2VUeXBlOiAnc2luZ2xlJyxcbiAgICAgIG1hcHBpbmdzOiB7XG4gICAgICAgIGR5bmFtaWM6IGZhbHNlLFxuICAgICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgdGl0bGU6IHtcbiAgICAgICAgICAgIHR5cGU6ICd0ZXh0JyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIGRlc2NyaXB0aW9uOiB7XG4gICAgICAgICAgICB0eXBlOiAndGV4dCcsXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICBtYW5hZ2VtZW50OiB7XG4gICAgICAgIGltcG9ydGFibGVBbmRFeHBvcnRhYmxlOiB0cnVlLFxuICAgICAgICBnZXRJbkFwcFVybChvYmopIHtcbiAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgcGF0aDogZGF0YVNvdXJjZUVuYWJsZWQgPyAnJyA6IGAvYXBwLyR7b2JzZXJ2YWJpbGl0eVBhbmVsc0lEfSMvJHtvYmouaWR9YCxcbiAgICAgICAgICAgIHVpQ2FwYWJpbGl0aWVzUGF0aDogJ2FkdmFuY2VkU2V0dGluZ3Muc2hvdycsXG4gICAgICAgICAgfTtcbiAgICAgICAgfSxcbiAgICAgICAgZ2V0VGl0bGUob2JqKSB7XG4gICAgICAgICAgcmV0dXJuIGBPYnNlcnZhYmlsaXR5IFNldHRpbmdzIFske29iai5pZH1dYDtcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICBtaWdyYXRpb25zOiB7XG4gICAgICAgICczLjAuMCc6IChkb2MpID0+ICh7IC4uLmRvYywgZGVzY3JpcHRpb246ICcnIH0pLFxuICAgICAgICAnMy4wLjEnOiAoZG9jKSA9PiAoeyAuLi5kb2MsIGRlc2NyaXB0aW9uOiAnU29tZSBEZXNjcmlwdGlvbiBUZXh0JyB9KSxcbiAgICAgICAgJzMuMC4yJzogKGRvYykgPT4gKHtcbiAgICAgICAgICAuLi5kb2MsXG4gICAgICAgICAgZGF0ZUNyZWF0ZWQ6IHBhcnNlSW50KChkb2MgYXMgeyBkYXRlQ3JlYXRlZD86IHN0cmluZyB9KS5kYXRlQ3JlYXRlZCB8fCAnMCcsIDEwKSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH07XG5cbiAgICBjb25zdCBpbnRlZ3JhdGlvbkluc3RhbmNlVHlwZTogU2F2ZWRPYmplY3RzVHlwZSA9IHtcbiAgICAgIG5hbWU6ICdpbnRlZ3JhdGlvbi1pbnN0YW5jZScsXG4gICAgICBoaWRkZW46IGZhbHNlLFxuICAgICAgbmFtZXNwYWNlVHlwZTogJ3NpbmdsZScsXG4gICAgICBtYW5hZ2VtZW50OiB7XG4gICAgICAgIGltcG9ydGFibGVBbmRFeHBvcnRhYmxlOiB0cnVlLFxuICAgICAgICBnZXRJbkFwcFVybChvYmo6IFNhdmVkT2JqZWN0PEludGVncmF0aW9uSW5zdGFuY2U+KSB7XG4gICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHBhdGg6IGAvYXBwL2ludGVncmF0aW9ucyMvaW5zdGFsbGVkLyR7b2JqLmlkfWAsXG4gICAgICAgICAgICB1aUNhcGFiaWxpdGllc1BhdGg6ICdhZHZhbmNlZFNldHRpbmdzLnNob3cnLFxuICAgICAgICAgIH07XG4gICAgICAgIH0sXG4gICAgICAgIGdldFRpdGxlKG9iajogU2F2ZWRPYmplY3Q8SW50ZWdyYXRpb25JbnN0YW5jZT4pIHtcbiAgICAgICAgICByZXR1cm4gb2JqLmF0dHJpYnV0ZXMubmFtZTtcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICBtYXBwaW5nczoge1xuICAgICAgICBkeW5hbWljOiBmYWxzZSxcbiAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgIG5hbWU6IHtcbiAgICAgICAgICAgIHR5cGU6ICd0ZXh0JyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHRlbXBsYXRlTmFtZToge1xuICAgICAgICAgICAgdHlwZTogJ3RleHQnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgZGF0YVNvdXJjZToge1xuICAgICAgICAgICAgdHlwZTogJ3RleHQnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgY3JlYXRpb25EYXRlOiB7XG4gICAgICAgICAgICB0eXBlOiAnZGF0ZScsXG4gICAgICAgICAgfSxcbiAgICAgICAgICBhc3NldHM6IHtcbiAgICAgICAgICAgIHR5cGU6ICduZXN0ZWQnLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG5cbiAgICBjb25zdCBpbnRlZ3JhdGlvblRlbXBsYXRlVHlwZTogU2F2ZWRPYmplY3RzVHlwZSA9IHtcbiAgICAgIG5hbWU6ICdpbnRlZ3JhdGlvbi10ZW1wbGF0ZScsXG4gICAgICBoaWRkZW46IGZhbHNlLFxuICAgICAgbmFtZXNwYWNlVHlwZTogJ3NpbmdsZScsXG4gICAgICBtYW5hZ2VtZW50OiB7XG4gICAgICAgIGltcG9ydGFibGVBbmRFeHBvcnRhYmxlOiB0cnVlLFxuICAgICAgICBnZXRJbkFwcFVybChvYmo6IFNhdmVkT2JqZWN0PFNlcmlhbGl6ZWRJbnRlZ3JhdGlvbj4pIHtcbiAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgcGF0aDogYC9hcHAvaW50ZWdyYXRpb25zIy9hdmFpbGFibGUvJHtvYmouYXR0cmlidXRlcy5uYW1lfWAsXG4gICAgICAgICAgICB1aUNhcGFiaWxpdGllc1BhdGg6ICdhZHZhbmNlZFNldHRpbmdzLnNob3cnLFxuICAgICAgICAgIH07XG4gICAgICAgIH0sXG4gICAgICAgIGdldFRpdGxlKG9iajogU2F2ZWRPYmplY3Q8U2VyaWFsaXplZEludGVncmF0aW9uPikge1xuICAgICAgICAgIHJldHVybiBvYmouYXR0cmlidXRlcy5kaXNwbGF5TmFtZSA/PyBvYmouYXR0cmlidXRlcy5uYW1lO1xuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIG1hcHBpbmdzOiB7XG4gICAgICAgIGR5bmFtaWM6IGZhbHNlLFxuICAgICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgbmFtZToge1xuICAgICAgICAgICAgdHlwZTogJ3RleHQnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgdmVyc2lvbjoge1xuICAgICAgICAgICAgdHlwZTogJ3RleHQnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgZGlzcGxheU5hbWU6IHtcbiAgICAgICAgICAgIHR5cGU6ICd0ZXh0JyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIGxpY2Vuc2U6IHtcbiAgICAgICAgICAgIHR5cGU6ICd0ZXh0JyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHR5cGU6IHtcbiAgICAgICAgICAgIHR5cGU6ICd0ZXh0JyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIGxhYmVsczoge1xuICAgICAgICAgICAgdHlwZTogJ3RleHQnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgYXV0aG9yOiB7XG4gICAgICAgICAgICB0eXBlOiAndGV4dCcsXG4gICAgICAgICAgfSxcbiAgICAgICAgICBkZXNjcmlwdGlvbjoge1xuICAgICAgICAgICAgdHlwZTogJ3RleHQnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgc291cmNlVXJsOiB7XG4gICAgICAgICAgICB0eXBlOiAndGV4dCcsXG4gICAgICAgICAgfSxcbiAgICAgICAgICBzdGF0aWNzOiB7XG4gICAgICAgICAgICB0eXBlOiAnbmVzdGVkJyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIGNvbXBvbmVudHM6IHtcbiAgICAgICAgICAgIHR5cGU6ICduZXN0ZWQnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgYXNzZXRzOiB7XG4gICAgICAgICAgICB0eXBlOiAnbmVzdGVkJyxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHNhbXBsZURhdGE6IHtcbiAgICAgICAgICAgIHR5cGU6ICduZXN0ZWQnLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgbWlncmF0aW9uczoge1xuICAgICAgICAnMy4wLjAnOiBtaWdyYXRlVjFJbnRlZ3JhdGlvblRvVjJJbnRlZ3JhdGlvbixcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIGNvcmUuc2F2ZWRPYmplY3RzLnJlZ2lzdGVyVHlwZShvYnNQYW5lbFR5cGUpO1xuICAgIGNvcmUuc2F2ZWRPYmplY3RzLnJlZ2lzdGVyVHlwZShpbnRlZ3JhdGlvbkluc3RhbmNlVHlwZSk7XG4gICAgY29yZS5zYXZlZE9iamVjdHMucmVnaXN0ZXJUeXBlKGludGVncmF0aW9uVGVtcGxhdGVUeXBlKTtcblxuICAgIC8vIFJlZ2lzdGVyIHNlcnZlciBzaWRlIEFQSXNcbiAgICBzZXR1cFJvdXRlcyh7XG4gICAgICByb3V0ZXIsXG4gICAgICBjbGllbnQ6IG9wZW5TZWFyY2hPYnNlcnZhYmlsaXR5Q2xpZW50LFxuICAgICAgZGF0YVNvdXJjZUVuYWJsZWQsXG4gICAgICBsb2dnZXI6IHRoaXMubG9nZ2VyLFxuICAgIH0pO1xuXG4gICAgY29yZS5zYXZlZE9iamVjdHMucmVnaXN0ZXJUeXBlKGdldFZpc3VhbGl6YXRpb25TYXZlZE9iamVjdChkYXRhU291cmNlRW5hYmxlZCkpO1xuICAgIGNvcmUuc2F2ZWRPYmplY3RzLnJlZ2lzdGVyVHlwZShnZXRTZWFyY2hTYXZlZE9iamVjdChkYXRhU291cmNlRW5hYmxlZCkpO1xuICAgIGlmICghZGVwcy5pbnZlc3RpZ2F0aW9uRGFzaGJvYXJkcykge1xuICAgICAgY29yZS5zYXZlZE9iamVjdHMucmVnaXN0ZXJUeXBlKG5vdGVib29rU2F2ZWRPYmplY3QpO1xuICAgIH1cbiAgICBjb3JlLmNhcGFiaWxpdGllcy5yZWdpc3RlclByb3ZpZGVyKCgpID0+ICh7XG4gICAgICBvYnNlcnZhYmlsaXR5OiB7XG4gICAgICAgIHNob3c6IHRydWUsXG4gICAgICB9LFxuICAgIH0pKTtcblxuICAgIGFzc2lzdGFudERhc2hib2FyZHM/LnJlZ2lzdGVyTWVzc2FnZVBhcnNlcihQUExQYXJzZXJzKTtcbiAgICByZWdpc3Rlck9ic2VydmFiaWxpdHlVSVNldHRpbmdzKGNvcmUudWlTZXR0aW5ncyk7XG5cbiAgICBjb3JlLnVpU2V0dGluZ3MucmVnaXN0ZXIoe1xuICAgICAgJ29ic2VydmFiaWxpdHk6ZGVmYXVsdERhc2hib2FyZCc6IHtcbiAgICAgICAgbmFtZTogJ09ic2VydmFiaWxpdHkgZGVmYXVsdCBkYXNoYm9hcmQnLFxuICAgICAgICB2YWx1ZTogJycsXG4gICAgICAgIGRlc2NyaXB0aW9uOiAnVGhlIGRlZmF1bHQgZGFzaGJvYXJkIHRvIGRpc3BsYXkgaW4gT2JzZXJ2YWJpbGl0eSBvdmVydmlldyBwYWdlJyxcbiAgICAgICAgc2NoZW1hOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIHNjb3BlOiBjb3JlLndvcmtzcGFjZS5pc1dvcmtzcGFjZUVuYWJsZWQoKVxuICAgICAgICAgID8gVWlTZXR0aW5nU2NvcGUuV09SS1NQQUNFXG4gICAgICAgICAgOiBVaVNldHRpbmdTY29wZS5HTE9CQUwsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgY29yZS51aVNldHRpbmdzLnJlZ2lzdGVyKHtcbiAgICAgICdvYnNlcnZhYmlsaXR5Om92ZXJ2aWV3Q2FyZHNEaXNwbGF5Jzoge1xuICAgICAgICBuYW1lOiAnT2JzZXJ2YWJpbGl0eSBvdmVydmlldyBjYXJkcycsXG4gICAgICAgIHZhbHVlOiB0cnVlLFxuICAgICAgICBkZXNjcmlwdGlvbjogJ1Nob3cgdGhlIE9ic2VydmFiaWxpdHkgb3ZlcnZpZXcgcGFnZSBjYXJkcycsXG4gICAgICAgIHNjaGVtYTogc2NoZW1hLmJvb2xlYW4oKSxcbiAgICAgICAgc2NvcGU6IGNvcmUud29ya3NwYWNlLmlzV29ya3NwYWNlRW5hYmxlZCgpXG4gICAgICAgICAgPyBVaVNldHRpbmdTY29wZS5XT1JLU1BBQ0VcbiAgICAgICAgICA6IFVpU2V0dGluZ1Njb3BlLkdMT0JBTCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICByZXR1cm4ge307XG4gIH1cblxuICBwdWJsaWMgc3RhcnQoX2NvcmU6IENvcmVTdGFydCkge1xuICAgIHRoaXMubG9nZ2VyLmRlYnVnKCdPYnNlcnZhYmlsaXR5OiBTdGFydGVkJyk7XG4gICAgcmV0dXJuIHt9O1xuICB9XG5cbiAgcHVibGljIHN0b3AoKSB7fVxufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyxPQUFBLEdBQUFELE9BQUE7QUFhQSxJQUFBRSxPQUFBLEdBQUFGLE9BQUE7QUFDQSxJQUFBRyxXQUFBLEdBQUFILE9BQUE7QUFDQSxJQUFBSSxnQ0FBQSxHQUFBSixPQUFBO0FBQ0EsSUFBQUssV0FBQSxHQUFBTCxPQUFBO0FBQ0EsSUFBQU0sV0FBQSxHQUFBTixPQUFBO0FBQ0EsSUFBQU8sa0JBQUEsR0FBQVAsT0FBQTtBQUNBLElBQUFRLE1BQUEsR0FBQVIsT0FBQTtBQUNBLElBQUFTLDJCQUFBLEdBQUFULE9BQUE7QUFJb0QsU0FBQVUsZ0JBQUFDLENBQUEsRUFBQUMsQ0FBQSxFQUFBQyxDQUFBLFlBQUFELENBQUEsR0FBQUUsY0FBQSxDQUFBRixDQUFBLE1BQUFELENBQUEsR0FBQUksTUFBQSxDQUFBQyxjQUFBLENBQUFMLENBQUEsRUFBQUMsQ0FBQSxJQUFBSyxLQUFBLEVBQUFKLENBQUEsRUFBQUssVUFBQSxNQUFBQyxZQUFBLE1BQUFDLFFBQUEsVUFBQVQsQ0FBQSxDQUFBQyxDQUFBLElBQUFDLENBQUEsRUFBQUYsQ0FBQTtBQUFBLFNBQUFHLGVBQUFELENBQUEsUUFBQVEsQ0FBQSxHQUFBQyxZQUFBLENBQUFULENBQUEsdUNBQUFRLENBQUEsR0FBQUEsQ0FBQSxHQUFBQSxDQUFBO0FBQUEsU0FBQUMsYUFBQVQsQ0FBQSxFQUFBRCxDQUFBLDJCQUFBQyxDQUFBLEtBQUFBLENBQUEsU0FBQUEsQ0FBQSxNQUFBRixDQUFBLEdBQUFFLENBQUEsQ0FBQVUsTUFBQSxDQUFBQyxXQUFBLGtCQUFBYixDQUFBLFFBQUFVLENBQUEsR0FBQVYsQ0FBQSxDQUFBYyxJQUFBLENBQUFaLENBQUEsRUFBQUQsQ0FBQSx1Q0FBQVMsQ0FBQSxTQUFBQSxDQUFBLFlBQUFLLFNBQUEseUVBQUFkLENBQUEsR0FBQWUsTUFBQSxHQUFBQyxNQUFBLEVBQUFmLENBQUEsS0E5QnBEO0FBQ0E7QUFDQTtBQUNBO0FBbUNPLE1BQU1nQixtQkFBbUIsQ0FDd0M7RUFHdEVDLFdBQVdBLENBQWtCQyxrQkFBNEMsRUFBRTtJQUFBLEtBQTlDQSxrQkFBNEMsR0FBNUNBLGtCQUE0QztJQUFBckIsZUFBQTtJQUN2RSxJQUFJLENBQUNzQixNQUFNLEdBQUdELGtCQUFrQixDQUFDQyxNQUFNLENBQUNDLEdBQUcsQ0FBQyxDQUFDO0VBQy9DO0VBRUEsTUFBYUMsS0FBS0EsQ0FDaEJDLElBQWUsRUFDZkMsSUFJQyxFQUNEO0lBQ0EsTUFBTTtNQUFFQyxtQkFBbUI7TUFBRUM7SUFBVyxDQUFDLEdBQUdGLElBQUk7SUFDaEQsSUFBSSxDQUFDSixNQUFNLENBQUNPLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztJQUN6QyxNQUFNQyxNQUFNLEdBQUdMLElBQUksQ0FBQ00sSUFBSSxDQUFDQyxZQUFZLENBQUMsQ0FBQztJQUV2QyxNQUFNQyxpQkFBaUIsR0FBRyxDQUFDLENBQUNMLFVBQVU7SUFDdEMsTUFBTU0sNkJBQW1ELEdBQUdULElBQUksQ0FBQ1UsVUFBVSxDQUFDQyxNQUFNLENBQUNDLFlBQVksQ0FDN0YsMEJBQTBCLEVBQzFCO01BQ0VDLE9BQU8sRUFBRSxDQUFDQyxxQkFBUyxFQUFFQyw4REFBNkI7SUFDcEQsQ0FDRixDQUFDO0lBQ0QsSUFBSVAsaUJBQWlCLEVBQUU7TUFDckJMLFVBQVUsQ0FBQ2EsdUJBQXVCLENBQUNGLHFCQUFTLENBQUM7TUFDN0NYLFVBQVUsQ0FBQ2EsdUJBQXVCLENBQUNELDhEQUE2QixDQUFDO0lBQ25FO0lBQ0E7SUFDQWYsSUFBSSxDQUFDTSxJQUFJLENBQUNXLDJCQUEyQixDQUFDLHNCQUFzQixFQUFFLENBQUNDLFFBQVEsRUFBRUMsUUFBUSxLQUFLO01BQ3BGLE9BQU87UUFDTHRCLE1BQU0sRUFBRSxJQUFJLENBQUNBLE1BQU07UUFDbkJ1QixtQkFBbUIsRUFBRVg7TUFDdkIsQ0FBQztJQUNILENBQUMsQ0FBQztJQUVGLE1BQU1ZLFlBQThCLEdBQUc7TUFDckNDLElBQUksRUFBRSxxQkFBcUI7TUFDM0JDLE1BQU0sRUFBRSxLQUFLO01BQ2JDLGFBQWEsRUFBRSxRQUFRO01BQ3ZCQyxRQUFRLEVBQUU7UUFDUkMsT0FBTyxFQUFFLEtBQUs7UUFDZEMsVUFBVSxFQUFFO1VBQ1ZDLEtBQUssRUFBRTtZQUNMQyxJQUFJLEVBQUU7VUFDUixDQUFDO1VBQ0RDLFdBQVcsRUFBRTtZQUNYRCxJQUFJLEVBQUU7VUFDUjtRQUNGO01BQ0YsQ0FBQztNQUNERSxVQUFVLEVBQUU7UUFDVkMsdUJBQXVCLEVBQUUsSUFBSTtRQUM3QkMsV0FBV0EsQ0FBQ0MsR0FBRyxFQUFFO1VBQ2YsT0FBTztZQUNMQyxJQUFJLEVBQUUzQixpQkFBaUIsR0FBRyxFQUFFLEdBQUksUUFBTzRCLDZCQUFzQixLQUFJRixHQUFHLENBQUNHLEVBQUcsRUFBQztZQUN6RUMsa0JBQWtCLEVBQUU7VUFDdEIsQ0FBQztRQUNILENBQUM7UUFDREMsUUFBUUEsQ0FBQ0wsR0FBRyxFQUFFO1VBQ1osT0FBUSwyQkFBMEJBLEdBQUcsQ0FBQ0csRUFBRyxHQUFFO1FBQzdDO01BQ0YsQ0FBQztNQUNERyxVQUFVLEVBQUU7UUFDVixPQUFPLEVBQUdDLEdBQUcsS0FBTTtVQUFFLEdBQUdBLEdBQUc7VUFBRVgsV0FBVyxFQUFFO1FBQUcsQ0FBQyxDQUFDO1FBQy9DLE9BQU8sRUFBR1csR0FBRyxLQUFNO1VBQUUsR0FBR0EsR0FBRztVQUFFWCxXQUFXLEVBQUU7UUFBd0IsQ0FBQyxDQUFDO1FBQ3BFLE9BQU8sRUFBR1csR0FBRyxLQUFNO1VBQ2pCLEdBQUdBLEdBQUc7VUFDTkMsV0FBVyxFQUFFQyxRQUFRLENBQUVGLEdBQUcsQ0FBOEJDLFdBQVcsSUFBSSxHQUFHLEVBQUUsRUFBRTtRQUNoRixDQUFDO01BQ0g7SUFDRixDQUFDO0lBRUQsTUFBTUUsdUJBQXlDLEdBQUc7TUFDaER0QixJQUFJLEVBQUUsc0JBQXNCO01BQzVCQyxNQUFNLEVBQUUsS0FBSztNQUNiQyxhQUFhLEVBQUUsUUFBUTtNQUN2Qk8sVUFBVSxFQUFFO1FBQ1ZDLHVCQUF1QixFQUFFLElBQUk7UUFDN0JDLFdBQVdBLENBQUNDLEdBQXFDLEVBQUU7VUFDakQsT0FBTztZQUNMQyxJQUFJLEVBQUcsZ0NBQStCRCxHQUFHLENBQUNHLEVBQUcsRUFBQztZQUM5Q0Msa0JBQWtCLEVBQUU7VUFDdEIsQ0FBQztRQUNILENBQUM7UUFDREMsUUFBUUEsQ0FBQ0wsR0FBcUMsRUFBRTtVQUM5QyxPQUFPQSxHQUFHLENBQUNXLFVBQVUsQ0FBQ3ZCLElBQUk7UUFDNUI7TUFDRixDQUFDO01BQ0RHLFFBQVEsRUFBRTtRQUNSQyxPQUFPLEVBQUUsS0FBSztRQUNkQyxVQUFVLEVBQUU7VUFDVkwsSUFBSSxFQUFFO1lBQ0pPLElBQUksRUFBRTtVQUNSLENBQUM7VUFDRGlCLFlBQVksRUFBRTtZQUNaakIsSUFBSSxFQUFFO1VBQ1IsQ0FBQztVQUNEMUIsVUFBVSxFQUFFO1lBQ1YwQixJQUFJLEVBQUU7VUFDUixDQUFDO1VBQ0RrQixZQUFZLEVBQUU7WUFDWmxCLElBQUksRUFBRTtVQUNSLENBQUM7VUFDRG1CLE1BQU0sRUFBRTtZQUNObkIsSUFBSSxFQUFFO1VBQ1I7UUFDRjtNQUNGO0lBQ0YsQ0FBQztJQUVELE1BQU1vQix1QkFBeUMsR0FBRztNQUNoRDNCLElBQUksRUFBRSxzQkFBc0I7TUFDNUJDLE1BQU0sRUFBRSxLQUFLO01BQ2JDLGFBQWEsRUFBRSxRQUFRO01BQ3ZCTyxVQUFVLEVBQUU7UUFDVkMsdUJBQXVCLEVBQUUsSUFBSTtRQUM3QkMsV0FBV0EsQ0FBQ0MsR0FBdUMsRUFBRTtVQUNuRCxPQUFPO1lBQ0xDLElBQUksRUFBRyxnQ0FBK0JELEdBQUcsQ0FBQ1csVUFBVSxDQUFDdkIsSUFBSyxFQUFDO1lBQzNEZ0Isa0JBQWtCLEVBQUU7VUFDdEIsQ0FBQztRQUNILENBQUM7UUFDREMsUUFBUUEsQ0FBQ0wsR0FBdUMsRUFBRTtVQUFBLElBQUFnQixxQkFBQTtVQUNoRCxRQUFBQSxxQkFBQSxHQUFPaEIsR0FBRyxDQUFDVyxVQUFVLENBQUNNLFdBQVcsY0FBQUQscUJBQUEsY0FBQUEscUJBQUEsR0FBSWhCLEdBQUcsQ0FBQ1csVUFBVSxDQUFDdkIsSUFBSTtRQUMxRDtNQUNGLENBQUM7TUFDREcsUUFBUSxFQUFFO1FBQ1JDLE9BQU8sRUFBRSxLQUFLO1FBQ2RDLFVBQVUsRUFBRTtVQUNWTCxJQUFJLEVBQUU7WUFDSk8sSUFBSSxFQUFFO1VBQ1IsQ0FBQztVQUNEdUIsT0FBTyxFQUFFO1lBQ1B2QixJQUFJLEVBQUU7VUFDUixDQUFDO1VBQ0RzQixXQUFXLEVBQUU7WUFDWHRCLElBQUksRUFBRTtVQUNSLENBQUM7VUFDRHdCLE9BQU8sRUFBRTtZQUNQeEIsSUFBSSxFQUFFO1VBQ1IsQ0FBQztVQUNEQSxJQUFJLEVBQUU7WUFDSkEsSUFBSSxFQUFFO1VBQ1IsQ0FBQztVQUNEeUIsTUFBTSxFQUFFO1lBQ056QixJQUFJLEVBQUU7VUFDUixDQUFDO1VBQ0QwQixNQUFNLEVBQUU7WUFDTjFCLElBQUksRUFBRTtVQUNSLENBQUM7VUFDREMsV0FBVyxFQUFFO1lBQ1hELElBQUksRUFBRTtVQUNSLENBQUM7VUFDRDJCLFNBQVMsRUFBRTtZQUNUM0IsSUFBSSxFQUFFO1VBQ1IsQ0FBQztVQUNENEIsT0FBTyxFQUFFO1lBQ1A1QixJQUFJLEVBQUU7VUFDUixDQUFDO1VBQ0Q2QixVQUFVLEVBQUU7WUFDVjdCLElBQUksRUFBRTtVQUNSLENBQUM7VUFDRG1CLE1BQU0sRUFBRTtZQUNObkIsSUFBSSxFQUFFO1VBQ1IsQ0FBQztVQUNEOEIsVUFBVSxFQUFFO1lBQ1Y5QixJQUFJLEVBQUU7VUFDUjtRQUNGO01BQ0YsQ0FBQztNQUNEVyxVQUFVLEVBQUU7UUFDVixPQUFPLEVBQUVvQjtNQUNYO0lBQ0YsQ0FBQztJQUVENUQsSUFBSSxDQUFDNkQsWUFBWSxDQUFDQyxZQUFZLENBQUN6QyxZQUFZLENBQUM7SUFDNUNyQixJQUFJLENBQUM2RCxZQUFZLENBQUNDLFlBQVksQ0FBQ2xCLHVCQUF1QixDQUFDO0lBQ3ZENUMsSUFBSSxDQUFDNkQsWUFBWSxDQUFDQyxZQUFZLENBQUNiLHVCQUF1QixDQUFDOztJQUV2RDtJQUNBLElBQUFjLGtCQUFXLEVBQUM7TUFDVjFELE1BQU07TUFDTjJELE1BQU0sRUFBRXZELDZCQUE2QjtNQUNyQ0QsaUJBQWlCO01BQ2pCWCxNQUFNLEVBQUUsSUFBSSxDQUFDQTtJQUNmLENBQUMsQ0FBQztJQUVGRyxJQUFJLENBQUM2RCxZQUFZLENBQUNDLFlBQVksQ0FBQyxJQUFBRyx1REFBMkIsRUFBQ3pELGlCQUFpQixDQUFDLENBQUM7SUFDOUVSLElBQUksQ0FBQzZELFlBQVksQ0FBQ0MsWUFBWSxDQUFDLElBQUFJLGdEQUFvQixFQUFDMUQsaUJBQWlCLENBQUMsQ0FBQztJQUN2RSxJQUFJLENBQUNQLElBQUksQ0FBQ2tFLHVCQUF1QixFQUFFO01BQ2pDbkUsSUFBSSxDQUFDNkQsWUFBWSxDQUFDQyxZQUFZLENBQUNNLCtDQUFtQixDQUFDO0lBQ3JEO0lBQ0FwRSxJQUFJLENBQUNxRSxZQUFZLENBQUNDLGdCQUFnQixDQUFDLE9BQU87TUFDeENDLGFBQWEsRUFBRTtRQUNiQyxJQUFJLEVBQUU7TUFDUjtJQUNGLENBQUMsQ0FBQyxDQUFDO0lBRUh0RSxtQkFBbUIsYUFBbkJBLG1CQUFtQixlQUFuQkEsbUJBQW1CLENBQUV1RSxxQkFBcUIsQ0FBQ0Msc0JBQVUsQ0FBQztJQUN0RCxJQUFBQyxrREFBK0IsRUFBQzNFLElBQUksQ0FBQzRFLFVBQVUsQ0FBQztJQUVoRDVFLElBQUksQ0FBQzRFLFVBQVUsQ0FBQ0MsUUFBUSxDQUFDO01BQ3ZCLGdDQUFnQyxFQUFFO1FBQ2hDdkQsSUFBSSxFQUFFLGlDQUFpQztRQUN2Q3hDLEtBQUssRUFBRSxFQUFFO1FBQ1RnRCxXQUFXLEVBQUUsaUVBQWlFO1FBQzlFZ0QsTUFBTSxFQUFFQSxvQkFBTSxDQUFDQyxNQUFNLENBQUMsQ0FBQztRQUN2QkMsS0FBSyxFQUFFaEYsSUFBSSxDQUFDaUYsU0FBUyxDQUFDQyxrQkFBa0IsQ0FBQyxDQUFDLEdBQ3RDQyxzQkFBYyxDQUFDQyxTQUFTLEdBQ3hCRCxzQkFBYyxDQUFDRTtNQUNyQjtJQUNGLENBQUMsQ0FBQztJQUVGckYsSUFBSSxDQUFDNEUsVUFBVSxDQUFDQyxRQUFRLENBQUM7TUFDdkIsb0NBQW9DLEVBQUU7UUFDcEN2RCxJQUFJLEVBQUUsOEJBQThCO1FBQ3BDeEMsS0FBSyxFQUFFLElBQUk7UUFDWGdELFdBQVcsRUFBRSw0Q0FBNEM7UUFDekRnRCxNQUFNLEVBQUVBLG9CQUFNLENBQUNRLE9BQU8sQ0FBQyxDQUFDO1FBQ3hCTixLQUFLLEVBQUVoRixJQUFJLENBQUNpRixTQUFTLENBQUNDLGtCQUFrQixDQUFDLENBQUMsR0FDdENDLHNCQUFjLENBQUNDLFNBQVMsR0FDeEJELHNCQUFjLENBQUNFO01BQ3JCO0lBQ0YsQ0FBQyxDQUFDO0lBRUYsT0FBTyxDQUFDLENBQUM7RUFDWDtFQUVPRSxLQUFLQSxDQUFDQyxLQUFnQixFQUFFO0lBQzdCLElBQUksQ0FBQzNGLE1BQU0sQ0FBQ08sS0FBSyxDQUFDLHdCQUF3QixDQUFDO0lBQzNDLE9BQU8sQ0FBQyxDQUFDO0VBQ1g7RUFFT3FGLElBQUlBLENBQUEsRUFBRyxDQUFDO0FBQ2pCO0FBQUNDLE9BQUEsQ0FBQWhHLG1CQUFBLEdBQUFBLG1CQUFBIn0=