/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.utils.DateTimeFormatters;

public final class DateTimeUtils {
    private static final DateTimeFormatter DIRECT_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy:HH:mm:ss");
    public static final Set<DateTimeFormatter> SUPPORTED_FORMATTERS = Set.of(DIRECT_FORMATTER, DateTimeFormatters.DATE_TIMESTAMP_FORMATTER, DateTimeFormatter.ISO_DATE_TIME);

    public static long roundFloor(long utcMillis, long unitMillis) {
        long res = utcMillis - utcMillis % unitMillis;
        return utcMillis < 0L && res != utcMillis ? res - unitMillis : res;
    }

    public static long roundWeek(long utcMillis, int interval) {
        return DateTimeUtils.roundFloor(utcMillis + 259200000L, 604800000L * (long)interval) - 259200000L;
    }

    public static long roundMonth(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneOffset.UTC).plusMonths(interval);
        long monthDiff = (long)(zonedDateTime.getYear() - initDateTime.getYear()) * 12L + (long)zonedDateTime.getMonthValue() - (long)initDateTime.getMonthValue();
        long multiplier = monthDiff / (long)interval - 1L;
        if (monthDiff < 0L && monthDiff % (long)interval != 0L) {
            --multiplier;
        }
        long monthToAdd = multiplier * (long)interval;
        return initDateTime.plusMonths(monthToAdd).toInstant().toEpochMilli();
    }

    public static long roundQuarter(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneOffset.UTC).plusMonths((long)interval * 3L);
        long monthDiff = (long)(zonedDateTime.getYear() - initDateTime.getYear()) * 12L + (long)zonedDateTime.getMonthValue() - (long)initDateTime.getMonthValue();
        long multiplier = monthDiff / ((long)interval * 3L) - 1L;
        if (monthDiff < 0L && monthDiff % ((long)interval * 3L) != 0L) {
            --multiplier;
        }
        long monthToAdd = multiplier * (long)interval * 3L;
        return initDateTime.plusMonths(monthToAdd).toInstant().toEpochMilli();
    }

    public static long roundYear(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneOffset.UTC);
        int yearDiff = zonedDateTime.getYear() - initDateTime.getYear();
        int multiplier = yearDiff / interval;
        if (yearDiff < 0 && yearDiff % interval != 0) {
            --multiplier;
        }
        int yearToAdd = multiplier * interval;
        return initDateTime.plusYears(yearToAdd).toInstant().toEpochMilli();
    }

    public static long getWindowStartTime(long timestamp, long size) {
        return timestamp - timestamp % size;
    }

    public static Boolean isValidMySqlTimeZoneId(ZoneId zone) {
        String timeZoneMax = "+14:00";
        String timeZoneMin = "-13:59";
        String timeZoneZero = "+00:00";
        ZoneId maxTz = ZoneId.of(timeZoneMax);
        ZoneId minTz = ZoneId.of(timeZoneMin);
        ZoneId defaultTz = ZoneId.of(timeZoneZero);
        ZonedDateTime defaultDateTime = LocalDateTime.of(2000, 1, 2, 12, 0).atZone(defaultTz);
        ZonedDateTime maxTzValidator = defaultDateTime.withZoneSameInstant(maxTz).withZoneSameLocal(defaultTz);
        ZonedDateTime minTzValidator = defaultDateTime.withZoneSameInstant(minTz).withZoneSameLocal(defaultTz);
        ZonedDateTime passedTzValidator = defaultDateTime.withZoneSameInstant(zone).withZoneSameLocal(defaultTz);
        return !(!passedTzValidator.isBefore(maxTzValidator) && !passedTzValidator.isEqual(maxTzValidator) || !passedTzValidator.isAfter(minTzValidator) && !passedTzValidator.isEqual(minTzValidator));
    }

    public static Instant extractTimestamp(ExprValue value, FunctionProperties functionProperties) {
        return value instanceof ExprTimeValue ? ((ExprTimeValue)value).timestampValue(functionProperties) : value.timestampValue();
    }

    public static LocalDate extractDate(ExprValue value, FunctionProperties functionProperties) {
        return value instanceof ExprTimeValue ? ((ExprTimeValue)value).dateValue(functionProperties) : value.dateValue();
    }

    public static ZonedDateTime getRelativeZonedDateTime(String input, ZonedDateTime baseTime) {
        Optional<ZonedDateTime> parsed = DateTimeUtils.tryParseAbsoluteTime(input);
        if (parsed.isPresent()) {
            return parsed.get().withZoneSameInstant(baseTime.getZone());
        }
        if ("now".equalsIgnoreCase(input) || "now()".equalsIgnoreCase(input)) {
            return baseTime;
        }
        ZonedDateTime result = baseTime;
        int i = 0;
        while (i < input.length()) {
            int j;
            char c = input.charAt(i);
            if (c == '@') {
                for (j = i + 1; j < input.length() && Character.isLetterOrDigit(input.charAt(j)); ++j) {
                }
                String rawUnit = input.substring(i + 1, j);
                result = DateTimeUtils.applySnap(result, rawUnit);
                i = j;
                continue;
            }
            if (c == '+' || c == '-') {
                int k;
                for (j = i + 1; j < input.length() && Character.isDigit(input.charAt(j)); ++j) {
                }
                String valueStr = input.substring(i + 1, j);
                int value = valueStr.isEmpty() ? 1 : Integer.parseInt(valueStr);
                for (k = j; k < input.length() && Character.isLetter(input.charAt(k)); ++k) {
                }
                String rawUnit = input.substring(j, k);
                result = DateTimeUtils.applyOffset(result, String.valueOf(c), value, rawUnit);
                i = k;
                continue;
            }
            throw new IllegalArgumentException("Unexpected character '" + c + "' at position " + i + " in input: " + input);
        }
        return result;
    }

    private static ZonedDateTime applyOffset(ZonedDateTime base, String sign, int value, String rawUnit) {
        String unit = DateTimeUtils.normalizeUnit(rawUnit);
        if ("q".equals(unit)) {
            int months = value * 3;
            return sign.equals("-") ? base.minusMonths(months) : base.plusMonths(months);
        }
        ChronoUnit chronoUnit = DateTimeUtils.mapChronoUnit(unit, "Unsupported offset unit: " + rawUnit);
        return sign.equals("-") ? base.minus(value, chronoUnit) : base.plus(value, chronoUnit);
    }

    private static ZonedDateTime applySnap(ZonedDateTime base, String rawUnit) {
        String unit;
        return switch (unit = DateTimeUtils.normalizeUnit(rawUnit)) {
            case "s" -> base.truncatedTo(ChronoUnit.SECONDS);
            case "m" -> base.truncatedTo(ChronoUnit.MINUTES);
            case "h" -> base.truncatedTo(ChronoUnit.HOURS);
            case "d" -> base.truncatedTo(ChronoUnit.DAYS);
            case "w" -> base.minusDays(base.getDayOfWeek().getValue() % 7).truncatedTo(ChronoUnit.DAYS);
            case "M" -> base.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            case "y" -> base.withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            case "q" -> {
                int month = base.getMonthValue();
                int quarterStart = (month - 1) / 3 * 3 + 1;
                yield base.withMonth(quarterStart).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            }
            default -> {
                if (unit.matches("w[0-7]")) {
                    int targetDay = unit.equals("w0") || unit.equals("w7") ? 7 : Integer.parseInt(unit.substring(1));
                    int diff = (base.getDayOfWeek().getValue() - targetDay + 7) % 7;
                    yield base.minusDays(diff).truncatedTo(ChronoUnit.DAYS);
                }
                throw new IllegalArgumentException("Unsupported snap unit: " + rawUnit);
            }
        };
    }

    private static String normalizeUnit(String rawUnit) {
        switch (rawUnit.toLowerCase(Locale.ROOT)) {
            case "m": 
            case "min": 
            case "mins": 
            case "minute": 
            case "minutes": {
                return "m";
            }
            case "s": 
            case "sec": 
            case "secs": 
            case "second": 
            case "seconds": {
                return "s";
            }
            case "h": 
            case "hr": 
            case "hrs": 
            case "hour": 
            case "hours": {
                return "h";
            }
            case "d": 
            case "day": 
            case "days": {
                return "d";
            }
            case "w": 
            case "wk": 
            case "wks": 
            case "week": 
            case "weeks": {
                return "w";
            }
            case "mon": 
            case "month": 
            case "months": {
                return "M";
            }
            case "y": 
            case "yr": 
            case "yrs": 
            case "year": 
            case "years": {
                return "y";
            }
            case "q": 
            case "qtr": 
            case "qtrs": 
            case "quarter": 
            case "quarters": {
                return "q";
            }
        }
        String lower = rawUnit.toLowerCase();
        if (lower.matches("w[0-7]")) {
            return lower;
        }
        throw new IllegalArgumentException("Unsupported unit alias: " + rawUnit);
    }

    public static String resolveTimeModifier(String timeModifier) {
        return DateTimeUtils.resolveTimeModifier(timeModifier, ZonedDateTime.now(ZoneOffset.UTC));
    }

    static String resolveTimeModifier(String input, ZonedDateTime nowReference) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        if ("now".equalsIgnoreCase(input) || "now()".equalsIgnoreCase(input)) {
            return "now";
        }
        String absoluteTime = DateTimeUtils.tryParseAbsoluteTimeAndFormat(input);
        if (absoluteTime != null) {
            return absoluteTime;
        }
        return DateTimeUtils.parseRelativeTimeExpression(input, nowReference);
    }

    private static String tryParseAbsoluteTimeAndFormat(String input) {
        Optional<ZonedDateTime> parsed = DateTimeUtils.tryParseAbsoluteTime(input);
        return parsed.map(zonedDateTime -> zonedDateTime.format(DateTimeFormatter.ISO_INSTANT)).orElse(null);
    }

    private static Optional<ZonedDateTime> tryParseAbsoluteTime(String input) {
        for (DateTimeFormatter formatter : SUPPORTED_FORMATTERS) {
            try {
                ZonedDateTime parsed;
                if (formatter == DateTimeFormatter.ISO_DATE_TIME) {
                    parsed = ZonedDateTime.parse(input, formatter);
                } else {
                    LocalDateTime localDateTime = LocalDateTime.parse(input, formatter);
                    parsed = localDateTime.atZone(ZoneOffset.UTC);
                }
                return Optional.of(parsed);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return Optional.empty();
    }

    private static String parseRelativeTimeExpression(String input, ZonedDateTime nowReference) {
        if (!DateTimeUtils.containsRelativeTimeOperators(input)) {
            return input;
        }
        StringBuilder result = new StringBuilder("now");
        int position = 0;
        ZonedDateTime currentReference = nowReference;
        while (position < input.length()) {
            char currentChar = input.charAt(position);
            if (currentChar == '@') {
                position = DateTimeUtils.processSnap(input, position, result, currentReference);
                continue;
            }
            if (currentChar == '+' || currentChar == '-') {
                OffsetResult offsetResult = DateTimeUtils.processOffset(input, position, result, currentReference);
                position = offsetResult.newPosition;
                currentReference = offsetResult.updatedReference;
                continue;
            }
            throw new IllegalArgumentException("Unexpected character '" + currentChar + "' at position " + position + " in input: " + input);
        }
        return result.toString();
    }

    private static boolean containsRelativeTimeOperators(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '+' && c != '-' && c != '@') continue;
            return true;
        }
        return false;
    }

    private static int processSnap(String input, int position, StringBuilder result, ZonedDateTime nowReference) {
        int nextPosition;
        int endOfUnit;
        for (endOfUnit = nextPosition = position + 1; endOfUnit < input.length() && Character.isLetterOrDigit(input.charAt(endOfUnit)); ++endOfUnit) {
        }
        String rawUnit = input.substring(nextPosition, endOfUnit);
        String normalizedUnit = DateTimeUtils.normalizeUnit(rawUnit);
        if ("q".equals(normalizedUnit)) {
            return DateTimeUtils.processQuarterSnap(result, nowReference, endOfUnit);
        }
        if ("w".equals(normalizedUnit)) {
            return DateTimeUtils.processWeekDaySnap(result, "w0", nowReference, endOfUnit);
        }
        if (normalizedUnit.matches("w[0-7]")) {
            return DateTimeUtils.processWeekDaySnap(result, normalizedUnit, nowReference, endOfUnit);
        }
        String osUnit = DateTimeUtils.convertToOsUnit(rawUnit);
        result.append('/').append(osUnit);
        return endOfUnit;
    }

    private static int processWeekDaySnap(StringBuilder result, String weekDay, ZonedDateTime nowReference, int endOfUnit) {
        int dayNumber;
        try {
            dayNumber = Integer.parseInt(weekDay.substring(1));
            if (dayNumber < 0 || dayNumber > 7) {
                throw new IllegalArgumentException("Invalid week day: " + weekDay);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid week day format: " + weekDay);
        }
        result.append("/w");
        int dayAdjust = 0;
        int dayNumberReference = nowReference.getDayOfWeek().getValue();
        if (dayNumber == 0 || dayNumber == 7) {
            dayNumber = 7;
            dayAdjust = dayNumber == dayNumberReference ? 6 : -1;
        } else if (dayNumber > 1) {
            dayAdjust = dayNumber - 1;
            if (dayNumber > dayNumberReference) {
                dayAdjust -= 7;
            }
        }
        if (dayAdjust > 0) {
            result.append("+").append(dayAdjust).append("d");
        } else if (dayAdjust < 0) {
            result.append(dayAdjust).append("d");
        }
        return endOfUnit;
    }

    private static int processQuarterSnap(StringBuilder result, ZonedDateTime nowReference, int endOfUnit) {
        int month = nowReference.getMonthValue();
        int quarterStartMonth = (month - 1) / 3 * 3 + 1;
        int monthsToSubtract = month - quarterStartMonth;
        result.append("/M");
        if (monthsToSubtract > 0) {
            result.append("-").append(monthsToSubtract).append("M");
        }
        return endOfUnit;
    }

    private static OffsetResult processOffset(String input, int position, StringBuilder result, ZonedDateTime nowReference) {
        int endOfUnit;
        int nextPosition;
        int endOfValue;
        char sign = input.charAt(position);
        result.append(sign);
        for (endOfValue = nextPosition = position + 1; endOfValue < input.length() && Character.isDigit(input.charAt(endOfValue)); ++endOfValue) {
        }
        String valueStr = input.substring(nextPosition, endOfValue);
        int value = valueStr.isEmpty() ? 1 : Integer.parseInt(valueStr);
        result.append(value);
        for (endOfUnit = endOfValue; endOfUnit < input.length() && Character.isLetter(input.charAt(endOfUnit)); ++endOfUnit) {
        }
        String rawUnit = input.substring(endOfValue, endOfUnit);
        String normalizedUnit = DateTimeUtils.normalizeUnit(rawUnit);
        ZonedDateTime updatedReference = DateTimeUtils.applyOffsetToReference(nowReference, sign, value, normalizedUnit);
        if ("q".equals(normalizedUnit)) {
            int newPosition = DateTimeUtils.processQuarterOffset(value, result, endOfUnit);
            return new OffsetResult(newPosition, updatedReference);
        }
        String osUnit = DateTimeUtils.convertToOsUnit(rawUnit);
        result.append(osUnit);
        return new OffsetResult(endOfUnit, updatedReference);
    }

    private static ZonedDateTime applyOffsetToReference(ZonedDateTime reference, char sign, int value, String unit) {
        if ("q".equals(unit)) {
            int months = value * 3;
            return sign == '+' ? reference.plusMonths(months) : reference.minusMonths(months);
        }
        ChronoUnit chronoUnit = DateTimeUtils.mapChronoUnit(unit, "Unsupported offset unit: " + unit);
        return sign == '+' ? reference.plus(value, chronoUnit) : reference.minus(value, chronoUnit);
    }

    private static ChronoUnit mapChronoUnit(String unit, String s) {
        return switch (unit) {
            case "s" -> ChronoUnit.SECONDS;
            case "m" -> ChronoUnit.MINUTES;
            case "h" -> ChronoUnit.HOURS;
            case "d" -> ChronoUnit.DAYS;
            case "w" -> ChronoUnit.WEEKS;
            case "M" -> ChronoUnit.MONTHS;
            case "y" -> ChronoUnit.YEARS;
            default -> throw new IllegalArgumentException(s);
        };
    }

    private static int processQuarterOffset(int value, StringBuilder result, int endOfUnit) {
        int months = value * 3;
        result.delete(result.length() - String.valueOf(value).length(), result.length());
        result.append(months).append("M");
        return endOfUnit;
    }

    private static String convertToOsUnit(String PPLUnit) {
        String normalizedUnit = DateTimeUtils.normalizeUnit(PPLUnit);
        if ("q".equals(normalizedUnit)) {
            return "M";
        }
        if ("M".equals(normalizedUnit)) {
            return normalizedUnit;
        }
        return normalizedUnit;
    }

    @Generated
    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record OffsetResult(int newPosition, ZonedDateTime updatedReference) {
    }
}

