-- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
-- This config is DEPRECATED.
-- Use the configs in `lsp/` instead (requires Nvim 0.11).
--
-- ALL configs in `lua/lspconfig/configs/` will be DELETED.
-- They exist only to support Nvim 0.10 or older.
-- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
local util = require 'lspconfig.util'

return {
  default_config = {
    cmd = { 'golangci-lint-langserver' },
    filetypes = { 'go', 'gomod' },
    init_options = {
      command = {
        'golangci-lint',
        'run',
        -- disable all output formats that might be enabled by the users .golangci.yml
        '--output.text.path=',
        '--output.tab.path=',
        '--output.html.path=',
        '--output.checkstyle.path=',
        '--output.junit-xml.path=',
        '--output.teamcity.path=',
        '--output.sarif.path=',
        -- disable stats output
        '--show-stats=false',
        -- enable JSON output to be used by the language server
        '--output.json.path=stdout',
      },
    },
    root_dir = function(fname)
      return util.root_pattern(
        '.golangci.yml',
        '.golangci.yaml',
        '.golangci.toml',
        '.golangci.json',
        'go.work',
        'go.mod',
        '.git'
      )(fname)
    end,
    before_init = function(_, config)
      -- Add support for golangci-lint V1 (in V2 `--out-format=json` was replaced by
      -- `--output.json.path=stdout`).
      local v1, v2 = false, false
      -- PERF: `golangci-lint version` is very slow (about 0.1 sec) so let's find
      -- version using `go version -m $(which golangci-lint) | grep '^\smod'`.
      if vim.fn.executable 'go' == 1 then
        local exe = vim.fn.exepath 'golangci-lint'
        local version = vim.system({ 'go', 'version', '-m', exe }):wait()
        v1 = string.match(version.stdout, '\tmod\tgithub.com/golangci/golangci%-lint\t')
        v2 = string.match(version.stdout, '\tmod\tgithub.com/golangci/golangci%-lint/v2\t')
      end
      if not v1 and not v2 then
        local version = vim.system({ 'golangci-lint', 'version' }):wait()
        v1 = string.match(version.stdout, 'version v?1%.')
      end
      if v1 then
        config.init_options.command = { 'golangci-lint', 'run', '--out-format', 'json' }
      end
    end,
  },
  docs = {
    description = [[
Combination of both lint server and client

https://github.com/nametake/golangci-lint-langserver
https://github.com/golangci/golangci-lint


Installation of binaries needed is done via

```
go install github.com/nametake/golangci-lint-langserver@latest
go install github.com/golangci/golangci-lint/cmd/golangci-lint@latest
```

]],
  },
}
