/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.ttml.exporters;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import mediathek.tool.ttml.ITtmlExporter;
import mediathek.tool.ttml.StyledString;
import mediathek.tool.ttml.Subtitle;
import mediathek.tool.ttml.TimedTextMarkupLanguageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubripTextExporter
implements ITtmlExporter {
    private static final Logger logger = LogManager.getLogger();
    private final SimpleDateFormat srtFormat = new SimpleDateFormat("HH:mm:ss,SSS");

    @Override
    public void write(TimedTextMarkupLanguageParser parser, Path srtFile) {
        try (FileOutputStream fos = new FileOutputStream(srtFile.toFile());
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(osw);){
            long counter = 1L;
            for (Subtitle title : parser.getSubtitleList()) {
                writer.println(counter);
                writer.println(this.srtFormat.format(title.getBegin()) + " --> " + this.srtFormat.format(title.getEnd()));
                for (StyledString entry : title.getListOfStrings()) {
                    String entryColor = entry.getColor();
                    if (!entryColor.isEmpty()) {
                        writer.print("<font color=\"" + entryColor + "\">");
                    }
                    writer.print(entry.getText());
                    if (!entryColor.isEmpty()) {
                        writer.print("</font>");
                    }
                    writer.println();
                }
                writer.println("");
                ++counter;
            }
            logger.trace("SRT export was succesful.");
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)srtFile, (Object)ex);
        }
    }
}

